
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_compare.h
**  Date:    Jan 17, 2003
**
**  Author:  Brian Wotring
**  Purpose: handle database comparisons.
**
******************************************************************************/

#ifndef MD_COMPARE_H
#define MD_COMPARE_H

typedef enum
{
    /* UNIX 1 */

    ATTR_CHECKSUM      = 1 << 0,
    ATTR_DEVICE        = 1 << 1,
    ATTR_INODE         = 1 << 2,
    ATTR_PERMISSIONS   = 1 << 3,
    ATTR_LINKS         = 1 << 4,
    ATTR_UID           = 1 << 5,
    ATTR_GID           = 1 << 6,
    ATTR_MTIME         = 1 << 7,
    ATTR_ATIME         = 1 << 8,
    ATTR_CTIME         = 1 << 9,
    ATTR_DEVICE_TYPE   = 1 << 10,
    ATTR_BYTES         = 1 << 11,
    ATTR_BLOCKS        = 1 << 12,
    ATTR_BLOCK_SIZE    = 1 << 13,

    /* WINNT */

    ATTR_OWNER_SID       = 1 << 14,
    ATTR_GROUP_SID       = 1 << 15,
    ATTR_WIN32_FILE      = 1 << 16,

    /* new and missing. */

    ATTR_NEW           = 1 << 17,
    ATTR_MISSING       = 1 << 18

} OSI_ATTR_MASK;


#define CMP_MASK_DEFAULT  ( ATTR_CHECKSUM | ATTR_DEVICE | ATTR_INODE |\
                            ATTR_PERMISSIONS | ATTR_LINKS | ATTR_UID |\
                            ATTR_GID | ATTR_MTIME | ATTR_CTIME |\
                            ATTR_DEVICE_TYPE | ATTR_BYTES |\
                            ATTR_BLOCKS | ATTR_BLOCK_SIZE |\
                            ATTR_OWNER_SID | ATTR_GROUP_SID |\
                            ATTR_WIN32_FILE )


typedef struct OSI_DB_CTX
{
    char host[MAX_HOSTNAME_LENGTH];
    char filepath[MAX_PATH_LENGTH];

    char db1_name[MAX_HOSTNAME_LENGTH];
    char db2_name[MAX_HOSTNAME_LENGTH];

    char config_name[MAX_HOSTNAME_LENGTH];

    OSI_ATTR_MASK compare_mask;
    osi_bool use_system_log;

    osi_bool include_missing;
    osi_bool include_new;
    osi_bool include_system;

    /* used to note what changed for a file. */

    OSI_ATTR_MASK changed_mask;

    /* compare statistics counters. */

    unsigned long diff_count;

    unsigned long suid_diff_count;
    unsigned long perm_diff_count;
    unsigned long checksum_diff_count;
    unsigned long root_diff_count;
    unsigned long new_count;
    unsigned long missing_count;

    FILE *file_handle;

} OSI_DB_CTX;


OSI_DB_CTX * osi_db_ctx_new();
void osi_db_ctx_destroy( OSI_DB_CTX *context );

void osi_db_ctx_set_host( OSI_DB_CTX *context, const char *host );

void osi_db_ctx_preflight( OSI_DB_CTX *context );
void osi_db_ctx_postflight( OSI_DB_CTX *context );

void osi_db_ctx_set_use_system_log( OSI_DB_CTX *context, osi_bool use );
void osi_db_ctx_set_log_file( OSI_DB_CTX *context, const char *filepath );

osi_bool md_compare_db( OSI_DB_CTX *context, OSI_DB *db1, OSI_DB *db2 );
osi_bool md_compare_db_records( OSI_DB_CTX *context,
                                SCAN_RECORD *record1,
                                SCAN_RECORD *record2 );

/* compare routines. */

void compare_db_with_default_for_host( OSI_DB *db, OSI_HOST *host );

/* utilities. */

void print_log_file_heading( OSI_DB_CTX *context );
void print_log_file_footer( OSI_DB_CTX *context );

void record_file_differences( OSI_DB_CTX *context, SCAN_RECORD *record1,
                              SCAN_RECORD *record2 );

#endif
