
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**    File:      osirisctl.h
**    Author:    Brian Wotring
**
**    Date:      May 22, 2002
**    Project:   osiris
**
******************************************************************************/

#ifndef OSIRISCTL_H
#define OSIRISCTL_H


#define MAX_AUTH_USERNAME_LENGTH        20
#define MAX_AUTH_PASSWORD_LENGTH        20

#define MAX_HELLO_VERSION_LENGTH        20
#define MAX_HELLO_MESSAGE_LENGTH		256

#define DB_RETREIVE_FILE_PERMISSIONS	0600
#define DEFAULT_CONFIG_NAME             "default"



/* different commands to be sent in a control request. */

#define CONTROL_COMMAND_UNKNOWN			        0x00

#define CONTROL_COMMAND_HELLO			        0x01
#define CONTROL_COMMAND_STATUS			        0x02
#define CONTROL_COMMAND_PUSH_CONFIG		        0x03
#define CONTROL_COMMAND_IMPORT_CONFIG		    0x04
#define CONTROL_COMMAND_START_SCAN		        0x05
#define CONTROL_COMMAND_STOP_SCAN		        0x06

#define CONTROL_COMMAND_LIST_HOSTS		        0x07
#define CONTROL_COMMAND_LIST_CONFIGS		    0x08
#define CONTROL_COMMAND_LIST_DATABASES  	    0x09
#define CONTROL_COMMAND_LIST_LOGS               0x0A
#define CONTROL_COMMAND_LIST_USERS              0x0B
#define CONTROL_COMMAND_GET_DATABASE_BRIEF	    0x0C
#define CONTROL_COMMAND_GET_CONFIG		        0x0D
#define CONTROL_COMMAND_GET_HOST_BRIEF		    0x0E
#define CONTROL_COMMAND_NEW_HOST		        0x0F
#define CONTROL_COMMAND_EDIT_HOST_BRIEF		    0x10
#define CONTROL_COMMAND_DROP_CONFIG		        0x11
#define CONTROL_COMMAND_GET_DATABASE_ERRORS	    0x12
#define CONTROL_COMMAND_GET_HOST_CONFIG	 	    0x13
#define CONTROL_COMMAND_SAVE_HOST_CONFIG	    0x14
#define CONTROL_COMMAND_GET_MANAGEMENT_CONFIG	0x15
#define CONTROL_COMMAND_SAVE_MANAGEMENT_CONFIG	0x16
#define CONTROL_COMMAND_GET_DATABASE		    0x17
#define CONTROL_COMMAND_SET_BASE_DATABASE       0x18
#define CONTROL_COMMAND_GET_LOG                 0x19
#define CONTROL_COMMAND_SET_USER                0x1A
#define CONTROL_COMMAND_DELETE_USER             0x1B
#define CONTROL_COMMAND_PUSH_DEFAULT_CONFIG     0x1D
#define CONTROL_COMMAND_UNSET_BASE_DATABASE     0x1E
#define CONTROL_COMMAND_LIST_CMP_FILTERS        0x1F
#define CONTROL_COMMAND_SAVE_CMP_FILTERS        0x20
#define CONTROL_COMMAND_SEND_NOTIFY_TEST        0x21
#define CONTROL_COMMAND_REMOVE_CONFIG           0x22
#define CONTROL_COMMAND_REMOVE_DB               0x23
#define CONTROL_COMMAND_REMOVE_HOST             0x24
#define CONTROL_COMMAND_LIST_SHARED_CONFIGS     0x25


typedef struct CONTROL_REQUEST
{
    osi_uint64 command;

    char host[MAX_HOST_BRIEF_NAME_LENGTH];
    char buffer[MAX_PATH_LENGTH];

} CONTROL_REQUEST;


typedef struct OSI_AUTH_CONTEXT
{
    char auth_user[MAX_AUTH_USERNAME_LENGTH];
    char auth_pass[MAX_AUTH_PASSWORD_LENGTH];

} OSI_AUTH_CONTEXT;


/* control context.  these are all the fields necessary, this is    */
/* the single argument to all the control functions, it is never    */
/* sent across the network, so add whatever you want within reason. */

typedef struct CTL_CONTEXT
{
    char mhost[MAX_HOST_BRIEF_NAME_LENGTH];
    int mhost_port;

    char host[MAX_HOST_BRIEF_NAME_LENGTH];

    char username[MAX_AUTH_USERNAME_LENGTH];
    char password[MAX_AUTH_PASSWORD_LENGTH];

    char buffer[MAX_PATH_LENGTH];
    char filename[MAX_PATH_LENGTH];

    void (*db_receive_callback)(long received, long total);

    SSL_CTX *ssl_context;
    SSL *ssl;

    OSI_SCAN_CONFIG *config;
    OSI_MANAGEMENT_CONFIG *mhost_config;
    osi_list cmp_filters;

    OSI_HOST_BRIEF *host_brief;
    OSI_ERROR error;

} CTL_CONTEXT;


/* used to pass version information, and a banner back    */
/* to the management application, as a result of a hello. */


typedef struct OSI_HELLO_RESPONSE
{
    char version[MAX_HELLO_VERSION_LENGTH];
    char message[MAX_HELLO_MESSAGE_LENGTH];

} OSI_HELLO_RESPONSE;


/* management functions to be used by management applications to talk */
/* to the management daemon for common operations.                    */

SSL * ctl_connect( CTL_CONTEXT *context );
osi_bool ctl_disconnect( CTL_CONTEXT *context );

OSI_STATUS * ctl_get_status( CTL_CONTEXT *context );
OSI_HELLO_RESPONSE * ctl_send_hello( CTL_CONTEXT *context );

osi_bool ctl_set_user( CTL_CONTEXT *context );
osi_bool ctl_delete_user( CTL_CONTEXT *context );

osi_list ctl_get_host_brief_list( CTL_CONTEXT *context );
osi_list ctl_get_config_brief_list( CTL_CONTEXT *context );
osi_list ctl_get_shared_config_brief_list( CTL_CONTEXT *context );
osi_list ctl_get_database_brief_list( CTL_CONTEXT *context );
osi_list ctl_get_log_brief_list( CTL_CONTEXT *context );
osi_list ctl_get_user_list( CTL_CONTEXT *context );
osi_list ctl_get_cmp_filters_list( CTL_CONTEXT *context );

osi_list ctl_get_database_errors( CTL_CONTEXT *context );
osi_bool ctl_send_notify_test( CTL_CONTEXT *context );

osi_bool ctl_push_config( CTL_CONTEXT *context );
osi_bool ctl_remove_config( CTL_CONTEXT *context );
osi_bool ctl_import_config( CTL_CONTEXT *context );

osi_bool ctl_save_cmp_filters( CTL_CONTEXT *context );

osi_bool ctl_start_scan( CTL_CONTEXT *context );
osi_bool ctl_stop_scan( CTL_CONTEXT *context );

osi_bool ctl_new_host( CTL_CONTEXT *context );
osi_bool ctl_remove_host( CTL_CONTEXT *context );
osi_bool ctl_edit_host_brief( CTL_CONTEXT *context );

osi_bool ctl_set_base_db( CTL_CONTEXT *context );
osi_bool ctl_unset_base_db( CTL_CONTEXT *context );

OSI_DATABASE_BRIEF * ctl_get_db_results( CTL_CONTEXT *context );
OSI_HOST_BRIEF * ctl_get_host( CTL_CONTEXT *context );
string_list * ctl_get_log( CTL_CONTEXT *context );

OSI_HOST_CONFIG *ctl_get_host_config( CTL_CONTEXT *context );
OSI_MANAGEMENT_CONFIG *ctl_get_management_config( CTL_CONTEXT *context );

osi_bool ctl_save_host_config( CTL_CONTEXT *context );
osi_bool ctl_save_management_config( CTL_CONTEXT *context );

osi_bool ctl_remove_db( CTL_CONTEXT *context );
osi_bool ctl_drop_config( CTL_CONTEXT *context );
OSI_SCAN_CONFIG * ctl_get_config( CTL_CONTEXT *context );

osi_bool ctl_get_database( CTL_CONTEXT *context );
X509 * ctl_get_peer_certificate( CTL_CONTEXT *context );

/* utility functions. */

void wrap_control_request( CONTROL_REQUEST *request );
void unwrap_control_request( CONTROL_REQUEST *request );

void wrap_hello_response( OSI_HELLO_RESPONSE *hello );
void unwrap_hello_response( OSI_HELLO_RESPONSE *hello );

void encrypt_auth_context( OSI_AUTH_CONTEXT *auth_context );


#endif
