
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    rootpriv.h
**  Date:    February 17, 2002
**
**  Author:  Brian Wotring
**  Purpose: scanning daemon options.
**
******************************************************************************/

#ifndef ROOTPRIV_H_
#define ROOTPRIV_H_

#define ROOT_OP_SUCCESS     0x01
#define ROOT_OP_FAIL        0x00

#define ROOT_OP_STAT        0x02
#define ROOT_OP_LSTAT       0x03
#define ROOT_OP_OPENDIR     0x04
#define ROOT_OP_FOPEN       0x05
#define ROOT_OP_PIDFILE     0x06


/* RUN AS ROOT */

void handle_root_requests();
void wait_for_root_request();
void process_root_request();

void setup_signals();
void handle_signals();
void root_handle_sigchld( int signal );
void root_handle_sigterm( int signal );
void root_handle_sigint( int signal );

void setup_pidfile();

void send_fd( int socket, int fd );
int receive_fd( int socket );

/* END RUN AS ROOT. */


/* priv methods for common READ-ONLY file operations. */

FILE * rootpriv_fopen( const char *path );
int rootpriv_stat( const char *path, struct stat *file_stats );
int rootpriv_lstat( const char *path, struct stat *file_stats );
osi_bool rootpriv_opendir( const char *path, OSI_DIRECTORY *dir );

void rootpriv_setup_pidfile();

#endif
