'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH mAM001 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B mAM001
Analog Input Module
.SH SYNOPSIS
.SS Voltage or current meter.
.PP
.B B2
[.]XXXXXXXXXXXX[XX][/[
.B current
|
.B volts
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I B2
.SH SPECIAL PROPERTIES
Note that the 
.I volts 
and 
.I current 
are mutually exclusive and set by switches on the sensor case.
.PP
Although both
.I volts
and
.I current 
will give a value, only one of the two is correct. (Based on the electrical connections and switch settings).
.SS current
.I read-write, floating point
.br
Reads the current.
.TP
Range
0-20mA
.TP
Resolution
12 bit (5 uA)
.TP
Units
A (amperes)
.TP
Frequency
DC
.SS volts
.I read-write, floating point
.br
Reads the voltage.
.TP
Range
0-10V
.TP
Resolution
12 bit (2.5 mV)
.TP
Units
V (volts)
.TP
Frequency
DC
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS mAM001
The
.B mAM001 (3)
is a voltage or current meter from CMC Industrial Electronics. It is packaged for industrial use.
.SH ADDRESSING
.so man3/addressing.3so
.SH WEBSITE
.br
http://www.cmciel.com/products-solutions/individual-products/analog-input-mam001/
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
