/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.phonegap.DirectoryManager;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import com.phonegap.file.EncodingException;
import com.phonegap.file.FileExistsException;
import com.phonegap.file.InvalidModificationException;
import com.phonegap.file.NoModificationAllowedException;
import com.phonegap.file.TypeMismatchException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUtils
extends Plugin {
    private static final String LOG_TAG = "FileUtils";
    private static final String _DATA = "_data";
    public static int NOT_FOUND_ERR = 1;
    public static int SECURITY_ERR = 2;
    public static int ABORT_ERR = 3;
    public static int NOT_READABLE_ERR = 4;
    public static int ENCODING_ERR = 5;
    public static int NO_MODIFICATION_ALLOWED_ERR = 6;
    public static int INVALID_STATE_ERR = 7;
    public static int SYNTAX_ERR = 8;
    public static int INVALID_MODIFICATION_ERR = 9;
    public static int QUOTA_EXCEEDED_ERR = 10;
    public static int TYPE_MISMATCH_ERR = 11;
    public static int PATH_EXISTS_ERR = 12;
    public static int TEMPORARY = 0;
    public static int PERSISTENT = 1;
    public static int RESOURCE = 2;
    public static int APPLICATION = 3;
    FileReader f_in;
    FileWriter f_out;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("testSaveLocationExists")) {
                boolean b = DirectoryManager.testSaveLocationExists();
                return new PluginResult(status, b);
            }
            if (action.equals("getFreeDiskSpace")) {
                long l = DirectoryManager.getFreeDiskSpace(false);
                return new PluginResult(status, l);
            }
            if (action.equals("testFileExists")) {
                boolean b = DirectoryManager.testFileExists(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("testDirectoryExists")) {
                boolean b = DirectoryManager.testFileExists(args.getString(0));
                return new PluginResult(status, b);
            }
            if (action.equals("readAsText")) {
                String s = this.readAsText(args.getString(0), args.getString(1));
                return new PluginResult(status, s);
            }
            if (action.equals("readAsDataURL")) {
                String s = this.readAsDataURL(args.getString(0));
                return new PluginResult(status, s);
            }
            if (action.equals("write")) {
                long fileSize = this.write(args.getString(0), args.getString(1), args.getInt(2));
                return new PluginResult(status, fileSize);
            }
            if (action.equals("truncate")) {
                long fileSize = this.truncateFile(args.getString(0), args.getLong(1));
                return new PluginResult(status, fileSize);
            }
            if (action.equals("requestFileSystem")) {
                long size = args.optLong(1);
                if (size != 0L && size > DirectoryManager.getFreeDiskSpace(true) * 1024L) {
                    JSONObject error = new JSONObject().put("code", QUOTA_EXCEEDED_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                JSONObject obj = this.requestFileSystem(args.getInt(0));
                return new PluginResult(status, obj, "window.localFileSystem._castFS");
            }
            if (action.equals("resolveLocalFileSystemURI")) {
                JSONObject obj = this.resolveLocalFileSystemURI(args.getString(0));
                return new PluginResult(status, obj, "window.localFileSystem._castEntry");
            }
            if (action.equals("getMetadata")) {
                JSONObject obj = this.getMetadata(args.getString(0));
                return new PluginResult(status, obj, "window.localFileSystem._castDate");
            }
            if (action.equals("getFileMetadata")) {
                JSONObject obj = this.getFileMetadata(args.getString(0));
                return new PluginResult(status, obj, "window.localFileSystem._castDate");
            }
            if (action.equals("getParent")) {
                JSONObject obj = this.getParent(args.getString(0));
                return new PluginResult(status, obj, "window.localFileSystem._castEntry");
            }
            if (action.equals("getDirectory")) {
                JSONObject obj = this.getFile(args.getString(0), args.getString(1), args.optJSONObject(2), true);
                return new PluginResult(status, obj, "window.localFileSystem._castEntry");
            }
            if (action.equals("getFile")) {
                JSONObject obj = this.getFile(args.getString(0), args.getString(1), args.optJSONObject(2), false);
                return new PluginResult(status, obj, "window.localFileSystem._castEntry");
            }
            if (action.equals("remove")) {
                boolean success = this.remove(args.getString(0));
                if (success) {
                    this.notifyDelete(args.getString(0));
                    return new PluginResult(status);
                }
                JSONObject error = new JSONObject().put("code", NO_MODIFICATION_ALLOWED_ERR);
                return new PluginResult(PluginResult.Status.ERROR, error);
            }
            if (action.equals("removeRecursively")) {
                boolean success = this.removeRecursively(args.getString(0));
                if (success) {
                    return new PluginResult(status);
                }
                JSONObject error = new JSONObject().put("code", NO_MODIFICATION_ALLOWED_ERR);
                return new PluginResult(PluginResult.Status.ERROR, error);
            }
            if (action.equals("moveTo")) {
                JSONObject entry = this.transferTo(args.getString(0), args.getJSONObject(1), args.optString(2), true);
                return new PluginResult(status, entry, "window.localFileSystem._castEntry");
            }
            if (action.equals("copyTo")) {
                JSONObject entry = this.transferTo(args.getString(0), args.getJSONObject(1), args.optString(2), false);
                return new PluginResult(status, entry, "window.localFileSystem._castEntry");
            }
            if (action.equals("readEntries")) {
                JSONArray entries = this.readEntries(args.getString(0));
                return new PluginResult(status, entries, "window.localFileSystem._castEntries");
            }
            return new PluginResult(status, result);
        }
        catch (FileNotFoundException e) {
            try {
                JSONObject error = new JSONObject().put("code", NOT_FOUND_ERR);
                return new PluginResult(PluginResult.Status.ERROR, error);
                catch (FileExistsException e2) {
                    error = new JSONObject().put("code", PATH_EXISTS_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (NoModificationAllowedException e3) {
                    error = new JSONObject().put("code", NO_MODIFICATION_ALLOWED_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (JSONException e4) {
                    error = new JSONObject().put("code", NO_MODIFICATION_ALLOWED_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (InvalidModificationException e5) {
                    error = new JSONObject().put("code", INVALID_MODIFICATION_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (MalformedURLException e6) {
                    error = new JSONObject().put("code", ENCODING_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (IOException e7) {
                    error = new JSONObject().put("code", INVALID_MODIFICATION_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (EncodingException e8) {
                    error = new JSONObject().put("code", ENCODING_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
                catch (TypeMismatchException e9) {
                    error = new JSONObject().put("code", TYPE_MISMATCH_ERR);
                    return new PluginResult(PluginResult.Status.ERROR, error);
                }
            }
            catch (JSONException e10) {
                e10.printStackTrace();
                return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            }
        }
    }

    private void notifyDelete(String filePath) {
        int result = this.ctx.getContentResolver().delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data = ?", new String[]{filePath});
    }

    private JSONObject resolveLocalFileSystemURI(String url) throws IOException, JSONException {
        String decoded = URLDecoder.decode(url, "UTF-8");
        File fp = null;
        if (decoded.startsWith("content:")) {
            Cursor cursor = this.ctx.managedQuery(Uri.parse((String)decoded), new String[]{_DATA}, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow(_DATA);
            cursor.moveToFirst();
            fp = new File(cursor.getString(column_index));
        } else {
            URL testUrl = new URL(decoded);
            fp = decoded.startsWith("file://") ? new File(decoded.substring(7, decoded.length())) : new File(decoded);
        }
        if (!fp.exists()) {
            throw new FileNotFoundException();
        }
        if (!fp.canRead()) {
            throw new IOException();
        }
        return this.getEntry(fp);
    }

    private JSONArray readEntries(String fileName) throws FileNotFoundException, JSONException {
        File fp = new File(fileName);
        if (!fp.exists()) {
            throw new FileNotFoundException();
        }
        JSONArray entries = new JSONArray();
        if (fp.isDirectory()) {
            File[] files = fp.listFiles();
            for (int i = 0; i < files.length; ++i) {
                entries.put((Object)this.getEntry(files[i]));
            }
        }
        return entries;
    }

    private JSONObject transferTo(String fileName, JSONObject newParent, String newName, boolean move) throws JSONException, NoModificationAllowedException, IOException, InvalidModificationException, EncodingException {
        if (newName != null && newName.contains(":")) {
            throw new EncodingException("Bad file name");
        }
        File source = new File(fileName);
        if (!source.exists()) {
            throw new FileNotFoundException("The source does not exist");
        }
        File destinationDir = new File(newParent.getString("fullPath"));
        if (!destinationDir.exists()) {
            throw new FileNotFoundException("The source does not exist");
        }
        File destination = this.createDestination(newName, source, destinationDir);
        if (source.getAbsolutePath().equals(destination.getAbsolutePath())) {
            throw new InvalidModificationException("Can't copy a file onto itself");
        }
        if (source.isDirectory()) {
            if (move) {
                return this.moveDirectory(source, destination);
            }
            return this.copyDirectory(source, destination);
        }
        if (move) {
            return this.moveFile(source, destination);
        }
        return this.copyFile(source, destination);
    }

    private File createDestination(String newName, File fp, File destination) {
        File destFile = null;
        if ("null".equals(newName) || "".equals(newName)) {
            newName = null;
        }
        destFile = newName != null ? new File(destination.getAbsolutePath() + File.separator + newName) : new File(destination.getAbsolutePath() + File.separator + fp.getName());
        return destFile;
    }

    private JSONObject copyFile(File srcFile, File destFile) throws IOException, InvalidModificationException, JSONException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        FileChannel input = new FileInputStream(srcFile).getChannel();
        FileChannel output = new FileOutputStream(destFile).getChannel();
        input.transferTo(0L, input.size(), output);
        input.close();
        output.close();
        return this.getEntry(destFile);
    }

    private JSONObject copyDirectory(File srcDir, File destinationDir) throws JSONException, IOException, NoModificationAllowedException, InvalidModificationException {
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (this.isCopyOnItself(srcDir.getAbsolutePath(), destinationDir.getAbsolutePath())) {
            throw new InvalidModificationException("Can't copy itself into itself");
        }
        if (!destinationDir.exists() && !destinationDir.mkdir()) {
            throw new NoModificationAllowedException("Couldn't create the destination direcotry");
        }
        for (File file : srcDir.listFiles()) {
            if (file.isDirectory()) {
                this.copyDirectory(file, destinationDir);
                continue;
            }
            File destination = new File(destinationDir.getAbsoluteFile() + File.separator + file.getName());
            this.copyFile(file, destination);
        }
        return this.getEntry(destinationDir);
    }

    private boolean isCopyOnItself(String src, String dest) {
        return dest.startsWith(src) && dest.indexOf(File.separator, src.length() - 1) != -1;
    }

    private JSONObject moveFile(File srcFile, File destFile) throws JSONException, InvalidModificationException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (!srcFile.renameTo(destFile)) {
            // empty if block
        }
        return this.getEntry(destFile);
    }

    private JSONObject moveDirectory(File srcDir, File destinationDir) throws JSONException, InvalidModificationException {
        if (destinationDir.exists() && destinationDir.isFile()) {
            throw new InvalidModificationException("Can't rename a file to a directory");
        }
        if (this.isCopyOnItself(srcDir.getAbsolutePath(), destinationDir.getAbsolutePath())) {
            throw new InvalidModificationException("Can't move itself into itself");
        }
        if (destinationDir.exists() && destinationDir.list().length > 0) {
            throw new InvalidModificationException("directory is not empty");
        }
        if (!srcDir.renameTo(destinationDir)) {
            // empty if block
        }
        return this.getEntry(destinationDir);
    }

    private boolean removeRecursively(String filePath) throws FileExistsException {
        File fp = new File(filePath);
        if (this.atRootDirectory(filePath)) {
            return false;
        }
        return this.removeDirRecursively(fp);
    }

    private boolean removeDirRecursively(File directory) throws FileExistsException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                this.removeDirRecursively(file);
            }
        }
        if (!directory.delete()) {
            throw new FileExistsException("could not delete: " + directory.getName());
        }
        return true;
    }

    private boolean remove(String filePath) throws NoModificationAllowedException, InvalidModificationException {
        File fp = new File(filePath);
        if (this.atRootDirectory(filePath)) {
            throw new NoModificationAllowedException("You can't delete the root directory");
        }
        if (fp.isDirectory() && fp.list().length > 0) {
            throw new InvalidModificationException("You can't delete a directory that is not empty.");
        }
        return fp.delete();
    }

    private JSONObject getFile(String dirPath, String fileName, JSONObject options, boolean directory) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
        boolean create = false;
        boolean exclusive = false;
        if (options != null && (create = options.optBoolean("create"))) {
            exclusive = options.optBoolean("exclusive");
        }
        if (fileName.contains(":")) {
            throw new EncodingException("This file has a : in it's name");
        }
        File fp = this.createFileObject(dirPath, fileName);
        if (create) {
            if (exclusive && fp.exists()) {
                throw new FileExistsException("create/exclusive fails");
            }
            if (directory) {
                fp.mkdir();
            } else {
                fp.createNewFile();
            }
            if (!fp.exists()) {
                throw new FileExistsException("create fails");
            }
        } else {
            if (!fp.exists()) {
                throw new FileNotFoundException("path does not exist");
            }
            if (directory) {
                if (fp.isFile()) {
                    throw new TypeMismatchException("path doesn't exist or is file");
                }
            } else if (fp.isDirectory()) {
                throw new TypeMismatchException("path doesn't exist or is directory");
            }
        }
        return this.getEntry(fp);
    }

    private File createFileObject(String dirPath, String fileName) {
        File fp = null;
        fp = fileName.startsWith("/") ? new File(fileName) : new File(dirPath + File.separator + fileName);
        return fp;
    }

    private JSONObject getParent(String filePath) throws JSONException {
        if (this.atRootDirectory(filePath)) {
            return this.getEntry(filePath);
        }
        return this.getEntry(new File(filePath).getParent());
    }

    private boolean atRootDirectory(String filePath) {
        return filePath.equals(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.ctx.getPackageName() + "/cache") || filePath.equals(Environment.getExternalStorageDirectory().getAbsolutePath());
    }

    private JSONObject getMetadata(String filePath) throws FileNotFoundException, JSONException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Failed to find file in getMetadata");
        }
        JSONObject metadata = new JSONObject();
        metadata.put("modificationTime", file.lastModified());
        return metadata;
    }

    private JSONObject getFileMetadata(String filePath) throws FileNotFoundException, JSONException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("File: " + filePath + " does not exist.");
        }
        JSONObject metadata = new JSONObject();
        metadata.put("size", file.length());
        metadata.put("type", (Object)FileUtils.getMimeType(filePath));
        metadata.put("name", (Object)file.getName());
        metadata.put("fullPath", (Object)file.getAbsolutePath());
        metadata.put("lastModifiedDate", file.lastModified());
        return metadata;
    }

    private JSONObject requestFileSystem(int type) throws IOException, JSONException {
        JSONObject fs = new JSONObject();
        if (type == TEMPORARY) {
            File fp;
            fs.put("name", (Object)"temporary");
            if (Environment.getExternalStorageState().equals("mounted")) {
                fs.put("root", (Object)this.getEntry(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.ctx.getPackageName() + "/cache/"));
                fp = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + this.ctx.getPackageName() + "/cache/");
            } else {
                fs.put("root", (Object)this.getEntry("/data/data/" + this.ctx.getPackageName() + "/cache/"));
                fp = new File("/data/data/" + this.ctx.getPackageName() + "/cache/");
            }
            fp.mkdirs();
        } else if (type == PERSISTENT) {
            fs.put("name", (Object)"persistent");
            if (Environment.getExternalStorageState().equals("mounted")) {
                fs.put("root", (Object)this.getEntry(Environment.getExternalStorageDirectory()));
            } else {
                fs.put("root", (Object)this.getEntry("/data/data/" + this.ctx.getPackageName()));
            }
        } else {
            throw new IOException("No filesystem of type requested");
        }
        return fs;
    }

    public JSONObject getEntry(File file) throws JSONException {
        JSONObject entry = new JSONObject();
        entry.put("isFile", file.isFile());
        entry.put("isDirectory", file.isDirectory());
        entry.put("name", (Object)file.getName());
        entry.put("fullPath", (Object)file.getAbsolutePath());
        return entry;
    }

    private JSONObject getEntry(String path) throws JSONException {
        return this.getEntry(new File(path));
    }

    public boolean isSynch(String action) {
        if (action.equals("testSaveLocationExists")) {
            return true;
        }
        if (action.equals("getFreeDiskSpace")) {
            return true;
        }
        if (action.equals("testFileExists")) {
            return true;
        }
        return action.equals("testDirectoryExists");
    }

    public String readAsText(String filename, String encoding) throws FileNotFoundException, IOException {
        byte[] bytes = new byte[1000];
        BufferedInputStream bis = new BufferedInputStream(this.getPathFromUri(filename), 1024);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int numRead = 0;
        while ((numRead = bis.read(bytes, 0, 1000)) >= 0) {
            bos.write(bytes, 0, numRead);
        }
        return new String(bos.toByteArray(), encoding);
    }

    public String readAsDataURL(String filename) throws FileNotFoundException, IOException {
        byte[] bytes = new byte[1000];
        BufferedInputStream bis = new BufferedInputStream(this.getPathFromUri(filename), 1024);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int numRead = 0;
        while ((numRead = bis.read(bytes, 0, 1000)) >= 0) {
            bos.write(bytes, 0, numRead);
        }
        String contentType = null;
        if (filename.startsWith("content:")) {
            Uri fileUri = Uri.parse((String)filename);
            contentType = this.ctx.getContentResolver().getType(fileUri);
        } else {
            contentType = FileUtils.getMimeType(filename);
        }
        byte[] base64 = Base64.encodeBase64((byte[])bos.toByteArray());
        String data = "data:" + contentType + ";base64," + new String(base64);
        return data;
    }

    public static String getMimeType(String filename) {
        MimeTypeMap map = MimeTypeMap.getSingleton();
        return map.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)filename));
    }

    public long write(String filename, String data, int offset) throws FileNotFoundException, IOException {
        boolean append = false;
        if (offset > 0) {
            this.truncateFile(filename, offset);
            append = true;
        }
        byte[] rawData = data.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(rawData);
        FileOutputStream out = new FileOutputStream(filename, append);
        byte[] buff = new byte[rawData.length];
        in.read(buff, 0, buff.length);
        out.write(buff, 0, rawData.length);
        out.flush();
        out.close();
        return data.length();
    }

    private long truncateFile(String filename, long size) throws FileNotFoundException, IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "rw");
        if (raf.length() >= size) {
            FileChannel channel = raf.getChannel();
            channel.truncate(size);
            return size;
        }
        return raf.length();
    }

    private InputStream getPathFromUri(String path) throws FileNotFoundException {
        if (path.startsWith("content")) {
            Uri uri = Uri.parse((String)path);
            return this.ctx.getContentResolver().openInputStream(uri);
        }
        return new FileInputStream(path);
    }

    protected static String getRealPathFromURI(Uri contentUri, PhonegapActivity ctx) {
        String[] proj = new String[]{_DATA};
        Cursor cursor = ctx.managedQuery(contentUri, proj, null, null, null);
        int column_index = cursor.getColumnIndexOrThrow(_DATA);
        cursor.moveToFirst();
        return cursor.getString(column_index);
    }
}

