dnl
dnl Checking for ImageMagick
dnl
AC_DEFUN([AC_CHECK_IMAGEMAGICK], [
    AC_ARG_WITH([imagemagick],
                AC_HELP_STRING([--without-imagemagick], 
                               [Turn off ImageMagick support.]),
                [], [with_imagemagick=yes])

    if test x"$with_imagemagick" = xyes; then
        AC_PATH_TOOL(IMAGEMAGICK_CONFIG, Wand-config, no)
        if test "$IMAGEMAGICK_CONFIG" = "no" ; then
            AC_MSG_RESULT([*** All ImageMagick dependent parts will be disabled, Wand-config not found. ***])
            have_imagemagick=no
        else
            IMAGEMAGICK_CFLAGS=`$IMAGEMAGICK_CONFIG --cflags`
            IMAGEMAGICK_LDFLAGS=`$IMAGEMAGICK_CONFIG --ldflags`
            IMAGEMAGICK_LIBS=`$IMAGEMAGICK_CONFIG --libs`
            have_imagemagick=yes
            AC_DEFINE(HAVE_IMAGEMAGICK,1,[Define this if you have ImageMagick])
        fi
    else
        have_imagemagick=no
    fi

    AM_CONDITIONAL(HAVE_IMAGEMAGICK, test x"$have_imagemagick" = "xyes" )
    AC_SUBST(IMAGEMAGICK_CFLAGS)
    AC_SUBST(IMAGEMAGICK_LDFLAGS)
    AC_SUBST(IMAGEMAGICK_LIBS)
])
