
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Most of this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: download.h 1182 2006-09-22 07:53:33Z mschwerin $
 *
 */

#ifndef HAVE_DOWNLOAD_H
#define HAVE_DOWNLOAD_H
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    char *buf;
    char *error;
    int size;
    int status;
} download_t;

int network_download (const char *url, download_t * download);
int is_downloadable (const char *url);
char *download_to_cache (const char *url, const char *filename, int force_update);

download_t * download_new (void);
void download_free (download_t * download);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_DOWNLOAD_H */
