dnl
dnl checking for stuff the extractor needs 
dnl
AC_DEFUN([AC_CHECK_EXTRACTOR], [
    AC_ARG_ENABLE([extractor], 
                  AC_HELP_STRING([--disable-extractor], 
                                 [do not activate ripping support]),
                  [enable_extractor=$enableval], [enable_extractor=yes])

    have_extractor=no
    have_extractor_dvd=no
    have_extractor_vcd=no
    have_extractor_cdda=no
    have_encoder_flac=no
    have_encoder_ogg=no
    have_encoder_mp3=no

    AC_CHECK_HAL

    if test "$have_hal" == "no" ; then
        AC_MSG_WARN([])
        AC_MSG_WARN([Please install the HAL subsystem if you wish to use the extractor.])
        AC_MSG_WARN([])
        enable_extractor=no
    fi

    if test "$enable_extractor" == "yes" ; then
        AC_PATH_PROG(cdparanoia_path, cdparanoia, no)
        if test "$cdparanoia_path" == no ; then
            AC_MSG_WARN([*** You need cdparanoia if you wish to use the extractor! ***])
        else
            AC_DEFINE_UNQUOTED([BIN_CDPARANOIA], 
                               ["${cdparanoia_path}"], 
                               [path to cdparanoia])
            have_extractor_cdda=yes
        fi

        AC_PATH_PROG(flac_path, flac, no)
        if test "$flac_path" != no ; then
            AC_DEFINE_UNQUOTED([BIN_FLAC], 
                               ["${flac_path}"], 
                               [path to flac])
            have_encoder_flac=yes
            have_extractor_cdda=yes
        fi

        AC_PATH_PROG(oggenc_path, oggenc, no)
        if test "$oggenc_path" != no ; then
            AC_DEFINE_UNQUOTED([BIN_OGGENC], 
                               ["${oggenc_path}"], 
                               [path to oggenc])
            have_encoder_ogg=yes
            have_extractor_cdda=yes
        fi

        AC_PATH_PROG(lame_path, lame, no)
        if test "$lame_path" != no ; then
            AC_DEFINE_UNQUOTED([BIN_LAME], 
                               ["${lame_path}"], 
                               [path to lame])
            have_encoder_mp3=yes
            have_extractor_cdda=yes
        fi

        AC_PATH_PROG(dd_path, dd, no)
        if test "$dd_path" != no ; then
            AC_DEFINE_UNQUOTED([BIN_DD], 
                               ["${dd_path}"], 
                               [path to dd])
            have_extractor_dvd=yes
            have_extractor_vcd=yes
        fi

        if test "$have_extractor_cdda" == yes ; then
            AC_DEFINE([HAVE_EXTRACTOR_CDDA],,[Define this if you have everything needed for ripping audio CDs.])
            have_extractor=yes
        fi

        if test "$have_extractor_dvd" == yes ; then
            AC_DEFINE([HAVE_EXTRACTOR_DVD],,[Define this if you have everything needed for ripping DVDs.])
            have_extractor=yes
        fi

        if test "$have_extractor_vcd" == yes ; then
            AC_DEFINE([HAVE_EXTRACTOR_VCD],,[Define this if you have everything needed for ripping VCDs.])
            have_extractor=yes
        fi

        if test "$have_extractor" == yes ; then
            AC_DEFINE([HAVE_EXTRACTOR],,[Define this if you have everything needed for ripping.])
        fi
    fi
])
