dnl
dnl checking for SHOUTcast
dnl
AC_DEFUN([AC_CHECK_SHOUTCAST], [
    AC_ARG_ENABLE([shoutcast], 
                  AC_HELP_STRING([--disable-shoutcast], 
                                 [do not activate SHOUTcast support]),
                  [enable_shoutcast=$enableval], [enable_shoutcast=yes])

    if test x"$enable_shoutcast" = xyes; then
        AC_CHECK_CURL

        if test "$have_curl" = "yes"; then
            AC_DEFINE([HAVE_SHOUTCAST], [1], [Define this if you want to enable SHOUTcast support and have libcurl installed.])
            have_shoutcast=yes
        else
            AC_MSG_WARN([])
            AC_MSG_WARN([Please install the CURL library if you wish to use the SHOUTcast plugin.])
            AC_MSG_WARN([])
            have_shoutcast=no
        fi
    fi
])
