
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: menu_help.c 2537 2007-07-17 13:45:38Z mschwerin $
 *
 */
#include "config.h"

#include "i18n.h"
#include "menu_base.h"
#include "menu_help.h"
#include "otk.h"
#include "oxine.h"
#include "utils.h"

extern oxine_t *oxine;

#define BUTTON_Y                (odk_osd_get_height (oxine->odk) - 55)

#define x0                      (20)
#define w0                      ((odk_osd_get_width (oxine->odk) - 40) * 60 / 100)

#define x1                      (x0 + w0 + 10)
#define w1                      (odk_osd_get_width (oxine->odk) - 20 - x1)

#define x2                      (x1 + 30)

#define al                      (OTK_ALIGN_LEFT | OTK_ALIGN_TOP)
#define background              "menu_help.png"


static void
show_buttons (otk_cb_t cb)
{
    int x = 20;
    if (odk_current_is_playback_mode (oxine->odk)) {
        otk_widget_t *b;
        bool focused = true;
        b = otk_text_button_new (oxine->otk, x, BUTTON_Y, 180, 35,
                                 _("Next Page"), cb, oxine);
        otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
        otk_widget_set_focused (b, focused);
        x += 190;
    }
    {
        otk_widget_t *b;
        bool focused = !odk_current_is_playback_mode (oxine->odk);
        b = otk_text_button_new (oxine->otk, x, BUTTON_Y, 180, 35,
                                 _("Back"), backto_menu_cb, oxine);
        otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
        otk_widget_set_focused (b, focused);
    }
}


static void
show_line (int y, const char *l, const char *h1, const char *h2)
{
    if (l) {
        otk_label_new (oxine->otk, x0, y, w0, al, l);
    }
    if (h1) {
        otk_label_new (oxine->otk, x1, y, w1, al, h1);
    }
    if (h2) {
        otk_label_new (oxine->otk, x2, y, w1, al, h2);
    }
}


static void
show_menu_help_three (void *oxine_p)
{
    int y = 100;

    create_new_window (false, true);

    show_line (y, _("toggle mute / unmute"), "m", NULL);
    y += 30;

    show_line (y, _("adjust volume"), "+", "/ -");
    y += 50;

    show_line (y, _("change audio language"), "x", "/ X");
    y += 30;

    show_line (y, _("adjust audio offset"), "c", "/ C");
    y += 50;

    show_line (y, _("change subtitle language"), "r", "/ R");
    y += 30;

    show_line (y, _("adjust subtitle offset"), "t", "/ T");
    y += 50;

    show_line (y, _("toggle aspect ratio"), "a", NULL);
    y += 30;

    show_line (y, _("toggle deinterlace"), "i", NULL);
    y += 50;

    show_line (y, _("adjust zoom factor"), "z", "/ Z");
    y += 30;

    show_line (y, _("reset zoom factor"), "Ctrl + Alt + z", NULL);
    y += 50;

    show_buttons (show_menu_help);

    set_current_menu (show_menu_help_three, NULL);

    show_user_interface (NULL);
    show_menu_background (background);
}


static void
show_menu_help_two (void *oxine_p)
{
    int y = 100;

    create_new_window (false, true);

    show_line (y, _("pause / play"), _("space"), NULL);
    y += 30;

    show_line (y, _("stop the stream"), "s", NULL);
    y += 30;

    if (odk_current_is_dvd (oxine->odk)) {
        show_line (y, _("next / previous chapter"),
                   _("Ctrl + page up / down"), NULL);
    }

    else if (odk_current_is_dvb (oxine->odk)
             || odk_current_is_v4l (oxine->odk)) {
        show_line (y, _("next / previous channel"),
                   _("Ctrl + page up / down"), NULL);
    }

    else {
        show_line (y, _("next / previous title"),
                   _("Ctrl + page up / down"), NULL);
    }
    y += 50;

    show_line (y, _("fast rewind / foreward"),
               _("Ctrl + left / right"), NULL);
    y += 30;

    show_line (y, _("seek backward / foreward"),
               _("Ctrl + Alt + left / right"), NULL);
    y += 30;

    show_line (y, _("adjust stream speed"), _("Ctrl + up / down"), NULL);
    y += 50;

    show_line (y, _("toggle playmode (normal, shuffle, loop)"), "M", NULL);

    show_buttons (show_menu_help_three);

    set_current_menu (show_menu_help_two, NULL);

    show_user_interface (NULL);
    show_menu_background (background);
}


void
show_menu_help (void *oxine_p)
{
    int y = 100;

    create_new_window (false, true);

    show_line (y, _("navigate the menus"), _("arrow keys"), NULL);
    y += 30;

    show_line (y, _("activate an item or a button"), _("enter"), NULL);
    y += 30;

    show_line (y, _("select an item in a list"), _("space"), NULL);
    y += 30;

    show_line (y, _("go back / go up one level"), _("backspace / esc"), NULL);
    y += 30;

    if (odk_current_is_playback_mode (oxine->odk)
        && odk_current_has_video (oxine->odk)) {
        show_line (y, _("show / hide the OSD"), "o", NULL);
        y += 30;
    }
    y += 20;

    if (odk_current_is_playback_mode (oxine->odk)
        && odk_current_is_dvd (oxine->odk)) {
        show_line (y, _("go to the DVD menus"), _("Ctrl + F1-F7"), NULL);
        y += 50;
    }

    if (odk_current_is_playback_mode (oxine->odk)) {
        show_line (y, _("show the playback menu"), "F3", NULL);
        y += 30;
    }

    show_line (y, _("show the main menu"), "F5", NULL);
    y += 30;

    show_line (y, _("show the music menu"), "F6", NULL);
    y += 30;

    show_line (y, _("show the video menu"), "F7", NULL);
    y += 30;

#ifdef HAVE_IMAGE_PLAYBACK
    show_line (y, _("show the image menu"), "F8", NULL);
    y += 30;
#endif

    show_line (y, _("show the playlist menu"), "F9", NULL);
    y += 30;

#ifdef HAVE_WEATHER
    show_line (y, _("show the weather menu"), "F10", NULL);
#endif

    show_buttons (show_menu_help_two);

    set_current_menu (show_menu_help, NULL);

    show_user_interface (NULL);
    show_menu_background (background);
}
