
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: meta_info.h 2384 2007-06-29 09:04:19Z mschwerin $
 *
 */

#ifndef HAVE_META_INFO_H
#define HAVE_META_INFO_H


/**
 * These are the meta information types that can be returned.
 */
typedef enum {
    META_INFO_TITLE = XINE_META_INFO_TITLE,
    META_INFO_ARTIST = XINE_META_INFO_ARTIST,
    META_INFO_GENRE = XINE_META_INFO_GENRE,
    META_INFO_ALBUM = XINE_META_INFO_ALBUM,
    META_INFO_YEAR = XINE_META_INFO_YEAR,
    META_INFO_TRACK_NUMBER = XINE_META_INFO_TRACK_NUMBER,
} meta_info_t;


/**
 * Initialize the meta information module.
 */
void meta_info_init (xine_t * xine);


/**
 * Free the meta information module.
 */
void meta_info_free (void);


/**
 * Returns the requested meta info.
 *
 * @param type                  The meta information type to return.
 * @param mrl                   The MRL of a media file.
 */
char *meta_info_get (meta_info_t type, const char *mrl);


/**
 * Returns the requested meta info.
 *
 * @param type                  The meta information type to return.
 * @param stream                A valid, open stream object.
 */
char *meta_info_get_from_stream (meta_info_t type, xine_stream_t * stream);


/**
 * Returns the playback length in seconds of the passed MRL.
 *
 * @param mrl                   The MRL of a media file.
 */
int meta_info_get_playback_length (const char *mrl);


#ifdef HAVE_LIBEXIF

typedef enum {
    EXIF_INFO_SORT,
    EXIF_INFO_DATE,
    EXIF_INFO_TIME,
} exif_info_t;


/**
 * Returns the requested EXIF info.
 *
 * @param type                  The EXIF information type to return.
 * @param mrl                   The MRL of a media file.
 */
char *exif_info_get (exif_info_t type, const char *mrl);


#endif /* HAVE_LIBEXIF */


#endif /* HAVE_META_INFO_H */
