
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_widget.h 2135 2007-05-23 09:43:27Z mschwerin $
 *
 */

#ifndef HAVE_OTK_WIDGET_H
#define HAVE_OTK_WIDGET_H

#define OTK_ALIGN_LEFT              (0x001)
#define OTK_ALIGN_CENTER            (0x002)
#define OTK_ALIGN_RIGHT             (0x004)
#define OTK_ALIGN_TOP               (0x008)
#define OTK_ALIGN_VCENTER           (0x010)
#define OTK_ALIGN_BOTTOM            (0x020)

#define OTK_SELECTABLE_NONE         (0x000)
#define OTK_SELECTABLE_KEY          (0x001)
#define OTK_SELECTABLE_MOUSE        (0x010)

typedef enum {
    OTK_WIDGET_WINDOW,
    OTK_WIDGET_BUTTON,
    OTK_WIDGET_LABEL,
    OTK_WIDGET_LIST,
    OTK_WIDGET_LISTENTRY,
    OTK_WIDGET_SLIDER,
    OTK_WIDGET_SCROLLBAR,
    OTK_WIDGET_CHECKBOX,
    OTK_WIDGET_BORDER,
    OTK_WIDGET_EDITBOX,
    OTK_WIDGET_IMAGE,
} otk_widget_type_t;


/// The datastructure of a widget.
struct otk_widget_s {
    otk_widget_type_t type;

    otk_t *otk;
    odk_t *odk;

    int x;
    int y;
    int w;
    int h;

    int selectable;

    bool is_focused;
    bool is_enabled;
    bool is_visible;

    bool need_update;
    bool need_repaint;

    char *font;
    int fontsize;
    int alignment;

    int foreground_color;
    int background_color;

    void (*draw) (otk_widget_t * this);
    void (*hide) (otk_widget_t * this);
    void (*destroy) (otk_widget_t * this);
    void (*update) (otk_widget_t * this);

    void (*key_handler) (otk_widget_t * this, oxine_event_t * event);
    void (*button_handler) (otk_widget_t * this, oxine_event_t * event);
    void (*motion_handler) (otk_widget_t * this, oxine_event_t * event);

    // we call this callback when this item gets the focus
    void *focus_enter_cb_data;
    void (*focus_enter_cb) (void *user_data);

    // we call this callback when this item looses the focus
    void *focus_leave_cb_data;
    void (*focus_leave_cb) (void *user_data);
};

void otk_widget_set_focus_callbacks (otk_widget_t * widget,
                                     otk_cb_t enter_cb, void *enter_cb_data,
                                     otk_cb_t leave_cb, void *leave_cb_data);

void otk_widget_set_font (otk_widget_t * widget,
                          const char *font, int fontsize);

void otk_widget_constructor (otk_widget_t * widget, otk_t * otk,
                             otk_widget_type_t type,
                             int x, int y, int w, int h);
void otk_widget_destructor (otk_widget_t * widget);

void otk_widget_set_updated (otk_widget_t * widget, bool updated);
void otk_widget_set_focused (otk_widget_t * widget, bool focused);
void otk_widget_set_enabled (otk_widget_t * widget, bool enabled);
void otk_widget_set_visible (otk_widget_t * widget, bool visible);
void otk_widget_set_alignment (otk_widget_t * widget, int alignment);
void otk_widget_set_selectable (otk_widget_t * widget, int selectable);

/// Checks if the expected type and the real type of a widget are the same.
bool otk_widget_is_correct (otk_widget_t * widget,
                            otk_widget_type_t expected);

/// Returns a string identifying the type of the widget.
const char *otk_widget_get_type (otk_widget_t * widget);

#endif /* HAVE_OTK_WIDGET_H */
