
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: oxine.h 2523 2007-07-17 12:30:20Z mschwerin $
 *
 */

#ifndef HAVE_OXINE_H
#define HAVE_OXINE_H

#include "filelist.h"
#include "odk.h"
#include "otk.h"
#include "playlist.h"
#include "menulist.h"
#include "weather.h"


/**
 * Contains the data of the currently visible message dialog. This is
 * necessary so we can show the same message dialog when a repaint event
 * occurs. I'd rather have defined this locally in utils_gui.c but we have
 * to initialize and free it somewhere.
 */
typedef struct {
    /// The callback for the 'OK' button.
    otk_cb_t ok_cb;
    /// The user data for <code>ok_cb</code>
    void *ok_cb_data;
    /// The callback for the 'Cancel' button.
    otk_cb_t cancel_cb;
    /// The user data for <code>cancel_cb</code>
    void *cancel_cb_data;
    /// The type of the dialog.
    int type;
    /// The background MRL.
    char *background_mrl;
    /// The message to show.
    char *msg;
} current_dialog_data_t;


/// This is the main data structure.
typedef struct {
    /// The one and only xine object.
    xine_t *xine;

    /// The OTK instance.
    otk_t *otk;

    /// The ODK instance.
    odk_t *odk;

    /// The ID of a job that show the playback menu after a certain time.
    int playback_menu_job;

#ifdef HAVE_HAL

    /**
     * A list of volumes and drives currently present in the system. This
     * list is maintained by the HAL monitor thread. Drives and volumes are
     * added and removed automatically whenever HAL tells us about a removal
     * or addition.
     *
     * Drives are only added, if there are no volumes associated with the
     * drive. This is necessary, so that we don't have to keep a separate list
     * of drives for the eject dialog.
     */
    filelist_t *hal_volume_list;
#endif

#ifdef HAVE_WEATHER

    /**
     * The current weather data. This data is updated by the weather
     * thread.
     *
     * @see start_weather_thread
     */
    weather_t *weather;

    /**
     * A mutex to protect the weather retrieval. This mutex is necessary, as
     * we have several threads updating a single weather object.
     */
    pthread_mutex_t weather_mutex;
#endif

    /// This is TRUE whenever a GUI is visible.
    bool user_interface_is_visible;
    /// This is TRUE whenever the playback controls are visible.
    bool playback_controls_are_visible;
    /// This is TRUE whenever the stream parameter is visible.
    bool stream_parameter_is_visible;

    /**
     * The main playlist. This is the main playlist that is used for normal
     * media files. This is the playlist, that the user can edit.
     */
    playlist_t *rw_playlist;

    /**
     * The read-only playlist. This playlist is used for DVD, VCD, DVB, V4L,
     * VDR playback. It is also used to add any files the user may specify
     * on the command line. This playlist can not be edited in any way.
     */
    playlist_t *ro_playlist;

    /**
     * The current playlist. It can be one of the above. 
     */
    playlist_t *current_playlist;

    /// The menu items of the main menu.
    menulist_t *main_menu;

    /// This stores the data needed to show the current message dialog.
    current_dialog_data_t current_dialog_data;

    /** 
     * This is a shell command to execute before leaving oxine. We want to
     * execute this right before leaving main.
     */
    char *shutdown_command;

    /// If this is set to TRUE oxine will restart.
    bool restart;
} oxine_t;

/**
\mainpage oxine

\section sec_general About oxine

oxine is a lightweight pure OSD (on screen display) GUI for the famous
<a target="_top" href="http://xinehq.de/">xine</a> engine. oxine is particularly suited
for set-top boxes or home entertainment systems. More information about oxine
can be found on the <a target="_top" href="http://oxine.sf.net">oxine homepage</a>.

\section sec_contact Contact

Questions, answers, suggestions, contributions to 
<a target="_top" href="http://sf.net/mail/?group_id=72768">oxine-devel</a>. 
Please submit 
<a target="_top" href="http://sourceforge.net/tracker/?group_id=72768&atid=535638">bugs</a>,
<a target="_top" href="http://sourceforge.net/tracker/?group_id=72768&atid=535641">feature requests</a> and
<a target="_top" href="http://sourceforge.net/tracker/?group_id=72768&atid=535639">support requests</a>
to the respective trackers. This helps the developers to keep an overview of
what has been and what still needs to be done.

\section sec_license License

oxine is published under the GNU General Public License (Version 2). A copy of
this license is distributed with the source code in the file COPYING in the
base directory.
*/

#endif /* HAVE_OXINE_H */
