//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __PACKAGELISTVIEWITEM_H_2005_03_13
#define __PACKAGELISTVIEWITEM_H_2005_03_13

#include <qlistview.h>

/** @brief List item to represent a package in a list view.
  * 
  * @author Benjamin Mesing
  */
class PackageListViewItem : public QListViewItem
{
	/** @brief The package this list item represents. */
	int _packageHandle;
public:
	/** @brief Creates an item for the list view.
	  * 
	  * @param pParent list view where to insert the item
	  * @param packageHandle package to represent
	   */
	PackageListViewItem(QListView *pParent, int packageHandle) : QListViewItem(pParent)
	{	_packageHandle = packageHandle; };
	~PackageListViewItem();
	/** @brief Returns the name of the package represented by this list view item. */
	QString packageName();
	/** @brief Returns the name of the handle of the package represented by this list view item. */
	int packageHandle();
};

#endif	// __PACKAGELISTVIEWITEM_H_2005_03_13
