//
// C++ Implementation: tagselectionlistview.cpp
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:13:27


#include <vector>
#include <algorithm>
#include <functional>
#include <assert.h>


#include <q3popupmenu.h>
//Added by qt3to4:
#include <QMouseEvent>

#include <apt-front/cache/entity/tag.h>

#include "tagselectionlistview.h"
#include "taglistviewitem.h"
#include "exception.h"

// NUtil
#include "debtagshelper.h"


namespace NWidgets
{

TagSelectionListView::TagSelectionListView(QWidget *parent, const char *name)
 : Q3ListView(parent, name)
{
	_pColl = 0;
	
	addColumn("Tags");
	addColumn("Description");
	setColumnWidthMode(0, Q3ListView::Manual);
	setColumnWidthMode(1, Q3ListView::Manual);
	setResizeMode(Q3ListView::LastColumn);
	setSelectionMode(Q3ListView::Multi);
	
	connect( 
		this, SIGNAL(contextMenuRequested(Q3ListViewItem*, const QPoint&, int)),
		SLOT(onContextMenuRequested(Q3ListViewItem*, const QPoint&, int))
	);
	connect( this, SIGNAL(selectionChanged()), SLOT(onSelectionChanged()));

	setColumnWidth(0,100);
}


void TagSelectionListView::deselectTag(const string& fullTagname)
{
	/// @todo had to change to the this... version because of the covariance not supported thing
	TagListViewItem* p = thisGetTagItem(fullTagname);
	setSelected(p, false);
}

void TagSelectionListView::deselectAll()
{
	clearSelection();	// this triggers selectionChanged signal(s)
}

void TagSelectionListView::expandAll()
{
	for (iterator it = begin(); it != end(); ++it)
		it->setOpen(true);
}

void TagSelectionListView::collapseAll()
{
	for (iterator it = begin(); it != end(); ++it)
		it->setOpen(false);
}


void TagSelectionListView::clear()
{
	// clear the list
	Q3ListView::clear();	// this should emit the selection changed signal
}

TagItem* TagSelectionListView::getTagItem(const string& fullName)
{
	iterator it = std::find_if(
		begin(), end(), 
		// unfortunatelly bind2nd(mem_fun(&TagItem::equals_to),fullName)
		// with equals_to(const string&) 
		// does not work, as the algorithm tries to create "const const string& &" for
		// the constructor :-(
		TagSelectionView::equal_to_tagname(fullName)
		
//		bind1st( equal_to<string>(mem_fun(&TagItem::fullTagname)),fullName )
	);
	return (it == end()) ?  0 : (*it);
}


void TagSelectionListView::loadVocabulary(const Tagcoll::OpSet<entity::Facet>& vocabulary)
{
	set<string> selectedTags;
	// collect the items currently selected
	transform (
		_selected.begin(), _selected.end(), 
		inserter(selectedTags, selectedTags.begin()),	// inserter to insert in the set
		mem_fun(&TagItem::fullTagname)
	);
	// This will be filled with the new tagItems that where selected in the old version.
	vector<TagListViewItem*> newSelected;
	clear();
	TagListViewItem* pRoot = new TagListViewItem(this, "/");	// insert as subitem of the root
	pRoot->setSelectable(false);
	pRoot->setOpen(true);
	// iterate over all facets
	for ( Tagcoll::OpSet<entity::Facet>::const_iterator it = vocabulary.begin(); it != vocabulary.end(); ++it )
	{
		// add the facet to the view
		/// @todo add the long description as tooltip
		const entity::Facet& facet = *it;
		TagListViewItem* pFacetItem = new TagListViewItem(pRoot, facet.name(), facet.shortDescription());
		pFacetItem->setSelectable(false);
		assert(pFacetItem);
		Tagcoll::OpSet<entity::Tag> tags = facet.tags();
		for ( Tagcoll::OpSet<entity::Tag>::const_iterator jt = tags.begin(); jt != tags.end(); ++jt)
		{
			const entity::Tag& tag = *jt;
			///@todo here loading fails under really strange circumstences - I assume a qt 
			/// or debtags bug here
			/// though I am not sure about it. The plugin crashes if this is called some more often
			/// and I don't know why. Using pRoot as parent works completely and so does it with
			/// loading only the 5 first factes (see above)
			/// it even happens if I use QListViewItems instead of TagListViewItems so it
			/// strongly speaks for a QT or debtags bug
			TagListViewItem* pItem = new TagListViewItem(
				pFacetItem, facet.name() + "::" + tag.name(), tag.shortDescription());

			if ( selectedTags.find(tag.name()) != selectedTags.end() )	// if the tag was selected before
				newSelected.push_back(pItem);	// add it to the new selected items
		}
		if ( selectedTags.find(facet.name()) != selectedTags.end() )	// if the tag was selected before
			newSelected.push_back(pFacetItem);	// add it to the new selected items
	}
	for( vector<TagListViewItem*>::iterator it = newSelected.begin(); it != newSelected.end(); ++it)
		setSelected(*it,true);
}

void TagSelectionListView::filter()
{
	// this is neccessary as QListViewItem setVisible() also makes all beneath the parents visible,
	// this behavoir is kinda odd because it does only occur if we go from a less detailed listview
	// to a more detailed one
	Q3ListViewItem* pCurrent = currentItem();
	if (pCurrent && !pCurrent->isVisible())	// if the item is not visible do not ensure it later
		pCurrent = 0;
	makeAllVisible();
	filterByName();
	filterByTagSet();
	if (pCurrent)
		ensureItemVisible(pCurrent);
}

void TagSelectionListView::filterByName() 
{
	if (_filterByNamePattern.empty()) return;
	// there should be exactly one or no root item
	TagListViewItem* pRoot = static_cast<TagListViewItem*>(firstChild());
	if (pRoot == 0)	// if we do not have a root
		return;
	pRoot->filterByName(_filterByNamePattern);
}

void TagSelectionListView::filterByTagSet()
{
	if (_pColl==0 || _selected.empty() ) return;
	TagListViewItem* pRoot = static_cast<TagListViewItem*>(firstChild());
	if (pRoot == 0)	// if we do not have a root
		return;
	
	Tagcoll::OpSet<entity::Tag> selectedTags = getSelectedTags();
	
	Tagcoll::OpSet<string> companionTags = NUtil::tagsToStrings(_pColl->getCompanionTags(selectedTags));
// TODO verify, that selectedTags part_of companionTags -> currently it doesn't, but shouldn't it be good to?
	companionTags += NUtil::tagsToStrings(selectedTags);
	pRoot->filterByTagset(companionTags);
}

void TagSelectionListView::makeAllVisible()
{
	for ( iterator it = begin(Q3ListViewItemIterator::Invisible); it != end(); ++it)
		it->setVisible(true);
}

void TagSelectionListView::onSelectionChanged()
{
	_selected.clear();
	_selected = set<TagItem*>(begin(Q3ListViewItemIterator::Selected), end());
	filter();
	emit tagItemsSelected(_selected);
}

Tagcoll::OpSet<entity::Tag> TagSelectionListView::getSelectedTags()
{
	Tagcoll::OpSet<entity::Tag> selectedTags;
	const aptFront::cache::component::Tags& tags = aptFront::cache::Global::get().tags();
	// insert all items names in the new set
	for ( set<TagItem*>::const_iterator it = _selected.begin(); it != _selected.end(); ++it)
	{
		selectedTags.insert( tags.tagByName((*it)->fullTagname()) );
	}
	return selectedTags;
}

void TagSelectionListView::onContextMenuRequested(Q3ListViewItem* item, const QPoint& pos, int col)
{
	Q3PopupMenu menu(this);
	menu.insertItem("Expand all", 1);
	menu.insertItem("Collapse all", 2);
	menu.insertItem("Deselect all", 3);
	switch (menu.exec(pos))
	{
		case 1:
			expandAll();
			break;
		case 2:
			collapseAll();
			break;
		case 3:
			deselectAll();
			break;
		default:
			break;
	}
}


void TagSelectionListView::contentsMousePressEvent(QMouseEvent* pE)
{
	Q3ListViewItem* pItem = itemAt( QPoint(0, pE->pos().y()) );
	if (pE->button() == Qt::RightButton )
		emit contextMenuRequested(pItem, pE->globalPos(), -1 );
	else
		Q3ListView::contentsMousePressEvent(pE);
	return;
}


}	// namespace NWidgets

