//
// C++ Implementation: main
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <string>
#include <iostream>

#include <qapplication.h>
#include <QMessageBox>

#include <apt-front/init.h>
#include <apt-front/cache/cache.h>
#include <apt-front/cache/component/packagetags.h>

#include "packagesearchimpl.h"

#include "helpers.h"

#include "globals.h"


using namespace std;

#include <stdio.h>
#include <stdlib.h>

void myMessageOutput( QtMsgType type, const char *msg )
{
	switch ( type ) {
			case QtDebugMsg:
				// do nothing
				break;
			case QtWarningMsg:
				// do noting either
				break;
			case QtFatalMsg:
				fprintf( stderr, "%s\n", msg );
				abort();                    // deliberately core dump
	}
}

int main(int argc, char* argv[])
{
	string usage("Usage: packagesearch [options]\n"
		"\t-h, --help     prints this message\n"
		"\t-v, --version  prints the version information\n"
		"If started without options the UI is launched\n");
	#ifndef __DEBUG
	qInstallMsgHandler( myMessageOutput );
	#endif
	QApplication a(argc, argv);
	if (argc > 1)
	{
		for (int i=1; i < argc; ++i)
		{
			QString arg(argv[i]);
			if (arg == "--version" || arg == "-v")
			{
				cout << toString(NPackageSearch::VERSION) << endl;
				return 0;
			}
			if (arg == "--help" || arg == "-h")
			{
				cout << usage;
				return 0;
			}
			cout << "Unknown option " << argv[i] << endl;
			cout << usage << endl; 
			return 1;
		}
	}
	aptFront::init();
	int aptFrontFlags = aptFront::cache::Cache::OpenReadOnly | aptFront::cache::Cache::OpenPackages 
		| aptFront::cache::Cache::OpenState | aptFront::cache::Cache::OpenRecords;
	if (aptFront::cache::component::PackageTags::hasTagDatabase())
	{
		aptFrontFlags |= aptFront::cache::Cache::OpenDebtags | aptFront::cache::Cache::OpenTags;
	}
	try
	{
		aptFront::cache::Global::get().open(aptFrontFlags);
	}
	catch (aptFront::exception::Exception e)
	{
		QMessageBox::critical
		(
			0,
			QObject::tr("Error Opening Apt-Front Backend"), 
			QObject::tr("An error occured when trying to open the apt-front backend. This could be due to a corrupted "
			   "package- or debtags database.<br>"
			    "The error reported was ") + e.what(),
			"OK"
		);
	}
	PackageSearchImpl search(0, "MainWindow");
	search.setCaption("Debian Package Search - Version " + NPackageSearch::VERSION);
	search.show();
	search.initialize();
	return a.exec();
}


// This code will crash, its only to pull in some symbols needed by the apt-plugin
void dummyToDragInSymbols()
{
	aptFront::cache::entity::Relation depends; 
	depends.type();
	depends.name();
	depends.format();
}
