//
// C++ Implementation: debtagsactionplugin
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "debtagsactionplugin.h"

#include <QAction>

namespace NPlugin
{

const QString DebtagsActionPlugin::PLUGIN_NAME = "DebtagsActionPlugin";


DebtagsActionPlugin::DebtagsActionPlugin() :
 	_title("Debtags-Action Plugin"),
	_briefDescription("Offers the menu and toolbar entries"),
	_description("This plugin offers the menu and toolbar entries for the Debtags plugin. "
		"Currently this is only the debtags update entry.")
{
	QAction* pQDebtagsUpdateAction = new QAction(QObject::tr("Update Tag Database"), this);
	pQDebtagsUpdateAction->setStatusTip(tr("Calls \"debtags update\" updating the tag database"));
	_pDebtagsUpdateAction = new Action(pQDebtagsUpdateAction, false, "System");
	
	QAction* pQSeparatorAction = new QAction(this);
	pQSeparatorAction->setSeparator(true);
	_pSeparatorAction = new Action(pQSeparatorAction, false, "System");
}


DebtagsActionPlugin::~DebtagsActionPlugin()
{
	delete _pDebtagsUpdateAction;
	delete _pSeparatorAction;
}

vector<Action*> DebtagsActionPlugin::actions() const
{
	vector<Action*> actions;
	actions.push_back(_pSeparatorAction);
	actions.push_back(_pDebtagsUpdateAction);
	return actions;
}

}
