//
// C++ Interface: debtagshelper
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NUTIL_DEBTAGSHELPER_H_2005_09_24
#define __NUTIL_DEBTAGSHELPER_H_2005_09_24

#include <string>

#include "aggregator.h"
#include <ept/debtags/tag.h>
/*
#include <ept/cache/apt/packages.h>
#include <ept/cache/package.h>
#include <ept/cache/relation.h>
#include <ept/cache/tag.h>
#include <ept/cache/debtags/vocabulary.h>
*/

#include "eptinstance.h"


using namespace std;


namespace NUtil
{

typedef std::string Package;
typedef ept::debtags::Tag Tag;
typedef ept::debtags::Debtags Debtags;
typedef ept::debtags::Vocabulary Vocabulary;


/** Returns the names of all the packages from <em>packages</em>. */
inline std::set<string> packagesToStrings(const set<Package>& packages)
{
	return packages;
	/*
	std::set<string> result;
	for (set<Package>::const_iterator it = packages.begin(); it != packages.end(); ++it)
	{
		result.insert(it->name());
	}
	return result;
	*/
}


/** Returns the names of all the tags from <em>tags</em>.
  *
  * Tag names are of the form facet::tagname.
  */
inline std::set<string> tagsToStrings(const set<Tag>& tags)
{
	std::set<string> result;
	for (set<Tag>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(it->fullname());
	}
	return result;
}

/** Collects the tags from the global vocabulary (accessible through EptInstance)
  * which match the given names.
  *
  * ?Tag names must be given in the form facet::tagname? (verify this)
  */
inline std::set<Tag> stringsToTags(const set<string>& tags)
{
	std::set<Tag> result;
	const Vocabulary& tagsComponent = EptInstance::aggregator()->vocabulary();
	for (set<string>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(tagsComponent.tagByName(*it));
	}
	return result;
}

/** Returns the entity::Package with the given name. */
inline Package getPackageByName(const string package)
{
	return EptInstance::aggregator()->apt().validate(package);
}


}

#endif //  __NUTIL_DEBTAGSHELPER_H_2005_09_24
