//
// C++ Implementation: selectioninputanddisplay
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "selectioninputanddisplay.h"

#include <cassert>

#include <QLayout>
#include <QLineEdit>

#include <wibble/operators.h>


// NTagModel
#include "vocabularymodel.h"
#include "vocabularymodelrole.h"
#include "unselectedtagsview.h"

#include "helpers.h"

using namespace wibble::operators;


namespace NWidgets 
{

typedef ept::debtags::Facet Facet;
typedef ept::debtags::Tag Tag;


SelectionInputAndDisplay::SelectionInputAndDisplay(const NPlugin::DebtagsPluginContainer* pContainer, NTagModel::VocabularyModel* pModel, QObject* pParent)
 : QObject(pParent), _pModel(pModel)
{
	_pTagSelectorWidget = new QWidget();
	QLayout* pLayout = new QVBoxLayout(_pTagSelectorWidget);
	QLineEdit* pFilterInput = new QLineEdit(_pTagSelectorWidget);

	// will be garbage collected once DebtagsPlugin is destroyed
	_pTagSelector = new NTagModel::UnselectedTagsView(pContainer, _pTagSelectorWidget);
	_pTagSelector->setModel(_pModel);
	
	_pTagSelector->show();
	pLayout->add(pFilterInput);
	pLayout->add(_pTagSelector);
	
 	connect(pFilterInput, SIGNAL(textChanged(const QString&)), 
 		_pTagSelector, SLOT(setFilterFixedString(const QString&)));
	
 	_pSelectedTagDisplay = new NTagModel::SelectedTagsView();
 	_pSelectedTagDisplay->setModel(_pModel);
 	_pSelectedTagDisplay->show();
	
}


SelectionInputAndDisplay::~SelectionInputAndDisplay()
{
	delete _pSelectedTagDisplay;
	delete _pTagSelector;
	delete _pTagSelectorWidget;
}

void SelectionInputAndDisplay::setShown(bool show)
{
	// TODO reimplement?
}

void SelectionInputAndDisplay::setEnabled(bool enabled)
{
	_pTagSelector->setEnabled(enabled);
	_pSelectedTagDisplay->setEnabled(enabled);
}

void SelectionInputAndDisplay::clear()
{
// TODO to be implemented?
// 	tagSelectionListView()->clear();
}


void SelectionInputAndDisplay::loadVocabulary(const std::set<Facet>& vocabulary)
{
// TODO to be implemented?
}


}	// namespace NWidgets 


#undef emit
//#include <ept/cache/debtags/vocabulary.tcc>
