// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type ModifyRouteTableRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* RouteTable ID  */
    RouteTableId string `json:"routeTableId"`

    /* 路由表的名字。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符 (Optional) */
    RouteTableName *string `json:"routeTableName"`

    /* 路由表的描述，取值范围：0-256个UTF-8编码下的全部字符 (Optional) */
    Description *string `json:"description"`
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyRouteTableRequest(
    regionId string,
    routeTableId string,
) *ModifyRouteTableRequest {

	return &ModifyRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/{routeTableId}",
			Method:  "PATCH",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RouteTableId: routeTableId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param routeTableName: 路由表的名字。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符 (Optional)
 * param description: 路由表的描述，取值范围：0-256个UTF-8编码下的全部字符 (Optional)
 */
func NewModifyRouteTableRequestWithAllParams(
    regionId string,
    routeTableId string,
    routeTableName *string,
    description *string,
) *ModifyRouteTableRequest {

    return &ModifyRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RouteTableId: routeTableId,
        RouteTableName: routeTableName,
        Description: description,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyRouteTableRequestWithoutParam() *ModifyRouteTableRequest {

    return &ModifyRouteTableRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}",
            Method:  "PATCH",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *ModifyRouteTableRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param routeTableId: RouteTable ID(Required) */
func (r *ModifyRouteTableRequest) SetRouteTableId(routeTableId string) {
    r.RouteTableId = routeTableId
}

/* param routeTableName: 路由表的名字。名称取值范围：1-32个中文、英文大小写的字母、数字和下划线分隔符(Optional) */
func (r *ModifyRouteTableRequest) SetRouteTableName(routeTableName string) {
    r.RouteTableName = &routeTableName
}

/* param description: 路由表的描述，取值范围：0-256个UTF-8编码下的全部字符(Optional) */
func (r *ModifyRouteTableRequest) SetDescription(description string) {
    r.Description = &description
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyRouteTableRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyRouteTableResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyRouteTableResult `json:"result"`
}

type ModifyRouteTableResult struct {
}