//=======================================================================
// maintreeview.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_MAIN_TREE_VIEW_H
#define GPACO_MAIN_TREE_VIEW_H

#include "pkgset.h"
#include "treeview.h"
#include <iosfwd>

namespace Gtk
{
	class ListStore;
}

namespace Gpaco
{

class Pkg;

class MainTreeView : public TreeView
{
	static int const CELL_HEIGHT			= 24;
	static int const PROGRESS_CELL_WIDTH	= 78;

	class ModelColumns : public Gtk::TreeModel::ColumnRecord
	{
		friend class MainTreeView;

		ModelColumns();

		Gtk::TreeModelColumn<Pkg*>							mPkg;
		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> >	mIcon;
		Gtk::TreeModelColumn<Glib::ustring>					mName;
		Gtk::TreeModelColumn<long>							mSizeInst;
		Gtk::TreeModelColumn<long>							mSizeMiss;
		Gtk::TreeModelColumn<float>							mSizePercent;
		Gtk::TreeModelColumn<int>							mDate;
		Gtk::TreeModelColumn<long>							mFilesInst;
		Gtk::TreeModelColumn<long>							mFilesMiss;
		Gtk::TreeModelColumn<float>							mFilesPercent;
		Gtk::TreeModelColumn<Glib::ustring>					mSummary;

	};	// class MainTreeView::ModelColumns

	public:

	MainTreeView();
	virtual ~MainTreeView();
	
	PkgSet& pkgSet()	{ return mPkgSet; }

	void refresh();
	void onUpdateDataBase();
	void onPkgWindow(int);
	void onUnlog();

	enum {
		COL_PKG = -1,
		COL_ICON = 0,
		COL_NAME,
		COL_SIZE_INST,
		COL_SIZE_MISS,
		COL_SIZE_PERCENT,
		COL_DATE,
		COL_FILES_INST,
		COL_FILES_MISS,
		COL_FILES_PERCENT,
		COL_SUMMARY,
		N_COLS
	};

	private:

	PkgSet							mPkgSet;
	ModelColumns					mColumns;
	Glib::RefPtr<Gtk::ListStore>	mpModel;
	Glib::RefPtr<Gtk::Action>		mpActionFiles;
	Glib::RefPtr<Gtk::Action>		mpActionInfo;
	Glib::RefPtr<Gtk::Action>		mpActionRemove;
	Glib::RefPtr<Gtk::Action>		mpActionPackage;
	Glib::RefPtr<Gtk::Action>		mpActionUnlog;

	MainTreeView &operator-=(Pkg*);
	MainTreeView &operator+=(Pkg*);

	virtual bool on_button_press_event(GdkEventButton*);
	virtual bool on_key_press_event(GdkEventKey*);
		
	bool onPopupMenu(GdkEvent*);

	typedef int (MainTreeView::*SortFunc)(iterator const&, iterator const&);
	typedef void (MainTreeView::*CellFunc)(Gtk::CellRenderer*, iterator const&);

	template <typename T>
	void addColumn(	Gtk::TreeModelColumn<T> const&,
					Glib::ustring const& title,
					SortFunc sortFunc = NULL,
					CellFunc cellFunc = NULL,
					gfloat xalign = 0.);

	void addProgressColumn(	Gtk::TreeModelColumn<float> const&,
							Glib::ustring const&,
							SortFunc sortFunc = NULL);

	int iconSortFunc			(iterator const&, iterator const&);
	int summarySortFunc			(iterator const&, iterator const&);
	int nameSortFunc			(iterator const&, iterator const&);
	int sizeInstSortFunc		(iterator const&, iterator const&);
	int sizeMissSortFunc		(iterator const&, iterator const&);
	int filesInstSortFunc		(iterator const&, iterator const&);
	int filesMissSortFunc		(iterator const&, iterator const&);
	int dateSortFunc			(iterator const&, iterator const&);
	int sizePercentSortFunc		(iterator const&, iterator const&);
	int filesPercentSortFunc	(iterator const&, iterator const&);

	void dateCellFunc(Gtk::CellRenderer*, iterator const&);
	void sizeCellFunc(Gtk::CellRenderer*, iterator const&);
	
	bool rowChanged(Gtk::TreeModel::Path const&, iterator const&);
	bool getIter(Pkg const&, iterator&);
	std::vector<Pkg*> getSelectedPkgs();
	void writeRow(Pkg&, iterator const&);
	bool rewriteRow(iterator const&);
	bool rewriteRows();

};	// class MainTreeView

} // namespace Gpaco

#endif  // GPACO_MAIN_TREE_VIEW_H
