//=======================================================================
// util.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "util.h"
#include "mainwindow.h"
#include "maintreeview.h"
#include "pkg.h"
#include "pkgwindow.h"
#include <gtkmm/label.h>
#include <gtkmm/main.h>
#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/stockid.h>

using Glib::ustring;
using namespace Gpaco;

// Forward decls
static int runDialog(Gtk::Window*, ustring const&, Gtk::MessageType, Gtk::ButtonsType);


void Gpaco::refreshMainLoop()
{
	while (Gtk::Main::events_pending())
		Gtk::Main::iteration();
}


void Gpaco::errorDialog(Gtk::Window* parent, ustring const& msg, bool fatal /* = false */)
{
	runDialog(parent, msg, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK);
	if (fatal)
		exit(EXIT_FAILURE);
}
	

bool Gpaco::questionDialog(Gtk::Window* parent, ustring const& msg)
{
	return runDialog(parent, msg, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_YES_NO) == Gtk::RESPONSE_YES;
}


static int runDialog(Gtk::Window* __parent, ustring const& msg, Gtk::MessageType type,
	Gtk::ButtonsType buttonsType)
{
	Gtk::MessageDialog* dialog;
	Gtk::Window* parent = __parent ? __parent : gpMainWindow;
	
	if (parent)
		dialog = new Gtk::MessageDialog(*parent, msg, false, type, buttonsType, true);
	else
		dialog = new Gtk::MessageDialog(msg, false, type, buttonsType, true);

	dialog->set_title("gpaco");

	int response = dialog->run();

	delete dialog;
	return response;
}


//--------//
// Button //
//--------//


Button::Button(Gtk::StockID const& id, ustring const& label)
:
	Gtk::Button()
{
	Gtk::HBox* pHBox(Gtk::manage(new Gtk::HBox(false, 5)));
	Glib::RefPtr<Gdk::Pixbuf> pPixbuf(pHBox->render_icon(id, Gtk::ICON_SIZE_BUTTON));

	pHBox->pack_start(*(Gtk::manage(new Gtk::Image(pPixbuf))), Gtk::PACK_SHRINK);
	pHBox->pack_start(*(Gtk::manage(new Gtk::Label(label, true))), Gtk::PACK_SHRINK);

	add(*pHBox);
}


//////////
// Lock //
//////////


Lock::Lock()
{
	set(false);
}


Lock::~Lock()
{
	set(true);
}


void Lock::set(bool sensitive)
{
	if (gpMainWindow) {
		gpMainWindow->set_sensitive(sensitive);
		PkgSet& pSet = gpMainWindow->treeView()->pkgSet();
		for (PkgSet::iterator p = pSet.begin(); p != pSet.end(); ++p) {
			if ((*p)->window())
				(*p)->window()->set_sensitive(sensitive);
		}
	}
}

