#include <config.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>

#include <security/pam_modules.h>
#include <security/_pam_macros.h>
#include <security/pam_appl.h>

typedef const void *pam_item_t;

/* syslogging function for errors and other information */
void
pam_syslog(pam_handle_t *pamh, int priority, const char *fmt, ...)
{
        int save_errno = errno;
        pam_item_t item;
        const char *service;
        va_list args;
        char *msgbuf;

        if (pam_get_item(pamh, PAM_SERVICE, &item) != PAM_SUCCESS || !item)
                service = "UNKNOWN SERVICE";
        else
                service = item;

        openlog(service, LOG_CONS | LOG_PID, LOG_AUTHPRIV);

        va_start(args, fmt);
        errno = save_errno;
        if (vasprintf (&msgbuf, fmt, args) < 0)
                msgbuf = NULL;
        va_end(args);

        if (!msgbuf) {
                syslog (LOG_AUTHPRIV|LOG_CRIT, "%s: vasprintf: %m",
                    "pam_keyring");
                closelog();
                return;
        }

        syslog (LOG_AUTHPRIV|priority, "%s: %s: %s",
            "pam_keyring", service, msgbuf);
//	_pam_overwrite(msgbuf);

        closelog();
}

/*
 * Do a simple conversation which can consist of a message and/or a user
 * response.
 */
int
pam_prompt(pam_handle_t *pamh, int style, const char *prompt, char **user_msg)
{
	int retval;
	const void *item;
	const struct pam_conv *conv;
	struct pam_message msg;
	const struct pam_message *msgs[1];
	struct pam_response *resp;

	if ((retval = pam_get_item(pamh, PAM_CONV, &item)) !=
	    PAM_SUCCESS)
		return retval;
	conv = (const struct pam_conv *)item;
	msg.msg_style = style;
	msg.msg = prompt != NULL ? prompt : "";
	msgs[0] = &msg;
	if ((retval = conv->conv(1, msgs, &resp, conv->appdata_ptr)) !=
	    PAM_SUCCESS)
		return retval;
	if (user_msg != NULL)
		*user_msg = resp[0].resp;
	else if (resp[0].resp != NULL)
		free(resp[0].resp);
	free(resp);
	return PAM_SUCCESS;
}
