/* pam_umask module, based on pam_tmpdir, based on pam_env which in
   turn was based on pam_mail */

/*
 * 
 * Written by Tollef Fog Heen <tfheen@err.no> 2004
 *
 * Based on pam_tmpdir, written by Tollef Fog Heen <tfheen@err.no> 2001-2003
 * Based on pam_env
 * Written by Dave Kinchlea <kinch@kinch.ark.com> 1997/01/31
 * Inspired by Andrew Morgan <morgan@parc.power.net, who also supplied the 
 * template for this file (via pam_mail)
 */


#include <ctype.h>
#include <errno.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <limits.h>
#include "util.h"

/*
 * here, we make a definition for the externally accessible function
 * in this file (this definition is required for static a module
 * but strongly encouraged generally) it is used to instruct the
 * modules include file to define the function prototypes.
 */

#define PAM_SM_SESSION      /* This is primarily a AUTH_SESSION module */

#include <security/pam_modules.h>
#include <security/_pam_macros.h>

#define PAM_UMASK_FILE_NAME ".pam_umask"
/* --- session management functions (only) --- */

 
PAM_EXTERN
int pam_sm_open_session(pam_handle_t *pamh, int flags, int argc, 
                        const char **argv) {
  const char *user;
  int ret;
  struct passwd *puser;
  FILE *umask_file;
  char *umask_file_path, *user_umask;
  mode_t um;

  ret = pam_get_item(pamh, PAM_USER, &user);
  if (ret != PAM_SUCCESS) {
    _log_err(LOG_ERR, "Can't get user");
    return PAM_SESSION_ERR;
  }

  puser = getpwnam(user);
  if (!puser) {
    _log_err(LOG_ERR, "User %s not found using getpwent", user);
    return PAM_SESSION_ERR;
  }

  umask_file_path = xmalloc(strlen(puser->pw_dir) + 1 +
                            strlen(PAM_UMASK_FILE_NAME) +
                            1);
  sprintf(umask_file_path, "%s/%s", puser->pw_dir, PAM_UMASK_FILE_NAME);

  umask_file = fopen(umask_file_path, "r");

  if (umask_file != NULL) {
    user_umask = freadline(umask_file);
    um = strtol(user_umask, NULL, 0);
    if (um == LONG_MIN || um == LONG_MAX) {
      _log_err(LOG_ERR, "illegal umask specified for user: %s", puser->pw_name);
      return PAM_SESSION_ERR;
    }
    fclose(umask_file);
    umask(um);
    return PAM_SUCCESS;
  }

  /* Ok, either no file, unreadable or something else. Ignore and go on with
     the system umask. */

  if (argc-- > 0) {
    if (strncmp(argv[argc], "umask=", 6) == 0) {
      um = strtol((argv[argc])+6, NULL, 0);
      if (um == LONG_MIN || um == LONG_MAX) {
        _log_err(LOG_ERR, "illegal umask specified");
        return PAM_SESSION_ERR;
      }
      umask(um);
      return PAM_SUCCESS;
    }
  }
  return PAM_SESSION_ERR;
}


PAM_EXTERN
int pam_sm_close_session(pam_handle_t *pamh,int flags,int argc,
			 const char **argv)
{
  D(("Called and Exit"));
  return PAM_SUCCESS;
}

#ifdef PAM_STATIC

/* static module data */

struct pam_module _pam_env_modstruct = {
     "pam_umask",
     NULL,
     NULL,
     NULL,
     pam_sm_open_session,
     pam_sm_close_session,
     NULL,
};

#endif

/* end of module definition */
