# 1 "src/Text/Pandoc/Data.hsb"
{-# LANGUAGE OverloadedStrings #-}
-- to be processed using hsb2hs
module Text.Pandoc.Data (dataFiles) where
import qualified Data.ByteString as B

dataFiles :: [(FilePath, B.ByteString)]
dataFiles = [("LaTeXMathML.js","/*\nLaTeXMathML.js from http://math.etsu.edu/LaTeXMathML/\nAdapted by Jeff Knisely and Douglas Woodall from ASCIIMathML.js v. 1.4.7,\n(c) 2005 Peter Jipsen http://www.chapman.edu/~jipsen.\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\nvar checkForMathML=true;var notifyIfNoMathML=true;var alertIfNoMathML=false;var mathcolor=\"\";var mathfontfamily=\"\";var showasciiformulaonhover=true;var isIE=document.createElementNS==null;if(document.getElementById==null)\nalert(\"This webpage requires a recent browser such as \\nMozilla/Netscape 7+ or Internet Explorer 6+MathPlayer\")\nfunction AMcreateElementXHTML(t){if(isIE)return document.createElement(t);else return document.createElementNS(\"http://www.w3.org/1999/xhtml\",t);}\nfunction AMnoMathMLNote(){var nd=AMcreateElementXHTML(\"h3\");nd.setAttribute(\"align\",\"center\")\nnd.appendChild(AMcreateElementXHTML(\"p\"));nd.appendChild(document.createTextNode(\"To view the \"));var an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"LaTeXMathML\"));an.setAttribute(\"href\",\"http://www.maths.nott.ac.uk/personal/drw/lm.html\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" notation use Internet Explorer 6+\"));an=AMcreateElementXHTML(\"a\");an.appendChild(document.createTextNode(\"MathPlayer\"));an.setAttribute(\"href\",\"http://www.dessci.com/en/products/mathplayer/download.htm\");nd.appendChild(an);nd.appendChild(document.createTextNode(\" or Netscape/Mozilla/Firefox\"));nd.appendChild(AMcreateElementXHTML(\"p\"));return nd;}\nfunction AMisMathMLavailable(){if(navigator.appName.slice(0,8)==\"Netscape\")\nif(navigator.appVersion.slice(0,1)>=\"5\")return null;else return AMnoMathMLNote();else if(navigator.appName.slice(0,9)==\"Microsoft\")\ntry{var ActiveX=new ActiveXObject(\"MathPlayer.Factory.1\");return null;}catch(e){return AMnoMathMLNote();}\nelse return AMnoMathMLNote();}\nvar AMcal=[0xEF35,0x212C,0xEF36,0xEF37,0x2130,0x2131,0xEF38,0x210B,0x2110,0xEF39,0xEF3A,0x2112,0x2133,0xEF3B,0xEF3C,0xEF3D,0xEF3E,0x211B,0xEF3F,0xEF40,0xEF41,0xEF42,0xEF43,0xEF44,0xEF45,0xEF46];var AMfrk=[0xEF5D,0xEF5E,0x212D,0xEF5F,0xEF60,0xEF61,0xEF62,0x210C,0x2111,0xEF63,0xEF64,0xEF65,0xEF66,0xEF67,0xEF68,0xEF69,0xEF6A,0x211C,0xEF6B,0xEF6C,0xEF6D,0xEF6E,0xEF6F,0xEF70,0xEF71,0x2128];var AMbbb=[0xEF8C,0xEF8D,0x2102,0xEF8E,0xEF8F,0xEF90,0xEF91,0x210D,0xEF92,0xEF93,0xEF94,0xEF95,0xEF96,0x2115,0xEF97,0x2119,0x211A,0x211D,0xEF98,0xEF99,0xEF9A,0xEF9B,0xEF9C,0xEF9D,0xEF9E,0x2124];var CONST=0,UNARY=1,BINARY=2,INFIX=3,LEFTBRACKET=4,RIGHTBRACKET=5,SPACE=6,UNDEROVER=7,DEFINITION=8,TEXT=9,BIG=10,LONG=11,STRETCHY=12,MATRIX=13;var AMsqrt={input:\"\\\\sqrt\",tag:\"msqrt\",output:\"sqrt\",ttype:UNARY},AMroot={input:\"\\\\root\",tag:\"mroot\",output:\"root\",ttype:BINARY},AMfrac={input:\"\\\\frac\",tag:\"mfrac\",output:\"/\",ttype:BINARY},AMover={input:\"\\\\stackrel\",tag:\"mover\",output:\"stackrel\",ttype:BINARY},AMatop={input:\"\\\\atop\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMchoose={input:\"\\\\choose\",tag:\"mfrac\",output:\"\",ttype:INFIX},AMsub={input:\"_\",tag:\"msub\",output:\"_\",ttype:INFIX},AMsup={input:\"^\",tag:\"msup\",output:\"^\",ttype:INFIX},AMtext={input:\"\\\\mathrm\",tag:\"mtext\",output:\"text\",ttype:TEXT},AMmbox={input:\"\\\\mbox\",tag:\"mtext\",output:\"mbox\",ttype:TEXT};var AMsymbols=[{input:\"\\\\alpha\",tag:\"mi\",output:\"\\u03B1\",ttype:CONST},{input:\"\\\\beta\",tag:\"mi\",output:\"\\u03B2\",ttype:CONST},{input:\"\\\\gamma\",tag:\"mi\",output:\"\\u03B3\",ttype:CONST},{input:\"\\\\delta\",tag:\"mi\",output:\"\\u03B4\",ttype:CONST},{input:\"\\\\epsilon\",tag:\"mi\",output:\"\\u03B5\",ttype:CONST},{input:\"\\\\varepsilon\",tag:\"mi\",output:\"\\u025B\",ttype:CONST},{input:\"\\\\zeta\",tag:\"mi\",output:\"\\u03B6\",ttype:CONST},{input:\"\\\\eta\",tag:\"mi\",output:\"\\u03B7\",ttype:CONST},{input:\"\\\\theta\",tag:\"mi\",output:\"\\u03B8\",ttype:CONST},{input:\"\\\\vartheta\",tag:\"mi\",output:\"\\u03D1\",ttype:CONST},{input:\"\\\\iota\",tag:\"mi\",output:\"\\u03B9\",ttype:CONST},{input:\"\\\\kappa\",tag:\"mi\",output:\"\\u03BA\",ttype:CONST},{input:\"\\\\lambda\",tag:\"mi\",output:\"\\u03BB\",ttype:CONST},{input:\"\\\\mu\",tag:\"mi\",output:\"\\u03BC\",ttype:CONST},{input:\"\\\\nu\",tag:\"mi\",output:\"\\u03BD\",ttype:CONST},{input:\"\\\\xi\",tag:\"mi\",output:\"\\u03BE\",ttype:CONST},{input:\"\\\\pi\",tag:\"mi\",output:\"\\u03C0\",ttype:CONST},{input:\"\\\\varpi\",tag:\"mi\",output:\"\\u03D6\",ttype:CONST},{input:\"\\\\rho\",tag:\"mi\",output:\"\\u03C1\",ttype:CONST},{input:\"\\\\varrho\",tag:\"mi\",output:\"\\u03F1\",ttype:CONST},{input:\"\\\\varsigma\",tag:\"mi\",output:\"\\u03C2\",ttype:CONST},{input:\"\\\\sigma\",tag:\"mi\",output:\"\\u03C3\",ttype:CONST},{input:\"\\\\tau\",tag:\"mi\",output:\"\\u03C4\",ttype:CONST},{input:\"\\\\upsilon\",tag:\"mi\",output:\"\\u03C5\",ttype:CONST},{input:\"\\\\phi\",tag:\"mi\",output:\"\\u03C6\",ttype:CONST},{input:\"\\\\varphi\",tag:\"mi\",output:\"\\u03D5\",ttype:CONST},{input:\"\\\\chi\",tag:\"mi\",output:\"\\u03C7\",ttype:CONST},{input:\"\\\\psi\",tag:\"mi\",output:\"\\u03C8\",ttype:CONST},{input:\"\\\\omega\",tag:\"mi\",output:\"\\u03C9\",ttype:CONST},{input:\"\\\\Gamma\",tag:\"mo\",output:\"\\u0393\",ttype:CONST},{input:\"\\\\Delta\",tag:\"mo\",output:\"\\u0394\",ttype:CONST},{input:\"\\\\Theta\",tag:\"mo\",output:\"\\u0398\",ttype:CONST},{input:\"\\\\Lambda\",tag:\"mo\",output:\"\\u039B\",ttype:CONST},{input:\"\\\\Xi\",tag:\"mo\",output:\"\\u039E\",ttype:CONST},{input:\"\\\\Pi\",tag:\"mo\",output:\"\\u03A0\",ttype:CONST},{input:\"\\\\Sigma\",tag:\"mo\",output:\"\\u03A3\",ttype:CONST},{input:\"\\\\Upsilon\",tag:\"mo\",output:\"\\u03A5\",ttype:CONST},{input:\"\\\\Phi\",tag:\"mo\",output:\"\\u03A6\",ttype:CONST},{input:\"\\\\Psi\",tag:\"mo\",output:\"\\u03A8\",ttype:CONST},{input:\"\\\\Omega\",tag:\"mo\",output:\"\\u03A9\",ttype:CONST},{input:\"\\\\frac12\",tag:\"mo\",output:\"\\u00BD\",ttype:CONST},{input:\"\\\\frac14\",tag:\"mo\",output:\"\\u00BC\",ttype:CONST},{input:\"\\\\frac34\",tag:\"mo\",output:\"\\u00BE\",ttype:CONST},{input:\"\\\\frac13\",tag:\"mo\",output:\"\\u2153\",ttype:CONST},{input:\"\\\\frac23\",tag:\"mo\",output:\"\\u2154\",ttype:CONST},{input:\"\\\\frac15\",tag:\"mo\",output:\"\\u2155\",ttype:CONST},{input:\"\\\\frac25\",tag:\"mo\",output:\"\\u2156\",ttype:CONST},{input:\"\\\\frac35\",tag:\"mo\",output:\"\\u2157\",ttype:CONST},{input:\"\\\\frac45\",tag:\"mo\",output:\"\\u2158\",ttype:CONST},{input:\"\\\\frac16\",tag:\"mo\",output:\"\\u2159\",ttype:CONST},{input:\"\\\\frac56\",tag:\"mo\",output:\"\\u215A\",ttype:CONST},{input:\"\\\\frac18\",tag:\"mo\",output:\"\\u215B\",ttype:CONST},{input:\"\\\\frac38\",tag:\"mo\",output:\"\\u215C\",ttype:CONST},{input:\"\\\\frac58\",tag:\"mo\",output:\"\\u215D\",ttype:CONST},{input:\"\\\\frac78\",tag:\"mo\",output:\"\\u215E\",ttype:CONST},{input:\"\\\\pm\",tag:\"mo\",output:\"\\u00B1\",ttype:CONST},{input:\"\\\\mp\",tag:\"mo\",output:\"\\u2213\",ttype:CONST},{input:\"\\\\triangleleft\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\triangleright\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\cdot\",tag:\"mo\",output:\"\\u22C5\",ttype:CONST},{input:\"\\\\star\",tag:\"mo\",output:\"\\u22C6\",ttype:CONST},{input:\"\\\\ast\",tag:\"mo\",output:\"\\u002A\",ttype:CONST},{input:\"\\\\times\",tag:\"mo\",output:\"\\u00D7\",ttype:CONST},{input:\"\\\\div\",tag:\"mo\",output:\"\\u00F7\",ttype:CONST},{input:\"\\\\circ\",tag:\"mo\",output:\"\\u2218\",ttype:CONST},{input:\"\\\\bullet\",tag:\"mo\",output:\"\\u2022\",ttype:CONST},{input:\"\\\\oplus\",tag:\"mo\",output:\"\\u2295\",ttype:CONST},{input:\"\\\\ominus\",tag:\"mo\",output:\"\\u2296\",ttype:CONST},{input:\"\\\\otimes\",tag:\"mo\",output:\"\\u2297\",ttype:CONST},{input:\"\\\\bigcirc\",tag:\"mo\",output:\"\\u25CB\",ttype:CONST},{input:\"\\\\oslash\",tag:\"mo\",output:\"\\u2298\",ttype:CONST},{input:\"\\\\odot\",tag:\"mo\",output:\"\\u2299\",ttype:CONST},{input:\"\\\\land\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\wedge\",tag:\"mo\",output:\"\\u2227\",ttype:CONST},{input:\"\\\\lor\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\vee\",tag:\"mo\",output:\"\\u2228\",ttype:CONST},{input:\"\\\\cap\",tag:\"mo\",output:\"\\u2229\",ttype:CONST},{input:\"\\\\cup\",tag:\"mo\",output:\"\\u222A\",ttype:CONST},{input:\"\\\\sqcap\",tag:\"mo\",output:\"\\u2293\",ttype:CONST},{input:\"\\\\sqcup\",tag:\"mo\",output:\"\\u2294\",ttype:CONST},{input:\"\\\\uplus\",tag:\"mo\",output:\"\\u228E\",ttype:CONST},{input:\"\\\\amalg\",tag:\"mo\",output:\"\\u2210\",ttype:CONST},{input:\"\\\\bigtriangleup\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\bigtriangledown\",tag:\"mo\",output:\"\\u25BD\",ttype:CONST},{input:\"\\\\dag\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\dagger\",tag:\"mo\",output:\"\\u2020\",ttype:CONST},{input:\"\\\\ddag\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\ddagger\",tag:\"mo\",output:\"\\u2021\",ttype:CONST},{input:\"\\\\lhd\",tag:\"mo\",output:\"\\u22B2\",ttype:CONST},{input:\"\\\\rhd\",tag:\"mo\",output:\"\\u22B3\",ttype:CONST},{input:\"\\\\unlhd\",tag:\"mo\",output:\"\\u22B4\",ttype:CONST},{input:\"\\\\unrhd\",tag:\"mo\",output:\"\\u22B5\",ttype:CONST},{input:\"\\\\sum\",tag:\"mo\",output:\"\\u2211\",ttype:UNDEROVER},{input:\"\\\\prod\",tag:\"mo\",output:\"\\u220F\",ttype:UNDEROVER},{input:\"\\\\bigcap\",tag:\"mo\",output:\"\\u22C2\",ttype:UNDEROVER},{input:\"\\\\bigcup\",tag:\"mo\",output:\"\\u22C3\",ttype:UNDEROVER},{input:\"\\\\bigwedge\",tag:\"mo\",output:\"\\u22C0\",ttype:UNDEROVER},{input:\"\\\\bigvee\",tag:\"mo\",output:\"\\u22C1\",ttype:UNDEROVER},{input:\"\\\\bigsqcap\",tag:\"mo\",output:\"\\u2A05\",ttype:UNDEROVER},{input:\"\\\\bigsqcup\",tag:\"mo\",output:\"\\u2A06\",ttype:UNDEROVER},{input:\"\\\\coprod\",tag:\"mo\",output:\"\\u2210\",ttype:UNDEROVER},{input:\"\\\\bigoplus\",tag:\"mo\",output:\"\\u2A01\",ttype:UNDEROVER},{input:\"\\\\bigotimes\",tag:\"mo\",output:\"\\u2A02\",ttype:UNDEROVER},{input:\"\\\\bigodot\",tag:\"mo\",output:\"\\u2A00\",ttype:UNDEROVER},{input:\"\\\\biguplus\",tag:\"mo\",output:\"\\u2A04\",ttype:UNDEROVER},{input:\"\\\\int\",tag:\"mo\",output:\"\\u222B\",ttype:CONST},{input:\"\\\\oint\",tag:\"mo\",output:\"\\u222E\",ttype:CONST},{input:\":=\",tag:\"mo\",output:\":=\",ttype:CONST},{input:\"\\\\lt\",tag:\"mo\",output:\"<\",ttype:CONST},{input:\"\\\\gt\",tag:\"mo\",output:\">\",ttype:CONST},{input:\"\\\\ne\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\neq\",tag:\"mo\",output:\"\\u2260\",ttype:CONST},{input:\"\\\\le\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leq\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\leqslant\",tag:\"mo\",output:\"\\u2264\",ttype:CONST},{input:\"\\\\ge\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geq\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\geqslant\",tag:\"mo\",output:\"\\u2265\",ttype:CONST},{input:\"\\\\equiv\",tag:\"mo\",output:\"\\u2261\",ttype:CONST},{input:\"\\\\ll\",tag:\"mo\",output:\"\\u226A\",ttype:CONST},{input:\"\\\\gg\",tag:\"mo\",output:\"\\u226B\",ttype:CONST},{input:\"\\\\doteq\",tag:\"mo\",output:\"\\u2250\",ttype:CONST},{input:\"\\\\prec\",tag:\"mo\",output:\"\\u227A\",ttype:CONST},{input:\"\\\\succ\",tag:\"mo\",output:\"\\u227B\",ttype:CONST},{input:\"\\\\preceq\",tag:\"mo\",output:\"\\u227C\",ttype:CONST},{input:\"\\\\succeq\",tag:\"mo\",output:\"\\u227D\",ttype:CONST},{input:\"\\\\subset\",tag:\"mo\",output:\"\\u2282\",ttype:CONST},{input:\"\\\\supset\",tag:\"mo\",output:\"\\u2283\",ttype:CONST},{input:\"\\\\subseteq\",tag:\"mo\",output:\"\\u2286\",ttype:CONST},{input:\"\\\\supseteq\",tag:\"mo\",output:\"\\u2287\",ttype:CONST},{input:\"\\\\sqsubset\",tag:\"mo\",output:\"\\u228F\",ttype:CONST},{input:\"\\\\sqsupset\",tag:\"mo\",output:\"\\u2290\",ttype:CONST},{input:\"\\\\sqsubseteq\",tag:\"mo\",output:\"\\u2291\",ttype:CONST},{input:\"\\\\sqsupseteq\",tag:\"mo\",output:\"\\u2292\",ttype:CONST},{input:\"\\\\sim\",tag:\"mo\",output:\"\\u223C\",ttype:CONST},{input:\"\\\\simeq\",tag:\"mo\",output:\"\\u2243\",ttype:CONST},{input:\"\\\\approx\",tag:\"mo\",output:\"\\u2248\",ttype:CONST},{input:\"\\\\cong\",tag:\"mo\",output:\"\\u2245\",ttype:CONST},{input:\"\\\\Join\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\bowtie\",tag:\"mo\",output:\"\\u22C8\",ttype:CONST},{input:\"\\\\in\",tag:\"mo\",output:\"\\u2208\",ttype:CONST},{input:\"\\\\ni\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\owns\",tag:\"mo\",output:\"\\u220B\",ttype:CONST},{input:\"\\\\propto\",tag:\"mo\",output:\"\\u221D\",ttype:CONST},{input:\"\\\\vdash\",tag:\"mo\",output:\"\\u22A2\",ttype:CONST},{input:\"\\\\dashv\",tag:\"mo\",output:\"\\u22A3\",ttype:CONST},{input:\"\\\\models\",tag:\"mo\",output:\"\\u22A8\",ttype:CONST},{input:\"\\\\perp\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\smile\",tag:\"mo\",output:\"\\u2323\",ttype:CONST},{input:\"\\\\frown\",tag:\"mo\",output:\"\\u2322\",ttype:CONST},{input:\"\\\\asymp\",tag:\"mo\",output:\"\\u224D\",ttype:CONST},{input:\"\\\\notin\",tag:\"mo\",output:\"\\u2209\",ttype:CONST},{input:\"\\\\begin{eqnarray}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\begin{array}\",output:\"X\",ttype:MATRIX,invisible:true},{input:\"\\\\\\\\\",output:\"}&{\",ttype:DEFINITION},{input:\"\\\\end{eqnarray}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\end{array}\",output:\"}}\",ttype:DEFINITION},{input:\"\\\\big\",tag:\"mo\",output:\"X\",atval:\"1.2\",ieval:\"2.2\",ttype:BIG},{input:\"\\\\Big\",tag:\"mo\",output:\"X\",atval:\"1.6\",ieval:\"2.6\",ttype:BIG},{input:\"\\\\bigg\",tag:\"mo\",output:\"X\",atval:\"2.2\",ieval:\"3.2\",ttype:BIG},{input:\"\\\\Bigg\",tag:\"mo\",output:\"X\",atval:\"2.9\",ieval:\"3.9\",ttype:BIG},{input:\"\\\\left\",tag:\"mo\",output:\"X\",ttype:LEFTBRACKET},{input:\"\\\\right\",tag:\"mo\",output:\"X\",ttype:RIGHTBRACKET},{input:\"{\",output:\"{\",ttype:LEFTBRACKET,invisible:true},{input:\"}\",output:\"}\",ttype:RIGHTBRACKET,invisible:true},{input:\"(\",tag:\"mo\",output:\"(\",atval:\"1\",ttype:STRETCHY},{input:\"[\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrack\",tag:\"mo\",output:\"[\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\{\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lbrace\",tag:\"mo\",output:\"{\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\langle\",tag:\"mo\",output:\"\\u2329\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lfloor\",tag:\"mo\",output:\"\\u230A\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\lceil\",tag:\"mo\",output:\"\\u2308\",atval:\"1\",ttype:STRETCHY},{input:\")\",tag:\"mo\",output:\")\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"]\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrack\",tag:\"mo\",output:\"]\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\}\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rbrace\",tag:\"mo\",output:\"}\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rangle\",tag:\"mo\",output:\"\\u232A\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rfloor\",tag:\"mo\",output:\"\\u230B\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\rceil\",tag:\"mo\",output:\"\\u2309\",rtag:\"mi\",atval:\"1\",ttype:STRETCHY},{input:\"|\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\|\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\vert\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\Vert\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\mid\",tag:\"mo\",output:\"\\u2223\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\parallel\",tag:\"mo\",output:\"\\u2225\",atval:\"1\",ttype:STRETCHY},{input:\"/\",tag:\"mo\",output:\"/\",atval:\"1.01\",ttype:STRETCHY},{input:\"\\\\backslash\",tag:\"mo\",output:\"\\u2216\",atval:\"1\",ttype:STRETCHY},{input:\"\\\\setminus\",tag:\"mo\",output:\"\\\\\",ttype:CONST},{input:\"\\\\!\",tag:\"mspace\",atname:\"width\",atval:\"-0.167em\",ttype:SPACE},{input:\"\\\\,\",tag:\"mspace\",atname:\"width\",atval:\"0.167em\",ttype:SPACE},{input:\"\\\\>\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\:\",tag:\"mspace\",atname:\"width\",atval:\"0.222em\",ttype:SPACE},{input:\"\\\\;\",tag:\"mspace\",atname:\"width\",atval:\"0.278em\",ttype:SPACE},{input:\"~\",tag:\"mspace\",atname:\"width\",atval:\"0.333em\",ttype:SPACE},{input:\"\\\\quad\",tag:\"mspace\",atname:\"width\",atval:\"1em\",ttype:SPACE},{input:\"\\\\qquad\",tag:\"mspace\",atname:\"width\",atval:\"2em\",ttype:SPACE},{input:\"\\\\prime\",tag:\"mo\",output:\"\\u2032\",ttype:CONST},{input:\"'\",tag:\"mo\",output:\"\\u02B9\",ttype:CONST},{input:\"''\",tag:\"mo\",output:\"\\u02BA\",ttype:CONST},{input:\"'''\",tag:\"mo\",output:\"\\u2034\",ttype:CONST},{input:\"''''\",tag:\"mo\",output:\"\\u2057\",ttype:CONST},{input:\"\\\\ldots\",tag:\"mo\",output:\"\\u2026\",ttype:CONST},{input:\"\\\\cdots\",tag:\"mo\",output:\"\\u22EF\",ttype:CONST},{input:\"\\\\vdots\",tag:\"mo\",output:\"\\u22EE\",ttype:CONST},{input:\"\\\\ddots\",tag:\"mo\",output:\"\\u22F1\",ttype:CONST},{input:\"\\\\forall\",tag:\"mo\",output:\"\\u2200\",ttype:CONST},{input:\"\\\\exists\",tag:\"mo\",output:\"\\u2203\",ttype:CONST},{input:\"\\\\Re\",tag:\"mo\",output:\"\\u211C\",ttype:CONST},{input:\"\\\\Im\",tag:\"mo\",output:\"\\u2111\",ttype:CONST},{input:\"\\\\aleph\",tag:\"mo\",output:\"\\u2135\",ttype:CONST},{input:\"\\\\hbar\",tag:\"mo\",output:\"\\u210F\",ttype:CONST},{input:\"\\\\ell\",tag:\"mo\",output:\"\\u2113\",ttype:CONST},{input:\"\\\\wp\",tag:\"mo\",output:\"\\u2118\",ttype:CONST},{input:\"\\\\emptyset\",tag:\"mo\",output:\"\\u2205\",ttype:CONST},{input:\"\\\\infty\",tag:\"mo\",output:\"\\u221E\",ttype:CONST},{input:\"\\\\surd\",tag:\"mo\",output:\"\\\\sqrt{}\",ttype:DEFINITION},{input:\"\\\\partial\",tag:\"mo\",output:\"\\u2202\",ttype:CONST},{input:\"\\\\nabla\",tag:\"mo\",output:\"\\u2207\",ttype:CONST},{input:\"\\\\triangle\",tag:\"mo\",output:\"\\u25B3\",ttype:CONST},{input:\"\\\\therefore\",tag:\"mo\",output:\"\\u2234\",ttype:CONST},{input:\"\\\\angle\",tag:\"mo\",output:\"\\u2220\",ttype:CONST},{input:\"\\\\diamond\",tag:\"mo\",output:\"\\u22C4\",ttype:CONST},{input:\"\\\\Diamond\",tag:\"mo\",output:\"\\u25C7\",ttype:CONST},{input:\"\\\\neg\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\lnot\",tag:\"mo\",output:\"\\u00AC\",ttype:CONST},{input:\"\\\\bot\",tag:\"mo\",output:\"\\u22A5\",ttype:CONST},{input:\"\\\\top\",tag:\"mo\",output:\"\\u22A4\",ttype:CONST},{input:\"\\\\square\",tag:\"mo\",output:\"\\u25AB\",ttype:CONST},{input:\"\\\\Box\",tag:\"mo\",output:\"\\u25A1\",ttype:CONST},{input:\"\\\\wr\",tag:\"mo\",output:\"\\u2240\",ttype:CONST},{input:\"\\\\arccos\",tag:\"mi\",output:\"arccos\",ttype:UNARY,func:true},{input:\"\\\\arcsin\",tag:\"mi\",output:\"arcsin\",ttype:UNARY,func:true},{input:\"\\\\arctan\",tag:\"mi\",output:\"arctan\",ttype:UNARY,func:true},{input:\"\\\\arg\",tag:\"mi\",output:\"arg\",ttype:UNARY,func:true},{input:\"\\\\cos\",tag:\"mi\",output:\"cos\",ttype:UNARY,func:true},{input:\"\\\\cosh\",tag:\"mi\",output:\"cosh\",ttype:UNARY,func:true},{input:\"\\\\cot\",tag:\"mi\",output:\"cot\",ttype:UNARY,func:true},{input:\"\\\\coth\",tag:\"mi\",output:\"coth\",ttype:UNARY,func:true},{input:\"\\\\csc\",tag:\"mi\",output:\"csc\",ttype:UNARY,func:true},{input:\"\\\\deg\",tag:\"mi\",output:\"deg\",ttype:UNARY,func:true},{input:\"\\\\det\",tag:\"mi\",output:\"det\",ttype:UNARY,func:true},{input:\"\\\\dim\",tag:\"mi\",output:\"dim\",ttype:UNARY,func:true},{input:\"\\\\exp\",tag:\"mi\",output:\"exp\",ttype:UNARY,func:true},{input:\"\\\\gcd\",tag:\"mi\",output:\"gcd\",ttype:UNARY,func:true},{input:\"\\\\hom\",tag:\"mi\",output:\"hom\",ttype:UNARY,func:true},{input:\"\\\\inf\",tag:\"mo\",output:\"inf\",ttype:UNDEROVER},{input:\"\\\\ker\",tag:\"mi\",output:\"ker\",ttype:UNARY,func:true},{input:\"\\\\lg\",tag:\"mi\",output:\"lg\",ttype:UNARY,func:true},{input:\"\\\\lim\",tag:\"mo\",output:\"lim\",ttype:UNDEROVER},{input:\"\\\\liminf\",tag:\"mo\",output:\"liminf\",ttype:UNDEROVER},{input:\"\\\\limsup\",tag:\"mo\",output:\"limsup\",ttype:UNDEROVER},{input:\"\\\\ln\",tag:\"mi\",output:\"ln\",ttype:UNARY,func:true},{input:\"\\\\log\",tag:\"mi\",output:\"log\",ttype:UNARY,func:true},{input:\"\\\\max\",tag:\"mo\",output:\"max\",ttype:UNDEROVER},{input:\"\\\\min\",tag:\"mo\",output:\"min\",ttype:UNDEROVER},{input:\"\\\\Pr\",tag:\"mi\",output:\"Pr\",ttype:UNARY,func:true},{input:\"\\\\sec\",tag:\"mi\",output:\"sec\",ttype:UNARY,func:true},{input:\"\\\\sin\",tag:\"mi\",output:\"sin\",ttype:UNARY,func:true},{input:\"\\\\sinh\",tag:\"mi\",output:\"sinh\",ttype:UNARY,func:true},{input:\"\\\\sup\",tag:\"mo\",output:\"sup\",ttype:UNDEROVER},{input:\"\\\\tan\",tag:\"mi\",output:\"tan\",ttype:UNARY,func:true},{input:\"\\\\tanh\",tag:\"mi\",output:\"tanh\",ttype:UNARY,func:true},{input:\"\\\\gets\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\leftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:CONST},{input:\"\\\\to\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\rightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:CONST},{input:\"\\\\leftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:CONST},{input:\"\\\\uparrow\",tag:\"mo\",output:\"\\u2191\",ttype:CONST},{input:\"\\\\downarrow\",tag:\"mo\",output:\"\\u2193\",ttype:CONST},{input:\"\\\\updownarrow\",tag:\"mo\",output:\"\\u2195\",ttype:CONST},{input:\"\\\\Leftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:CONST},{input:\"\\\\Rightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:CONST},{input:\"\\\\Leftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:CONST},{input:\"\\\\iff\",tag:\"mo\",output:\"~\\\\Longleftrightarrow~\",ttype:DEFINITION},{input:\"\\\\Uparrow\",tag:\"mo\",output:\"\\u21D1\",ttype:CONST},{input:\"\\\\Downarrow\",tag:\"mo\",output:\"\\u21D3\",ttype:CONST},{input:\"\\\\Updownarrow\",tag:\"mo\",output:\"\\u21D5\",ttype:CONST},{input:\"\\\\mapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},{input:\"\\\\longleftarrow\",tag:\"mo\",output:\"\\u2190\",ttype:LONG},{input:\"\\\\longrightarrow\",tag:\"mo\",output:\"\\u2192\",ttype:LONG},{input:\"\\\\longleftrightarrow\",tag:\"mo\",output:\"\\u2194\",ttype:LONG},{input:\"\\\\Longleftarrow\",tag:\"mo\",output:\"\\u21D0\",ttype:LONG},{input:\"\\\\Longrightarrow\",tag:\"mo\",output:\"\\u21D2\",ttype:LONG},{input:\"\\\\Longleftrightarrow\",tag:\"mo\",output:\"\\u21D4\",ttype:LONG},{input:\"\\\\longmapsto\",tag:\"mo\",output:\"\\u21A6\",ttype:CONST},AMsqrt,AMroot,AMfrac,AMover,AMsub,AMsup,AMtext,AMmbox,AMatop,AMchoose,{input:\"\\\\acute\",tag:\"mover\",output:\"\\u00B4\",ttype:UNARY,acc:true},{input:\"\\\\grave\",tag:\"mover\",output:\"\\u0060\",ttype:UNARY,acc:true},{input:\"\\\\breve\",tag:\"mover\",output:\"\\u02D8\",ttype:UNARY,acc:true},{input:\"\\\\check\",tag:\"mover\",output:\"\\u02C7\",ttype:UNARY,acc:true},{input:\"\\\\dot\",tag:\"mover\",output:\".\",ttype:UNARY,acc:true},{input:\"\\\\ddot\",tag:\"mover\",output:\"..\",ttype:UNARY,acc:true},{input:\"\\\\mathring\",tag:\"mover\",output:\"\\u00B0\",ttype:UNARY,acc:true},{input:\"\\\\vec\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overrightarrow\",tag:\"mover\",output:\"\\u20D7\",ttype:UNARY,acc:true},{input:\"\\\\overleftarrow\",tag:\"mover\",output:\"\\u20D6\",ttype:UNARY,acc:true},{input:\"\\\\hat\",tag:\"mover\",output:\"\\u005E\",ttype:UNARY,acc:true},{input:\"\\\\widehat\",tag:\"mover\",output:\"\\u0302\",ttype:UNARY,acc:true},{input:\"\\\\tilde\",tag:\"mover\",output:\"~\",ttype:UNARY,acc:true},{input:\"\\\\widetilde\",tag:\"mover\",output:\"\\u02DC\",ttype:UNARY,acc:true},{input:\"\\\\bar\",tag:\"mover\",output:\"\\u203E\",ttype:UNARY,acc:true},{input:\"\\\\overbrace\",tag:\"mover\",output:\"\\uFE37\",ttype:UNARY,acc:true},{input:\"\\\\overbracket\",tag:\"mover\",output:\"\\u23B4\",ttype:UNARY,acc:true},{input:\"\\\\overline\",tag:\"mover\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\underbrace\",tag:\"munder\",output:\"\\uFE38\",ttype:UNARY,acc:true},{input:\"\\\\underbracket\",tag:\"munder\",output:\"\\u23B5\",ttype:UNARY,acc:true},{input:\"\\\\underline\",tag:\"munder\",output:\"\\u00AF\",ttype:UNARY,acc:true},{input:\"\\\\displaystyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"true\",ttype:UNARY},{input:\"\\\\textstyle\",tag:\"mstyle\",atname:\"displaystyle\",atval:\"false\",ttype:UNARY},{input:\"\\\\scriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"1\",ttype:UNARY},{input:\"\\\\scriptscriptstyle\",tag:\"mstyle\",atname:\"scriptlevel\",atval:\"2\",ttype:UNARY},{input:\"\\\\textrm\",tag:\"mstyle\",output:\"\\\\mathrm\",ttype:DEFINITION},{input:\"\\\\mathbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\textbf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"bold\",ttype:UNARY},{input:\"\\\\mathit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\textit\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"italic\",ttype:UNARY},{input:\"\\\\mathtt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\texttt\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"monospace\",ttype:UNARY},{input:\"\\\\mathsf\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"sans-serif\",ttype:UNARY},{input:\"\\\\mathbb\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"double-struck\",ttype:UNARY,codes:AMbbb},{input:\"\\\\mathcal\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"script\",ttype:UNARY,codes:AMcal},{input:\"\\\\mathfrak\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"fraktur\",ttype:UNARY,codes:AMfrk},{input:\"\\\\textcolor\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"mathcolor\",ttype:BINARY},{input:\"\\\\colorbox\",tag:\"mstyle\",atname:\"mathvariant\",atval:\"background\",ttype:BINARY}];function compareNames(s1,s2){if(s1.input>s2.input)return 1\nelse return-1;}\nvar AMnames=[];function AMinitSymbols(){AMsymbols.sort(compareNames);for(i=0;i<AMsymbols.length;i++)AMnames[i]=AMsymbols[i].input;}\nvar AMmathml=\"http://www.w3.org/1998/Math/MathML\";function AMcreateElementMathML(t){if(isIE)return document.createElement(\"m:\"+t);else return document.createElementNS(AMmathml,t);}\nfunction AMcreateMmlNode(t,frag){if(isIE)var node=document.createElement(\"m:\"+t);else var node=document.createElementNS(AMmathml,t);node.appendChild(frag);return node;}\nfunction newcommand(oldstr,newstr){AMsymbols=AMsymbols.concat([{input:oldstr,tag:\"mo\",output:newstr,ttype:DEFINITION}]);}\nfunction AMremoveCharsAndBlanks(str,n){var st;st=str.slice(n);for(var i=0;i<st.length&&st.charCodeAt(i)<=32;i=i+1);return st.slice(i);}\nfunction AMposition(arr,str,n){if(n==0){var h,m;n=-1;h=arr.length;while(n+1<h){m=(n+h)>>1;if(arr[m]<str)n=m;else h=m;}\nreturn h;}else\nfor(var i=n;i<arr.length&&arr[i]<str;i++);return i;}\nfunction AMgetSymbol(str){var k=0;var j=0;var mk;var st;var tagst;var match=\"\";var more=true;for(var i=1;i<=str.length&&more;i++){st=str.slice(0,i);j=k;k=AMposition(AMnames,st,j);if(k<AMnames.length&&str.slice(0,AMnames[k].length)==AMnames[k]){match=AMnames[k];mk=k;i=match.length;}\nmore=k<AMnames.length&&str.slice(0,AMnames[k].length)>=AMnames[k];}\nAMpreviousSymbol=AMcurrentSymbol;if(match!=\"\"){AMcurrentSymbol=AMsymbols[mk].ttype;return AMsymbols[mk];}\nAMcurrentSymbol=CONST;k=1;st=str.slice(0,1);if(\"0\"<=st&&st<=\"9\")tagst=\"mn\";else tagst=((\"A\">st||st>\"Z\")&&(\"a\">st||st>\"z\")?\"mo\":\"mi\");return{input:st,tag:tagst,output:st,ttype:CONST};}\nvar AMpreviousSymbol,AMcurrentSymbol;function AMparseSexpr(str){var symbol,node,result,result2,i,st,newFrag=document.createDocumentFragment();str=AMremoveCharsAndBlanks(str,0);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];if(symbol.ttype==DEFINITION){str=symbol.output+AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol==null||symbol.ttype==RIGHTBRACKET)\nreturn[null,str,null];}\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);switch(symbol.ttype){case SPACE:node=AMcreateElementMathML(symbol.tag);node.setAttribute(symbol.atname,symbol.atval);return[node,str,symbol.tag];case UNDEROVER:if(isIE){if(symbol.input.substr(0,4)==\"\\\\big\"){str=\"\\\\\"+symbol.input.substr(4)+str;symbol=AMgetSymbol(str);symbol.ttype=UNDEROVER;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nreturn[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];case CONST:var output=symbol.output;if(isIE){if(symbol.input==\"'\")\noutput=\"\\u2032\";else if(symbol.input==\"''\")\noutput=\"\\u2033\";else if(symbol.input==\"'''\")\noutput=\"\\u2033\\u2032\";else if(symbol.input==\"''''\")\noutput=\"\\u2033\\u2033\";else if(symbol.input==\"\\\\square\")\noutput=\"\\u25A1\";else if(symbol.input.substr(0,5)==\"\\\\frac\"){var denom=symbol.input.substr(6,1);if(denom==\"5\"||denom==\"6\"){str=symbol.input.replace(/\\\\frac/,\"\\\\frac \")+str;return[node,str,symbol.tag];}}}\nnode=AMcreateMmlNode(symbol.tag,document.createTextNode(output));return[node,str,symbol.tag];case LONG:node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));node.setAttribute(\"minsize\",\"1.5\");node.setAttribute(\"maxsize\",\"1.5\");node=AMcreateMmlNode(\"mover\",node);node.appendChild(AMcreateElementMathML(\"mspace\"));return[node,str,symbol.tag];case STRETCHY:if(isIE&&symbol.input==\"\\\\backslash\")\nsymbol.output=\"\\\\\";node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(symbol.input==\"|\"||symbol.input==\"\\\\vert\"||symbol.input==\"\\\\|\"||symbol.input==\"\\\\Vert\"){node.setAttribute(\"lspace\",\"0em\");node.setAttribute(\"rspace\",\"0em\");}\nnode.setAttribute(\"maxsize\",symbol.atval);if(symbol.rtag!=null)\nreturn[node,str,symbol.rtag];else\nreturn[node,str,symbol.tag];case BIG:var atval=symbol.atval;if(isIE)\natval=symbol.ieval;symbol=AMgetSymbol(str);if(symbol==null)\nreturn[null,str,null];str=AMremoveCharsAndBlanks(str,symbol.input.length);node=AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",atval+\"ex\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}else{node.setAttribute(\"minsize\",atval);node.setAttribute(\"maxsize\",atval);}\nreturn[node,str,symbol.tag];case LEFTBRACKET:if(symbol.input==\"\\\\left\"){symbol=AMgetSymbol(str);if(symbol!=null){if(symbol.input==\".\")\nsymbol.invisible=true;str=AMremoveCharsAndBlanks(str,symbol.input.length);}}\nresult=AMparseExpr(str,true,false);if(symbol==null||(typeof symbol.invisible==\"boolean\"&&symbol.invisible))\nnode=AMcreateMmlNode(\"mrow\",result[0]);else{node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));node=AMcreateMmlNode(\"mrow\",node);node.appendChild(result[0]);}\nreturn[node,result[1],result[2]];case MATRIX:if(symbol.input==\"\\\\begin{array}\"){var mask=\"\";symbol=AMgetSymbol(str);str=AMremoveCharsAndBlanks(str,0);if(symbol==null)\nmask=\"l\";else{str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"{\")\nmask=\"l\";else do{symbol=AMgetSymbol(str);if(symbol!=null){str=AMremoveCharsAndBlanks(str,symbol.input.length);if(symbol.input!=\"}\")\nmask=mask+symbol.input;}}while(symbol!=null&&symbol.input!=\"\"&&symbol.input!=\"}\");}\nresult=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);mask=mask.replace(/l/g,\"left \");mask=mask.replace(/r/g,\"right \");mask=mask.replace(/c/g,\"center \");node.setAttribute(\"columnalign\",mask);node.setAttribute(\"displaystyle\",\"false\");if(isIE)\nreturn[node,result[1],null];var lspace=AMcreateElementMathML(\"mspace\");lspace.setAttribute(\"width\",\"0.167em\");var rspace=AMcreateElementMathML(\"mspace\");rspace.setAttribute(\"width\",\"0.167em\");var node1=AMcreateMmlNode(\"mrow\",lspace);node1.appendChild(node);node1.appendChild(rspace);return[node1,result[1],null];}else{result=AMparseExpr(\"{\"+str,true,true);node=AMcreateMmlNode(\"mtable\",result[0]);if(isIE)\nnode.setAttribute(\"columnspacing\",\"0.25em\");else\nnode.setAttribute(\"columnspacing\",\"0.167em\");node.setAttribute(\"columnalign\",\"right center left\");node.setAttribute(\"displaystyle\",\"true\");node=AMcreateMmlNode(\"mrow\",node);return[node,result[1],null];}\ncase TEXT:if(str.charAt(0)==\"{\")i=str.indexOf(\"}\");else i=0;if(i==-1)\ni=str.length;st=str.slice(1,i);if(st.charAt(0)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nnewFrag.appendChild(AMcreateMmlNode(symbol.tag,document.createTextNode(st)));if(st.charAt(st.length-1)==\" \"){node=AMcreateElementMathML(\"mspace\");node.setAttribute(\"width\",\"0.33em\");newFrag.appendChild(node);}\nstr=AMremoveCharsAndBlanks(str,i+1);return[AMcreateMmlNode(\"mrow\",newFrag),str,null];case UNARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str];if(typeof symbol.func==\"boolean\"&&symbol.func){st=str.charAt(0);if(st==\"^\"||st==\"_\"||st==\",\"){return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}else{node=AMcreateMmlNode(\"mrow\",AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)));if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node.appendChild(space);}\nnode.appendChild(result[0]);return[node,result[1],symbol.tag];}}\nif(symbol.input==\"\\\\sqrt\"){if(isIE){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"height\",\"1.2ex\");space.setAttribute(\"width\",\"0em\");node=AMcreateMmlNode(symbol.tag,result[0])\nnode.appendChild(space);return[node,result[1],symbol.tag];}else\nreturn[AMcreateMmlNode(symbol.tag,result[0]),result[1],symbol.tag];}else if(typeof symbol.acc==\"boolean\"&&symbol.acc){node=AMcreateMmlNode(symbol.tag,result[0]);var output=symbol.output;if(isIE){if(symbol.input==\"\\\\hat\")\noutput=\"\\u0302\";else if(symbol.input==\"\\\\widehat\")\noutput=\"\\u005E\";else if(symbol.input==\"\\\\bar\")\noutput=\"\\u00AF\";else if(symbol.input==\"\\\\grave\")\noutput=\"\\u0300\";else if(symbol.input==\"\\\\tilde\")\noutput=\"\\u0303\";}\nvar node1=AMcreateMmlNode(\"mo\",document.createTextNode(output));if(symbol.input==\"\\\\vec\"||symbol.input==\"\\\\check\")\nnode1.setAttribute(\"maxsize\",\"1.2\");if(isIE&&symbol.input==\"\\\\bar\")\nnode1.setAttribute(\"maxsize\",\"0.5\");if(symbol.input==\"\\\\underbrace\"||symbol.input==\"\\\\underline\")\nnode1.setAttribute(\"accentunder\",\"true\");else\nnode1.setAttribute(\"accent\",\"true\");node.appendChild(node1);if(symbol.input==\"\\\\overbrace\"||symbol.input==\"\\\\underbrace\")\nnode.ttype=UNDEROVER;return[node,result[1],symbol.tag];}else{if(!isIE&&typeof symbol.codes!=\"undefined\"){for(i=0;i<result[0].childNodes.length;i++)\nif(result[0].childNodes[i].nodeName==\"mi\"||result[0].nodeName==\"mi\"){st=(result[0].nodeName==\"mi\"?result[0].firstChild.nodeValue:result[0].childNodes[i].firstChild.nodeValue);var newst=[];for(var j=0;j<st.length;j++)\nif(st.charCodeAt(j)>64&&st.charCodeAt(j)<91)newst=newst+\nString.fromCharCode(symbol.codes[st.charCodeAt(j)-65]);else newst=newst+st.charAt(j);if(result[0].nodeName==\"mi\")\nresult[0]=AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst));else result[0].replaceChild(AMcreateElementMathML(\"mo\").appendChild(document.createTextNode(newst)),result[0].childNodes[i]);}}\nnode=AMcreateMmlNode(symbol.tag,result[0]);node.setAttribute(symbol.atname,symbol.atval);if(symbol.input==\"\\\\scriptstyle\"||symbol.input==\"\\\\scriptscriptstyle\")\nnode.setAttribute(\"displaystyle\",\"false\");return[node,result[1],symbol.tag];}\ncase BINARY:result=AMparseSexpr(str);if(result[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];result2=AMparseSexpr(result[1]);if(result2[0]==null)return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.input)),str,null];if(symbol.input==\"\\\\textcolor\"||symbol.input==\"\\\\colorbox\"){var tclr=str.match(/\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\{\\s*[#\\w]+\\s*\\}/,\"\");if(tclr!=null){if(IsColorName.test(tclr[1].toLowerCase())){tclr=LaTeXColor[tclr[1].toLowerCase()];}else{tclr=tclr[1];}\nnode=AMcreateElementMathML(\"mstyle\");node.setAttribute(symbol.atval,tclr);node.appendChild(result2[0]);return[node,result2[1],symbol.tag];}}\nif(symbol.input==\"\\\\root\"||symbol.input==\"\\\\stackrel\")newFrag.appendChild(result2[0]);newFrag.appendChild(result[0]);if(symbol.input==\"\\\\frac\")newFrag.appendChild(result2[0]);return[AMcreateMmlNode(symbol.tag,newFrag),result2[1],symbol.tag];case INFIX:str=AMremoveCharsAndBlanks(str,symbol.input.length);return[AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output)),str,symbol.tag];default:return[AMcreateMmlNode(symbol.tag,document.createTextNode(symbol.output)),str,symbol.tag];}}\nfunction AMparseIexpr(str){var symbol,sym1,sym2,node,result,tag,underover;str=AMremoveCharsAndBlanks(str,0);sym1=AMgetSymbol(str);result=AMparseSexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(symbol.ttype==INFIX){str=AMremoveCharsAndBlanks(str,symbol.input.length);result=AMparseSexpr(str);if(result[0]==null)\nresult[0]=AMcreateMmlNode(\"mo\",document.createTextNode(\"\\u25A1\"));str=result[1];tag=result[2];if(symbol.input==\"_\"||symbol.input==\"^\"){sym2=AMgetSymbol(str);tag=null;underover=((sym1.ttype==UNDEROVER)||(node.ttype==UNDEROVER));if(symbol.input==\"_\"&&sym2.input==\"^\"){str=AMremoveCharsAndBlanks(str,sym2.input.length);var res2=AMparseSexpr(str);str=res2[1];tag=res2[2];node=AMcreateMmlNode((underover?\"munderover\":\"msubsup\"),node);node.appendChild(result[0]);node.appendChild(res2[0]);}else if(symbol.input==\"_\"){node=AMcreateMmlNode((underover?\"munder\":\"msub\"),node);node.appendChild(result[0]);}else{node=AMcreateMmlNode((underover?\"mover\":\"msup\"),node);node.appendChild(result[0]);}\nnode=AMcreateMmlNode(\"mrow\",node);}else{node=AMcreateMmlNode(symbol.tag,node);if(symbol.input==\"\\\\atop\"||symbol.input==\"\\\\choose\")\nnode.setAttribute(\"linethickness\",\"0ex\");node.appendChild(result[0]);if(symbol.input==\"\\\\choose\")\nnode=AMcreateMmlNode(\"mfenced\",node);}}\nreturn[node,str,tag];}\nfunction AMparseExpr(str,rightbracket,matrix){var symbol,node,result,i,tag,newFrag=document.createDocumentFragment();do{str=AMremoveCharsAndBlanks(str,0);result=AMparseIexpr(str);node=result[0];str=result[1];tag=result[2];symbol=AMgetSymbol(str);if(node!=undefined){if((tag==\"mn\"||tag==\"mi\")&&symbol!=null&&typeof symbol.func==\"boolean\"&&symbol.func){var space=AMcreateElementMathML(\"mspace\");space.setAttribute(\"width\",\"0.167em\");node=AMcreateMmlNode(\"mrow\",node);node.appendChild(space);}\nnewFrag.appendChild(node);}}while((symbol.ttype!=RIGHTBRACKET)&&symbol!=null&&symbol.output!=\"\");tag=null;if(symbol.ttype==RIGHTBRACKET){if(symbol.input==\"\\\\right\"){str=AMremoveCharsAndBlanks(str,symbol.input.length);symbol=AMgetSymbol(str);if(symbol!=null&&symbol.input==\".\")\nsymbol.invisible=true;if(symbol!=null)\ntag=symbol.rtag;}\nif(symbol!=null)\nstr=AMremoveCharsAndBlanks(str,symbol.input.length);var len=newFrag.childNodes.length;if(matrix&&len>0&&newFrag.childNodes[len-1].nodeName==\"mrow\"&&len>1&&newFrag.childNodes[len-2].nodeName==\"mo\"&&newFrag.childNodes[len-2].firstChild.nodeValue==\"&\"){var pos=[];var m=newFrag.childNodes.length;for(i=0;matrix&&i<m;i=i+2){pos[i]=[];node=newFrag.childNodes[i];for(var j=0;j<node.childNodes.length;j++)\nif(node.childNodes[j].firstChild.nodeValue==\"&\")\npos[i][pos[i].length]=j;}\nvar row,frag,n,k,table=document.createDocumentFragment();for(i=0;i<m;i=i+2){row=document.createDocumentFragment();frag=document.createDocumentFragment();node=newFrag.firstChild;n=node.childNodes.length;k=0;for(j=0;j<n;j++){if(typeof pos[i][k]!=\"undefined\"&&j==pos[i][k]){node.removeChild(node.firstChild);row.appendChild(AMcreateMmlNode(\"mtd\",frag));k++;}else frag.appendChild(node.firstChild);}\nrow.appendChild(AMcreateMmlNode(\"mtd\",frag));if(newFrag.childNodes.length>2){newFrag.removeChild(newFrag.firstChild);newFrag.removeChild(newFrag.firstChild);}\ntable.appendChild(AMcreateMmlNode(\"mtr\",row));}\nreturn[table,str];}\nif(typeof symbol.invisible!=\"boolean\"||!symbol.invisible){node=AMcreateMmlNode(\"mo\",document.createTextNode(symbol.output));newFrag.appendChild(node);}}\nreturn[newFrag,str,tag];}\nfunction AMparseMath(str){var result,node=AMcreateElementMathML(\"mstyle\");var cclr=str.match(/\\\\color\\s*\\{\\s*([#\\w]+)\\s*\\}/);str=str.replace(/\\\\color\\s*\\{\\s*[#\\w]+\\s*\\}/g,\"\");if(cclr!=null){if(IsColorName.test(cclr[1].toLowerCase())){cclr=LaTeXColor[cclr[1].toLowerCase()];}else{cclr=cclr[1];}\nnode.setAttribute(\"mathcolor\",cclr);}else{if(mathcolor!=\"\")node.setAttribute(\"mathcolor\",mathcolor);};if(mathfontfamily!=\"\")node.setAttribute(\"fontfamily\",mathfontfamily);node.appendChild(AMparseExpr(str.replace(/^\\s+/g,\"\"),false,false)[0]);node=AMcreateMmlNode(\"math\",node);if(showasciiformulaonhover)\nnode.setAttribute(\"title\",str.replace(/\\s+/g,\" \"));if(false){var fnode=AMcreateElementXHTML(\"font\");fnode.setAttribute(\"face\",mathfontfamily);fnode.appendChild(node);return fnode;}\nreturn node;}\nfunction AMstrarr2docFrag(arr,linebreaks){var newFrag=document.createDocumentFragment();var expr=false;for(var i=0;i<arr.length;i++){if(expr)newFrag.appendChild(AMparseMath(arr[i]));else{var arri=(linebreaks?arr[i].split(\"\\n\\n\"):[arr[i]]);newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[0])));for(var j=1;j<arri.length;j++){newFrag.appendChild(AMcreateElementXHTML(\"p\"));newFrag.appendChild(AMcreateElementXHTML(\"span\").appendChild(document.createTextNode(arri[j])));}}\nexpr=!expr;}\nreturn newFrag;}\nfunction AMprocessNodeR(n,linebreaks){var mtch,str,arr,frg,i;if(n.childNodes.length==0){if((n.nodeType!=8||linebreaks)&&n.parentNode.nodeName!=\"form\"&&n.parentNode.nodeName!=\"FORM\"&&n.parentNode.nodeName!=\"textarea\"&&n.parentNode.nodeName!=\"TEXTAREA\"&&n.parentNode.nodeName!=\"pre\"&&n.parentNode.nodeName!=\"PRE\"){str=n.nodeValue;if(!(str==null)){str=str.replace(/\\r\\n\\r\\n/g,\"\\n\\n\");str=str.replace(/\\x20+/g,\" \");str=str.replace(/\\s*\\r\\n/g,\" \");mtch=(str.indexOf(\"\\$\")==-1?false:true);str=str.replace(/([^\\\\])\\$/g,\"$1 \\$\");str=str.replace(/^\\$/,\" \\$\");arr=str.split(\" \\$\");for(i=0;i<arr.length;i++)\narr[i]=arr[i].replace(/\\\\\\$/g,\"\\$\");if(arr.length>1||mtch){if(checkForMathML){checkForMathML=false;var nd=AMisMathMLavailable();AMnoMathML=nd!=null;if(AMnoMathML&&notifyIfNoMathML)\nif(alertIfNoMathML)\nalert(\"To view the ASCIIMathML notation use Internet Explorer 6 +\\nMathPlayer (free from www.dessci.com)\\nor Firefox/Mozilla/Netscape\");else AMbody.insertBefore(nd,AMbody.childNodes[0]);}\nif(!AMnoMathML){frg=AMstrarr2docFrag(arr,n.nodeType==8);var len=frg.childNodes.length;n.parentNode.replaceChild(frg,n);return len-1;}else return 0;}}}else return 0;}else if(n.nodeName!=\"math\"){for(i=0;i<n.childNodes.length;i++)\ni+=AMprocessNodeR(n.childNodes[i],linebreaks);}\nreturn 0;}\nfunction AMprocessNode(n,linebreaks,spanclassAM){var frag,st;if(spanclassAM!=null){frag=document.getElementsByTagName(\"span\")\nfor(var i=0;i<frag.length;i++)\nif(frag[i].className==\"AM\")\nAMprocessNodeR(frag[i],linebreaks);}else{try{st=n.innerHTML;}catch(err){}\nif(st==null||st.indexOf(\"\\$\")!=-1)\nAMprocessNodeR(n,linebreaks);}\nif(isIE){frag=document.getElementsByTagName('math');for(var i=0;i<frag.length;i++)frag[i].update()}}\nvar inAppendix=false;var sectionCntr=0;var IEcommentWarning=true;var biblist=[];var bibcntr=0;var LaTeXCounter=[];LaTeXCounter[\"definition\"]=0;LaTeXCounter[\"proposition\"]=0;LaTeXCounter[\"lemma\"]=0;LaTeXCounter[\"theorem\"]=0;LaTeXCounter[\"corollary\"]=0;LaTeXCounter[\"example\"]=0;LaTeXCounter[\"exercise\"]=0;LaTeXCounter[\"subsection\"]=0;LaTeXCounter[\"subsubsection\"]=0;LaTeXCounter[\"figure\"]=0;LaTeXCounter[\"equation\"]=0;LaTeXCounter[\"table\"]=0;var LaTeXColor=[];LaTeXColor[\"greenyellow\"]=\"#D9FF4F\";LaTeXColor[\"yellow\"]=\"#FFFF00\";LaTeXColor[\"goldenrod\"]=\"#FFE529\";LaTeXColor[\"dandelion\"]=\"#FFB529\";LaTeXColor[\"apricot\"]=\"#FFAD7A\";LaTeXColor[\"peach\"]=\"#FF804D\";LaTeXColor[\"melon\"]=\"#FF8A80\";LaTeXColor[\"yelloworange\"]=\"#FF9400\";LaTeXColor[\"orange\"]=\"#FF6321\";LaTeXColor[\"burntorange\"]=\"#FF7D00\";LaTeXColor[\"bittersweet\"]=\"#C20300\";LaTeXColor[\"redorange\"]=\"#FF3B21\";LaTeXColor[\"mahogany\"]=\"#A60000\";LaTeXColor[\"maroon\"]=\"#AD0000\";LaTeXColor[\"brickred\"]=\"#B80000\";LaTeXColor[\"red\"]=\"#FF0000\";LaTeXColor[\"orangered\"]=\"#FF0080\";LaTeXColor[\"rubinered\"]=\"#FF00DE\";LaTeXColor[\"wildstrawberry\"]=\"#FF0A9C\";LaTeXColor[\"salmon\"]=\"#FF789E\";LaTeXColor[\"carnationpink\"]=\"#FF5EFF\";LaTeXColor[\"magenta\"]=\"#FF00FF\";LaTeXColor[\"violetred\"]=\"#FF30FF\";LaTeXColor[\"rhodamine\"]=\"#FF2EFF\";LaTeXColor[\"mulberry\"]=\"#A314FA\";LaTeXColor[\"redviolet\"]=\"#9600A8\";LaTeXColor[\"fuchsia\"]=\"#7303EB\";LaTeXColor[\"lavender\"]=\"#FF85FF\";LaTeXColor[\"thistle\"]=\"#E069FF\";LaTeXColor[\"orchid\"]=\"#AD5CFF\";LaTeXColor[\"darkorchid\"]=\"#9933CC\";LaTeXColor[\"purple\"]=\"#8C24FF\";LaTeXColor[\"plum\"]=\"#8000FF\";LaTeXColor[\"violet\"]=\"#361FFF\";LaTeXColor[\"royalpurple\"]=\"#401AFF\";LaTeXColor[\"blueviolet\"]=\"#1A0DF5\";LaTeXColor[\"periwinkle\"]=\"#6E73FF\";LaTeXColor[\"cadetblue\"]=\"#616EC4\";LaTeXColor[\"cornflowerblue\"]=\"#59DEFF\";LaTeXColor[\"midnightblue\"]=\"#007091\";LaTeXColor[\"navyblue\"]=\"#0F75FF\";LaTeXColor[\"royalblue\"]=\"#0080FF\";LaTeXColor[\"blue\"]=\"#0000FF\";LaTeXColor[\"cerulean\"]=\"#0FE3FF\";LaTeXColor[\"cyan\"]=\"#00FFFF\";LaTeXColor[\"processblue\"]=\"#0AFFFF\";LaTeXColor[\"skyblue\"]=\"#61FFE0\";LaTeXColor[\"turquoise\"]=\"#26FFCC\";LaTeXColor[\"tealblue\"]=\"#1FFAA3\";LaTeXColor[\"aquamarine\"]=\"#2EFFB2\";LaTeXColor[\"bluegreen\"]=\"#26FFAB\";LaTeXColor[\"emerald\"]=\"#00FF80\";LaTeXColor[\"junglegreen\"]=\"#03FF7A\";LaTeXColor[\"seagreen\"]=\"#4FFF80\";LaTeXColor[\"green\"]=\"#00FF00\";LaTeXColor[\"forestgreen\"]=\"#00E000\";LaTeXColor[\"pinegreen\"]=\"#00BF29\";LaTeXColor[\"limegreen\"]=\"#80FF00\";LaTeXColor[\"yellowgreen\"]=\"#8FFF42\";LaTeXColor[\"springgreen\"]=\"#BDFF3D\";LaTeXColor[\"olivegreen\"]=\"#009900\";LaTeXColor[\"rawsienna\"]=\"#8C0000\";LaTeXColor[\"sepia\"]=\"#4D0000\";LaTeXColor[\"brown\"]=\"#660000\";LaTeXColor[\"tan\"]=\"#DB9470\";LaTeXColor[\"gray\"]=\"#808080\";LaTeXColor[\"grey\"]=\"#808080\";LaTeXColor[\"black\"]=\"#000000\";LaTeXColor[\"white\"]=\"#FFFFFF\";var IsColorName=/^(?:greenyellow|yellow|goldenrod|dandelion|apricot|peach|melon|yelloworange|orange|burntorange|bittersweet|redorange|mahogany|maroon|brickred|red|orangered|rubinered|wildstrawberry|salmon|carnationpink|magenta|violetred|rhodamine|mulberry|redviolet|fuchsia|lavender|thistle|orchid|darkorchid|purple|plum|violet|royalpurple|blueviolet|periwinkle|cadetblue|cornflowerblue|midnightblue|navyblue|royalblue|blue|cerulean|cyan|processblue|skyblue|turquoise|tealblue|aquamarine|bluegreen|emerald|junglegreen|seagreen|green|forestgreen|pinegreen|limegreen|yellowgreen|springgreen|olivegreen|rawsienna|sepia|brown|tan|gray|grey|black|white)$/;var IsCounter=/^(?:definition|proposition|lemma|theorem|corollary|example|exercise|subsection|subsubsection|figure|equation|table)$/;var IsLaTeXElement=/^(?:displayequation|title|author|address|date|abstract|keyword|section|subsection|subsubsection|ref|cite|thebibliography|definition|proposition|lemma|theorem|corollary|example|exercise|itemize|enumerate|enddefinition|endproposition|endlemma|endtheorem|endcorollary|endexample|endexercise|enditemize|endenumerate|LaTeXMathMLlabel|LaTeXMathML|smallskip|medskip|bigskip|quote|quotation|endquote|endquotation|center|endcenter|description|enddescription|inlinemath)$/;var IsTextOnlyArea=/^(?:form|textarea|pre)$/i;var tableid=0;function makeNumberString(cntr){if(sectionCntr>0){if(inAppendix){return\"A\"+sectionCntr+\".\"+cntr;}else{return sectionCntr+\".\"+cntr;}}else{return\"\"+cntr;}};function LaTeXpreProcess(thebody){var TheBody=thebody;if(TheBody.hasChildNodes()){if(!(IsLaTeXElement.test(TheBody.className)))\n{for(var i=0;i<TheBody.childNodes.length;i++){LaTeXpreProcess(TheBody.childNodes[i])}}}\nelse{if(TheBody.nodeType==3&&!(IsTextOnlyArea.test(TheBody.parentNode.nodeName)))\n{var str=TheBody.nodeValue;if(!(str==null)){str=str.replace(/\\\\%/g,\"<per>\");str=str.replace(/%[^\\n]*(?=\\n)/g,\"\");str=str.replace(/%[^\\r]*(?=\\r)/g,\"\");str=str.replace(/%[^\\n]*$/,\"\")\nif(isIE&&str.match(/%/g)!=null&&IEcommentWarning){alert(\"Comments may not have parsed properly.  Try putting in <pre class='LaTeX><div>..</div></pre> structure.\");IEcommentWarning=false;}\nstr=str.replace(/<per>/g,\"%\");if(str.match(/XXX[\\s\\S]*/)!=null){var tmp=str.match(/XXX[\\s\\S]*/)[0];var tmpstr=tmp.charCodeAt(7)+\"::\"+tmp.charCodeAt(8)+\"::\"+tmp.charCodeAt(9)+\"::\"+tmp.charCodeAt(10)+\"::\"+tmp.charCodeAt(11)+\"::\"+tmp.charCodeAt(12)+\"::\"+tmp.charCodeAt(13);alert(tmpstr);}\nstr=str.replace(/([^\\\\])\\\\(\\s)/g,\"$1\\u00A0$2\");str=str.replace(/\\\\quad/g,\"\\u2001\");str=str.replace(/\\\\qquad/g,\"\\u2001\\u2001\");str=str.replace(/\\\\enspace/g,\"\\u2002\");str=str.replace(/\\\\;/g,\"\\u2004\");str=str.replace(/\\\\:/g,\"\\u2005\");str=str.replace(/\\\\,/g,\"\\u2006\");str=str.replace(/\\\\thinspace/g,\"\\u200A\");str=str.replace(/([^\\\\])~/g,\"$1\\u00A0\");str=str.replace(/\\\\~/g,\"~\");str=str.replace(/\\\\\\[/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\\\]/g,\"}$ <DEQ> \");str=str.replace(/\\$\\$/g,\"${$<DEQ>$}$\");str=str.replace(/\\\\begin\\s*\\{\\s*array\\s*\\}/g,\"\\\\begin{array}\");str=str.replace(/\\\\end\\s*\\{\\s*array\\s*\\}/g,\"\\\\end{array}\");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\s*\\}/g,\"  <DEQ>eqno$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"  <DEQ>$\\\\begin{eqnarray}\");str=str.replace(/\\\\end\\s*\\{\\s*eqnarray\\*\\s*\\}/g,\"\\\\end{eqnarray}$<DEQ>  \");str=str.replace(/\\\\begin\\s*\\{\\s*displaymath\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*displaymath\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\" <DEQ> $\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\*\\s*\\}/g,\"}$ <DEQ> \");str=str.replace(/\\\\begin\\s*\\{\\s*equation\\s*\\}/g,\" <DEQ>eqno$\\\\displaystyle{\");str=str.replace(/\\\\end\\s*\\{\\s*equation\\s*\\}/g,\"}$ <DEQ> \");str=str.split(\"<DEQ>\");var newFrag=document.createDocumentFragment();for(var i=0;i<str.length;i++){if(i%2){var DEQtable=document.createElement(\"table\");DEQtable.className='displayequation';var DEQtbody=document.createElement(\"tbody\");var DEQtr=document.createElement(\"tr\");var DEQtdeq=document.createElement(\"td\");DEQtdeq.className='eq';str[i]=str[i].replace(/\\$\\}\\$/g,\"$\\\\displaystyle{\");str[i]=str[i].replace(/\\$\\{\\$/g,\"}\");var lbl=str[i].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);var ISeqno=str[i].match(/^eqno/);str[i]=str[i].replace(/^eqno/,\" \");str[i]=str[i].replace(/\\\\label\\s*\\{\\s*\\w+\\s*\\}/,\" \");DEQtdeq.appendChild(document.createTextNode(str[i]));DEQtr.appendChild(DEQtdeq);str[i]=str[i].replace(/\\\\nonumber/g,\"\");if(ISeqno!=null||lbl!=null){var DEQtdno=document.createElement(\"td\");DEQtdno.className='eqno';LaTeXCounter[\"equation\"]++;var eqnoString=makeNumberString(LaTeXCounter[\"equation\"]);var DEQanchor=document.createElement(\"a\");if(lbl!=null){DEQanchor.id=lbl[1]};DEQanchor.className=\"eqno\";var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"eqno\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(eqnoString));DEQanchor.appendChild(anchorSpan);DEQtdno.appendChild(DEQanchor);var DEQspan=document.createElement(\"span\");DEQspan.className=\"eqno\";DEQspan.appendChild(document.createTextNode(\"(\"+eqnoString+\")\"));DEQtdno.appendChild(DEQspan);DEQtr.appendChild(DEQtdno);}\nDEQtbody.appendChild(DEQtr);DEQtable.appendChild(DEQtbody);newFrag.appendChild(DEQtable);}\nelse{str[i]=str[i].replace(/\\$\\}\\$/g,\"\");str[i]=str[i].replace(/\\$\\{\\$/g,\"\");str[i]=str[i].replace(/\\\\maketitle/g,\"\");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*document\\s*\\}/g,\"\");str[i]=str[i].replace(/\\\\documentclass[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\usepackage[^\\}]*?\\}/g,\"\");str[i]=str[i].replace(/\\\\noindent/g,\"\");str[i]=str[i].replace(/\\\\notag/g,\"\");str[i]=str[i].replace(/\\\\ref\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[ref\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\url\\s*\\{\\s*([^\\}\\n]+)\\}/g,\" \\\\[url\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\href\\s*\\{\\s*([^\\}]+)\\}\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[href\\\\]$1\\\\]$2\\\\[ \");str[i]=str[i].replace(/\\\\cite\\s*\\{\\s*(\\w+)\\}/g,\" \\\\[cite\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\qed/g,\"\\u220E\");str[i]=str[i].replace(/\\\\endproof/g,\"\\u220E\");str[i]=str[i].replace(/\\\\proof/g,\"\\\\textbf{Proof: }\");str[i]=str[i].replace(/\\\\n(?=\\s)/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\newline/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\linebreak/g,\" \\\\[br\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\smallskip/g,\" \\\\[logicalbreak\\\\]smallskip\\\\[ \");str[i]=str[i].replace(/\\\\medskip/g,\" \\\\[logicalbreak\\\\]medskip\\\\[ \");str[i]=str[i].replace(/\\\\bigskip/g,\" \\\\[logicalbreak\\\\]bigskip\\\\[ \");str[i]=str[i].replace(/[\\n\\r]+[ \\f\\n\\r\\t\\v\\u2028\\u2029]*[\\n\\r]+/g,\" \\\\[logicalbreak\\\\]LaTeXMathML\\\\[ \");if(isIE){str[i]=str[i].replace(/\\r/g,\" \");}\nstr[i]=str[i].replace(/\\\\bibitem\\s*([^\\{]*\\{\\s*\\w*\\s*\\})/g,\" \\\\[bibitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\bibitem\\s*/g,\" \\\\[bibitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\item\\s*\\[\\s*(\\w+)\\s*\\]/g,\" \\\\[alistitem\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\item\\s*/g,\" \\\\[alistitem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\appendix/g,\" \\\\[appendix\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*figure\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*figure\\s*\\}/g,\" \\\\[figure\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*table\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*table\\s*\\}/g,\" \\\\[table\\\\]$1\\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[theorem\\\\]Theorem \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*theorem\\s*\\}/g,\" \\\\[endtheorem\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[definition\\\\]Definition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*definition\\s*\\}/g,\" \\\\[enddefinition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[lemma\\\\]Lemma \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*lemma\\s*\\}/g,\" \\\\[endlemma\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[corollary\\\\]Corollary \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*corollary\\s*\\}/g,\" \\\\[endcorollary\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[proposition\\\\]Proposition \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proposition\\s*\\}/g,\" \\\\[endproposition\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*example\\s*\\}/g,\" \\\\[example\\\\]Example \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*example\\s*\\}/g,\" \\\\[endexample\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[exercise\\\\]Exercise \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*exercise\\s*\\}/g,\" \\\\[endexercise\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}\\s*\\{\\s*\\w+\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[thebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*thebibliography\\s*\\}/g,\" \\\\[endthebibliography\\\\]References \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[proof\\\\]Proof: \\\\[ \");if(isIE){str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\"\\u220E \\\\[endproof\\\\] \\\\[ \");}else{str[i]=str[i].replace(/\\\\end\\s*\\{\\s*proof\\s*\\}/g,\" \\\\[endproof\\\\] \\\\[ \");}\nstr[i]=str[i].replace(/\\\\title\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[title\\\\] \\\\[$1 \\\\[endtitle\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\author\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[author\\\\] \\\\[$1 \\\\[endauthor\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\address\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[address\\\\] \\\\[$1 \\\\[endaddress\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\date\\s*\\{\\s*([^\\}]+)\\}/g,\" \\\\[date\\\\] \\\\[$1 \\\\[enddate\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[keyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*keyword\\s*\\}/g,\" \\\\[endkeyword\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[abstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*abstract\\s*\\}/g,\" \\\\[endabstract\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\begin\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[$1\\\\] \\\\[ \");str[i]=str[i].replace(/\\\\end\\s*\\{\\s*(?!array|tabular)(\\w+)\\s*\\}/g,\" \\\\[end$1\\\\] \\\\[ \");var sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\section\\s*\\{/,\" \\\\[section\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\section\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsection\\s*\\{/,\" \\\\[subsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nsectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);while(sectionIndex>=0){str[i]=str[i].replace(/\\\\subsubsection\\s*\\{/,\" \\\\[subsubsection\\\\]\");var delimcnt=1;for(var ii=sectionIndex;ii<str[i].length;ii++){if(str[i].charAt(ii)==\"{\"){delimcnt++};if(str[i].charAt(ii)==\"}\"){delimcnt--};if(delimcnt==0){str[i]=str[i].substring(0,ii)+\"\\\\[ \"+str[i].substring(ii+1,str[i].length);break;}};sectionIndex=str[i].search(/\\\\subsubsection\\s*\\{\\s*[\\s\\S]+\\}/);}\nvar CatToNextEven=\"\";var strtmp=str[i].split(\"\\\\[\");for(var j=0;j<strtmp.length;j++){if(j%2){var strtmparray=strtmp[j].split(\"\\\\]\");switch(strtmparray[0]){case\"section\":var nodeTmp=document.createElement(\"H2\");nodeTmp.className='section';sectionCntr++;for(var div in LaTeXCounter){LaTeXCounter[div]=0};var nodeAnchor=document.createElement(\"a\");if(inAppendix){nodeAnchor.className='appendixsection';}else{nodeAnchor.className='section';}\nvar nodeNumString=makeNumberString(\"\");var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"section\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='section';nodeSpan.appendChild(document.createTextNode(nodeNumString+\" \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsection\":var nodeTmp=document.createElement(\"H3\");nodeTmp.className='subsection';LaTeXCounter[\"subsection\"]++;LaTeXCounter[\"subsubsection\"]=0;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"subsubsection\":var nodeTmp=document.createElement(\"H4\");nodeTmp.className='subsubsection';LaTeXCounter[\"subsubsection\"]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className='subsubsection';var nodeNumString=makeNumberString(LaTeXCounter[\"subsection\"]+\".\"+LaTeXCounter[\"subsubsection\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"subsubsection\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(nodeNumString));nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className='subsubsection';nodeSpan.appendChild(document.createTextNode(nodeNumString+\". \"));nodeTmp.appendChild(nodeSpan);nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"href\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"url\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathML';nodeTmp.href=strtmparray[1];nodeTmp.appendChild(document.createTextNode(strtmparray[1]));newFrag.appendChild(nodeTmp);break;case\"figure\":var nodeTmp=document.createElement(\"table\");nodeTmp.className='figure';var FIGtbody=document.createElement(\"tbody\");var FIGlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var FIGcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;FIGcap=tmp.substring(capstart,pos);break}}}\nvar FIGtr2=document.createElement(\"tr\");var FIGtd2=document.createElement(\"td\");FIGtd2.className=\"caption\";var FIGanchor=document.createElement(\"a\");FIGanchor.className=\"figure\";if(FIGlbl!=null){FIGanchor.id=FIGlbl[1];}\nLaTeXCounter[\"figure\"]++;var fignmbr=makeNumberString(LaTeXCounter[\"figure\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"figure\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(fignmbr));FIGanchor.appendChild(anchorSpan);FIGtd2.appendChild(FIGanchor);var FIGspan=document.createElement(\"span\");FIGspan.className=\"figure\";FIGspan.appendChild(document.createTextNode(\"Figure \"+fignmbr+\". \"));FIGtd2.appendChild(FIGspan);FIGtd2.appendChild(document.createTextNode(\"\"+FIGcap));FIGtr2.appendChild(FIGtd2);FIGtbody.appendChild(FIGtr2);var IsSpecial=false;var FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\{([^\\}]+)\\}/);if(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\includegraphics\\s*\\[[^\\]]*\\]\\s*\\{\\s*([^\\}]+)\\s*\\}/);}\nif(FIGinfo==null){FIGinfo=strtmparray[1].match(/\\\\special\\s*\\{\\s*([^\\}]+)\\}/);IsSpecial=true};if(FIGinfo!=null){var FIGtr1=document.createElement(\"tr\");var FIGtd1=document.createElement(\"td\");FIGtd1.className=\"image\";var FIGimg=document.createElement(\"img\");var FIGsrc=FIGinfo[1];FIGimg.src=FIGsrc;FIGimg.alt=\"Figure \"+FIGsrc+\" did not load\";FIGimg.title=\"Figure \"+fignmbr+\". \"+FIGcap;FIGimg.id=\"figure\"+fignmbr;FIGtd1.appendChild(FIGimg);FIGtr1.appendChild(FIGtd1);FIGtbody.appendChild(FIGtr1);}\nnodeTmp.appendChild(FIGtbody);newFrag.appendChild(nodeTmp);break;case\"table\":var nodeTmp=document.createElement(\"table\");if(strtmparray[1].search(/\\\\centering/)>=0){nodeTmp.className='LaTeXtable centered';nodeTmp.align=\"center\";}else{nodeTmp.className='LaTeXtable';};tableid++;nodeTmp.id=\"LaTeXtable\"+tableid;var TABlbl=strtmparray[1].match(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\\\label\\s*\\{\\w+\\}/g,\"\");var capIndex=strtmparray[1].search(/\\\\caption\\s*\\{[\\s\\S]+\\}/);var TABcap=\"\";if(capIndex>=0){var tmp=strtmparray[1];var delimcnt=0;var capstart=-1;for(var pos=capIndex;pos<tmp.length;pos++){if(tmp.charAt(pos)==\"{\"){delimcnt++};if(tmp.charAt(pos)==\"}\"){delimcnt--};if(delimcnt==1&&capstart<0){capstart=pos+1};if(delimcnt==0&&capstart>0){capend=pos-1;TABcap=tmp.substring(capstart,pos);break}}}\nif(TABcap!=\"\"){var TABtbody=document.createElement(\"tbody\");var TABcaption=document.createElement(\"caption\");TABcaption.className=\"LaTeXtable centered\";var TABanchor=document.createElement(\"a\");TABanchor.className=\"LaTeXtable\";if(TABlbl!=null){TABanchor.id=TABlbl[1];}\nLaTeXCounter[\"table\"]++;var tabnmbr=makeNumberString(LaTeXCounter[\"table\"]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=\"LaTeXtable\";anchorSpan.style.display=\"none\";anchorSpan.appendChild(document.createTextNode(tabnmbr));TABanchor.appendChild(anchorSpan);TABcaption.appendChild(TABanchor);var TABspan=document.createElement(\"span\");TABspan.className=\"LaTeXtable\";TABspan.appendChild(document.createTextNode(\"Table \"+tabnmbr+\". \"));TABcaption.appendChild(TABspan);TABcaption.appendChild(document.createTextNode(\"\"+TABcap));nodeTmp.appendChild(TABcaption);}\nvar TABinfo=strtmparray[1].match(/\\\\begin\\s*\\{\\s*tabular\\s*\\}([\\s\\S]+)\\\\end\\s*\\{\\s*tabular\\s*\\}/);if(TABinfo!=null){var TABtbody=document.createElement('tbody');var TABrow=null;var TABcell=null;var row=0;var col=0;var TABalign=TABinfo[1].match(/^\\s*\\{([^\\}]+)\\}/);TABinfo=TABinfo[1].replace(/^\\s*\\{[^\\}]+\\}/,\"\");TABinfo=TABinfo.replace(/\\\\hline/g,\"\");TABalign[1]=TABalign[1].replace(/\\|/g,\"\");TABalign[1]=TABalign[1].replace(/\\s/g,\"\");TABinfo=TABinfo.split(\"\\\\\\\\\");for(row=0;row<TABinfo.length;row++){TABrow=document.createElement(\"tr\");TABinfo[row]=TABinfo[row].split(\"&\");for(col=0;col<TABinfo[row].length;col++){TABcell=document.createElement(\"td\");switch(TABalign[1].charAt(col)){case\"l\":TABcell.align=\"left\";break;case\"c\":TABcell.align=\"center\";break;case\"r\":TABcell.align=\"right\";break;default:TABcell.align=\"left\";};TABcell.appendChild(document.createTextNode(TABinfo[row][col]));TABrow.appendChild(TABcell);}\nTABtbody.appendChild(TABrow);}\nnodeTmp.appendChild(TABtbody);}\nnewFrag.appendChild(nodeTmp);break;case\"logicalbreak\":var nodeTmp=document.createElement(\"p\");nodeTmp.className=strtmparray[1];nodeTmp.appendChild(document.createTextNode(\"\\u00A0\"));newFrag.appendChild(nodeTmp);break;case\"appendix\":inAppendix=true;sectionCntr=0;break;case\"alistitem\":var EndDiv=document.createElement(\"div\");EndDiv.className=\"endlistitem\";newFrag.appendChild(EndDiv);var BegDiv=document.createElement(\"div\");BegDiv.className=\"listitem\";if(strtmparray[1]!=\" \"){var BegSpan=document.createElement(\"span\");BegSpan.className=\"listitemmarker\";var boldBegSpan=document.createElement(\"b\");boldBegSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"));BegSpan.appendChild(boldBegSpan);BegDiv.appendChild(BegSpan);}\nnewFrag.appendChild(BegDiv);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"bibitem\":newFrag.appendChild(document.createElement(\"br\"));var nodeTmp=document.createElement(\"a\");nodeTmp.className='bibitem';var nodeSpan=document.createElement(\"span\");nodeSpan.className='bibitem';bibcntr++;var lbl=strtmparray[1].match(/\\{\\s*(\\w+)\\s*\\}/);strtmparray[1]=strtmparray[1].replace(/\\s*\\{\\s*\\w+\\s*\\}/g,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s*\\[/,\"\");strtmparray[1]=strtmparray[1].replace(/\\s*\\]$/,\"\");strtmparray[1]=strtmparray[1].replace(/^\\s+|\\s+$/g,\"\");if(lbl==null){biblist[bibcntr]=\"bibitem\"+bibcntr}else{biblist[bibcntr]=lbl[1];};nodeTmp.name=biblist[bibcntr];nodeTmp.id=biblist[bibcntr];if(strtmparray[1]!=\"\"){nodeSpan.appendChild(document.createTextNode(strtmparray[1]));}else{nodeSpan.appendChild(document.createTextNode(\"[\"+bibcntr+\"]\"));}\nnodeTmp.appendChild(nodeSpan);newFrag.appendChild(nodeTmp);break;case\"cite\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='cite';nodeTmp.name='cite';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;case\"ref\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='ref';nodeTmp.name='ref';nodeTmp.href=\"#\"+strtmparray[1];newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"div\");nodeTmp.className=strtmparray[0];if(IsCounter.test(strtmparray[0])){LaTeXCounter[strtmparray[0]]++;var nodeAnchor=document.createElement(\"a\");nodeAnchor.className=strtmparray[0];var divnum=makeNumberString(LaTeXCounter[strtmparray[0]]);var anchorSpan=document.createElement(\"span\");anchorSpan.className=strtmparray[0];anchorSpan.appendChild(document.createTextNode(divnum));anchorSpan.style.display=\"none\";nodeAnchor.appendChild(anchorSpan);nodeTmp.appendChild(nodeAnchor);var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]+\" \"+divnum+\". \"));nodeTmp.appendChild(nodeSpan);}\nif(isIE){if(strtmparray[0]==(\"thebibliography\"||\"abstract\"||\"keyword\"||\"proof\")){var nodeSpan=document.createElement(\"span\");nodeSpan.className=strtmparray[0];nodeSpan.appendChild(document.createTextNode(strtmparray[1]));nodeTmp.appendChild(nodeSpan);}}\nif(strtmparray[0]==\"endenumerate\"||strtmparray[0]==\"enditemize\"||strtmparray[0]==\"enddescription\"){var endDiv=document.createElement(\"div\");endDiv.className=\"endlistitem\";newFrag.appendChild(endDiv);}\nnewFrag.appendChild(nodeTmp);if(strtmparray[0]==\"enumerate\"||strtmparray[0]==\"itemize\"||strtmparray[0]==\"description\"){var endDiv=document.createElement(\"div\");endDiv.className=\"listitem\";newFrag.appendChild(endDiv);}}}else{strtmp[j]=strtmp[j].replace(/\\\\\\$/g,\"<per>\");strtmp[j]=strtmp[j].replace(/\\$([^\\$]+)\\$/g,\" \\\\[$1\\\\[ \");strtmp[j]=strtmp[j].replace(/<per>/g,\"\\\\$\");strtmp[j]=strtmp[j].replace(/\\\\begin\\s*\\{\\s*math\\s*\\}([\\s\\S]+?)\\\\end\\s*\\{\\s*math\\s*\\}/g,\" \\\\[$1\\\\[ \");var strtmptmp=strtmp[j].split(\"\\\\[\");for(var jjj=0;jjj<strtmptmp.length;jjj++){if(jjj%2){var nodeTmp=document.createElement(\"span\");nodeTmp.className='inlinemath';nodeTmp.appendChild(document.createTextNode(\"$\"+strtmptmp[jjj]+\"$\"));newFrag.appendChild(nodeTmp);}else{var TagIndex=strtmptmp[jjj].search(/\\\\\\w+/);var tmpIndex=TagIndex;while(tmpIndex>-1){if(/^\\\\textcolor/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\textcolor\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[textcolor\\\\]$1\\\\]|\");}else{if(/^\\\\colorbox/.test(strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length))){strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\colorbox\\s*\\{\\s*(\\w+)\\s*\\}\\s*/,\" \\\\[colorbox\\\\]$1\\\\]|\");}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).replace(/\\\\\\s*(\\w+)\\s*/,\" \\\\[$1\\\\]|\");}}\nTagIndex+=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\|/);TagIndex++;strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\]\\|/,\"\\\\] \");if(strtmptmp[jjj].charAt(TagIndex)==\"{\"){strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);var delimcnt=1;for(var kk=TagIndex;kk<strtmptmp[jjj].length;kk++){if(strtmptmp[jjj].charAt(kk)==\"{\"){delimcnt++};if(strtmptmp[jjj].charAt(kk)==\"}\"){delimcnt--};if(delimcnt==0){break;}}\nstrtmptmp[jjj]=strtmptmp[jjj].substring(0,kk)+\"\\\\[ \"+strtmptmp[jjj].substring(kk+1,strtmptmp[jjj].length);TagIndex=kk+3;}else{strtmptmp[jjj]=strtmptmp[jjj].substring(0,TagIndex)+\"\\\\[ \"+strtmptmp[jjj].substring(TagIndex+1,strtmptmp[jjj].length);TagIndex=TagIndex+3;}\nif(TagIndex<strtmptmp[jjj].length){tmpIndex=strtmptmp[jjj].substring(TagIndex,strtmptmp[jjj].length).search(/\\\\\\w+/);}\nelse{tmpIndex=-1};TagIndex+=tmpIndex;}\nstrtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\\\s*\\\\\\\\/g,\"\\\\\\\\\");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\\\\\/g,\" \\\\[br\\\\] \\\\[ \");strtmptmp[jjj]=strtmptmp[jjj].replace(/\\\\label\\s*\\{\\s*(\\w+)\\s*\\}/g,\" \\\\[a\\\\]$1\\\\[ \");var strlbls=strtmptmp[jjj].split(\"\\\\[\");for(var jj=0;jj<strlbls.length;jj++){if(jj%2){var strtmparray=strlbls[jj].split(\"\\\\]\");switch(strtmparray[0]){case\"textcolor\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.color=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.color=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"colorbox\":var nodeTmp=document.createElement(\"span\");nodeTmp.className='LaTeXColor';if(IsColorName.test(strtmparray[1].toLowerCase())){nodeTmp.style.background=LaTeXColor[strtmparray[1].toLowerCase()];}else{nodeTmp.style.background=strtmparray[1];};nodeTmp.appendChild(document.createTextNode(strtmparray[2]));newFrag.appendChild(nodeTmp);break;case\"br\":newFrag.appendChild(document.createElement(\"br\"));break;case\"a\":var nodeTmp=document.createElement(\"a\");nodeTmp.className='LaTeXMathMLlabel';nodeTmp.id=strtmparray[1];nodeTmp.style.display=\"none\";newFrag.appendChild(nodeTmp);break;default:var nodeTmp=document.createElement(\"span\");nodeTmp.className=strtmparray[0];nodeTmp.appendChild(document.createTextNode(strtmparray[1]))\nnewFrag.appendChild(nodeTmp);}}else{newFrag.appendChild(document.createTextNode(strlbls[jj]));}}}}}}}};TheBody.parentNode.replaceChild(newFrag,TheBody);}}}\nreturn TheBody;}\nfunction LaTeXDivsAndRefs(thebody){var TheBody=thebody;var EndDivClass=null;var AllDivs=TheBody.getElementsByTagName(\"div\");var lbl2id=\"\";var lblnode=null;for(var i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){EndDivClass=EndDivClass[0];var DivClass=EndDivClass.substring(3,EndDivClass.length);var EndDivNode=AllDivs[i];break;}}\nwhile(EndDivClass!=null){var newFrag=document.createDocumentFragment();var RootNode=EndDivNode.parentNode;var ClassCount=1;while(EndDivNode.previousSibling!=null&&ClassCount>0){switch(EndDivNode.previousSibling.className){case EndDivClass:ClassCount++;newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);break;case DivClass:if(EndDivNode.previousSibling.nodeName==\"DIV\"){ClassCount--;if(lbl2id!=\"\"){EndDivNode.previousSibling.id=lbl2id;lbl2id=\"\"}\nif(ClassCount==0){RootNode=EndDivNode.previousSibling;}else{newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}};break;case'LaTeXMathMLlabel':lbl2id=EndDivNode.previousSibling.id;EndDivNode.parentNode.removeChild(EndDivNode.previousSibling);break;default:newFrag.insertBefore(EndDivNode.previousSibling,newFrag.firstChild);}}\nRootNode.appendChild(newFrag);EndDivNode.parentNode.removeChild(EndDivNode);AllDivs=TheBody.getElementsByTagName(\"DIV\");for(i=AllDivs.length-1;i>=0;i--){EndDivClass=AllDivs[i].className.match(/end\\w+/);if(EndDivClass!=null){ClassCount=0;EndDivClass=EndDivClass[0];DivClass=EndDivClass.substring(3,EndDivClass.length);EndDivNode=AllDivs[i];RootNode=EndDivNode.parentNode;break;}}}\nvar AllDivs=TheBody.getElementsByTagName(\"div\");var DIV2LI=null;for(var i=0;i<AllDivs.length;i++){if(AllDivs[i].className==\"itemize\"||AllDivs[i].className==\"enumerate\"||AllDivs[i].className==\"description\"){if(AllDivs[i].className==\"itemize\"){RootNode=document.createElement(\"UL\");}else{RootNode=document.createElement(\"OL\");}\nRootNode.className='LaTeXMathML';if(AllDivs[i].hasChildNodes()){AllDivs[i].removeChild(AllDivs[i].firstChild)};while(AllDivs[i].hasChildNodes()){if(AllDivs[i].firstChild.hasChildNodes()){DIV2LI=document.createElement(\"LI\");while(AllDivs[i].firstChild.hasChildNodes()){DIV2LI.appendChild(AllDivs[i].firstChild.firstChild);}\nif(DIV2LI.firstChild.className==\"listitemmarker\"){DIV2LI.style.listStyleType=\"none\";}\nRootNode.appendChild(DIV2LI)}\nAllDivs[i].removeChild(AllDivs[i].firstChild);}\nAllDivs[i].appendChild(RootNode);}}\nvar AllAnchors=TheBody.getElementsByTagName(\"a\");for(var i=0;i<AllAnchors.length;i++){if(AllAnchors[i].className==\"ref\"||AllAnchors[i].className==\"cite\"){var label=AllAnchors[i].href.match(/\\#(\\w+)/);if(label!=null){var labelNode=document.getElementById(label[1]);if(labelNode!=null){var TheSpans=labelNode.getElementsByTagName(\"SPAN\");if(TheSpans!=null){var refNode=TheSpans[0].cloneNode(true);refNode.style.display=\"inline\"\nrefNode.className=AllAnchors[i].className;AllAnchors[i].appendChild(refNode);}}}}}\nreturn TheBody;}\nvar AMbody;var AMnoMathML=false,AMtranslated=false;function translate(spanclassAM){if(!AMtranslated){AMtranslated=true;AMinitSymbols();var LaTeXContainers=[];var AllContainers=document.getElementsByTagName('*');var ExtendName=\"\";for(var k=0,l=0;k<AllContainers.length;k++){ExtendName=\" \"+AllContainers[k].className+\" \";if(ExtendName.match(/\\sLaTeX\\s/)!=null){LaTeXContainers[l]=AllContainers[k];l++;}};if(LaTeXContainers.length>0){for(var m=0;m<LaTeXContainers.length;m++){AMbody=LaTeXContainers[m];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nif(AMbody.tagName==\"PRE\"){var PreChilds=document.createDocumentFragment();var DivChilds=document.createElement(\"DIV\");while(AMbody.hasChildNodes()){DivChilds.appendChild(AMbody.firstChild);}\nPreChilds.appendChild(DivChilds);AMbody.parentNode.replaceChild(PreChilds,AMbody);AMbody=DivChilds;}\nAMprocessNode(AMbody,false,spanclassAM);}}else{AMbody=document.getElementsByTagName(\"body\")[0];try{AMbody=LaTeXDivsAndRefs(LaTeXpreProcess(AMbody));}catch(err){alert(\"Unknown Error: Defaulting to Original LaTeXMathML\");}\nAMprocessNode(AMbody,false,spanclassAM);}}}\nif(isIE){document.write(\"<object id=\\\"mathplayer\\\" classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");}\nfunction generic()\n{translate();};if(typeof window.addEventListener!='undefined')\n{window.addEventListener('load',generic,false);}\nelse if(typeof document.addEventListener!='undefined')\n{document.addEventListener('load',generic,false);}\nelse if(typeof window.attachEvent!='undefined')\n{window.attachEvent('onload',generic);}\nelse\n{if(typeof window.onload=='function')\n{var existing=onload;window.onload=function()\n{existing();generic();};}\nelse\n{window.onload=generic;}}\n"),("reference.odt","PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\NUL\NULmimetypeapplication/vnd.oasis.opendocument.textPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL;\138\vC\163\159\SOHAJ\SOH\NUL\NUL\STX\ETX\NUL\NUL\b\NUL\FS\NULmeta.xmlUT\t\NUL\ETX\177)\bR\177)\bRux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\141R\203v\131 \DLE\221\231+<t\173\168\201\162\225\168\217u\221E\251\SOH\EOT'J\171\224\SOH\140\249\252\STXF\139I\ETBu\199}\204\220\153\177\&8\221\250.\186\130\210\\\138\DC2eI\138\"\DLEL\214\\4%\250\252x\139_\209\169\218\NAK\242r\225\fH-\217\216\131\&0q\SI\134\238\"\251Y\187\208d\166K4*A$\213\\\DC3A{\208\196\&0\"\a\DLE\139\141\132j\226\154\ENQ5n\GS\ETB\223%j\141\EM\b\198\211\&4%\211>\145\170\193\217\241x\196\158\r\229\&5[\181\195\168:\175\172\EM\134\SO\\'\141\179$\195\161\222%\254o@\167}\140'\165\\\ESC:\203<\132o\155\167\233\SOH\207\239\208\209\168\186\238\254\SUB\200\234\247\216\166\165\134\198W\SO\211\203\236\186\175%8F\142*\203,\203w\169*\175,|\192\245\CAN\218P\195\181\225\204\147Q\228YC\207\GS\196L\142\194\148\200^\213\131\188\167\205\DC3(\207_\192\204/\SUBV\EM\STX}\134\SYNL\209F\209\161]\136\252NLR\213\v\182\223\148a\173\245\&0\ETXj\173u\216\240B\138xj\185\SOH=Pf\ESC>\201s\132\195\209\ESC\DLE\160\168\145\170z\167\238x\ENQ~\128\221\218\240fo\235s\243\SIW\187\USPK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\"\STX\240\214\207\ENQ\NUL\NUL\138&\NUL\NUL\f\NUL\NUL\NULsettings.xml\181Z]s\218:\DLE}\191\191\"\227\247\148\144\228\&67LB\aHiiI`\128\&6s\251&\236\ENQt#k=\146\FS\224\223\223\149\fi\n8\165\182\245\148\137?v\165\213\238\158s\214\220|X\197\226\228\EM\148\230(o\131\250\187\179\224\EOTd\136\DC1\151\243\219\224\219\164{\250O\240\161\249\215\r\206f<\132F\132a\SUB\131\&4\167\SUB\140\161G\244\t\189.u#\187}\ESC\164J6\144i\174\ESC\146\197\160\ESC&l`\STXr\251Z\227\245\211\r\231,\187\178\DC2\\>\221\ACK\vc\146F\173\182\\.\223-/\222\161\154\215\234\215\215\215\&5ww\251h\136r\198\231\199\186\202\158~\237\n\DC1_\FS\217\ETB\178\197\&8g\231gg\151\181\236\255\224d\179\200W\161\&9\SI\154\219\&8l\183\223\188\217\&8\200\254\156r\ETX\177\141\205\201\230\178]\218m@.\ESC\207\FS\150/Q\v\SO\189\247\235;\223\233\249\150\STX6\193$\216\222\&1\235\132\238pi\130\230\217Mm\223\194\241V\251\&03\RS\204>\242\200,\SO\217=\175_]^\149\179\253\EM\248|qp\209\245\179\DEL\174.\139\EM\US/p9\130\136\242\v:\v&\231\160w\FSL\DC1\ENQ0\EM4\141J\161\152\143\158l+\\j\184\199\b\242\172\207\152\208G\155?\141Yr\202e\EOT+\136\246cu8\185\220;T\SYNj}\\\196{\209\206R\181Q\148\185A\211\230\241y\241\147\204K\188\139\179\203zq\171\&9ER\198\168\230S\SOH\149\151\137\179ZuI;\163\163\188\234\176\165\247w)\211m4\ACK\227\188\202\187(f\251\ab<!K\187i\182@U\174\SI\245\217\SUBS\211A\145\198r\183\154\171\178\222F|\170\172\156\247\227\210e\161Aux\237\245\179\130\171\239\233\&1\b\b\rD]E\ETB\n,\253\192\197\215m%\239\246\166S\GS~\128\DLE\241x\f\205.\164\138\EMB\228?\SOHS\234\237\202\180R\131\223\146\136\153\220\189\151\232\241\186\207\166 \238\&6\228\195C^\220\&3\179h3\r\SYN\170Z\130\207\165'?#\205w[\DELV\234\151W\ETBW\245\235bF\a\169\177\235\238\195\&3\136\DEL9\136H?\164\241\DC4\FS\162T\191\133!\217\&5\182u\SI\153\ETB@\191\195\a4_Rm\248l\221\167m\233Gn\SYN\247L\166L\180\137\168<y\216RG\240$\129h\200C\147\170\252=\149\240\224rj\194\166c\131\201\DLE5\183%V}\232\220\209L`e\134\130\133\176@\DC1\193n\159\171b3\223\&4\fD\228\&3\199:\169RT\128w\204\176)Ue\a\227\152\201\FS\206T;&.h\168\&7wQ\237\226le\ENQ\209\166\136?uQ\SUB\US\217\227<\208&tB\187\CANM\250\RS\\\180i\249s\133\169\140\134L\177\SOH\233\178;\197\150\SO\NUL\170w\214\NAK\200\f\GS\173\128\a\140\153\154\243=*Q\133\151q\204\132\232\176D\SIA\133\148M\212\174\222\191\247u:\GS:z\133\194C?\252He\SYN\141\215\154n\248\202/\v\224D\138@Q\161%\212\NUL\173$\175\156=\186\&0}\230Q\EOT\210\182(?}\201\150\&8(k\255Q\177$\241\211\157z\250+(\217\210\156\201a*\t3\216[\237\188\170\186\247e\255c\156\152\245\155X^\230H\228\212b\182+\245-^x\241\179=\250\193\244?\138\213\SYNb=\161\DC3J\162q?\211l \201+\185\244\224jb#7\194\229W\128]U[Y\STX\140\192N\225`\ETB^+Z\190\RS\129\160\250x&]\222#\169\146\207\170K\210\RS\167\208=Q\210\172\SOY\STX\170\171\&0\RS\131I}\FSF+\202\180\227`6#\241\229\133\133F\SO\221\199\t\v\169\&2&\232\178\171\ETX\194\aleZ\208\198k\STXq\"\188\232B\218\207\199\NAK\193\150d\162\SI,z\163\218K\158\253\152L\v\248\130So\236\SO\148\173\SO;a\167\DC2\201\198 9#\194\ENQ%\250)\129\&4\138\212\182\184\226:t\132xx\224[F\139\146b{\202\142\254\192\EOTg;d)\DC1\167\150\148h\FS\222\230\219/HP\168\SUB,\239\189w\132\212\155l\218\156\246=\208q\134>\210i3p\223h\RS\n\212WX\239\186!M\245\254\178\205%S\235\227\244\147[\243\193\198\247\135\166zs\137\n\186\\ic\197}\ACK\t=\233UL\162\DLE\164\STX\192\DC1\GS\219\237l\SI\244\212(@=\236O\255\142\ETB\170\142\235\251b\249=I\217m\218\168\136\186l \192\ESCg%\FS\254\169(=\205\136H\218\217q\141\213\169\196\191\244@Z\175~H\140\237\v3\129K\SI\DLE\150$bM\157A\217YG\245\230i\237-7\172\203\n\141\&8\178M\254\&9\145\214\133\238\201>\215^t\152\\\145\163\DLE~\128B\194\231\223@s\EM\133\207\158\225{\246\ENQy ;\STX\181\143\227w\t\221e\171R\133=6k\SOH\250\SOH\239`\198R\225#\232\ESCn\231(\221o\170\187d\143\251\221`\168\184\249>\178hD\217\130R\236AVU'\249\201\230\254\ESC\200[|\245];z\247\249\EM\164%\168\ENQ\185M\DLE\DC3\237\&0\EM\130\240\192\219\183J\218\194\179?\152\176\165\251I\224\148\189|\213\177\204\209\203p\235\215Y\178\253;\198T\133\197\139\&9\227\&0V\219\182d\212\SYN\140\214M!\179\241\234\&0\DC1\166\194\215\&8\232\240T\252\192\160\174\204\ao\a\173# \ENQj\219I\203\CANe7G\252\204\210\DC2O\223^Z\250e\STX\217\146!\145x\136\RS\NAK=\170\186b\237$\177\&7\217\229\218\165\135^p\160\ESC\183\204\216\&0U`\252\145\251a\183\182\247s\169Z\222\SI\201\154\255\ETXPK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\250+^\183\175\ETX\NUL\NUL+\SO\NUL\NUL\v\NUL\NUL\NULcontent.xml\165W\223o\219\&6\DLE~\223_\161i@\223\CAN\198\241\ACK4j\236bhQl@2\fM\138\245\149!)\155\ESCE\170$e\217\255\253\142\164EK\142e\v\240\139l\241\190\239\238x\191H=|\220V2\219pc\133V\139|vs\155g\\Q\205\132Z-\242o/_\208\251\252\227\242\167\a]\150\130\242\130i\218T\\9D\181r\240\155\SOH[\217\"J\ETBycT\161\137\NAK\182P\164\226\182p\180\208\&5W\GS\171\232\163\139`+\174X\183\147\147\233\SOH\220g;\190uS\201\RS;\224\146\215\233\150\ETX\184\207f\134\180S\201\RS\vA\237\211K=\149\188\181\DC2\149\SUB\162^\213\196\137#/\182R\168\255\SYN\249\218\185\186\192\184m\219\155v~\163\205\n\207\238\239\239q\144&\135i\194\213\141\145\SOH\197(\230\146{c\SYN\207nf\184\195V\220\145\169\254yl\223%\213T\175\220L\SO\rq\228MV\237f5\185\"6\171\145\208\208\&51\147k#\128\135\233\157\179\233\233\157\179>\183\"n=\146\147\247\248\t\132\225\241\244x\168\ENQSM\181\229\177\131PQ#\234\201\219\140\232>_k\157\\\245\132\216\160\193\221\187\219\219_q|\239\161\219\179\240\214\b\199M\SIN\207\194)\145\&4E\\W\167\130\ACK\184\EM\ACK\EOT\226\ESC_\166\169\240} \236\b\225\SOGq\STX[6\170\250\251\211\227\&3]\243\138\FS\192\226\&2\CAN\te\GSQ\135\200\CAN\159\132\209\157\254\134\r\175\181q)0\229\244\129\t\217\186K\190\173]%\199\219\221K;\232\202\&0v\DC2\n\238\204\&1\180>4\RS\218\b\222\254\146\SI&\249\249\130\184?*\136\&0\SYN/Q\STX\168?7\207\DC2f\183\216cR\ESCC\137\FS\134\188Y\165s\168\212\141\130M\192\217\181\SI \223\214\220\b/\"2\208\138\129\134\193\244\NAK\\v\237\157\236\159R\ETX\158\162\202B\182\161\170u]\244\216\195an\170\237\&4u\190\146\&5+\143\&5\RSu5\181v\238N%\239\229+\246\&2\228\207\&2\152\214{K\189\&3\252._v\avlv\139\211B\t\a7*\t\229\136q*\237\242!\SO\222\180\156\197w\239\247\"\DELv\196<\239\170W\r\NAK\ENQC\182CUB\238\ACKB|^\205\vY\235\138\204N\232\136\146K\252O\186\&1\130\155\236/\222\158\208\241\142\212\218~\232a\226B\158\rTz,Zq\ENQy\128qTi\198\141\SUB@j\225(L\236Rl9\187\184!\200\165\245\166\178\175\224\190\SUBu\234\b7\193\&1\179\215\247\198\175\r1\"\180\208\ENQ\215~\a\216\169lu\235\227\166m+\172\189\198\244cC\ENQ#\217\&3Q6\251\166\EOT\\\"\249hdN`'D\199\238\172\227\213\&5>\238\vn\180\DC2\175\183\142\199\SUBm\191N\SUB\a\134\156\160(\232I\GS\CAN\158\ETX_\255\158%[{'kb\200\202\144z\221\t`\193\223\198\195\v\138\172/Z\251\211\183S\155(\168\134Q\195\141\DC3P\145\165\SO\ETBaD\164X\193\196\160\\\133\ETX;2\254m\172\DC3\229\SOY\184\173\130\214V\ESC\152\146%\145\&6n\175\231\237a\179o7\181\ETB\188j\182K/\222\230\242!\\\193-\255\209\192wF\n\206\219\197,,1akIvH7\SO\238\177\FSI\184\SOH\192\137\ACKC2\136\227\150\255\148\DC2|6\225\FS\240>^\165\236\165K\228uZ\224\239\213J>\199O\134\DLE\246\241\168\213\145\210\175\SOH\CAN\205p,\SUB\150/\255\224R\234\236\USm$\251y\175\164>\164-&\EOT\SIr\133G>\245\150\255\ETXPK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vCq\197\131\202\DC1\ETX\NUL\NUL\DC1\ETX\NUL\NUL\CAN\NUL\NUL\NULThumbnails/thumbnail.png\137PNG\r\n\SUB\n\NUL\NUL\NUL\rIHDR\NUL\NUL\NUL\198\NUL\NUL\SOH\NUL\b\STX\NUL\NUL\NULg?\158\ETB\NUL\NUL\STX\216IDATx\156\237\214A\n\194\&0\DC4\NULQ\ETX\222\255\202_\161 E\DLE\186\CANQ\235{\139\240\179j\SYNC\210\235\204\\\160s\253\244\SOH8\ESCI\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC4\177,\169\181\214\204\220\215m\251\152\183\225i\173>\202\ETB*o\169GO\251y\ESC\246+\231\246\222\135o\DELo\241'\178\164^=g\158\185\DEL\227\247\156\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\138\152\164\136I\234\144\181\214\204|\250\DC4\191AR\135\232\233\&8I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC41I\DC1\147\DC4\177\ESC\b\SUB(\EOTp\211\ESCp\NUL\NUL\NUL\NULIEND\174B`\130PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\180\247h\210\ENQ\SOH\NUL\NUL\131\ETX\NUL\NUL\f\NUL\NUL\NULmanifest.rdf\205\147\205n\131\&0\DLE\132\239<\133e\206\216@/\ENQ\ENQr(\202\185j\159\192\&5\134X\ENQ/\242\154\DC2\222\190\142\147VQ\164\170\234\159\212\227\174F3\223\142\180\155\237a\FS\200\139\178\168\193T4c)%\202Hh\181\233+:\187.\185\165\219:\218\216\182+\US\154\GS\241j\131\165\159*\186wn*9_\150\133-7\fl\207\179\162(x\154\243<O\188\"\193\213\&8qH\f\198\180\142\b\t\RS\141Bi\245\228|\SUB9\206\226\tfWQt\235\160\144y\247 =\139\221:\169\160\178\na\182R\189\135\182 \145\129@\141\tL\202\132t\131\FS\186NK\197\&3\150\243Q9\193\161\237\226\199`\189\211\131\162<`\240+\142\207\216\222\136\f\166\229^\224\189\176\238\\\131\223|\149hz\238czu\211\197\241\223#\148`\156\&2\238O\234\187;y\255\231\254.\207\255\EM\226\175\180vDl@\206\163g\250\144\231\180\242\USUG\175PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\US\NUL\NUL\NULConfigurations2/images/Bitmaps/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/popupmenu/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/toolpanel/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NULConfigurations2/statusbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\FS\NUL\NUL\NULConfigurations2/progressbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/toolbar/PK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/menubar/PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC\NUL\NUL\NUL\NUL\STX\NUL\NUL\NUL\NUL\NUL\NUL\NUL'\NUL\NUL\NULConfigurations2/accelerator/current.xml\ETX\NULPK\ETX\EOT\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NULConfigurations2/floater/PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\205f\"DQ}\226,\EM\DC2\NUL\NUL;\213\NUL\NUL\n\NUL\FS\NULstyles.xmlUT\t\NUL\ETX\STX\210\197R\STX\210\197Rux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237]\205\142\235\182\NAK\222\231)\f_\EOTE\ETB\178%\249\DEL\144i\144\166-R\224\166Mso\214\ENQ-\209\182\SUBY\DC4(j<\147U\SYNE\247E\129\182\139\162@\251h}\128<CI\234\143\250\&5m\209c\206\140\DC3 \185\SYN\SI\201\195\239\FS\RS\158\143\"u?\251\252q\239\SI\RS \142<\DC4\220\SI\173\145\&9\FS\192\192A\174\ETBl\239\135\&1\217\CAN\203\225\231\191\248\228\&3\180\217x\SO\188s\145\DC3\239a@\140\136<\249\&0\SUB\208\202At\151\DC4Rq\FS\220!\DLEy\209]\NUL\246\&0\186#\206\GS\na\144U\186\DC3\165\239XW\159$Oxc\178\213\185\176X\155\192G\"[\153\201\150\234\130\181|\207\\X\172\237bp\144\173\204d)\166b\245\r\146\173\252\CAN\249\198\ACK\EM\SO\218\135\128x\NAK-\RS}/\248\254~\184#$\188\ESC\143\SI\135\195\232\&0\EM!\188\GS[\171\213j\204Ks\133\157\\.\140\177\207\165\\g\f}\200:\139\198\214\200\SUBg\178{H\128\172~LVT)\136\247k\136\165\161\SOH\EOT\212\172\SUB=l\165=\226a\219\STX\141\179\ETXX\218\&7\184p\217\188\DC3W\222\188\DC3W\172\187\ad\215b\147\229\248kZ\200\255\243\245\251\194\ETB\240^\182/&[\130\202\193^(=\204DZ\172\143\DLE\202Ue\NAK\146\t\202\213\181Ms:N~\v\210\135N\241\ETX\246\b\196\130\184\211)\238\NUL\223\201\DC1G\251&\208\168\156\&5\166\DC2\ACK|`n\154Ic6\232\214\150gc\fC\132I\174\200F>@Qt\236|z\237\200\222o\159^\172\&4\DC3\221b\215m\DC4\165\234L\198t\170QG7\RS<xxW(\197T\238\&6\192\170b\NUL\RS\134\142U\225Bb\156\234\172`\153c&\147O\ESCj\146\"\168\226m\RS\246\&7(\SO\232 \232R\145\STX\b\USC\136=V\EOT|^\237\174\212Bi.F\209\132\&4\129\243\241\219\&1+3Xl\RS\SI\a\233\242 ,I\246\240\ETB\159\f\ACK\217\DC2\180At\249\217\NUL\a\SUB.t\252\136\NAK\209\194$~\228e\131\228\&7S\242~\248\129\NUL\252\225i\191F\212PL\152\198\139Lr\239\249O%\129\193X\162\193\143`\135\246\192ji-)\149k\233K\DC4c\SI\226\193\239\224\161\165\181\159\t\"?Ke\196\ACK\153\148\177\133\SOH5\ETX\157g{\228B\FS\fE\145\208#\SO\rE\ESC\239\DC1\186\146\195\163\ACK\141X\DEL\131o\233@\130\&6\197*b\199\149\195Bk5\253\RS\NUL\246\184\207J\169\248\ENQ\NAK\166\198\170)\149<?\166Ht\240\162H\141\"\239c\199s\193\224\ETX\b\162\193w\129G\DC3'\216\134W\131\232q\204\162\167\136\192\189\SUB]3\199l\243X\165\186|6n\159\175\217TN\146\200\146\230.\220\128\216O\243\203\172\151T\205-\ACK\225\206s\134I\133\188J\250\216\b1\141k\152x\212)7\232\238@\159\SUB($<\134\176\US\195\180\SYN\vtw\209\SO\184\232`P=\"H\140\199\251\161\&9\178\172\165\229\ENQ\GSROmR4z\DLE\131\166Y\208\136B\224\208$\207\216!\236\253\128XPL\234X\211\227u\RS\152\238Nk\r\186J\157\216G\173F{\SI)\206>\GS\236\193#;#I\169\&7\192\143\n\215\202\241\SO\SOH\ACK\FSs\DC1\241\164\136\213\&3@L\DLE\235\146z\156\231B\148\136\STX?\220\129rw\\\183\&5\134\128&\175\DC1\161\RSF\178\184\197\&2\b\166\&0\139f\247C\US\ESCd]\209\148\249\148\ETB\184\144-\222\140\142\136\227\204\DC4\207\212\206\NAK\167k\"\245+\DC4F\194\144\198\237c\170\f\155\143\173\&6\226\&8\130\DC4\178\128\185\tW\202A>\162\137/\193\&1\204T\166\206\200\139\"\239\a:\SUB\203\SO\233\&8\233\&3\US\EOT\219\CANl\233#\CAN\240\a\SO]\\\t\166^\246\221\135\nP\144\208\132\202\248\158Fv><\222\184\136\EOTk\217\160i\r\b\210\246\203\213\211\142\&2\137\US\RS\US\179\218i\151YI\128\STX\216\NUL4o\158%\216>|\204\ACKPi:/e\141\151Z\200\186\200%x'y\188\SUB7L{\233\128\144[\173\SUB\DC2\SUB]\148B\188{\nw0\224\t\140\225\ETX\151\174\149\ACK\215\143iE}h\239U\160;\201\159\195\&8pH\156\&4\206\STX\SO\205u(<\212b\195v\135/\247\150\250\167\225z4>\EOT\172Cs4]\217\179\234D-\207\143\144\SUB\160>K\207vW\193\240\205\233@\147C\ETB\174\222\233\214]\SO\221\220}\230\154\173\235l\221S\197\137\208\&1\ENQ\SUB\189T\156\b5Ur\ETB\SYN\215\203\139\207\DC4\193ma\SYN\218\n\184E\143\198p\SI\188\192`<6sk\187E4\140\163]EP\205\148LxG\213\ETB\217C\209\EM\147\157\148\&5\194l\ACK2/\166k\DC2uE\US\132\DC1\159/\234T10:4\171C\v*\209\225{\bC\131\160-$;\182y\193\230\253\t\170\136*\228\188\131\178%\236\SO[\195\150\144J9>\136\"\170\&4\157\182\213l\174\222\242W\DLE\184B`\233l\152>\204\&7\236\140\138b\130X\192\226\133(\244\145>\248\163m\254q\141\220\167a\131\146\146!w\SI0\141\129\DC4\214\144\167\GS\243\185\DLE\205\138\226\&5\"\132q\DELsd.'L\"\159\DC3\SOH\235,\ACK~uu/\154\224f\227iK\192\211\SYN\224\US\192S$\ESC\DC1\133@'\144\135\218\170=\173\174\170*\"\212\180\136\SI=\162\fo\165\226\166\&2\238Y2\176\224\tt\245\t}\240$\184\193@\244\129\179\157M\149\SI\153\179\213\242\136\SI\149$\142y\210\&9\216\189\167+\244\185\128tL,\159\&5{\154\219V\253\197:k<_\STX\206\148\DC4\219\152j\142\193\153FN\194\128\186@\193w\254\147}i\206\SYN\162\220\252\188\132\231f\217\182\181y<xt\230@I\t\171GSFJ\208(g\149O\215\139\202\153L\218DK\248\169\217_*-i\235\&2\151\202\244>\195\153~K9\217\163bW\242x\155\&2\174\212jh\209\DC1N5\247E&]\186\138\179X`\181\a\224Tj`\157\139h\150,H/\246\162*i\186\131b\194!\243\225\ETX\203\213,\137`~d\198X\179O\171\&3\230\NUL\189\237\142.\224k\228\187\237\DC3F\168(\136$u3\161\230\SYN\138\EM\208\217F.\150\180\210\207\176\246q\195\218\SUB\EM\214\238o\216\233\209P\216h\239\DC3S%\185\NULy\154W4\231x\205q\241y\188gr\220{&\SUBy\207\228\"\222#\ETB\SYN\154\141\167\194\SOH.a\216\233q\195N52\236\180\183a\151\245p\223?*\176F/\FS\DC4\150\141+\197\&5c\194\236\184\235\204\&4r\157\217%\\G*$4\155N\129\245/a\213\249q\171\206\&5\178\234\188\183U\ETBgZu\209\223\170\157M\244\183\234\USbD\248.k\164\152\ETX\241\163&\167\177i\USn\b#\203\147\213d\209D\167q\130x.\208\176c\215\205\194\173\211\246\234\184Ox\252\157\GS\173]\212e{\173F\169\240\252\189\153o0d'\164\NUL!\208e.\205\\\187}v\137\210\ETX.zu\163%\200w\226.\131\250\233\ESC\160\181\211(\181mP\179i\199\&2\157u\r\181\219\146\&5\179}75\159\DEL\DC2\205\NAK\153\155y\230\RS\232\175\224\198\v<6Y\DC3O\193\251vO)d\a\\\176\175\159t\133\227\178^\197\175\151\187c\218:\"\EM\188\155\197\235\200\247D\189\180\b\158\ETBh\ESC7-\179(\155\ACK\216Z\DLE,\193\174\&2\DC4~do\186\216\136\190d\182\228G'\219\208\230\162\131\\\238\250\ESC\193\EM\162\166\189Zu.]\169@\SId\251l\EM\158e\142\134\140\172\201\SUB=_\243uZ\255\SUB\150\161,i\ESC\176\179\SI\NULW\226\255\159\226\136x\155'\131\189\254\165\250\US\DLEvs\235\156o\215\212\SO\252\DC4W\249t\203\133\222\ACK\FS\225\174\rY\234\ENQ\243\208\223 D\STXD\160Fs\217Z5\191\254\237\n\144F\181\218\ENQ'\179\236.Us\254\"\145\226(J[\152i!\190\154a\207\129\184\253\&4^QR+\203\198\128\"/9\200\&9\EM\137\167\161\138Q\146\167\144\SO\204\161#e\176\140Oir>\234h\145;f\169\193\204L5\245\143\US%\236\151\152\242\255sud3\212AM\\y\198\212\150\213\NAK\202\158\151\176.\154W\SYN!a-I<g\194z\154\GSD\147(\177\198\229\210R\181\236\243y9\255\175\128\130u\238\\j\208\186X\176\210^o\210\191\136\201\SO)\139\243\245\217\203P\DC3\218\216\131\136\157\203d\aJS\t)w\203\138\182E\188/\157\157{\ACK\160\190\202\SI\195\&3#\189\247\STX\216>;\v\217\SOH\ETB|6\183y\142\141\161,W\146\157\159\137Xz\DC2\147/\217\a\207%;1\210\154\230\210\v\ACK\244\SI\214$\253\ETX\DEL\"(\DC1\STX7\185/\156\133\146\172=\RS}\242c\172\233\211\&4\236\136\233xQ\200\135X\173\145)c\141,+$\ETX\ETB\197\140\GS\189[\154\236\223\243R\250\&2\251@\FSB\214\151\244\230Y9#\156\USM\b\231\213\ETB\216\165Lp~n\"\232\225\136;X\163\215\150\253\158\203\SOj\139\205U\SO\143\RS=\225\250;n\169\244\229Hr7\175c\243\"\151\RSd\162\149\193\201u\250\203\216\247!\145\234\&1\DC1\237\236\238\212\221\215\234\&5\197\234\230\235\170c\239\181^\183\197\rW\DC2;\175\199\ESC\203EWg\250\237\175\247\225\142\221\195=\a\184\230U\163AS\238\143\199\222\ACK'R*\142\189} \CAN%\254\154\143\174\213}\DC2\217\129\n\CAN\180\218s\160\227\242\190\135(\174\189E\145\159\DC1\252)\143\214d\135Q\188\221e\134\142\144\239\157\169UL\187H\238\189\247\212\171\160\141\DC1ks0[~z\166Fk\229\250\172\207\214\230K/ya\249\154f\227GH\227\&3\229\240JBs\247\187(\249\151`\237o\184\206;gK\179\245 Y\176\146\175|\180\133\155Lr\192\197\206\179rzU\236\157\201\210\191J\STX\197\197c\202\226pr\DC1S\156\176]\130<\215L\217B\151\\\218wqe\173\215\134h\177\192w$K\169\236 \251.\192\&9\249\132\216!\b\FSF\229\142w\152\n\234\DC1\167\132\ETBo\157\b\240\DC4;;#Ro\230\247II1\128\146<?S\146\214Jr\245\202)c\154\182\ESC\201Kz\129\145\230Z\179K\DC3i\ESC\213=\202=\219\STX\SOHkZ\"^\169\180\&8A\DC2\238\NUL\183is\154\186\246\203Rw\242\178\212\157\190,ug/K\221\249\203Rw\241\178\212]\190,uW/K]\171\146\140\\W\235J\185X\146\238CE\164a\133,\237wt\220\ACK*v:\172\202j*\f,\201\162\147\205\174\202\138*n\150\165b\237\251-\STX\160Q\188\217x4g\GS\181cm\157\tv\154\EOT\SYN[\151U\172[Fv\250\240m}\134\207?(a\172\217\217\195\196\203V\v[|\ry5\140&\250bT>\196zE\140\166\250b4[\153+-0\154\233\139\209b\185\152j\129\209\\_\140V\203\233\\\v\140\SYN\186bd\141\172\165\&5\211\STX\163\165\190\CANM\232d\211\STX\163\149\190\CAN\205\SYN3=\214~\203\212\ETB\164\197\194\190\\\208\SYNe\206\202\216;\174y\ETB\EM\187\253\172\EM\251[H\203\139\&1\150[`\USW|\NUL~\fY\227\253\210\242\185\RS!\254\252\180\\\STX\163I\207\180\220\150J9\179+f\SUB\166\229\DC2\CANM{\166\156s\169t*\253\218\159\142i\185\EOTF\179^\DC1\222^\172,\EM\140(\197\177\&5M\203%0\154\247\194h9_Md0Z\152\FSK\GS\211r\t\140\SYN=0\178i:\181\148\194he\206tM\203%0Z\246\192h2\154.'\DC21\219\SUB\153\246d\174iZ.\129\209\170\aF\211\209\204\\H\172\253\148\ACK\154\246R\215\180\\\STX$\171\225n\134\&4J\179\209\220\&2%\200\v\141\238\&6\223\152z\230\188\188\227\ETX:E^>y\137y9\223~\184l\140\215\&6/\151\221zy\ACK\140\180\205\203\237\209dnK\228\156\207\128\145\182y\249d4\155N%r\206g\192H\219\188|:Z\216\&2\219S\207\128\145\182y\249\140\230\146s\137\156\243\EM0\210\&6/_\140\204\229b\169\ENQF\218\230\229\203\145=_J\229\229\ETB\199H\219\188|5\154\234\177\242k\156\149[\230h>\185`\130\212;-\239\248\252a\145\150O\159\&5-\151x\129\241\219W\188\147.5\252\vl\175\191\133S/\141\192\245\221s\DEL\vGa\SUB\129\235\183\DC1\255\&6\206\199\&4\STX\215\135\ENQ\188\149C3\141\192\245\161\ACKo\229$M#p}\248\194[9^\211\b\\\US\DC2\241V\206\220\&4\STX\215\135Y\188\153\131\&8\141\200\245#\FS\154\US\207\233\248fv\193\&7f\186\241\141\254'wf\139\ETB\204\&7\172f\190!\246\152\153\146\171\DC3\245f#\v96b\207\248f\159\206l\228\231\237\176\STX\245ld:\153H\157\220H\SOHV\EOT\220:\249\EOTG\US6\194\197\146v\248\223\134x?\252\223\143\255\237\ENQ\197|b\201\241\139Y\229\240A\222\EM\171!\251\157\144\227H&\131;\GS\201S\233\137z$\165\t\135\230H\158\202W\212#\185\154\202\GS\208\211\GS\201S\t\140j$\173\145\185ZJ\188\194\208\US\201S\EM\141z$\237\217T\234\144\150\238H\158Jq\212#95W\175\194'O\230<\234\161\156\205g\218.9\231p\160\247^\242q\184\142\251\196L\228\248U\226&s=\187\181d\b\142f>}*?R\191\246S\132$\215~\189\145<\149\DC2\169GrbI\238\227j\142\228\245\&9\210Tv\175Hs$\175\207\145\230\165\191\129\225\229\"y}\142\180\144:\156\164?\146\215\230H\140m\202\FS\208\209\US\201\235s$\203|\GSq\242\250\FS\201\158\201r$\189\145\212\128#M\173\133\220\203\197+@\217\135#u\220\224\230\FS\233\232\229\237\vq\164\191\245\230H\214\210\210\217\167Up\164\211@\170q\164\EOT\161\227.\173\&9\146*8R?$\237\201\\\238\ENQ\186\230H\170\224H\253\144\156\204d.h\234\143\164\n\142\212\SI\201\169\228\DC1S\205\129TA\145\250\SOH\153\222\187\DEL\241H\170\160H\253\144Lo\231\191x$UP\164~H.\237\215\&1\187UP\164~H\174\166\&3\185\ETBr\154#\169\132\"\245\129\210\SUBI\221\ENQ\188\SO\146}\CANR\199]z\206\144\142^\163\191\fC\250\231_\251\191E\210\251\205\168\STX\134\244\247\255\244|\139\&4\147\220\211\211\ESCI\ENQ\f\233\245\187\155\STX\242ss7U\228\231\245\187\155\STXbss7U\196\230\245\187\155\STX\206rs7U\156\229\245\187\155\n:\242\138\253\173\SI\US\233\248\136\NUL\231#G\191\USp\EM>\242\239\219\169\182\163 \253\244\227_n\167\218\148\240\145\159~\252\243\237T\155\DC2\210\210\ETB\201\219\169\&6UH\222N\181\169B\242v\170M\NAK\146\183Smj\144\188\157jS\135\228\237T\155\&2(_\235\169\182\142\SI\USp\142t\244\155\a\151\225H\255\250\199\141#\169\ACK\233\198\145.\133\228\141#\169B\242\198\145T!y\227H\170\144\188q$UH\222\&8\146\SUB$o\FSI\GS\146\&7\142\164\f\202\ETB\203\145\STXD`d8(\216x\219\CAN\ETX\226\161`\144\ETB\CAN\142\SI\162\232~\184A\136\176\223\201\248x\177\227\DC1.l\136h\255&\149+\192n\170\177F\238Sk5\DLE8;\132Efv\244\179g\166\208I\166id\132(\242Xw\247\195\DLElE\205\147\186A\230\CAN\ACKk\215EN\188\135\SOH\201\145=\SOH\FS\CAN\184\ENQ6u\149\189f\149\203\GS\249^\NUL\v\141\154:\228\133\ACK\147c\246\NUL~$\SO\tm6\DC1$\226'\EOT\155\160+\228\211\214\n\136|\184!\169\158^\224`\200\176`\153\\\162\229gc\218\129\231\192dfE\252Q\250\EOT\196\EOT\209\230=\199(\202r\151\174S\239\175\191\177\&2\221\&6`\239\249O\204:\CANl1\bw\"\128\244!\213\160\230$\DLE\ETB\148<\ETBLj\139Sg\131\146\217\EOT|oK\a\231\208\166 .\DEL\244\237OqD\188\ruC\138\&7\237\226\128\176\155\193\154[f,\140\162\&4.\230Ptb?\161\152\148G\ETB\238\173\186\130\185lEE^\146\ACK\134\229HH\SO\178\178\GS\244\182;f9\171\211\162\&9f\212w\136\129\176G\135\vR\207G\152`\224Q\211\210\&6\247\NULoi@\"(\164UK\189\165%kD\168\&1\147B\225\&1\243\141\150\SUB8U\176\208\239\128\169GQ\ETB\222#\151\STX\226c\131\172\203Zf\DC3\212\216\131\199|\132&m\160\SYN\DLEs\201\b\134Y\235Y\CAN5\205E\233\146@\190\135Ch\252\200\226\&2\171\200\133'\229e\174\"\f6\212;*\178\131l\SOH\b`\226\132\247\195\NUL\ENQ\176\218\ACKp\153\US%\147%\153B\201s\\\132|{\246i\181\150\131|D\151\156w&\255\167\DC4\204\187|\166\226X;\b\\\166\&7\159c\227J\225\134O\SYN1\218\215k\166\&2e\167dKVn\149Q)\207\170z\132Yv\DC3\\\152\178\161\n\247:sd\ETB\216\186Ot\210\176\184AWR\234\&1\213\217W\160Q\USK\ETXN\165\&0\213\DC4\148\178\128\181\aQ\222Z9Z\165%\172\209\210\172\166\235n\224\STX\236\150\227Sa\161\246\185\159h.\224\207\ETXlX\207RXX,\196rA\214\137\248\ENQ\204\b\250\208!\\C\SUB\213b\204bd\169\158\149.\245BM\161\247\180\172\EM\223\&2\178\STX\SYN%d+\232\229\207\179\245\&3/\249?PK\ETX\EOT\DC4\NUL\NUL\b\b\NUL\186\186\vC_\197\128\&2\FS\SOH\NUL\NUL>\EOT\NUL\NUL\NAK\NUL\NUL\NULMETA-INF/manifest.xml\173TKn\195 \DLE\221\231\DC4\SYN\219\202\208fU\161\&8YT\234\t\210\ETXP<v\144`\176`\136\226\219\ETB[M\236\170Je\171\217\&1\191\247\222|\196\238pq\182\&8C\136\198c\197^\248\&3+\NUL\181\175\r\182\NAK\251\&8\190\151\175\236\176\223\236\156B\211@$y}\DC4\185\SO\227\205\172X\n(\189\138&JT\SO\162$-}\aX{\157\FS \201\159\249rd\186Y3\SOH[\182\223\DC4\DC3_c,\148\185>\244Sv\147\172-;E\167\138\137{ \147\219AmTI}\a\NAKS]g\141V\148\211\196\EMk>\n\230s\157\156\224BL\172\209\224\128\DC4\207\237\221\225\FS\NUL\197\DLE^\ENQ\SUB\129(\239 >\FSX{\164\161\207G\227\RSO\201}\162\&26\n\186>y\135\237\GS\DC2\227T\vb\136\175\155\245\183\143\135\186Y\176\227\156\245\180\186\147\&7\143\141iS\CAN!\226V(\173\193B6}\DLE:\133\240\247\244\254\199\181\240nc\194A\STXO\134\235\&9\194\202\ESC\163\222\194\210\v\219\137_\DEL\192\254\vPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC^\198\&2\f'\NUL\NUL\NUL'\NUL\NUL\NUL\b\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULmimetypePK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL;\138\vC\163\159\SOHAJ\SOH\NUL\NUL\STX\ETX\NUL\NUL\b\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\182\129M\NUL\NUL\NULmeta.xmlUT\ENQ\NUL\ETX\177)\bRux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\"\STX\240\214\207\ENQ\NUL\NUL\138&\NUL\NUL\f\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\217\SOH\NUL\NULsettings.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\250+^\183\175\ETX\NUL\NUL+\SO\NUL\NUL\v\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\210\a\NUL\NULcontent.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vCq\197\131\202\DC1\ETX\NUL\NUL\DC1\ETX\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\170\v\NUL\NULThumbnails/thumbnail.pngPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\180\247h\210\ENQ\SOH\NUL\NUL\131\ETX\NUL\NUL\f\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\241\SO\NUL\NULmanifest.rdfPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\US\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL \DLE\NUL\NULConfigurations2/images/Bitmaps/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL]\DLE\NUL\NULConfigurations2/popupmenu/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\149\DLE\NUL\NULConfigurations2/toolpanel/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SUB\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\205\DLE\NUL\NULConfigurations2/statusbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\FS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\ENQ\DC1\NUL\NULConfigurations2/progressbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL?\DC1\NUL\NULConfigurations2/toolbar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULu\DC1\NUL\NULConfigurations2/menubar/PK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC\NUL\NUL\NUL\NUL\STX\NUL\NUL\NUL\NUL\NUL\NUL\NUL'\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\171\DC1\NUL\NULConfigurations2/accelerator/current.xmlPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\NUL\NUL\186\186\vC\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\242\DC1\NUL\NULConfigurations2/floater/PK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\205f\"DQ}\226,\EM\DC2\NUL\NUL;\213\NUL\NUL\n\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\182\129(\DC2\NUL\NULstyles.xmlUT\ENQ\NUL\ETX\STX\210\197Rux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\DC4\NUL\DC4\NUL\NUL\b\b\NUL\186\186\vC_\197\128\&2\FS\SOH\NUL\NUL>\EOT\NUL\NUL\NAK\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\133$\NUL\NULMETA-INF/manifest.xmlPK\ENQ\ACK\NUL\NUL\NUL\NUL\DC1\NUL\DC1\NUL\160\EOT\NUL\NUL\212%\NUL\NUL\NUL\NUL"),("MathMLinHTML.js","/*\nMarch 19, 2004 MathHTML (c) Peter Jipsen http://www.chapman.edu/~jipsen\nReleased under the GNU General Public License version 2 or later.\nSee the GNU General Public License (at http://www.gnu.org/copyleft/gpl.html)\nfor more details.\n*/\n\nfunction convertMath(node) {// for Gecko\n  if (node.nodeType==1) {\n    var newnode =\n      document.createElementNS(\"http://www.w3.org/1998/Math/MathML\",\n        node.nodeName.toLowerCase());\n    for(var i=0; i < node.attributes.length; i++)\n      newnode.setAttribute(node.attributes[i].nodeName,\n        node.attributes[i].value);\n    for (var i=0; i<node.childNodes.length; i++) {\n      var st = node.childNodes[i].nodeValue;\n      if (st==null || st.slice(0,1)!=\" \" && st.slice(0,1)!=\"\\n\")\n        newnode.appendChild(convertMath(node.childNodes[i]));\n    }\n    return newnode;\n  }\n  else return node;\n}\n\nfunction convert() {\n  var mmlnode = document.getElementsByTagName(\"math\");\n  var st,str,node,newnode;\n  for (var i=0; i<mmlnode.length; i++)\n    if (document.createElementNS!=null)\n      mmlnode[i].parentNode.replaceChild(convertMath(mmlnode[i]),mmlnode[i]);\n    else { // convert for IE\n      str = \"\";\n      node = mmlnode[i];\n      while (node.nodeName!=\"/MATH\") {\n        st = node.nodeName.toLowerCase();\n        if (st==\"#text\") str += node.nodeValue;\n        else {\n          str += (st.slice(0,1)==\"/\" ? \"</m:\"+st.slice(1) : \"<m:\"+st);\n          if (st.slice(0,1)!=\"/\")\n             for(var j=0; j < node.attributes.length; j++)\n               if (node.attributes[j].value!=\"italic\" &&\n                 node.attributes[j].value!=\"\" &&\n                 node.attributes[j].value!=\"inherit\" &&\n                 node.attributes[j].value!=undefined)\n                 str += \" \"+node.attributes[j].nodeName+\"=\"+\n                     \"\\\"\"+node.attributes[j].value+\"\\\"\";\n          str += \">\";\n        }\n        node = node.nextSibling;\n        node.parentNode.removeChild(node.previousSibling);\n      }\n      str += \"</m:math>\";\n      newnode = document.createElement(\"span\");\n      node.parentNode.replaceChild(newnode,node);\n      newnode.innerHTML = str;\n    }\n}\n\nif (document.createElementNS==null) {\n  document.write(\"<object id=\\\"mathplayer\\\"\\\n  classid=\\\"clsid:32F66A20-7614-11D4-BD11-00104BD3F987\\\"></object>\");\n  document.write(\"<?import namespace=\\\"m\\\" implementation=\\\"#mathplayer\\\"?>\");\n}\nif(typeof window.addEventListener != 'undefined'){\n  window.addEventListener('load', convert, false);\n}\nif(typeof window.attachEvent != 'undefined') {\n  window.attachEvent('onload', convert);\n}\n"),("reference.docx","PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\224\171\193D\185\190\SI8^\SOH\NUL\NUL%\ACK\NUL\NUL\DC3\NUL\FS\NUL[Content_Types].xmlUT\t\NUL\ETX\ETX\254\139S\ACK\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\181\148\203j\195\&0\DLEE\247\249\n\163m\177\149tQJ\137\147E\US\203\&6\208\244\ETX\DC4y\156\136\234\133\&4y\253}\199vcJ\tv\200cc\176g\230\222\163\203\200\227\233\206\232d\ETX!*gs6\202\134,\SOH+]\161\236\&2g_\243\183\244\145M'\131\241|\239!&\212kc\206V\136\254\137\243(W`D\204\156\aK\149\210\ENQ#\144^\195\146{!\191\197\DC2\248\253p\248\192\165\179\b\SYNS\172\&4\216d\252\STX\165XkL^w\244\185\241\165q\150<7}\149U\206\132\247ZI\129T\230u\149\US\GS\f\160c\199\228\198\SYN\255\240\210_\180\140&\235\158\184R>\222\GS,>(\138\160\nHf\"\224\187\&0\164\199\183.\DC4|\v\139O@\164Xb\214M{\196\211\149\165\146P8\185\&64\146U\130>8\t1\146\158\209\217\US\241~\DC2\187\&6\v\b\212{}\142V\186\159\"\222,\140xr\DC2H\251\a\205st1G-\211\239Y\146\195\\,4\\\255\224\173t'\ENQ\205\207\130\243\145\147\219\197\fP\221\164\STX\138\148@<\EOTT\208\GS{k.]8#\129\195\221\171\166O\181l\182\r\247\SUBn\177k\181n\191\DEL\171pu\130\182b\132\178\167\172\159C\235\240\SYNY\180\210-\ENQ\175\255\250\147\193\SIPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\142\236\DC2\EM\220\NUL\NUL\NUL?\STX\NUL\NUL\v\NUL\NUL\NUL_rels/.rels\173\146\207J\ETXA\f\135\239>\197\144{7\219*\"\210\221^\164\208\155H}\128\&0\147\221\GS\236\252!\DC3\181\190\189#\136Z\169\165\a\143\147\249\229\203G\200r\181\SI;\243\194R|\138\GS\204\155\SYN\fG\155\156\143c\a\143\219\245\236\ACKV\253\197\242\129w\164\&5R&\159\139\169=\177t0\169\230[\196b'\SOT\154\148\&9\214\159!I \173O\EM1\147}\162\145q\209\182\215(?\EM\208\US0\205\198u \ESC7\a\179}\203|\SO;\r\131\183|\151\236s\224\168GF\252JT2\201\200\218\193k\DC2\135\238\179\220T,\CAN<\174s\245\159:\188W\142\142\221,K\237\ETB\245\\\190\157\170\206}-\ETB\164\156O*]\158\175\244\247\246\&1\176\146#%\180I\248\180\208G\226\203\b\SI\SO\161\DEL\aPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\247\171\193D\232\150\&1\DC2\v\SOH\NUL\NUL\209\STX\NUL\NUL\DC1\NUL\FS\NULword/document.xmlUT\t\NUL\ETX2\254\139S2\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\157\146MN\196\&0\f\133\247s\138*\251\&6\GS\SYN\bUmg3B\FS\NUL\SO\DLERw\SUB)\137#'m\225\246\164?\SOH\177\NULU\179yVd\191O\182\227\250\242at6\SOHy\133\182a\231\162d\EMX\137\157\178\183\134\189\189>\231O\236\210\158\234\185\234P\142\ACKl\200\162\193\250jn\216\DLE\130\171\&8\247r\NUL#|\129\SOl\204\245HF\132\248\164\ESC\159\145:G(\193\251\200\&3\154?\148\229#7BY\182c\204\DC1\f\246\189\146p\221\ESCH\144\&0$\b\221\v!\208\"\196\193\253\160\156O4l\216H\182\218Q\185Q\146\208c\USr\137\166\218({H\142\233?\199dt\170\155\207\229\SOH\246\178\180\228\DLEG&\235H\204\DEL\172\215)y\a!\186\194H\223\227\205\238\SO\198\239\175\191nI\214\198Cz\199\238s\137n\DC1Zd\189\169\202;!\161a\142\192\ETXM\192\218\ETB\208\SUB\179\b\210]Q\243X\214.J\171\186U7\DC4\255\&9\206\246\244\ENQPK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\232\171\193D\208\179\r$\252\NUL\NUL\NUL1\EOT\NUL\NUL\FS\NUL\FS\NULword/_rels/document.xml.relsUT\t\NUL\ETX\DC3\254\139S\DC3\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\181\211OO\195 \CAN\ACK\240\251>\ENQy\239\150v\234\&4\203\218]\140\201\174Z?\NULm\223\254\137\ENQ\SUBx\167\238\219K\220\STX\204x\240\194\145<\240\240\131\192n\255%g\246\129\198NZ\149Pd90T\173\238&5\148\240V?\223<\194\190Z\237^p\SYN\228\166\216qZ,sk\148-a$Z\182\156\219vD)l\166\ETBT.\233\181\145\130\220\208\f|\DC1\237\187\CAN\144\175\243|\195M\220\SOH\213U'\171O\v\254\167Q\247\253\212\226\147n\143\DC2\NAK\253Q\204\213Q6h\156\US\216\161+\193\FS\186\STXX-\204\128T\130\SI3\215\v\140'SX:\205h=a\GS\b\231$\249\254H\228\142\EM\EOT\183\145\224\146\165\&6|b\243\250\155q\ETB\CANQ\156Z\210kE\181hf\244\142\251\224\240aj\ENQ\185\181A\176\t\130\159\224\FS\ETB\233\175B\147\210\DC4\189\205\135\248*.\161W\240\171\159_\173\190\SOHPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\141\231\194\&4o\NUL\NUL\NUL}\NUL\NUL\NUL\GS\NUL\NUL\NULword/_rels/footnotes.xml.relsM\140A\SO\STX!\fE\247\158\130t\239\DC4]\CANc\134\153\157\a0z\128\ACK+\DLE\135B(1\RS_\150.\DEL\222{\DEL^\191y3\USn\154\138\&88L\SYN\f\139/\207$\193\193\227~\221\159a]v\243\141\&7\234C\209\152\170\154\209\136:\136\189\215\v\162\250\200\153t*\149e\144Wi\153\250\152-`%\255\166\192x\180\246\132\237\255\ETX\f.?PK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194DO\174i\165h\SOH\NUL\NUL\204\ACK\NUL\NUL\DC2\NUL\NUL\NULword/numbering.xml\197\149\205n\131\&0\f\199\239{\n\148\251\SUB\190FiU\218[\165N\211\180C\247\NUL\SOH\210\&6R\DC2P\DC2h\247\246s\178B\215\RSP\197\133\v&\246\223\142\DEL\160\196\171\205Ep\175\165J\179Jf(\152\249\200\163\178\168J&\143\EM\250\222o_S\180Y\191\172\206K\217\136\156*p{\144!\245\242\156\161\147\&1\245\DC2c]\156\168 zV\213TB\236P)A\f,\213\DC1\159+U\214\170*\168\214\144)8\SO}?\193\130\&0\137\214P\147\228\218(R\152\207Fxw\171]\153!\223I\164f%\196Z\194\&3D\131\249!Y\228\EOTy\216\134D\195\r\251\160-\229\251\159\154v\"\231\229\214{\149\241\150C\140\129\233k6b+L\151\144\&7\156Ss\DC3\239\233\165\143y7\247{\209\&99=t\242\250KYc\160\245\171\237D\176\a\130\247\186\210vW\171\198\&7\GS\147\150\201\214\201P\156\250Vx\"\242\232\190\185[\255\201]u\236v\DEL\EOT\t&\SOH\153\135\131(\SOH\252\221\DC1,\225$,A\FS\SI\195,\194\&10\209$0a\144\f\194\132I<\ACK&\158\ACK&M\aa\162(\EM\ETX\243\&6\t\f\244:|\252\253Q\231?\153\EOT&\142\134/\NUL\232\253\&9\CAN|w\219_Q<\247\180W\DEL\240\&8\GSv\253\f\232\235I\155\135\255\205\165\245/PK\ETX\EOT\DC4\NUL\NUL\NUL\b\NUL\b\157\ETBE\FS\165\153\197!\ACK\NUL\NUL\222\&2\NUL\NUL\SI\NUL\FS\NULword/styles.xmlUT\t\NUL\ETX\144P\249S\144P\249Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NUL\237Z]w\155\&8\DLE}\239\175\224\240\222\SUBc'qs\226\246\&8N}\154\179\253Hk\167}\150A\182U\ETXb%\145\143\253\245;\STX\132\SOH\v\236`6I\187\233K\163\185\131tgt5\DC2\194g\239\239|\207\184\193\140\DC3\SUB\f\205\238\ESC\203\&4p\224P\151\EOT\203\161y=\155\188\RS\152\239\223\189:\187=\229\226\222\195\220\NUL\247\128\159\178\161\185\DC2\"<\237t\184\179\194>\226oh\136\ETX\192\SYN\148\249H@\147-;t\177 \SO\190\160N\228\227@tl\203:\238\&0\236!\SOHC\241\NAK\t\185\153\246v\187Oo\183\148\185!\163\SO\230\FS\184\249^\210\159\143H`\190{e\CAN\192\208\165\206\ENQ^\160\200\DC3\\Zb\ESC\187b\169-1)\163j%\237\t\r\EOT7nO\DC1w\b\153\SOH\ENQ<4}\DC2P\246q\DC4pb\STX\130\DC1\ETB#N\144\SYN\\\201?\180\136\195E\206|N\\\176v\nc\243\DEL\192\237\ACKyC\211\238occ^\141z(X*\DC4\a\175\175\167y\158\&9\211\FSF\GS\154\136\189\158\142r]\156uryH\ESC\133L\193\b\161.ya)y<D\SO\137\153\160\133\192 \f\152\151\210\&8a~\156b\167\210R\154\183\&84\SOH\138\153&\138\ETX\a\188\248D\157\&5v\167\STX\128\161i\153\137\241\250\242\138\DC1\202\136\184\223\216\166\216'\US\137\235\226 \231\ETB\172\136\139\DEL\174pp\205\177\187\177\DEL\155\196\250J\r\SO\141\STX\248\219>9N\233+\209\ETX&\238C\CAN7D\f-\EM\nW\233\243\146\&2\172\EM\217\138\GS/\161\239/\178K\207\204r\CAN \US\171YJ1\149\FS@\255N\CAN\228,\185\244\SYN\146;\199\176\CAN\128Cw\DLE\147Ms\GS\183:\133\228\170\172\198\140v\135\145\DC1\USS\US\ACK\DC3z\230\n\204\DC1\157#\200\229\215\160\205\216z\199\185\208z\199mE6#\194\195\250\184\DC2\232!Q\ENQ\248N4\143y\141q\248E\246\208)\EM?\145\NUL\164\222\169MO\191\&0\245v\191\176\204nO\DEL9\138\151\ETX\139\a3]\250\202\229\175\178\248\161_5\197O\130\USR\219V\253+<\185\169\DEL\210\\\170\DEL2\221\197\214\184\152\STX\135z\148\169\160z\253\163\209`$;\141\187\FSK\f\202\154#\131\237f\230\233\n\185\&0\220\249Qq\156M\149\205\201j\171\198\150$\199\182%\183\167\226\166\209\\$\162\&3\234\254\233\DC4\153=Z-\202-\209>\161&c\NAK\182\174\201\220tY5\211ei\166\171I\129\CANEbE\153\190B\164\216Sd{\159\228\&5\t\247\STX6Q}\176\&1\242'\133:\154s\193*w\181\f\253M6\128\158\149_l=K\187\247\215.'\187f9\217\186\229\212(\235\231d\238\DC1\SUB\219\239\245\153/x4\205~U'\218\&9\200\181\152j5\137\237#F\242\221\168\171\143+E\141n\139\146\138\136:\229*\159\183Ot\228(\137\135F\194\131>>\221x\138\216\190\130\252\191\157\&9\236\154M\204nk\213\165\218\179\235\149i?\158\&2\163\194k\215\163\157H\172\aI\182\251\135I\182?\EMt\207/*%\251\f\EOT\218\171\ETBh\239E\160/\STX-\v\212\RS\212\156[\ACK-\v\180_/\208\254\139@_\EOT\186%\208~\141@\251-\v\244\168^\160G/\STX\253\253\EOTJ\138\173\223T\160\231\RSu\214\223\"Zu\193\DLE\227F\226\240\252E\170\185}/(\175\187\247\ESC\248\211\214\190\146\152\RS\251:`B\169\b`\198g0\137zY(\SI#vi*\140\194\&8m\203\163>pg\133\228E\146\188\184\170\252\&2\148~\227\186R9\146\146\168\184\134K<\141\204\213\136}s\212x\246\149kG \245\180\ENQ\154\203\155\228J\202\&3\137\239\254\162e\204\146~\SUB\240\171X\135b\238\NAK\214\SI\180/\ETX\ETBF\189M?\214%\252\221;T\DC40\248\141\177\231}F\197o\148\130\134;\158\141\221<\188\DLE\137_\215\SUB\212z\206\169\DLE\212\223\167OF\150\171\221\157\202i*sOm\a\220\243\226\ENQ\t\136\252\218>\195\204\175\148Z\234c\196NM\215\222\166\US\179\178\156\&6\218\243\183\&6\249\250B;o\169f\229\226\217\145\183}S\214h;\165\238}u\213\148\232\195+&\FS\142\214\249\RSd\ac(_\213\243\182\&5\EM]\187\181\175\206q\229\CAN\163\176:\211\177\135\161\\\RS+R\181\225\ETB\182{}\216\SUB\NAK\146\150Tx\233\163e}vb\143?>;\133\237\213\137\&8\212\222\248\199!\229\253\170\DLEG\253\154\&1\202\177\150\DC2\166\221\173w\164o\175\149\190o,?0\155#A\252\234X\148\199\174P\170f\183\238\136*\DEL\242\DC1p\234!\158\157=\243\166\138\227d\131\171\194}\211\161\SOw\223\241b\199\EMRz\FS\154\140\ESC\204\196\200#\203\236\&1\RS\133\152q\135\145P\252w1\194>\184\214\a\ETB#\135\ACK\213\224%R\USb}\245\170\tpJ#\230\192X.\188\RS\150\"L #\198`\244\186\nVZ}\133\133\146\192\178\246\192\DEL\242'\131?\129\150\242\164\139X\EM\170:m\"j<c\DEL\225{9\200\140\174\183\STX\202A\218x4\180YB\187\&0O\150ub%\149\&5=\221\168)i\129\253\ENQ\DC2h\ACKO\232\232\231\177C\248\191\ENQ\246\201kr\155\196\177\243\ETXyZ\218\EMr\b\233\190\133 \237-\147>\a*_t\156\&3\224\217Q\158x\DC4\t\GS\229\fxv\148\229\152:\198\202~\CAN\225\DC3\160\220\&2\225\169`p\168\210Q\222 \207\142\244\152\250\242\&7\221\218Do\160Ch\US\ETX\233\185\170{\164]\246_a\203\211\138$\ETXZ\170\216\237Q\RSyp\"\209Q\206\128C(/\SYN\150*\210\173o2\147(p\226;\b]\EM\201a\a\165\252\216\RS\156\224\150S\254\GS/\129\218g\196\214z\177\148\241\a\EOT\144\DC2=\144\224\a\198\168\150Y\ACK<WM$g9\GS\245\r\210\&8\157\234/\254\238\213\191PK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D(\130*b\219\NUL\NUL\NULs\STX\NUL\NUL\DC2\NUL\NUL\NULword/footnotes.xml\157\209\193j\196 \DLE\ACK\224{\159\"x\207\154\221C)\178\217\189,}\130\246\SOH\196\232F\136\142\204L\226>~-\ESC\v=\180\132\156D\198\255\131\DEL<_\USaj\SYN\139\228!\246\226x\232Dc\163\129\193\199{/>?\222\219\&7q\189\188\156\179r\NUL\FS\129-5%\DC1I\229^\140\204IIIf\180A\211\SOH\146\141e\230\NUL\131\230r\197\187\204\128CB0\150\168\128a\146\167\174{\149A\251(V&la\192\&9o\236\r\204\FSl\228\138\240X\DC1\220\139\160\157\&4\151\230\&4\250DU\131^\204\CAN\213J\181\193\ESC\EOT\STX\199\173\129\160\158\202z\212\196\242_b\tS}\151\143\221\ACK\251{i5\161\183\&4\ESCP\231?\214\155\188\217!\148\DC4\207\248S/\167\GS\198\239\175\191=\135\162\145\151/PK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\128\221u\231\218\NUL\NUL\NUL\137\SOH\NUL\NUL\DC1\NUL\NUL\NULdocProps/core.xmlm\144MK\196@\f\134\239\254\138\&2\247\&6\237\n\"\165\237\222<\185 \168\224u\200\196\238\176\157\SI2\209\174\255\222\177j+\184\183$\239\147\135\153t\251\179\155\138w\226d\131\239US\213\170 \143\193X?\246\234\249\233\174\188U\251\225\170\195\216b`z\224\DLE\137\197R*\242\158O-\198^\GSEb\v\144\240HN\167*\DC3>\135\175\129\157\150\220\242\bQ\227I\143\EOT\187\186\190\SOHG\162\141\SYN\r_\194\&2\174F\245\163\&4\184*\227\ESCO\139\192 \208D\142\188$h\170\ACK6V\136]\186\184\176$\DELHg\229#\210E\244\&7\\\233s\178+8\207s5_/h~\DEL\ETX/\135\251\199\229\171\165\245I\180GRCg\176\NAK+\DC3\r\GSle\174\144IK\224\239\241\214\252;\231\240\tPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\SOHdNFd\SOH\NUL\NUL\212\STX\NUL\NUL\DLE\NUL\NUL\NULdocProps/app.xml\157R\203N\195\&0\DLE\188\247+\162\220\137Ky\170r]!\DLE\226\NUL\b\169)\156-{\147X8\182e\ESC\EOT\DEL\207n\211\134 8\145\211\238\204\206\236f\DC2\190\254\232m\241\SO1\EM\239V\229q5/\vp\202k\227\218U\185\173o\143.\203\181\152\241\167\232\ETX\196l \NAK(piUv9\135%cIu\208\203T!\237\144i|\236e\198\&6\182\204\&7\141Qp\227\213[\SI.\179\197|~\206\224#\131\211\160\143\194hX\SO\142\203\247\252_S\237\NAK\221\151\158\235\207\128~bV\DC4\252\197G\157\196\229\tgCE\216\166\147\DC14jE#m\STX\206\190\SOH\162\239P\GS\173q\175\233\186\147\174\ENQ}\CAN\251M\208\248\189q\144\196\241\130\179\161\"\236*\132\231!K$\170\&9>\156M\176\189\236\&5mC\237od\134\195\134\159\224\222\201\SUB%3\201\RS\140\138>\249&\ETB\244.\ENQ9W\131\241\&8B\DC2<.J\149q\215\139\201\221&H\133W\157Q\EOT\DEL2$\169\161\SI\150V>R\196\182\210>\247\156\141(\141`:\ESCPo\209\228O\129K\167\237\206\193gik\211\131\&8G\225\216\236\226V\210\194\&5~\152\&1\238\DC1\248y\174\&8\189\&8\155\RS\185\163\159\176k\163\f\GS~E\206&\221@\182\148=\225T\204\176\CAN\255'\241\ENQPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D=\149\n\180\EM\ACK\NUL\NUL\250\GS\NUL\NUL\NAK\NUL\NUL\NULword/theme/theme1.xml\237YMo\219\&6\CAN\190\239W\DLE\186\183\178l+u\130:E\236\216\237\214\166\r\DC2\183C\143\180DKl(Q \233$\190\r\237q\192\128a\221\176\195\n\236\182\195\176\173@\v\236\210\253\154l\GS\182\SO\232_\CANE\201\DC2eS\141\147\182\219\138\&5\aG\164\158\231\253\230K\210\190|\229\&8\"\224\DLE1\142i\220\181\156\139\r\v\160\216\163>\142\131\174u{4\188\208\177\174l~p\EMn\136\DLEE\bHt\204\&7`\215\n\133H6l\155{r\SUB\242\139\&4A\177|7\161,\130B\SOY`\251\f\RSI)\DC1\177\155\141\198\154\GSA\FS[ \134\DC1\234Z\183&\DC3\236!0JEZ\155s\225\ETX\"?b\193\211\t\143\176}Oi\212\EM\n\235\US8\233?>\227}\194\192!$]K\234\241\233\209\b\GS\v\v\DLE\200\133|\209\181\SUB\234\207\STX\246\230e\187`\DC1QC\214\136C\245\&7'\230\f\255\160\169\136,\CAN\ETBLg\216^\191\180]jhf\SUB\150\129\131\193\160?pJ\137\n\SOH=Oz\235,\129\219\195\142\211+\164j\168\236qYz\191\225\&6\218\v\EOTMCk\137\176\222\235\245\220\245*\161U\DC2\218K\132Nc\173\189\213\172\DC2\218%\193]\246\161\183\213\239\175U\tnIX[\"\f/\173\175\181\ETB\b\n\NAK\DC2\FS\US,\193\211\204\150)*0\DC3J\174\EM\241\GS\137\239\DC4\181P\194l\173\210\&2\SOH\177\168\171\187\b\222\163l(\SOH*\203P\224\CAN\136Y\130&\208\147\184>$x\204\176\210\NUL7\DLE\212^\229s\RS_\158K\213\SOH\238\&1\156\136\174\245Q\STX\229\STX)1/\159\253\240\242\217\DC3pr\255\233\201\253\159O\RS<8\185\255\147\137v\r\198\129N{\241\221\231\DEL=\250\EOT\252\249\228\219\ETB\SI\191\172!p\157\240\219\143\159\254\250\203\ETB5H\161#\159\DEL\245\248\247\167\143\159\DEL\253\217\US\223?4\225\183\CAN\FS\235\248\DC1\142\DLE\a7\209\DC1\216\163Q\234\156A\ENQ\SUB\179\&3RF!\196:e+\SO8\140aJ2\193\a\"\172\192o\206 \129&`\SIU\ETXy\135\201\198`D^\157\222\171\CAN\189\US\178\169\192&\228\245\&0\170 w(%=\202\204\142]W\234\180XL\227\160F?\155\234\192=\b\SI\141\234\251\v\169\RSL\DC3Y\219\216(\180\US\162\138\169\187Df\US\ACK(F\STX\164\239\232\SOHB&\222]\140+\241\221\193\RS\163\156N\EOT\184\139A\SIbs`Fx,\204\172k8\146\t\154\EMm\148\169\175Dh\231\SO\232QbT\176\141\SO\171P\185L 1\nE\164\DC2\205\171p*`d\182\SUBFD\135\222\128\"4\SUB\186?c^%\240\\\200\164\a\136P0\240\DC1\231F\210-6\171\152|]\246\148\154\n\216!\179\168\ne\STX\US\CAN\161\&7 \165:t\155\RS\244C\CAN%f\187q\FS\234\224\SI\249\129\172X\bv\169\&0\219A\171k&\GS\203\132\192\184>\243w0\DC2g\\\241\183q\DLE\154\139%}3e\243\190^\233\208\DC1\142_\213\174#\217\173\225[h\215\178;>\255\230\209;\214\168\183d,\140kc\177=\215\STX\ETB\155r\159\&2\US\191\ESC=y\ESCN\227]\148\214\253\251\150\252\190%\191o\201\175X\229+7\226\178\247\218\250\161Z\t\140jO\216\DC3L\200\190\152\DC1t\131\171\174\205\165\221\254PN\170\129\"\NAK'\250$\148\143s}\NAK`\192\160z\ACK\140\138\143\177\b\247C\152H=\142R\DC1\240\\v\192AB\185\188IX\181\194\213\197\DC4K\247\213\156[\220&%\FS\138\GS\234g\243\173\202\&5\179\DLE\164F\SOH\215U\181R\DC1\171\170k]z]uN\134\\Q\159\227\214\232s_\173\207\214b*\215\ACK\128\233\247\ACK\206Z37\147{\144 ?\141~.a\158\157\183\152)\167\161\167*\132>2\205k>:\173\183\DC3S\247\140v\188\161X7\150cm//.\DC2WG\224\168k\173\187M\215\STX\RSL\186\214D\RS\153\228c\148H\129<\237(\144\EOTq\215\242D\230\228\233Ks\193\233\245\154\250r\SUBn\173\207\NAK%\t\227b\ESC\242\&0\163\169W\197\ETB*q\233B\211m\167\226\222\140\SI\166\246\178\162\GS\173\142\243\175\218a/f\CANM&\200\DC353\229\&0\DELG\167\STX\177\253\208?\STXc2e{PZ\222\206\170\204\199\\\238\EOT\205\249\128\201\&2o\231\ENQX]\198\249\&2Y\252\218&_>\144$!\204\203\190\163W@\134W\207\133\DC1j\164\217g\215\CAN\DELN_Zo\208\ETB\247\255\236KZ\190\242t\218\242\213\rJn\239\f\130\180N\187\SYNe\"\164\178\US%!\246\134L\RS\b\148\&2i\CAN\144kC\181,\146~\255\156\SUB\139\SO\181\SYN\150\t\201\SUB^\DLE\138=\FS\NUL\134e\215\DC3!ChW\228\158\158\"\205\153w\200|y\228\146\242\142S\CAN\204\147\236\255\CAN\GS\"2J\ETB\241Z\SUB\STX\v\132E[\201c\161\128\139\137\179Mkl\FS\f\255\203\135\154\246\&9w\162RU\251,\ESCb[\223\EOT\180\189a\253u\173Xe_\214\DC46k\220n\186\245\155\209\226\ACK\156\200\139\ACKH?d#\199\204#\229\DC1vD\247d\NAK\128\242\NUL K\242B'_\138\197\228XZ\221\209\253Ke\253SG\164N]\222\223\232\233R\139x\171.\226\167(<\DEL\196]C\192\221S\226m//X[\187\177\168\209\210OUt|O*\223\150W\162)\201fx\"G\217\195.\203|\RSS\DEL6\DEL&<k\DC1y4\230}\158\196{h\STX\176\DEL<O\239B\\\243_\130\202M~/S\146\ACK\160`\182V`\230\132ro)\216\205\NAK\216\ENQe~;,\216\234\214g\146@4\221\EM!\203v\209\&7\139\128\145\248\&5#\183\138\a\230\200\EMky\229\200\173\146\177sDN\FS\159\DC2\185<`\182\169\f\209\177`\176?\255yKVs.IU\240\230\223PK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D{\220H:\155\SOH\NUL\NUL\190\t\NUL\NUL\DC2\NUL\NUL\NULword/fontTable.xml\237\149]O\131\&0\DC4\134\239\247+HM\188s\DC4\134\147\225\216\226Gv\233\133\206x]X\EMMhK\218\&2\220\191\247\192\152\SO\182\136\&1\241\202\145\&4)o\223\158\158<9\167\157\206\223yfm\168\210L\138\DLE9C\140,*b\185bb\GS\162\215\229\226\202G\243\217`Z\ACK\137\DC4F[\224\SYN:P!J\141\201\ETX\219\214qJ9\209C\153S\SOHk\137T\156\CAN\248Uk[&\t\139\233\163\140\vN\133\177]\140\199\182\162\EM1p\146NY\174Q\DC3\173\252I\180R\170U\174dL\181\134\212x\182\139\199\t\DC3h6\184\188\152\220\&6)Ze \b\167!z\217\242Hf\205bc\200\137\144\154:\224\217\144,D\CANb\224k\220\250\144e\183\182\196)Q\154\154\175-]CB8\203\182\251uR\CAN\217u\228\204\196\233\222\176!\138\145(\163]\147fk\176\DC4:\194p\200g.\181\226\FS)n\173\&8\a\202\168\237\137\235\&8~[i\197iN\159\218;l\167\EM.\EM\167\218z\162\165\245,9\DC1}0]<\198#\NUL\234\193pa\230\245\193<\162\253w0G=0\SI\149\147\&0\ESC\193\249\&5\204\aY(FU\133\179\SI\228\r\192\155\212@+\144\222\EMd\v\228\ESC\\\NUL\213\253\164\191\199X\161s\234\225\ETXB\US\160\250\231\230>\172G\194#H\183\175\SYN\171f\222\&5u\213\220\238\185\SYN;\DLE3\ACK\DC4\251 .\234jtk\156g\136]\136w\144k\239K}\SI\245\231\&5\DLE\221\DEL\141p?\211\179\SIPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\210\159V\SOH\235\STX\NUL\NUL\242\a\NUL\NUL\DC1\NUL\NUL\NULword/settings.xml\157UMo\226\&0\DLE\189\247WD9/%|\135\bZ-P\218C\187BM\187w\199\153\128\133\GSG\182!K\DEL\253N N\178j\161hO\216\239\205\ESC\143'\158\199\228\254\143\224\206\RS\148f2\157\186\157[\207u \165\&2f\233z\234\190\191-[\190{\DELw3\201\ETX\r\198 \168\GS\DC4\164:\144Sw\167\210@\211\r\b\162[\130Q%\181LL\139J\DC1\200$a\DC4\202\US\183T\168\169\187\&1&\v\218\237Rt+3H\145K\164\DC2\196\224V\173\219'\201B\210\157\128\212\180\187\158\&7l+\224\196`yz\195\&2m\179\137\255\205\134\228\198&\217_\186\196^p\ESC\151w\188+\174\155K\NAKW\138k\202+\EOT\153\146\DC4\180\198\206\nn\vd\169M\163\249\&5yN\212\&3\139\DC4Q\135F\146\187\ESC\199\193/\247!\165p\242 \ETXE\177\vSw\140\223\184]r \"\136\195\131\&6 \150\&25\186\"\176.\153\132\134\CAN@\169\206\128\243\227\139\160\FS\bV\151\akE\132 \170B\172N\155\ETX\135\NAKIay,p\201\184\SOH\133\241{\130W\241<\175_\135\198\242\151\&4o\138\208\237\139\220C}t\f\t\217q\243F\162\208\200\204jG\221F\217\177\"9\214\243\168X\252$\NAK\251\192\210\t\SI3B\DC1\180\130\222\240k\193oP\134\209o\194\153\206\&89\212\185\ETB\181\254\SOH\167\229P\221\232\147\198\166\191BA7\EOTo\143\253)K\153\227QJr\ESCy\236\207\\\138L\225\ETXit\152\236a\165`\207 _1jv\n*\n\167\&8\214\197\186\218\189Ji\234\238\SI\198\222\194\ESC\149\169\170\152\198\215\233t\230\254\236<\223\DEL\232\142g\189\243\252w\249G~\DEL1\240\207\243\254b\232\SI/\228\159\249\195\217hp\129\159\247\253\197\ENQ~\222\ESCvG\227\243\252C\175\&3\248i\207\159\180\ESC\r\157\136\160\&0\142\149*\149\167m12\142\&8\169\159w\148\197\196yT$\141\161>B\EOT\145\218\206Xj\195\"\192\201\253\130\SIw\145\ri\181\154\180\SYN\132\243%\190\DC3K'\132\235\DEL\DC2\DC4\SIo\SOH\201Y\158\191\DLE\181\174+\240\154\156\186\192\229\138d\175l\189\&1\r\140\165\230\153\t\ESC\174wQ\184\203\154\154\DC4\GS\232\\\192\164\221l\"6\223\160mA\209\195gR\207!\164\173\247\176\&1#\\\133\133\189\193\v\201\178\211\184F\235\206\212\229Ea\157\194\137\f\238b\162\182\199M\180\238\150\\\247\200uO\220qCh\225\DEL\CAN].j\172k\177F\\\207b\189\SUB\235[\172_c\ETX\139\rjlh\177a\129m\SOh\189h\159[\244r\187,\240Dr.s\136\159j\254\DC3\212\176\ETB\160\f\159Bx\DLEQm\DC1\183\&5\207\153\&6!d\232(FV\134\251\227\200\ETB/\217\254}\223\253\ENQPK\ETX\EOT\DC4\NUL\STX\b\b\NUL\171\FS\194D\133\FST\206\156\NUL\NUL\NUL\199\NUL\NUL\NUL\DC4\NUL\NUL\NULword/webSettings.xml]\142;\SO\194\&0\DLED\251\156\194rOl(\DLE\138\242\DC1M\232\"\164\192\SOHL\178$\150lo\228\181\DC2\142\207BAA9\243\244FS6/\239\196\n\145,\134J\238s-\ENQ\132\SOHG\ESC\166J\222o\237\238$\155:+\ETX\233b\131G\SI)1!\193V\160\130\219J\206)-\133R4\204\224\r\229\184@`\250\196\232M\226\CAN'\181a\FS\151\136\ETX\DLE\177\236\157:h}T\222\216 \235L\136\239\184q\SO\183kw\DC1\234W\141\216a\234\205\ng\234\217s\208Z\a\US^\170\191;\245\ESCPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\224\171\193D\185\190\SI8^\SOH\NUL\NUL%\ACK\NUL\NUL\DC3\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\NUL\NUL\NUL\NUL[Content_Types].xmlUT\ENQ\NUL\ETX\ETX\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\142\236\DC2\EM\220\NUL\NUL\NUL?\STX\NUL\NUL\v\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\171\SOH\NUL\NUL_rels/.relsPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\247\171\193D\232\150\&1\DC2\v\SOH\NUL\NUL\209\STX\NUL\NUL\DC1\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\176\STX\NUL\NULword/document.xmlUT\ENQ\NUL\ETX2\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\232\171\193D\208\179\r$\252\NUL\NUL\NUL1\EOT\NUL\NUL\FS\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\164\129\ACK\EOT\NUL\NULword/_rels/document.xml.relsUT\ENQ\NUL\ETX\DC3\254\139Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\141\231\194\&4o\NUL\NUL\NUL}\NUL\NUL\NUL\GS\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NULX\ENQ\NUL\NULword/_rels/footnotes.xml.relsPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194DO\174i\165h\SOH\NUL\NUL\204\ACK\NUL\NUL\DC2\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\STX\ACK\NUL\NULword/numbering.xmlPK\SOH\STX\RS\ETX\DC4\NUL\NUL\NUL\b\NUL\b\157\ETBE\FS\165\153\197!\ACK\NUL\NUL\222\&2\NUL\NUL\SI\NUL\CAN\NUL\NUL\NUL\NUL\NUL\SOH\NUL\NUL\NUL\182\129\154\a\NUL\NULword/styles.xmlUT\ENQ\NUL\ETX\144P\249Sux\v\NUL\SOH\EOT\245\SOH\NUL\NUL\EOT\DC4\NUL\NUL\NULPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D(\130*b\219\NUL\NUL\NULs\STX\NUL\NUL\DC2\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\EOT\SO\NUL\NULword/footnotes.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\128\221u\231\218\NUL\NUL\NUL\137\SOH\NUL\NUL\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SI\SI\NUL\NULdocProps/core.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\SOHdNFd\SOH\NUL\NUL\212\STX\NUL\NUL\DLE\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\CAN\DLE\NUL\NULdocProps/app.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D=\149\n\180\EM\ACK\NUL\NUL\250\GS\NUL\NUL\NAK\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\170\DC1\NUL\NULword/theme/theme1.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D{\220H:\155\SOH\NUL\NUL\190\t\NUL\NUL\DC2\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\246\ETB\NUL\NULword/fontTable.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\210\159V\SOH\235\STX\NUL\NUL\242\a\NUL\NUL\DC1\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\193\EM\NUL\NULword/settings.xmlPK\SOH\STX\NUL\NUL\DC4\NUL\STX\b\b\NUL\171\FS\194D\133\FST\206\156\NUL\NUL\NUL\199\NUL\NUL\NUL\DC4\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\219\FS\NUL\NULword/webSettings.xmlPK\ENQ\ACK\NUL\NUL\NUL\NUL\SO\NUL\SO\NUL\236\ETX\NUL\NUL\169\GS\NUL\NUL\NUL\NUL"),("epub.css","/* This defines styles and classes used in the book */\nbody { margin: 5%; text-align: justify; font-size: medium; }\ncode { font-family: monospace; }\nh1 { text-align: left; }\nh2 { text-align: left; }\nh3 { text-align: left; }\nh4 { text-align: left; }\nh5 { text-align: left; }\nh6 { text-align: left; }\nh1.title { }\nh2.author { }\nh3.date { }\nol.toc { padding: 0; margin-left: 1em; }\nol.toc li { list-style-type: none; margin: 0; padding: 0; }\n"),("sample.lua","-- This is a sample custom writer for pandoc.  It produces output\n-- that is very similar to that of pandoc's HTML writer.\n-- There is one new feature: code blocks marked with class 'dot'\n-- are piped through graphviz and images are included in the HTML\n-- output using 'data:' URLs.\n--\n-- Invoke with: pandoc -t sample.lua\n--\n-- Note:  you need not have lua installed on your system to use this\n-- custom writer.  However, if you do have lua installed, you can\n-- use it to test changes to the script.  'lua sample.lua' will\n-- produce informative error messages if your code contains\n-- syntax errors.\n\n-- Character escaping\nlocal function escape(s, in_attribute)\n  return s:gsub(\"[<>&\\\"']\",\n    function(x)\n      if x == '<' then\n        return '&lt;'\n      elseif x == '>' then\n        return '&gt;'\n      elseif x == '&' then\n        return '&amp;'\n      elseif x == '\"' then\n        return '&quot;'\n      elseif x == \"'\" then\n        return '&#39;'\n      else\n        return x\n      end\n    end)\nend\n\n-- Helper function to convert an attributes table into\n-- a string that can be put into HTML tags.\nlocal function attributes(attr)\n  local attr_table = {}\n  for x,y in pairs(attr) do\n    if y and y ~= \"\" then\n      table.insert(attr_table, ' ' .. x .. '=\"' .. escape(y,true) .. '\"')\n    end\n  end\n  return table.concat(attr_table)\nend\n\n-- Run cmd on a temporary file containing inp and return result.\nlocal function pipe(cmd, inp)\n  local tmp = os.tmpname()\n  local tmph = io.open(tmp, \"w\")\n  tmph:write(inp)\n  tmph:close()\n  local outh = io.popen(cmd .. \" \" .. tmp,\"r\")\n  local result = outh:read(\"*all\")\n  outh:close()\n  os.remove(tmp)\n  return result\nend\n\n-- Table to store footnotes, so they can be included at the end.\nlocal notes = {}\n\n-- Blocksep is used to separate block elements.\nfunction Blocksep()\n  return \"\\n\\n\"\nend\n\n-- This function is called once for the whole document. Parameters:\n-- body is a string, metadata is a table, variables is a table.\n-- This gives you a fragment.  You could use the metadata table to\n-- fill variables in a custom lua template.  Or, pass `--template=...`\n-- to pandoc, and pandoc will add do the template processing as\n-- usual.\nfunction Doc(body, metadata, variables)\n  local buffer = {}\n  local function add(s)\n    table.insert(buffer, s)\n  end\n  add(body)\n  if #notes > 0 then\n    add('<ol class=\"footnotes\">')\n    for _,note in pairs(notes) do\n      add(note)\n    end\n    add('</ol>')\n  end\n  return table.concat(buffer,'\\n')\nend\n\n-- The functions that follow render corresponding pandoc elements.\n-- s is always a string, attr is always a table of attributes, and\n-- items is always an array of strings (the items in a list).\n-- Comments indicate the types of other variables.\n\nfunction Str(s)\n  return escape(s)\nend\n\nfunction Space()\n  return \" \"\nend\n\nfunction LineBreak()\n  return \"<br/>\"\nend\n\nfunction Emph(s)\n  return \"<em>\" .. s .. \"</em>\"\nend\n\nfunction Strong(s)\n  return \"<strong>\" .. s .. \"</strong>\"\nend\n\nfunction Subscript(s)\n  return \"<sub>\" .. s .. \"</sub>\"\nend\n\nfunction Superscript(s)\n  return \"<sup>\" .. s .. \"</sup>\"\nend\n\nfunction SmallCaps(s)\n  return '<span style=\"font-variant: small-caps;\">' .. s .. '</span>'\nend\n\nfunction Strikeout(s)\n  return '<del>' .. s .. '</del>'\nend\n\nfunction Link(s, src, tit)\n  return \"<a href='\" .. escape(src,true) .. \"' title='\" ..\n         escape(tit,true) .. \"'>\" .. s .. \"</a>\"\nend\n\nfunction Image(s, src, tit)\n  return \"<img src='\" .. escape(src,true) .. \"' title='\" ..\n         escape(tit,true) .. \"'/>\"\nend\n\nfunction Code(s, attr)\n  return \"<code\" .. attributes(attr) .. \">\" .. escape(s) .. \"</code>\"\nend\n\nfunction InlineMath(s)\n  return \"\\\\(\" .. escape(s) .. \"\\\\)\"\nend\n\nfunction DisplayMath(s)\n  return \"\\\\[\" .. escape(s) .. \"\\\\]\"\nend\n\nfunction Note(s)\n  local num = #notes + 1\n  -- insert the back reference right before the final closing tag.\n  s = string.gsub(s,\n          '(.*)</', '%1 <a href=\"#fnref' .. num ..  '\">&#8617;</a></')\n  -- add a list item with the note to the note table.\n  table.insert(notes, '<li id=\"fn' .. num .. '\">' .. s .. '</li>')\n  -- return the footnote reference, linked to the note.\n  return '<a id=\"fnref' .. num .. '\" href=\"#fn' .. num ..\n            '\"><sup>' .. num .. '</sup></a>'\nend\n\nfunction Span(s, attr)\n  return \"<span\" .. attributes(attr) .. \">\" .. s .. \"</span>\"\nend\n\nfunction Cite(s, cs)\n  local ids = {}\n  for _,cit in ipairs(cs) do\n    table.insert(ids, cit.citationId)\n  end\n  return \"<span class=\\\"cite\\\" data-citation-ids=\\\"\" .. table.concat(ids, \",\") ..\n    \"\\\">\" .. s .. \"</span>\"\nend\n\nfunction Plain(s)\n  return s\nend\n\nfunction Para(s)\n  return \"<p>\" .. s .. \"</p>\"\nend\n\n-- lev is an integer, the header level.\nfunction Header(lev, s, attr)\n  return \"<h\" .. lev .. attributes(attr) ..  \">\" .. s .. \"</h\" .. lev .. \">\"\nend\n\nfunction BlockQuote(s)\n  return \"<blockquote>\\n\" .. s .. \"\\n</blockquote>\"\nend\n\nfunction HorizontalRule()\n  return \"<hr/>\"\nend\n\nfunction CodeBlock(s, attr)\n  -- If code block has class 'dot', pipe the contents through dot\n  -- and base64, and include the base64-encoded png as a data: URL.\n  if attr.class and string.match(' ' .. attr.class .. ' ',' dot ') then\n    local png = pipe(\"base64\", pipe(\"dot -Tpng\", s))\n    return '<img src=\"data:image/png;base64,' .. png .. '\"/>'\n  -- otherwise treat as code (one could pipe through a highlighter)\n  else\n    return \"<pre><code\" .. attributes(attr) .. \">\" .. escape(s) ..\n           \"</code></pre>\"\n  end\nend\n\nfunction BulletList(items)\n  local buffer = {}\n  for _, item in pairs(items) do\n    table.insert(buffer, \"<li>\" .. item .. \"</li>\")\n  end\n  return \"<ul>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</ul>\"\nend\n\nfunction OrderedList(items)\n  local buffer = {}\n  for _, item in pairs(items) do\n    table.insert(buffer, \"<li>\" .. item .. \"</li>\")\n  end\n  return \"<ol>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</ol>\"\nend\n\n-- Revisit association list STackValue instance.\nfunction DefinitionList(items)\n  local buffer = {}\n  for _,item in pairs(items) do\n    for k, v in pairs(item) do\n      table.insert(buffer,\"<dt>\" .. k .. \"</dt>\\n<dd>\" ..\n                        table.concat(v,\"</dd>\\n<dd>\") .. \"</dd>\")\n    end\n  end\n  return \"<dl>\\n\" .. table.concat(buffer, \"\\n\") .. \"\\n</dl>\"\nend\n\n-- Convert pandoc alignment to something HTML can use.\n-- align is AlignLeft, AlignRight, AlignCenter, or AlignDefault.\nfunction html_align(align)\n  if align == 'AlignLeft' then\n    return 'left'\n  elseif align == 'AlignRight' then\n    return 'right'\n  elseif align == 'AlignCenter' then\n    return 'center'\n  else\n    return 'left'\n  end\nend\n\n-- Caption is a string, aligns is an array of strings,\n-- widths is an array of floats, headers is an array of\n-- strings, rows is an array of arrays of strings.\nfunction Table(caption, aligns, widths, headers, rows)\n  local buffer = {}\n  local function add(s)\n    table.insert(buffer, s)\n  end\n  add(\"<table>\")\n  if caption ~= \"\" then\n    add(\"<caption>\" .. caption .. \"</caption>\")\n  end\n  if widths and widths[1] ~= 0 then\n    for _, w in pairs(widths) do\n      add('<col width=\"' .. string.format(\"%d%%\", w * 100) .. '\" />')\n    end\n  end\n  local header_row = {}\n  local empty_header = true\n  for i, h in pairs(headers) do\n    local align = html_align(aligns[i])\n    table.insert(header_row,'<th align=\"' .. align .. '\">' .. h .. '</th>')\n    empty_header = empty_header and h == \"\"\n  end\n  if empty_header then\n    head = \"\"\n  else\n    add('<tr class=\"header\">')\n    for _,h in pairs(header_row) do\n      add(h)\n    end\n    add('</tr>')\n  end\n  local class = \"even\"\n  for _, row in pairs(rows) do\n    class = (class == \"even\" and \"odd\") or \"even\"\n    add('<tr class=\"' .. class .. '\">')\n    for i,c in pairs(row) do\n      add('<td align=\"' .. html_align(aligns[i]) .. '\">' .. c .. '</td>')\n    end\n    add('</tr>')\n  end\n  add('</table')\n  return table.concat(buffer,'\\n')\nend\n\nfunction Div(s, attr)\n  return \"<div\" .. attributes(attr) .. \">\\n\" .. s .. \"</div>\"\nend\n\n-- The following code will produce runtime warnings when you haven't defined\n-- all of the functions you need for the custom writer, so it's useful\n-- to include when you're working on a writer.\nlocal meta = {}\nmeta.__index =\n  function(_, key)\n    io.stderr:write(string.format(\"WARNING: Undefined function '%s'\\n\",key))\n    return function() return \"\" end\n  end\nsetmetatable(_G, meta)\n\n"),("templates/default.textile","$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.s5","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!-- configuration parameters -->\n  <meta name=\"defaultView\" content=\"slideshow\" />\n  <meta name=\"controlVis\" content=\"hidden\" />\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" type=\"text/css\" />\n$endfor$\n  <!-- style sheet links -->\n  <link rel=\"stylesheet\" href=\"$s5-url$/slides.css\" type=\"text/css\" media=\"projection\" id=\"slideProj\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/outline.css\" type=\"text/css\" media=\"screen\" id=\"outlineStyle\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/print.css\" type=\"text/css\" media=\"print\" id=\"slidePrint\" />\n  <link rel=\"stylesheet\" href=\"$s5-url$/opera.css\" type=\"text/css\" media=\"projection\" id=\"operaFix\" />\n  <!-- S5 JS -->\n  <script src=\"$s5-url$/slides.js\" type=\"text/javascript\"></script>\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div class=\"layout\">\n<div id=\"controls\"></div>\n<div id=\"currentSlide\"></div>\n<div id=\"header\"></div>\n<div id=\"footer\">\n  <h1>$date$</h1>\n  <h2>$title$</h2>\n</div>\n</div>\n<div class=\"presentation\">\n$if(title)$\n<div class=\"titleslide slide\">\n  <h1>$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <h2>$for(author)$$author$$sep$<br/>$endfor$</h2>\n  <h3>$date$</h3>\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</div>\n</body>\n</html>\n"),("templates/default.asciidoc","$if(titleblock)$\n$title$\n$for(author)$\n:author: $author$\n$endfor$\n$if(date)$\n:date: $date$\n$endif$\n$if(toc)$\n:toc:\n$endif$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.rtf","{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0 \\fswiss Helvetica;}{\\f1 Courier;}}\n{\\colortbl;\\red255\\green0\\blue0;\\red0\\green0\\blue255;}\n\\widowctrl\\hyphauto\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0 \\b \\fs36 $title$\\par}\n$endif$\n$for(author)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $author$\\par}\n$endfor$\n$if(date)$\n{\\pard \\qc \\f0 \\sa180 \\li0 \\fi0  $date$\\par}\n$endif$\n$if(spacer)$\n{\\pard \\ql \\f0 \\sa180 \\li0 \\fi0 \\par}\n$endif$\n$if(toc)$\n$toc$\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n}\n"),("templates/default.html","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div id=\"$idprefix$header\">\n<h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n<h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</div>\n$endif$\n$if(toc)$\n<div id=\"$idprefix$TOC\">\n$toc$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.markdown","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.dzslides","<!DOCTYPE html>\n<head>\n<meta charset=\"utf-8\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$if(css)$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\" $if(html5)$$else$type=\"text/css\" $endif$/>\n$endfor$\n$else$\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      font-family: Arial, serif;\n      font-size: 20pt;\n    }\n  address, blockquote, dl, fieldset, form, h1, h2, h3, h4, h5, h6, hr, ol, p, pre, table, ul, dl { padding: 10px 20px 10px 20px; }\n  h1, h2, h3 {\n    text-align: center;\n    margin: 10pt 10pt 20pt 10pt;\n  }\n  ul, ol {\n    margin: 10px 10px 10px 50px;\n  }\n  section.titleslide h1 { margin-top: 200px; }\n  h1.title { margin-top: 150px; }\n  h1 { font-size: 180%; }\n  h2 { font-size: 120%; }\n  h3 { font-size: 100%; }\n  q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  blockquote { font-style: italic }\n  /* Figures are displayed full-page, with the caption on\n     top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n  }\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { color: red; opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0.2; }\n</style>\n$endif$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$if(title)$\n<section class=\"title\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n  <h3 class=\"date\">$date$</h3>\n</section>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$dzslides-core$\n</body>\n</html>\n"),("templates/default.epub3","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:epub=\"http://www.idpf.org/2007/ops\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(quotes)$\n  <style type=\"text/css\">\n    q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }\n  </style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"$css$\" />\n$endfor$\n</head>\n<body$if(coverpage)$ id=\"cover\"$endif$>\n$if(titlepage)$\n<section epub:type=\"titlepage\">\n$for(title)$\n$if(title.type)$\n  <h1 class=\"$title.type$\">$title.text$</h1>\n$else$\n  <h1 class=\"title\">$title$</h1>\n$endif$\n$endfor$\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$for(creator)$\n  <h2 class=\"$creator.type$\">$creator.text$</h2>\n$endfor$\n$if(publisher)$\n  <p class=\"publisher\">$publisher$</p>\n$endif$\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n$if(rights)$\n  <p class=\"rights\">$rights$</p>\n$endif$\n</section>\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.html5","<!DOCTYPE html>\n<html$if(lang)$ lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"generator\" content=\"pandoc\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=yes\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\">\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\">\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n  <!--[if lt IE 9]>\n    <script src=\"http://html5shim.googlecode.com/svn/trunk/html5.js\"></script>\n  <![endif]-->\n$if(quotes)$\n  <style type=\"text/css\">q { quotes: \"\226\128\156\" \"\226\128\157\" \"\226\128\152\" \"\226\128\153\"; }</style>\n$endif$\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" href=\"$css$\">\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<header>\n<h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n<h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n<h2 class=\"author\">$author$</h2>\n$endfor$\n$if(date)$\n<h3 class=\"date\">$date$</h3>\n$endif$\n</header>\n$endif$\n$if(toc)$\n<nav id=\"$idprefix$TOC\">\n$toc$\n</nav>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.man","$if(has-tables)$\n.\\\"t\n$endif$\n.TH \"$title$\" \"$section$\" \"$date$\" \"$footer$\" \"$header$\"\n$for(header-includes)$\n$header-includes$\n$endfor$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n$if(author)$\n.SH AUTHORS\n$for(author)$$author$$sep$; $endfor$.\n$endif$\n"),("templates/default.rst","$if(title)$\n$title$\n\n$endif$\n$for(author)$\n:Author: $author$\n$endfor$\n$if(date)$\n:Date:   $date$\n$endif$\n$if(author)$\n\n$else$\n$if(date)$\n\n$endif$\n$endif$\n$if(math)$\n.. role:: math(raw)\n   :format: html latex\n..\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n.. contents::\n   :depth: $toc-depth$\n..\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.slidy","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slidy-url$/styles/slidy.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slidy-url$/scripts/slidy.js\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.opendocument","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" office:version=\"1.2\">\n  <office:font-face-decls>\n    <style:font-face style:name=\"Courier New\" style:font-family-generic=\"modern\" style:font-pitch=\"fixed\" svg:font-family=\"'Courier New'\" />\n  </office:font-face-decls>\n  $automatic-styles$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n<office:body>\n<office:text>\n$if(title)$\n<text:h text:style-name=\"Title\">$title$</text:h>\n$endif$\n$for(author)$\n<text:p text:style-name=\"Author\">$author$</text:p>\n$endfor$\n$if(date)$\n<text:p text:style-name=\"Date\">$date$</text:p>\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</office:text>\n</office:body>\n</office:document-content>\n"),("templates/default.haddock","$body$\n"),("templates/default.org","$if(title)$\n#+TITLE: $title$\n\n$endif$\n$if(author)$\n#+AUTHOR: $for(author)$$author$$sep$; $endfor$\n$endif$\n$if(date)$\n#+DATE: $date$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.latex","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(lang)$$lang$,$endif$$if(papersize)$$papersize$,$endif$$for(classoption)$$classoption$$sep$,$endfor$]{$documentclass$}\n$if(fontfamily)$\n\\usepackage{$fontfamily$}\n$else$\n\\usepackage{lmodern}\n$endif$\n$if(linestretch)$\n\\usepackage{setspace}\n\\setstretch{$linestretch$}\n$endif$\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n\\ifnum 0\\ifxetex 1\\fi\\ifluatex 1\\fi=0 % if pdftex\n  \\usepackage[T1]{fontenc}\n  \\usepackage[utf8]{inputenc}\n$if(euro)$\n  \\usepackage{eurosym}\n$endif$\n\\else % if luatex or xelatex\n  \\ifxetex\n    \\usepackage{mathspec}\n    \\usepackage{xltxtra,xunicode}\n  \\else\n    \\usepackage{fontspec}\n  \\fi\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\newcommand{\\euro}{\226\130\172}\n$if(mainfont)$\n    \\setmainfont{$mainfont$}\n$endif$\n$if(sansfont)$\n    \\setsansfont{$sansfont$}\n$endif$\n$if(monofont)$\n    \\setmonofont[Mapping=tex-ansi]{$monofont$}\n$endif$\n$if(mathfont)$\n    \\setmathfont(Digits,Latin,Greek){$mathfont$}\n$endif$\n\\fi\n% use upquote if available, for straight quotes in verbatim environments\n\\IfFileExists{upquote.sty}{\\usepackage{upquote}}{}\n% use microtype if available\n\\IfFileExists{microtype.sty}{%\n\\usepackage{microtype}\n\\UseMicrotypeSet[protrusion]{basicmath} % disable protrusion for tt fonts\n}{}\n$if(geometry)$\n\\usepackage[$for(geometry)$$geometry$$sep$,$endfor$]{geometry}\n$endif$\n$if(lang)$\n\\ifxetex\n  \\usepackage{polyglossia}\n  \\setmainlanguage{$mainlang$}\n\\else\n  \\usepackage[shorthands=off,$lang$]{babel}\n\\fi\n$endif$\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{$if(biblio-style)$$biblio-style$$else$plainnat$endif$}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n\\VerbatimFootnotes\n$endif$\n$if(tables)$\n\\usepackage{longtable,booktabs}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n\\makeatletter\n\\def\\maxwidth{\\ifdim\\Gin@nat@width>\\linewidth\\linewidth\\else\\Gin@nat@width\\fi}\n\\def\\maxheight{\\ifdim\\Gin@nat@height>\\textheight\\textheight\\else\\Gin@nat@height\\fi}\n\\makeatother\n% Scale images if necessary, so that they will not overflow the page\n% margins by default, and it is still possible to overwrite the defaults\n% using explicit options in \\includegraphics[width, height, ...]{}\n\\setkeys{Gin}{width=\\maxwidth,height=\\maxheight,keepaspectratio}\n$endif$\n\\ifxetex\n  \\usepackage[setpagesize=false, % page size defined by xetex\n              unicode=false, % unicode breaks when used with xetex\n              xetex]{hyperref}\n\\else\n  \\usepackage[unicode=true]{hyperref}\n\\fi\n\\hypersetup{breaklinks=true,\n            bookmarks=true,\n            pdfauthor={$author-meta$},\n            pdftitle={$title-meta$},\n            colorlinks=true,\n            citecolor=$if(citecolor)$$citecolor$$else$blue$endif$,\n            urlcolor=$if(urlcolor)$$urlcolor$$else$blue$endif$,\n            linkcolor=$if(linkcolor)$$linkcolor$$else$magenta$endif$,\n            pdfborder={0 0 0}}\n\\urlstyle{same}  % don't use monospace font for urls\n$if(links-as-notes)$\n% Make links footnotes instead of hotlinks:\n\\renewcommand{\\href}[2]{#2\\footnote{\\url{#1}}}\n$endif$\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n\\setcounter{secnumdepth}{5}\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n\n$if(title)$\n\\title{$title$$if(subtitle)$\\\\\\vspace{0.5em}{\\large $subtitle$}$endif$}\n$endif$\n$if(author)$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n$endif$\n\\date{$date$}\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n\\begin{document}\n$if(title)$\n\\maketitle\n$endif$\n$if(abstract)$\n\\begin{abstract}\n$abstract$\n\\end{abstract}\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n{\n\\hypersetup{linkcolor=black}\n\\setcounter{tocdepth}{$toc-depth$}\n\\tableofcontents\n}\n$endif$\n$if(lot)$\n\\listoftables\n$endif$\n$if(lof)$\n\\listoffigures\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\bibliography{$biblio-files$}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\printbibliography$if(biblio-title)$[title=$biblio-title$]$endif$\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("templates/default.dokuwiki","$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n__TOC__\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.icml","<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<?aid style=\"50\" type=\"snippet\" readerVersion=\"6.0\" featureSet=\"513\" product=\"8.0(370)\" ?>\n<?aid SnippetType=\"InCopyInterchange\"?>\n<Document DOMVersion=\"8.0\" Self=\"pandoc_doc\">\n    <RootCharacterStyleGroup Self=\"pandoc_character_styles\">\n      <CharacterStyle Self=\"$$ID/NormalCharacterStyle\" Name=\"Default\" />\n      $charStyles$ \n    </RootCharacterStyleGroup>\n    <RootParagraphStyleGroup Self=\"pandoc_paragraph_styles\">\n      <ParagraphStyle Self=\"$$ID/NormalParagraphStyle\" Name=\"$$ID/NormalParagraphStyle\"\n          SpaceBefore=\"6\" SpaceAfter=\"6\"> <!-- paragraph spacing -->\n        <Properties>\n          <TabList type=\"list\">\n            <ListItem type=\"record\">\n              <Alignment type=\"enumeration\">LeftAlign</Alignment>\n              <AlignmentCharacter type=\"string\">.</AlignmentCharacter>\n              <Leader type=\"string\"></Leader>\n              <Position type=\"unit\">10</Position> <!-- first tab stop -->\n            </ListItem>\n          </TabList>\n        </Properties>\n      </ParagraphStyle>\n      $parStyles$ \n    </RootParagraphStyleGroup>\n    <RootTableStyleGroup Self=\"pandoc_table_styles\">\n      <TableStyle Self=\"TableStyle/Table\" Name=\"Table\" />\n    </RootTableStyleGroup>\n    <RootCellStyleGroup Self=\"pandoc_cell_styles\">\n      <CellStyle Self=\"CellStyle/Cell\" AppliedParagraphStyle=\"ParagraphStyle/$$ID/[No paragraph style]\" Name=\"Cell\" />\n    </RootCellStyleGroup>\n  <Story Self=\"pandoc_story\"\n      TrackChanges=\"false\"\n      StoryTitle=\"$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$\"\n      AppliedTOCStyle=\"n\"\n      AppliedNamedGrid=\"n\" >\n    <StoryPreference OpticalMarginAlignment=\"true\" OpticalMarginSize=\"12\" />\n\n<!-- body needs to be non-indented, otherwise code blocks are indented too far -->\n$body$\n\n  </Story>\n  $hyperlinks$\n</Document>\n"),("templates/default.opml","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<opml version=\"2.0\">\n  <head>\n    <title>$title$</title>\n    <dateModified>$date$</dateModified>\n    <ownerName>$for(author)$$author$$sep$; $endfor$</ownerName>\n  </head>\n  <body>\n$body$\n  </body>\n</opml>\n"),("templates/README.markdown","Templates for [pandoc](http://github.com/jgm/pandoc).\n\nIf you use custom templates, we recommend forking this repository,\nso that you can integrate changes to the default templates in future\npandoc releases.\n\nAll of the templates in this repository are dual licensed, under both\nthe GPL (v2 or higher, same as pandoc) and the BSD 3-clause license\n(included below).\n\n----\n\nCopyright (c) 2014, John MacFarlane\n\nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are met:\n\n    * Redistributions of source code must retain the above copyright\n      notice, this list of conditions and the following disclaimer.\n\n    * Redistributions in binary form must reproduce the above\n      copyright notice, this list of conditions and the following\n      disclaimer in the documentation and/or other materials provided\n      with the distribution.\n\n    * Neither the name of John MacFarlane nor the names of other\n      contributors may be used to endorse or promote products derived\n      from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n\"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\nLIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\nA PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\nOWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\nSPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\nLIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"),("templates/default.texinfo","\\input texinfo\n@documentencoding UTF-8\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(strikeout)$\n@macro textstrikeout{text}\n~~\\text\\~~\n@end macro\n\n$endif$\n$if(subscript)$\n@macro textsubscript{text}\n@iftex\n@textsubscript{\\text\\}\n@end iftex\n@ifnottex\n_@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n$if(superscript)$\n@macro textsuperscript{text}\n@iftex\n@textsuperscript{\\text\\}\n@end iftex\n@ifnottex\n^@{\\text\\@}\n@end ifnottex\n@end macro\n\n$endif$\n@ifnottex\n@paragraphindent 0\n@end ifnottex\n$if(titlepage)$\n@titlepage\n@title $title$\n$for(author)$\n@author $author$\n$endfor$\n$if(date)$\n$date$\n$endif$\n@end titlepage\n\n$endif$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n@contents\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n\n@bye\n"),("templates/default.context","\\startmode[*mkii]\n  \\enableregime[utf-8]  \n  \\setupcolors[state=start]\n\\stopmode\n$if(mainlang)$\n\\mainlanguage[$mainlang$]\n$endif$\n\n% Enable hyperlinks\n\\setupinteraction[state=start, color=middleblue]\n\n\\setuppapersize [$if(papersize)$$papersize$$else$letter$endif$][$if(papersize)$$papersize$$else$letter$endif$]\n\\setuplayout    [width=middle,  backspace=1.5in, cutspace=1.5in,\n                 height=middle, topspace=0.75in, bottomspace=0.75in]\n\n\\setuppagenumbering[location={footer,center}]\n\n\\setupbodyfont[11pt]\n\n\\setupwhitespace[medium]\n\n\\setuphead[chapter]      [style=\\tfd]\n\\setuphead[section]      [style=\\tfc]\n\\setuphead[subsection]   [style=\\tfb]\n\\setuphead[subsubsection][style=\\bf]\n\n$if(number-sections)$\n$else$\n\\setuphead[chapter, section, subsection, subsubsection][number=no]\n$endif$\n\n\\definedescription\n  [description]\n  [headstyle=bold, style=normal, location=hanging, width=broad, margin=1cm]\n\n\\setupitemize[autointro]    % prevent orphan list intro\n\\setupitemize[indentnext=no]\n\n\\setupfloat[figure][default={here,nonumber}]\n\\setupfloat[table][default={here,nonumber}]\n\n\\setupthinrules[width=15em] % width of horizontal rules\n\n\\setupdelimitedtext\n  [blockquote]\n  [before={\\blank[medium]},\n   after={\\blank[medium]},\n   indentnext=no,\n  ]\n\n$if(toc)$\n\\setupcombinedlist[content][list={$placelist$}]\n\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n\\starttext\n$if(title)$\n\\startalignment[center]\n  \\blank[2*big]\n  {\\tfd $title$}\n$if(author)$\n  \\blank[3*medium]\n  {\\tfa $for(author)$$author$$sep$\\crlf $endfor$}\n$endif$\n$if(date)$\n  \\blank[2*medium]\n  {\\tfa $date$}\n$endif$\n  \\blank[3*medium]\n\\stopalignment\n$endif$\n$for(include-before)$\n$include-before$\n$endfor$\n$if(toc)$\n\\placecontent\n$endif$\n\n$body$\n\n$for(include-after)$\n$include-after$\n$endfor$\n\\stoptext\n"),("templates/default.plain","$if(titleblock)$\n$titleblock$\n\n$endif$\n$for(header-includes)$\n$header-includes$\n\n$endfor$\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n$toc$\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.epub","<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n  <title>$pagetitle$</title>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" href=\"$css$\" />\n$endfor$\n</head>\n<body$if(coverpage)$ id=\"cover\"$endif$>\n$if(titlepage)$\n$for(title)$\n$if(title.text)$\n  <h1 class=\"$title.type$\">$title.text$</h1>\n$else$\n  <h1 class=\"title\">$title$</h1>\n$endif$\n$endfor$\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n  <h2 class=\"author\">$author$</h2>\n$endfor$\n$for(creator)$\n  <h2 class=\"$creator.type$\">$creator.text$</h2>\n$endfor$\n$if(publisher)$\n  <p class=\"publisher\">$publisher$</p>\n$endif$\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n$if(rights)$\n  <p class=\"rights\">$rights$</p>\n$endif$\n$else$\n$body$\n$endif$\n</body>\n</html>\n\n"),("templates/default.docbook","<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n$if(mathml)$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook EBNF Module V1.1CR1//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/mathml/1.1CR1/dbmathml.dtd\">\n$else$\n<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\"\n                  \"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">\n$endif$\n<article>\n  <articleinfo>\n    <title>$title$</title>\n$if(author)$\n    <authorgroup>\n$for(author)$\n      <author>\n        $author$\n      </author>\n$endfor$\n    </authorgroup>\n$endif$\n$if(date)$\n    <date>$date$</date>\n$endif$\n  </articleinfo>\n$for(include-before)$\n$include-before$\n$endfor$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</article>\n"),("templates/default.slideous","<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\"$if(lang)$ lang=\"$lang$\" xml:lang=\"$lang$\"$endif$>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n  <meta http-equiv=\"Content-Style-Type\" content=\"text/css\" />\n  <meta name=\"generator\" content=\"pandoc\" />\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n  <style type=\"text/css\">\n$highlighting-css$\n  </style>\n$endif$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n    href=\"$slideous-url$/slideous.css\" />\n$for(css)$\n  <link rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection, print\"\n   href=\"$css$\" />\n$endfor$\n$if(math)$\n  $math$\n$endif$\n$for(header-includes)$\n  $header-includes$\n$endfor$\n  <script src=\"$slideous-url$/slideous.js\"\n    charset=\"utf-8\" type=\"text/javascript\"></script>\n$if(duration)$\n  <meta name=\"duration\" content=\"$duration$\" />\n$endif$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n<div id=\"statusbar\">\n<span style=\"float:right;\">\n<span style=\"margin-right:4em;font-weight:bold;\"><span id=\"slideidx\"></span> of {$$slidecount}</span>\n<button id=\"homebutton\" title=\"first slide\">1</button>\n<button id=\"prevslidebutton\" title=\"previous slide\">&laquo;</button>\n<button id=\"previtembutton\" title=\"previous item\">&lsaquo;</button>\n<button id=\"nextitembutton\" title=\"next item\">&rsaquo;</button>\n<button id=\"nextslidebutton\" title=\"next slide\">&raquo;</button>\n<button id=\"endbutton\" title=\"last slide\">{$$slidecount}</button>\n<button id=\"incfontbutton\" title=\"content\">A+</button>\n<button id=\"decfontbutton\" title=\"first slide\">A-</button>\n<select id=\"tocbox\" size=\"1\"><option></option></select>\n</span>\n<span id=\"eos\">&frac12;</span>\n<span title=\"{$$location}, {$$date}\">{$$title}, {$$author}</span>\n</div>\n$if(title)$\n<div class=\"slide titlepage\">\n  <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n  <p class=\"author\">\n$for(author)$$author$$sep$<br/>$endfor$\n  </p>\n$if(date)$\n  <p class=\"date\">$date$</p>\n$endif$\n</div>\n$endif$\n$body$\n$for(include-after)$\n$include-after$\n$endfor$\n</body>\n</html>\n"),("templates/default.mediawiki","$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n__TOC__\n\n$endif$\n$body$\n$for(include-after)$\n\n$include-after$\n$endfor$\n"),("templates/default.revealjs","<!DOCTYPE html>\n<html$if(lang)$ lang=\"$lang$\"$endif$>\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"generator\" content=\"pandoc\">\n$for(author-meta)$\n  <meta name=\"author\" content=\"$author-meta$\" />\n$endfor$\n$if(date-meta)$\n  <meta name=\"dcterms.date\" content=\"$date-meta$\" />\n$endif$\n  <title>$if(title-prefix)$$title-prefix$ - $endif$$pagetitle$</title>\n  <meta name=\"apple-mobile-web-app-capable\" content=\"yes\" />\n  <meta name=\"apple-mobile-web-app-status-bar-style\" content=\"black-translucent\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no\">\n  <link rel=\"stylesheet\" href=\"$revealjs-url$/css/reveal.min.css\"/>\n    <style type=\"text/css\">code{white-space: pre;}</style>\n$if(highlighting-css)$\n    <style type=\"text/css\">\n$highlighting-css$\n    </style>\n$endif$\n$if(css)$\n$for(css)$\n    <link rel=\"stylesheet\" href=\"$css$\"/>\n$endfor$\n$else$\n    <link rel=\"stylesheet\" href=\"$revealjs-url$/css/theme/simple.css\" id=\"theme\">\n$endif$\n    <!-- If the query includes 'print-pdf', include the PDF print sheet -->\n    <script>\n      if( window.location.search.match( /print-pdf/gi ) ) {\n        var link = document.createElement( 'link' );\n        link.rel = 'stylesheet';\n        link.type = 'text/css';\n        link.href = '$revealjs-url$/css/print/pdf.css';\n        document.getElementsByTagName( 'head' )[0].appendChild( link );\n      }\n    </script>\n    <!--[if lt IE 9]>\n    <script src=\"$revealjs-url$/lib/js/html5shiv.js\"></script>\n    <![endif]-->\n$if(math)$\n    $math$\n$endif$\n$for(header-includes)$\n    $header-includes$\n$endfor$\n</head>\n<body>\n$for(include-before)$\n$include-before$\n$endfor$\n  <div class=\"reveal\">\n    <div class=\"slides\">\n\n$if(title)$\n<section>\n    <h1 class=\"title\">$title$</h1>\n$if(subtitle)$\n  <h1 class=\"subtitle\">$subtitle$</h1>\n$endif$\n$for(author)$\n    <h2 class=\"author\">$author$</h2>\n$endfor$\n    <h3 class=\"date\">$date$</h3>\n</section>\n$endif$\n$if(toc)$\n<section id=\"$idprefix$TOC\">\n$toc$\n</section>\n$endif$\n\n$body$\n    </div>\n  </div>\n\n\n  <script src=\"$revealjs-url$/lib/js/head.min.js\"></script>\n  <script src=\"$revealjs-url$/js/reveal.min.js\"></script>\n\n  <script>\n\n      // Full list of configuration options available here:\n      // https://github.com/hakimel/reveal.js#configuration\n      Reveal.initialize({\n        controls: true,\n        progress: true,\n        history: true,\n        center: true,\n        theme: $if(theme)$'$theme$'$else$Reveal.getQueryHash().theme$endif$, // available themes are in /css/theme\n        transition: $if(transition)$'$transition$'$else$Reveal.getQueryHash().transition || 'default'$endif$, // default/cube/page/concave/zoom/linear/fade/none\n\n        // Optional libraries used to extend on reveal.js\n        dependencies: [\n          { src: '$revealjs-url$/lib/js/classList.js', condition: function() { return !document.body.classList; } },\n          { src: '$revealjs-url$/plugin/zoom-js/zoom.js', async: true, condition: function() { return !!document.body.classList; } },\n          { src: '$revealjs-url$/plugin/notes/notes.js', async: true, condition: function() { return !!document.body.classList; } },\n//          { src: '$revealjs-url$/plugin/search/search.js', async: true, condition: function() { return !!document.body.classList; }, }\n//          { src: '$revealjs-url$/plugin/remotes/remotes.js', async: true, condition: function() { return !!document.body.classList; } }\n]});\n    </script>\n  $for(include-after)$\n  $include-after$\n  $endfor$\n  </body>\n</html>\n"),("templates/default.beamer","\\documentclass[$if(fontsize)$$fontsize$,$endif$$if(handout)$handout,$endif$$if(beamer)$ignorenonframetext,$endif$$for(classoption)$$classoption$$sep$,$endfor$]{$documentclass$}\n$if(theme)$\n\\usetheme{$theme$}\n$endif$\n$if(colortheme)$\n\\usecolortheme{$colortheme$}\n$endif$\n$if(fonttheme)$\n\\usefonttheme{$fonttheme$}\n$endif$\n\\setbeamertemplate{caption}[numbered]\n\\setbeamertemplate{caption label separator}{:}\n\\setbeamercolor{caption name}{fg=normal text.fg}\n\\usepackage{amssymb,amsmath}\n\\usepackage{ifxetex,ifluatex}\n\\usepackage{fixltx2e} % provides \\textsubscript\n\\usepackage{lmodern}\n\\ifxetex\n  \\usepackage{fontspec,xltxtra,xunicode}\n  \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n  \\newcommand{\\euro}{\226\130\172}\n\\else\n  \\ifluatex\n    \\usepackage{fontspec}\n    \\defaultfontfeatures{Mapping=tex-text,Scale=MatchLowercase}\n    \\newcommand{\\euro}{\226\130\172}\n  \\else\n    \\usepackage[T1]{fontenc}\n    \\usepackage[utf8]{inputenc}\n    $if(euro)$\n      \\usepackage{eurosym}\n    $endif$\n  \\fi\n\\fi\n% use upquote if available, for straight quotes in verbatim environments\n\\IfFileExists{upquote.sty}{\\usepackage{upquote}}{}\n% use microtype if available\n\\IfFileExists{microtype.sty}{\\usepackage{microtype}}{}\n$if(natbib)$\n\\usepackage{natbib}\n\\bibliographystyle{plainnat}\n$endif$\n$if(biblatex)$\n\\usepackage{biblatex}\n$if(biblio-files)$\n\\bibliography{$biblio-files$}\n$endif$\n$endif$\n$if(listings)$\n\\usepackage{listings}\n$endif$\n$if(lhs)$\n\\lstnewenvironment{code}{\\lstset{language=Haskell,basicstyle=\\small\\ttfamily}}{}\n$endif$\n$if(highlighting-macros)$\n$highlighting-macros$\n$endif$\n$if(verbatim-in-note)$\n\\usepackage{fancyvrb}\n$endif$\n$if(tables)$\n\\usepackage{longtable,booktabs}\n\\usepackage{caption}\n% These lines are needed to make table captions work with longtable:\n\\makeatletter\n\\def\\fnum@table{\\tablename~\\thetable}\n\\makeatother\n$endif$\n$if(url)$\n\\usepackage{url}\n$endif$\n$if(graphics)$\n\\usepackage{graphicx}\n\\makeatletter\n\\def\\maxwidth{\\ifdim\\Gin@nat@width>\\linewidth\\linewidth\\else\\Gin@nat@width\\fi}\n\\def\\maxheight{\\ifdim\\Gin@nat@height>\\textheight0.8\\textheight\\else\\Gin@nat@height\\fi}\n\\makeatother\n% Scale images if necessary, so that they will not overflow the page\n% margins by default, and it is still possible to overwrite the defaults\n% using explicit options in \\includegraphics[width, height, ...]{}\n\\setkeys{Gin}{width=\\maxwidth,height=\\maxheight,keepaspectratio}\n$endif$\n\n% Comment these out if you don't want a slide with just the\n% part/section/subsection/subsubsection title:\n\\AtBeginPart{\n  \\let\\insertpartnumber\\relax\n  \\let\\partname\\relax\n  \\frame{\\partpage}\n}\n\\AtBeginSection{\n  \\let\\insertsectionnumber\\relax\n  \\let\\sectionname\\relax\n  \\frame{\\sectionpage}\n}\n\\AtBeginSubsection{\n  \\let\\insertsubsectionnumber\\relax\n  \\let\\subsectionname\\relax\n  \\frame{\\subsectionpage}\n}\n\n$if(strikeout)$\n\\usepackage[normalem]{ulem}\n% avoid problems with \\sout in headers with hyperref:\n\\pdfstringdefDisableCommands{\\renewcommand{\\sout}{}}\n$endif$\n\\setlength{\\parindent}{0pt}\n\\setlength{\\parskip}{6pt plus 2pt minus 1pt}\n\\setlength{\\emergencystretch}{3em}  % prevent overfull lines\n$if(numbersections)$\n$else$\n\\setcounter{secnumdepth}{0}\n$endif$\n$if(verbatim-in-note)$\n\\VerbatimFootnotes % allows verbatim text in footnotes\n$endif$\n$if(lang)$\n\\usepackage[$lang$]{babel}\n$endif$\n$for(header-includes)$\n$header-includes$\n$endfor$\n\n$if(title)$\n\\title{$title$}\n$endif$\n$if(subtitle)$\n\\subtitle{$subtitle$}\n$endif$\n$if(author)$\n\\author{$for(author)$$author$$sep$ \\and $endfor$}\n$endif$\n\\date{$date$}\n\n\\begin{document}\n$if(title)$\n\\frame{\\titlepage}\n$endif$\n\n$for(include-before)$\n$include-before$\n\n$endfor$\n$if(toc)$\n\\begin{frame}\n\\tableofcontents[hideallsubsections]\n\\end{frame}\n\n$endif$\n$body$\n\n$if(natbib)$\n$if(biblio-files)$\n$if(biblio-title)$\n$if(book-class)$\n\\renewcommand\\bibname{$biblio-title$}\n$else$\n\\renewcommand\\refname{$biblio-title$}\n$endif$\n$endif$\n\\begin{frame}[allowframebreaks]{$biblio-title$}\n\\bibliography{$biblio-files$}\n\\end{frame}\n\n$endif$\n$endif$\n$if(biblatex)$\n\\begin{frame}[allowframebreaks]{$biblio-title$}\n\\printbibliography[heading=none]\n\\end{frame}\n\n$endif$\n$for(include-after)$\n$include-after$\n\n$endfor$\n\\end{document}\n"),("dzslides/template.html","<!DOCTYPE html>\n\n<meta charset=\"utf-8\">\n<title>The Title Of Your Presentation</title>\n\n<!-- Your Slides -->\n<!-- One section is one slide -->\n\n<section>\n    <!-- This is the first slide -->\n    <h1>My Presentation</h1>\n    <footer>by John Doe</footer>\n</section>\n\n<section>\n    <p>Some random text: But I've never been to the moon! You can see how I lived before I met you. Also Zoidberg.\n    I could if you hadn't turned on the light and shut off my stereo.</p>\n</section>\n\n<section>\n    <h3>An incremental list</h3>\n    <ul class=\"incremental\">\n      <li>Item 1\n      <li>Item 2\n      <li>Item 3\n    </ul>\n    <details>Some notes. They are only visible using onstage shell.</details>\n</section>\n\n<section>\n  <q>\n    Who's brave enough to fly into something we all keep calling a death sphere?\n  </q>\n</section>\n\n<section>\n    <h2>Part two</h2>\n</section>\n\n<section>\n    <figure> <!-- Figures are used to display images and videos fullpage -->\n      <img src=\"http://placekitten.com/g/800/600\">\n      <figcaption>An image</figcaption>\n    </figure>\n    <details>Kittens are so cute!</details>\n</section>\n\n<section>\n    <figure> <!-- Videos are automatically played -->\n      <video src=\"http://videos-cdn.mozilla.net/brand/Mozilla_Firefox_Manifesto_v0.2_640.webm\" poster=\"http://www.mozilla.org/images/about/poster.jpg\"></video>\n      <figcaption>A video</figcaption>\n    </figure>\n</section>\n\n<section>\n    <h2>End!</h2>\n</section>\n\n<!-- Your Style -->\n<!-- Define the style of your presentation -->\n\n<!-- Maybe a font from http://www.google.com/webfonts ? -->\n<link href='http://fonts.googleapis.com/css?family=Oswald' rel='stylesheet'>\n\n<style>\n  html { background-color: black; }\n  body { background-color: white; border-radius: 12px}\n  /* A section is a slide. It's size is 800x600, and this will never change */\n  section {\n      /* The font from Google */\n      font-family: 'Oswald', arial, serif;\n      font-size: 30px;\n  }\n  h1, h2 {\n    margin-top: 200px;\n    text-align: center;\n    font-size: 80px;\n  }\n  h3 {\n    margin: 100px 0 50px 100px;\n  }\n\n  ul {\n      margin: 50px 200px;\n  }\n\n  p {\n    margin: 75px;\n    font-size: 50px;\n  }\n\n  q {\n    display: block;\n    width: 100%;\n    height: 100%;\n    background-color: black;\n    color: white;\n    font-size: 60px;\n    padding: 50px;\n  }\n\n  /* Figures are displayed full-page, with the caption\n     on top of the image/video */\n  figure {\n    background-color: black;\n  }\n  figcaption {\n    margin: 70px;\n    font-size: 50px;\n  }\n\n  footer {\n    position: absolute;\n    bottom: 0;\n    width: 100%;\n    padding: 40px;\n    text-align: right;\n    background-color: #F3F4F8;\n    border-top: 1px solid #CCC;\n  }\n\n  /* Transition effect */\n  /* Feel free to change the transition effect for original\n     animations. See here:\n     https://developer.mozilla.org/en/CSS/CSS_transitions\n     How to use CSS3 Transitions: */\n  section {\n      -moz-transition: left 400ms linear 0s;\n      -webkit-transition: left 400ms linear 0s;\n      -ms-transition: left 400ms linear 0s;\n      transition: left 400ms linear 0s;\n  }\n\n  /* Before */\n  section { left: -150%; }\n  /* Now */\n  section[aria-selected] { left: 0; }\n  /* After */\n  section[aria-selected] ~ section { left: +150%; }\n\n  /* Incremental elements */\n\n  /* By default, visible */\n  .incremental > * { opacity: 1; }\n\n  /* The current item */\n  .incremental > *[aria-selected] { opacity: 1; }\n\n  /* The items to-be-selected */\n  .incremental > *[aria-selected] ~ * { opacity: 0; }\n\n  /* The progressbar, at the bottom of the slides, show the global\n     progress of the presentation. */\n  #progress-bar {\n    height: 2px;\n    background: #AAA;\n  }\n</style>\n\n<!-- {{{{ dzslides core\n#\n#\n#     __  __  __       .  __   ___  __\n#    |  \\  / /__` |    | |  \\ |__  /__`\n#    |__/ /_ .__/ |___ | |__/ |___ .__/ core :\226\130\172\n#\n#\n# The following block of code is not supposed to be edited.\n# But if you want to change the behavior of these slides,\n# feel free to hack it!\n#\n-->\n\n<div id=\"progress-bar\"></div>\n\n<!-- Default Style -->\n<style>\n  * { margin: 0; padding: 0; -moz-box-sizing: border-box; -webkit-box-sizing: border-box; box-sizing: border-box; }\n  details { display: none; }\n  body {\n    width: 800px; height: 600px;\n    margin-left: -400px; margin-top: -300px;\n    position: absolute; top: 50%; left: 50%;\n    overflow: hidden;\n  }\n  section {\n    position: absolute;\n    pointer-events: none;\n    width: 100%; height: 100%;\n  }\n  section[aria-selected] { pointer-events: auto; }\n  html { overflow: hidden; }\n  body { display: none; }\n  body.loaded { display: block; }\n  .incremental {visibility: hidden; }\n  .incremental[active] {visibility: visible; }\n  #progress-bar{\n    bottom: 0;\n    position: absolute;\n    -moz-transition: width 400ms linear 0s;\n    -webkit-transition: width 400ms linear 0s;\n    -ms-transition: width 400ms linear 0s;\n    transition: width 400ms linear 0s;\n  }\n  figure {\n    width: 100%;\n    height: 100%;\n  }\n  figure > * {\n    position: absolute;\n  }\n  figure > img, figure > video {\n    width: 100%; height: 100%;\n  }\n</style>\n\n<script>\n  var Dz = {\n    remoteWindows: [],\n    idx: -1,\n    step: 0,\n    slides: null,\n    progressBar : null,\n    params: {\n      autoplay: \"1\"\n    }\n  };\n\n  Dz.init = function() {\n    document.body.className = \"loaded\";\n    this.slides = $$(\"body > section\");\n    this.progressBar = $(\"#progress-bar\");\n    this.setupParams();\n    this.onhashchange();\n    this.setupTouchEvents();\n    this.onresize();\n  }\n  \n  Dz.setupParams = function() {\n    var p = window.location.search.substr(1).split('&');\n    p.forEach(function(e, i, a) {\n      var keyVal = e.split('=');\n      Dz.params[keyVal[0]] = decodeURIComponent(keyVal[1]);\n    });\n  // Specific params handling\n    if (!+this.params.autoplay)\n      $$.forEach($$(\"video\"), function(v){ v.controls = true });\n  }\n\n  Dz.onkeydown = function(aEvent) {\n    // Don't intercept keyboard shortcuts\n    if (aEvent.altKey\n      || aEvent.ctrlKey\n      || aEvent.metaKey\n      || aEvent.shiftKey) {\n      return;\n    }\n    if ( aEvent.keyCode == 37 // left arrow\n      || aEvent.keyCode == 38 // up arrow\n      || aEvent.keyCode == 33 // page up\n    ) {\n      aEvent.preventDefault();\n      this.back();\n    }\n    if ( aEvent.keyCode == 39 // right arrow\n      || aEvent.keyCode == 40 // down arrow\n      || aEvent.keyCode == 34 // page down\n    ) {\n      aEvent.preventDefault();\n      this.forward();\n    }\n    if (aEvent.keyCode == 35) { // end\n      aEvent.preventDefault();\n      this.goEnd();\n    }\n    if (aEvent.keyCode == 36) { // home\n      aEvent.preventDefault();\n      this.goStart();\n    }\n    if (aEvent.keyCode == 32) { // space\n      aEvent.preventDefault();\n      this.toggleContent();\n    }\n    if (aEvent.keyCode == 70) { // f\n      aEvent.preventDefault();\n      this.goFullscreen();\n    }\n  }\n\n  /* Touch Events */\n\n  Dz.setupTouchEvents = function() {\n    var orgX, newX;\n    var tracking = false;\n\n    var db = document.body;\n    db.addEventListener(\"touchstart\", start.bind(this), false);\n    db.addEventListener(\"touchmove\", move.bind(this), false);\n\n    function start(aEvent) {\n      aEvent.preventDefault();\n      tracking = true;\n      orgX = aEvent.changedTouches[0].pageX;\n    }\n\n    function move(aEvent) {\n      if (!tracking) return;\n      newX = aEvent.changedTouches[0].pageX;\n      if (orgX - newX > 100) {\n        tracking = false;\n        this.forward();\n      } else {\n        if (orgX - newX < -100) {\n          tracking = false;\n          this.back();\n        }\n      }\n    }\n  }\n\n  /* Adapt the size of the slides to the window */\n\n  Dz.onresize = function() {\n    var db = document.body;\n    var sx = db.clientWidth / window.innerWidth;\n    var sy = db.clientHeight / window.innerHeight;\n    var transform = \"scale(\" + (1/Math.max(sx, sy)) + \")\";\n\n    db.style.MozTransform = transform;\n    db.style.WebkitTransform = transform;\n    db.style.OTransform = transform;\n    db.style.msTransform = transform;\n    db.style.transform = transform;\n  }\n\n\n  Dz.getDetails = function(aIdx) {\n    var s = $(\"section:nth-of-type(\" + aIdx + \")\");\n    var d = s.$(\"details\");\n    return d ? d.innerHTML : \"\";\n  }\n\n  Dz.onmessage = function(aEvent) {\n    var argv = aEvent.data.split(\" \"), argc = argv.length;\n    argv.forEach(function(e, i, a) { a[i] = decodeURIComponent(e) });\n    var win = aEvent.source;\n    if (argv[0] === \"REGISTER\" && argc === 1) {\n      this.remoteWindows.push(win);\n      this.postMsg(win, \"REGISTERED\", document.title, this.slides.length);\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n      return;\n    }\n    if (argv[0] === \"BACK\" && argc === 1)\n      this.back();\n    if (argv[0] === \"FORWARD\" && argc === 1)\n      this.forward();\n    if (argv[0] === \"START\" && argc === 1)\n      this.goStart();\n    if (argv[0] === \"END\" && argc === 1)\n      this.goEnd();\n    if (argv[0] === \"TOGGLE_CONTENT\" && argc === 1)\n      this.toggleContent();\n    if (argv[0] === \"SET_CURSOR\" && argc === 2)\n      window.location.hash = \"#\" + argv[1];\n    if (argv[0] === \"GET_CURSOR\" && argc === 1)\n      this.postMsg(win, \"CURSOR\", this.idx + \".\" + this.step);\n    if (argv[0] === \"GET_NOTES\" && argc === 1)\n      this.postMsg(win, \"NOTES\", this.getDetails(this.idx));\n  }\n\n  Dz.toggleContent = function() {\n    // If a Video is present in this new slide, play it.\n    // If a Video is present in the previous slide, stop it.\n    var s = $(\"section[aria-selected]\");\n    if (s) {\n      var video = s.$(\"video\");\n      if (video) {\n        if (video.ended || video.paused) {\n          video.play();\n        } else {\n          video.pause();\n        }\n      }\n    }\n  }\n\n  Dz.setCursor = function(aIdx, aStep) {\n    // If the user change the slide number in the URL bar, jump\n    // to this slide.\n    aStep = (aStep != 0 && typeof aStep !== \"undefined\") ? \".\" + aStep : \".0\";\n    window.location.hash = \"#\" + aIdx + aStep;\n  }\n\n  Dz.onhashchange = function() {\n    var cursor = window.location.hash.split(\"#\"),\n        newidx = 1,\n        newstep = 0;\n    if (cursor.length == 2) {\n      newidx = ~~cursor[1].split(\".\")[0];\n      newstep = ~~cursor[1].split(\".\")[1];\n      if (newstep > Dz.slides[newidx - 1].$$('.incremental > *').length) {\n        newstep = 0;\n        newidx++;\n      }\n    }\n    this.setProgress(newidx, newstep);\n    if (newidx != this.idx) {\n      this.setSlide(newidx);\n    }\n    if (newstep != this.step) {\n      this.setIncremental(newstep);\n    }\n    for (var i = 0; i < this.remoteWindows.length; i++) {\n      this.postMsg(this.remoteWindows[i], \"CURSOR\", this.idx + \".\" + this.step);\n    }\n  }\n\n  Dz.back = function() {\n    if (this.idx == 1 && this.step == 0) {\n      return;\n    }\n    if (this.step == 0) {\n      this.setCursor(this.idx - 1,\n                     this.slides[this.idx - 2].$$('.incremental > *').length);\n    } else {\n      this.setCursor(this.idx, this.step - 1);\n    }\n  }\n\n  Dz.forward = function() {\n    if (this.idx >= this.slides.length &&\n        this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n        return;\n    }\n    if (this.step >= this.slides[this.idx - 1].$$('.incremental > *').length) {\n      this.setCursor(this.idx + 1, 0);\n    } else {\n      this.setCursor(this.idx, this.step + 1);\n    }\n  }\n\n  Dz.goStart = function() {\n    this.setCursor(1, 0);\n  }\n\n  Dz.goEnd = function() {\n    var lastIdx = this.slides.length;\n    var lastStep = this.slides[lastIdx - 1].$$('.incremental > *').length;\n    this.setCursor(lastIdx, lastStep);\n  }\n\n  Dz.setSlide = function(aIdx) {\n    this.idx = aIdx;\n    var old = $(\"section[aria-selected]\");\n    var next = $(\"section:nth-of-type(\"+ this.idx +\")\");\n    if (old) {\n      old.removeAttribute(\"aria-selected\");\n      var video = old.$(\"video\");\n      if (video) {\n        video.pause();\n      }\n    }\n    if (next) {\n      next.setAttribute(\"aria-selected\", \"true\");\n      var video = next.$(\"video\");\n      if (video && !!+this.params.autoplay) {\n        video.play();\n      }\n    } else {\n      // That should not happen\n      this.idx = -1;\n      // console.warn(\"Slide doesn't exist.\");\n    }\n  }\n\n  Dz.setIncremental = function(aStep) {\n    this.step = aStep;\n    var old = this.slides[this.idx - 1].$('.incremental > *[aria-selected]');\n    if (old) {\n      old.removeAttribute('aria-selected');\n    }\n    var incrementals = $$('.incremental');\n    if (this.step <= 0) {\n      $$.forEach(incrementals, function(aNode) {\n        aNode.removeAttribute('active');\n      });\n      return;\n    }\n    var next = this.slides[this.idx - 1].$$('.incremental > *')[this.step - 1];\n    if (next) {\n      next.setAttribute('aria-selected', true);\n      next.parentNode.setAttribute('active', true);\n      var found = false;\n      $$.forEach(incrementals, function(aNode) {\n        if (aNode != next.parentNode)\n          if (found)\n            aNode.removeAttribute('active');\n          else\n            aNode.setAttribute('active', true);\n        else\n          found = true;\n      });\n    } else {\n      setCursor(this.idx, 0);\n    }\n    return next;\n  }\n\n  Dz.goFullscreen = function() {\n    var html = $('html'),\n        requestFullscreen = html.requestFullscreen || html.requestFullScreen || html.mozRequestFullScreen || html.webkitRequestFullScreen;\n    if (requestFullscreen) {\n      requestFullscreen.apply(html);\n    }\n  }\n  \n  Dz.setProgress = function(aIdx, aStep) {\n    var slide = $(\"section:nth-of-type(\"+ aIdx +\")\");\n    if (!slide)\n      return;\n    var steps = slide.$$('.incremental > *').length + 1,\n        slideSize = 100 / (this.slides.length - 1),\n        stepSize = slideSize / steps;\n    this.progressBar.style.width = ((aIdx - 1) * slideSize + aStep * stepSize) + '%';\n  }\n  \n  Dz.postMsg = function(aWin, aMsg) { // [arg0, [arg1...]]\n    aMsg = [aMsg];\n    for (var i = 2; i < arguments.length; i++)\n      aMsg.push(encodeURIComponent(arguments[i]));\n    aWin.postMessage(aMsg.join(\" \"), \"*\");\n  }\n  \n  function init() {\n    Dz.init();\n    window.onkeydown = Dz.onkeydown.bind(Dz);\n    window.onresize = Dz.onresize.bind(Dz);\n    window.onhashchange = Dz.onhashchange.bind(Dz);\n    window.onmessage = Dz.onmessage.bind(Dz);\n  }\n\n  window.onload = init;\n</script>\n\n\n<script> // Helpers\n  if (!Function.prototype.bind) {\n    Function.prototype.bind = function (oThis) {\n\n      // closest thing possible to the ECMAScript 5 internal IsCallable\n      // function \n      if (typeof this !== \"function\")\n      throw new TypeError(\n        \"Function.prototype.bind - what is trying to be fBound is not callable\"\n      );\n\n      var aArgs = Array.prototype.slice.call(arguments, 1),\n          fToBind = this,\n          fNOP = function () {},\n          fBound = function () {\n            return fToBind.apply( this instanceof fNOP ? this : oThis || window,\n                   aArgs.concat(Array.prototype.slice.call(arguments)));\n          };\n\n      fNOP.prototype = this.prototype;\n      fBound.prototype = new fNOP();\n\n      return fBound;\n    };\n  }\n\n  var $ = (HTMLElement.prototype.$ = function(aQuery) {\n    return this.querySelector(aQuery);\n  }).bind(document);\n\n  var $$ = (HTMLElement.prototype.$$ = function(aQuery) {\n    return this.querySelectorAll(aQuery);\n  }).bind(document);\n\n  $$.forEach = function(nodeList, fun) {\n    Array.prototype.forEach.call(nodeList, fun);\n  }\n\n</script>\n<!-- vim: set fdm=marker: }}} -->\n")]
