Treat an image alone in its paragraph (but not a figure)
as an independent image:
```
% pandoc -f native -t rst
[Para [Image ("",["align-center"],[]) [Str "https://pandoc.org/diagram.jpg"] ("https://pandoc.org/diagram.jpg","")]]
^D
.. image:: https://pandoc.org/diagram.jpg
   :alt: https://pandoc.org/diagram.jpg
   :align: center
```

Here we just omit the center attribute as it's not valid:
```
% pandoc -f native -t rst
[Para [Str "hi",Space,Image ("",["align-center"],[]) [Str "https://pandoc.org/diagram.jpg"] ("https://pandoc.org/diagram.jpg","")]]
^D
hi |https://pandoc.org/diagram.jpg|

.. |https://pandoc.org/diagram.jpg| image:: https://pandoc.org/diagram.jpg
```

But we can use top, middle, or bottom alignment:
```
% pandoc -f native -t rst
[Para [Str "hi",Space,Image ("",["align-top"],[]) [Str "https://pandoc.org/diagram.jpg"] ("https://pandoc.org/diagram.jpg","")]]
^D
hi |https://pandoc.org/diagram.jpg|

.. |https://pandoc.org/diagram.jpg| image:: https://pandoc.org/diagram.jpg
   :align: top
```
