/*
**  UUFile.h
**
**  Copyright (c) 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_UUFile
#define _Pantomime_H_UUFile

#import <Foundation/NSData.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@interface UUFile : NSObject
{
  NSDictionary *attributes;
  NSString *name;
  NSData *data;
}

- (id) initWithName: (NSString *) theName
               data: (NSData *) theData
         attributes: (NSDictionary *) theAttributes;


//
// access / mutation methods
//
- (NSString *) name;
- (void) setName: (NSString *) theName;

- (NSData *) data;
- (void) setData: (NSData *) theData;

- (NSDictionary *) attributes;
- (void) setAttributes: (NSDictionary *) theAttributes;

@end

#endif // _Pantomime_H_UUFile
