#ifndef INCLUDE_COLOUR_PREFERENCE_H
#define INCLUDE_COLOUR_PREFERENCE_H

#include "papaya/Preference.h"
#include "PreferenceHandler.h"
#include "papaya/ColourEditor.h"

class ColourPreference : public Preference {
 public:
  ColourPreference();
  ~ColourPreference();

  GtkWidget * getWidget();
  void destroyWidget();

  Category * getCategories();

  void loadPreferences(Prefs *);
  void applyPreferences(Prefs *);

  // Not really public, but C function needs access.
  void setColourState(bool);

 private:

  ColourEditor * white_editor;
  ColourEditor * red_editor;
  ColourEditor * green_editor;
  ColourEditor * blue_editor;
  ColourEditor * yellow_editor;
  ColourEditor * magenta_editor;
  ColourEditor * cyan_editor;
  ColourEditor * black_editor;

  ColourEditor * white_bold_editor;
  ColourEditor * red_bold_editor;
  ColourEditor * green_bold_editor;
  ColourEditor * blue_bold_editor;
  ColourEditor * yellow_bold_editor;
  ColourEditor * magenta_bold_editor;
  ColourEditor * cyan_bold_editor;
  ColourEditor * black_bold_editor;
  ColourEditor * background_editor;

};

const Category colour_categories[] = {
  CategoryColours,
  CategoryLast
};


#endif // INCLUDE_COLOUR_PREFERENCE_H
