#include "mudclient.h"
#include "papaya/system.h"
#include "PapayaList.h"

/**
 * Generic list class.
 */

PapayaList::PapayaList() {
  debug ("WARNING: Use of PapayaList is deprecated.\n");
  firstElement = (PapayaListElement *)NULL;
}

PapayaList::~PapayaList() {

  PapayaListElement * tmp_next = (PapayaListElement *)NULL;

  for (PapayaListElement * tmp = firstElement; tmp; tmp = tmp_next) {
    tmp_next = tmp->getNext();
    delete tmp;
  }

}

PapayaListElement * PapayaList::findEntry(void * data) {

  PapayaListElement * tmp = firstElement;

  for (; tmp; tmp = tmp->getNext()) {
    if (tmp->getData() == data)
      return tmp;
  }

  return (PapayaListElement *)NULL;
}

PapayaListElement * PapayaList::findEntry(Connection * connection) {

  PapayaListElement * tmp = firstElement;

  for (; tmp; tmp = tmp->getNext()) {
    if (tmp->getConnection() == connection)
      return tmp;
  }

  return (PapayaListElement *)NULL;

}

PapayaListElement * PapayaList::newEntry(void * data) {
  PapayaListElement * element = new PapayaListElement();
  element->setConnection((Connection *)NULL);
  element->setData(data);

  if (!firstElement) {
    firstElement = element;
    element->setNext(NULL);
  }

  // Add this element at the end of the list.
  for (PapayaListElement * tmp = firstElement; tmp; tmp = tmp->getNext()) {
    if (!tmp->getNext()) {
      tmp->setNext(element);
      element->setNext(NULL);
      return element;
    }
  }

  printf(_("Ran past end of list appending entry to it."));
  printf(CRLF);
  abort();
  return NULL;
}

PapayaListElement * PapayaList::newEntry(Connection * connection, void * data) {
  PapayaListElement * element = new PapayaListElement();
  element->setConnection(connection);
  element->setData(data);

  if (!firstElement) {
    firstElement = element;
    element->setNext(NULL);
  }

  // Add this element at the end of the list.
  for (PapayaListElement * tmp = firstElement; tmp; tmp = tmp->getNext()) {
    if (!tmp->getNext()) {
      tmp->setNext(element);
      element->setNext(NULL);
      return element;
    }
  }

  printf(_("Ran past end of list appending entry to it."));
  printf(CRLF);
  abort();

  return NULL;
}

void PapayaList::deleteEntry(PapayaListElement * ele) {
  PapayaListElement * tmp = firstElement;

  if (!tmp)
    return;

  if (ele == firstElement) {
    firstElement = ele->getNext();
    delete ele;
    return;
  }

  for (; tmp->getNext(); tmp = tmp->getNext()) {
    if (tmp->getNext() == ele) {
      tmp->setNext(ele->getNext());
      delete ele;
      return;
    }
  }
}

void PapayaList::deleteEntry(Connection * connection) {
  
  PapayaListElement * tmp = firstElement;

  if (!tmp)
    return;

  if (tmp->getConnection() == connection) {
    firstElement = tmp->getNext();
    delete tmp;
    return;
  }

  for (; tmp->getNext(); tmp = tmp->getNext()) {
    if (tmp->getNext()->getConnection() == connection) {
      PapayaListElement * deleted = tmp->getNext();
      tmp->setNext(deleted->getNext());
      delete deleted;
      return;
    }
  }
}

void PapayaList::deleteAll() {
  PapayaListElement * tmp, * tmp_next;

  for (tmp = firstElement; tmp; tmp = tmp_next) {
    tmp_next = tmp->getNext();

    delete tmp;
  }

  firstElement = (PapayaListElement *)NULL;
}


/**
 * Generic list element.
 */

PapayaListElement::PapayaListElement() {
  next = (PapayaListElement *)NULL;
  connection = (Connection *)NULL;
  data = NULL;
}

PapayaListElement::~PapayaListElement() {
  // Not really sure if we want to do this here, or have the data creator nuke it.
  if (data)
    free (data);
}

void PapayaListElement::setNext(PapayaListElement * n) {
  next = n;
}

PapayaListElement * PapayaListElement::getNext() {
  return next;
}

void PapayaListElement::setConnection(Connection * c) {
  connection = c;
}

Connection * PapayaListElement::getConnection() {
  return connection;
}

void PapayaListElement::setData(void * d) {
  data = d;
}

void * PapayaListElement::getData() {
  return data;
}
