#include "papaya/system.h"
#include "Telnet.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct lookup_table {
    int value;
    const char *name;
};

static lookup_table commands_table[] =
{
    { Telnet::IAC, "IAC" },
    { Telnet::DONT, "DONT" },
    { Telnet::DO, "DO" },
    { Telnet::WONT, "WONT" },
    { Telnet::WILL, "WILL" },
    { Telnet::SB, "SB" },
    { Telnet::GA, "GA" },
    { Telnet::EL, "EL" },
    { Telnet::EC, "EC" },
    { Telnet::AYT, "AYT" },
    { Telnet::AO, "AO" },
    { Telnet::IP, "IP" },
    { Telnet::BREAK, "BREAK" },
    { Telnet::DM, "DM" },
    { Telnet::NOP, "NOP" },
    { Telnet::SE, "SE" },
    { Telnet::EOR, "EOR" },
    { Telnet::ABORT, "ABORT" },
    { Telnet::SUSP, "SUSP" },
    { Telnet::xEOF, "xEOF" },
    { Telnet::BOGUS_EOR, "BOGUS_EOR" },
    { -1, NULL }
};

static lookup_table options_table[] = 
{
    { Telnet::BINARY, "BINARY" },
    { Telnet::ECHO, "ECHO" },
    { Telnet::RCP, "RCP" },
    { Telnet::SGA, "SGA" },
    { Telnet::NAMS, "NAMS" },
    { Telnet::STATUS, "STATUS" },
    { Telnet::TM, "TM" },
    { Telnet::RCTE, "RCTE" },
    { Telnet::NAOL, "NAOL" },
    { Telnet::NAOP, "NAOP" },
    { Telnet::NAOCRD, "NAOCRD" },
    { Telnet::NAOHTS, "NAOHTS" },
    { Telnet::NAOHTD, "NAOHTD" },
    { Telnet::NAOFFD, "NAOFFD" },
    { Telnet::NAOVTS, "NAOVTS" },
    { Telnet::NAOVTD, "NAOVTD" },
    { Telnet::NAOLFD, "NAOLFD" },
    { Telnet::XASCII, "XASCII" },
    { Telnet::LOGOUT, "LOGOUT" },
    { Telnet::BM, "BM" },
    { Telnet::DET, "DET" },
    { Telnet::SUPDUP, "SUPDUP" },
    { Telnet::SUPDUPOUTPUT, "SUPDUPOUTPUT" },
    { Telnet::SNDLOC, "SNDLOC" },
    { Telnet::TTYPE, "TTYPE" },
    { Telnet::OPT_EOR, "EOR" },
    { Telnet::TUID, "TUID" },
    { Telnet::OUTMRK, "OUTMRK" },
    { Telnet::TTYLOC, "TTYLOC" },
    { Telnet::OPT_3270REGIME, "3270REGIME" },
    { Telnet::X3PAD, "X3PAD" },
    { Telnet::NAWS, "NAWS" },
    { Telnet::TSPEED, "TSPEED" },
    { Telnet::LFLOW, "LFLOW" },
    { Telnet::LINEMODE, "LINEMODE" },
    { Telnet::XDISPLOC, "XDISPLOC" },
    { Telnet::OLD_ENVIRON, "OLD_ENVIRON" },
    { Telnet::AUTHENTICATION, "AUTHENTICATION" },
    { Telnet::ENCRYPT, "ENCRYPT" },
    { Telnet::NEW_ENVIRON, "NEW_ENVIRON" },
    { Telnet::COMPRESS, "COMPRESS" },
    { Telnet::COMPRESS2, "COMPRESS2" },
    { Telnet::TURF_HTTPD, "TURF_HTTPD" },
    { Telnet::EXOPL, "EXOPL" },
    { -1, NULL }
};

const char *
Telnet::option_name(Telnet::option_t opt)
{
    for (int i = 0; options_table[i].name; ++i)
	if (options_table[i].value == (int)opt)
	    return options_table[i].name;

    static char buf[20];
    snprintf(buf, 20, "option-%d", (int)opt);
    return buf;
}

const char *
Telnet::command_name(Telnet::command_t cmd)
{
    for (int i = 0; commands_table[i].name; ++i)
	if (commands_table[i].value == (int)cmd)
	    return commands_table[i].name;
    
    static char buf[20];
    snprintf(buf, 20, "command-%d", (int)cmd);
    return buf;
}

Telnet::option_t
Telnet::option_value(const char *name)
{
    if (!strncmp(name, "option-", 7))
    {
	char *endptr;
	long opt = strtol(name+7, &endptr, 10);
	if (name[7] && !*endptr)
	    return (Telnet::option_t) opt;
	return Telnet::BAD_OPTION;
    }
    
    for (int i = 0; options_table[i].name; ++i)
	if (!strcmp(options_table[i].name, name))
	    return (Telnet::option_t)options_table[i].value;
    
    return Telnet::BAD_OPTION;
}

Telnet::command_t
Telnet::command_value(const char *name)
{
    if (!strncmp(name, "command-", 8))
    {
	char *endptr;
	long opt = strtol(name+8, &endptr, 10);
	if (name[8] && !*endptr)
	    return (Telnet::command_t) opt;
	return Telnet::BAD_COMMAND;
    }
    
    for (int i = 0; commands_table[i].name; ++i)
	if (!strcmp(commands_table[i].name, name))
	    return (Telnet::command_t)commands_table[i].value;
    
    return Telnet::BAD_COMMAND;
}

