#include <list>
#include <algorithm>
#include <stdio.h>

#include "BSXScene.h"

BSXScene::BSXScene() {
  scene = NULL;
}

BSXScene::~BSXScene() {
  reset();
}

void BSXScene::reset() {

  // Don't free anything in here as these are cached items.

  if (scene)
    scene = NULL;

  // Remove the entries from the object list.
  ObjectList::iterator next;
  for (ObjectList::iterator i = objects.begin();
       i != objects.end();
       i = next) {
    next = i;
    ++next;

    objects.erase(i);
  }

}

void BSXScene::setScene(BSXCacheEntry * s) {
  scene = s;
}

int EntryCmp(BSXObject * o1, BSXObject * o2) {
  
  if (!o1 || !o2)
    return (o1 < o2);
  
  return (o1->y < o2->y);
}

int BSXScene::stringToHex(char * string) {

  int result = 0;

  sscanf(string, "%x", &result);
  return result;
}

void BSXScene::removeObject(BSXCacheEntry * centry) {

  BSXObject * o = NULL;
  ObjectList::iterator i;

  for (i = objects.begin();
       i != objects.end();
       ++i) {
    if ((*i)->entry == centry) {
      o = (*i);
      break;
    }
  }

  if (!o)
    return;

  i = std::lower_bound(objects.begin(),
					    objects.end(),
					    o,
					    EntryCmp);

  if (i == objects.end() || (*i) != o)
    return;

  objects.erase(i);
}

void BSXScene::addObject(BSXCacheEntry * centry, char * location) {

  // If there is already an object of this cache entry in the scene,
  // just update its location

  ObjectList::iterator i;

  for (i = objects.begin();
       i != objects.end();
       ++i) {
    if ((*i)->entry == centry) {
      char buf[3];
      buf[2] = '\0';
      
      buf[0] = location[0];
      buf[1] = location[1];
      (*i)->x = stringToHex(buf);
      
      buf[0] = location[2];
      buf[1] = location[3];
      (*i)->y = stringToHex(buf);

      return;
    }
  }

  // This object wasn't present in the scene already, add it.
  BSXObject * o = (BSXObject *)malloc(sizeof(BSXObject));

  o->entry = centry;

  char buf[3];
  buf[2] = '\0';

  buf[0] = location[0];
  buf[1] = location[1];
  o->x = stringToHex(buf);
  
  buf[0] = location[2];
  buf[1] = location[3];
  o->y = stringToHex(buf);

  i = std::lower_bound(objects.begin(),
					    objects.end(),
					    o,
					    EntryCmp);

  objects.insert(i, o);
}

BSXCacheEntry * BSXScene::getScene() {
  return scene;
}

/**
 * This function is empty in this class.  Generally this class is inherited
 * by a class that implements this function in an output dependent format.
 */

void BSXScene::redraw() {
}
