# Battleships for Papaya using the Turf Client Protocol

# BATTLESHIP.wannaplay
# BATTLESHIP.willplay
# BATTLESHIP.challenge
# BATTLESHIP.deny
# BATTLESHIP.gameon

# BATTLESHIP.ready : done placing ships
# BATTLESHIP.yield : surrender message
# BATTLESHIP.shot x y : send a shot to x y
# BATTLESHIP.hit : last shot sent was a hit
# BATTLESHIP.miss : last shot sent missed
# BATTLESHIP.idiot : last shot sent was in a taken slot
# BATTLESHIP.sink : last shot sent sunk something
# BATTLESHIP.bbox x1 y1 x2 y2 : sends bounding boxes for all ships to show ship locations at the end of the game

import papaya
import re

from gtk import *
from GdkImlib import *
from GDK import *

TARGET_STRING = 0
TARGET_ROOTWIN = 1

target = [
('STRING', 0, TARGET_STRING),
('text/plain', 0, TARGET_STRING),
('application/x-rootwin-drop', 0, TARGET_ROOTWIN)]

# You or the other player has said yes, we'll play
def battleship_accept(player, mode):
# @@ Insert code.
    return

# You or the other player has declined to play.
def battleship_decline(player):
    return

def battleship_client_protocol(input):
    global parser

    result = parser.match(input)
    if result == None:
        return input

    player = result.group(1)
    game = result.group(2)
    cmd = result.group(3)
    arg = result.group(4)

    if game == 'BATTLESHIP':
        if cmd == 'ready':
            battleship_ready_from(papaya_connection)
            return

        if cmd == 'yield':
            battleship_yield(papaya_connection)
            return

        if cmd == 'shot':
            battleship_shot(papaya_connection, arg)
            return

        if cmd == 'hit':
            battleship_hit(papaya_connection)
            return

        if cmd == 'miss':
            battleship_miss(papaya_connection)
            return

        if cmd == 'idiot':
            battleship_idiot(papaya_connection)
            return

        if cmd == 'sink':
            battleship_sink(papaya_connection)
            return

        if cmd == 'bbox':
            battleship_bbox(papaya_connection, arg)
            return

    return input

arg_parser = re.compile(" ([0-9]) ([0-9])")

def battleship_ready_from(conn):
    global battleship_myturn
    # This indicates that the other person is ready to start playing...

    # We should check this as well as if it's our time before we start
    # firing or accepting shots from the other player.

    # Whoever sends the ready first is the player that goes first.
    if battleship_myturn[conn] == -1:
        battleship_myturn[conn] = 0

    if battleship_myturn[conn] == -2:
        battleship_myturn[conn] = 1

def battleship_shot(conn, params):
    global battleship_data
    global battleship_ships
    global turfgame_playing

    player = turfgame_playing["BATTLESHIP"][conn]
    result = arg_parser.match(params)

    x = int(result.group(1))
    y = int(result.group(2))

    data = battleship_data[conn][0]
    if data[x][y] == 6 or data[x][y] == 7:
        # Already tried here
        papaya.send("c15 c" + player + " BATTLESHIP.idiot")
        return

    # Is this a hit or miss?

    hit = 0
    for i in [0,1,2,3,4]:
        ship = battleship_ships[conn][i]

        if ship['orientation'] == 'horizontal':
            if y == ship['y']:
                if x >= ship['x'] and x <= ship['x'] + ship['length']:
                    # Hit
                    hit = 1
                    break
        else:
            if ship['orientation'] == 'vertical':
                if x == ship['x']:
                    if y >= ship['y'] and y <= ship['y'] + ship['length']:
                        hit = 1
                        break

    if hit == 0:
        papaya.send("c15 c" + player + " BATTLESHIP.miss")
        battleship_data[conn][0] = 7
    else:
        papaya.send("c15 c" + player + " BATTLESHIP.hit")
        battleship_data[conn][0] = 6

                
def battleship_create_board(conn):

    global turfgame_playing
    global battleship_windows
    global battleship_boards
    global battleship_ready

    player = turfgame_playing["BATTLESHIP"][conn]

    window = GtkWindow(WINDOW_TOPLEVEL)
    window.set_title(conn + " - Battleships vs " + player)
    window.show()

    battleship_windows[conn] = window

    battleship_boards[conn] = {}

    battleship_boards[conn][0] = battleship_create_gameboard(conn, 0)
    battleship_boards[conn][1] = battleship_create_gameboard(conn, 1)

    battleship_update_gameboard(conn, 0)
    battleship_update_gameboard(conn, 1)

    vbox = GtkVBox(FALSE, 4)
    vbox.show()
    window.add(vbox)

    vbox.pack_start(battleship_boards[conn][0])
    vbox.pack_start(battleship_boards[conn][1])

    hbuttonbox = GtkHButtonBox()
    hbuttonbox.show()

    quit_button = GtkButton("Quit Game")
    quit_button.show()
    quit_button.connect("clicked", battleship_quit_clicked, conn)

    ready_button = GtkButton("Start Game")
    ready_button.show()
    ready_button.connect("clicked", battleship_ready_clicked, conn)

    hbuttonbox.pack_start(quit_button)
    hbuttonbox.pack_start(ready_button)

    battleship_ready[conn] = ready_button
    
    vbox.pack_start(hbuttonbox)

    entry = GtkEntry()
    entry.show()
    entry.set_editable(FALSE)
    vbox.pack_start(entry)

    entry.set_text("Place your ships.")

    battleship_boards[conn] = window

def battleship_ready_clicked(widget, conn):
    global battleship_ready
    global papaya_connection
    global battleship_myturn
    
    battleship_ready[conn].hide()
    
    papaya_connection = conn
    papaya.send("c15 c" + turfgame_playing["BATTLESHIP"][conn] + " BATTLESHIP.ready")
    if battleship_myturn[conn] < 0:
        battleship_myturn[conn] = -2

def battleship_quit_clicked(widget, conn):
    global battleship_boards
    global turfgame_playing
    global papaya_connection

    battleship_boards[conn].destroy()
    del battleship_boards[conn]

    papaya_connection = conn
    papaya.send("c15 c" + turfgame_playing["BATTLESHIP"][conn] + " BATTLESHIP.yield")

# Generic gameboard creation routine
def battleship_create_gameboard(conn, side):
    global battleship_gameboard_squares
    global battleship_data
    global battleship_gameboard_table
    global battleship_ships
    
    if battleship_data.has_key(conn) == 0:
        battleship_data[conn] = {}

    battleship_data[conn][side] = {}

    for i in [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]:
        battleship_data[conn][side][i] = {}
        for j in [0, 1, 2, 3, 4, 5, 6, 7, 8 ,9]:
            battleship_data[conn][side][i][j] = '0'

    # Initialise the default ship locations.
    data = battleship_data[conn][side]

    if side == 0:
        battleship_ships[conn] = {}
        for i in [0,1,2,3,4]:
            battleship_ships[conn][i] = {}
            battleship_ships[conn][i]['orientation'] = 'vertical'
            battleship_ships[conn][i]['x'] = i;
            battleship_ships[conn][i]['y'] = 0;

        battleship_ships[conn][0]['length'] = 2
        battleship_ships[conn][1]['length'] = 3
        battleship_ships[conn][2]['length'] = 3
        battleship_ships[conn][3]['length'] = 4
        battleship_ships[conn][4]['length'] = 5

        battleship_ships[conn][0]['image'] = battleship_images['2']
        battleship_ships[conn][1]['image'] = battleship_images['3']
        battleship_ships[conn][2]['image'] = battleship_images['3']
        battleship_ships[conn][3]['image'] = battleship_images['4']
        battleship_ships[conn][4]['image'] = battleship_images['5']

        battleship_ships[conn][0]['mask'] = battleship_masks['2']
        battleship_ships[conn][1]['mask'] = battleship_masks['3']
        battleship_ships[conn][2]['mask'] = battleship_masks['3']
        battleship_ships[conn][3]['mask'] = battleship_masks['4']
        battleship_ships[conn][4]['mask'] = battleship_masks['5']

    ## Board starts like this until ships are placed.
    # 0 = default

    ## Things that only apply to own board except at end
    # 1 = empty
    # 2-5 unused
    ## Things that only apply to other board
    # 6 = hit
    # 7 = miss

    ## Create the widgets that draw the board.
    if side == 0:
        frame = GtkFrame("Your Ships")
    else:
        frame = GtkFrame("Opponent's Ships")
    frame.show()

    table = GtkTable(9, 9);
    table.drag_dest_set(DEST_DEFAULT_ALL, target, ACTION_COPY|ACTION_MOVE)
    table.show()

    table.connect('drag_data_received', battleship_ship_dropped, conn)

    frame.add(table)

    # Create the hit and miss pixmap widgets and place them
    squares = {}
    for i in [0,1,2,3,4,5,6,7,8,9]:
        squares[i] = {}
        for j in [0,1,2,3,4,5,6,7,8,9]:
            squares[i][j] = GtkPixmap(battleship_images['0'], battleship_masks['0'])
            squares[i][j].show()
            table.attach(squares[i][j], i, i + 1, j, j + 1)

    # Create the pixmap widgets for all the ships and place them
    if side == 0:
        for i in [0,1,2,3,4]:
            current_ship = battleship_ships[conn][i]

            ship = GtkPixmap(current_ship['image'], current_ship['mask'])
            ship.show()
            
            event = GtkEventBox()
            event.show()
            
            event.add(ship)
            # Set up Drag 'n' Drop
            
            colormap = battleship_windows[conn].get_colormap()
            
            event.drag_source_set(BUTTON1_MASK, target, ACTION_COPY|ACTION_MOVE)

            event.drag_source_set_icon(colormap, current_ship['image'], current_ship['mask'])

            # @@ Can we set the co-ordinates of the icon where the pointer is?
            
            # Connect Drag 'n' Drop events
            event.connect('drag_data_get', battleship_drag_data_get, (conn, i))

            # Attach the ship to the table into the appropriate location
            if current_ship['orientation'] == 'horizontal':
                table.attach(event, current_ship['x'], current_ship['x'] + current_ship['length'] + 1, current_ship['y'], current_ship['y'] + 1)
            else:
                table.attach(event, current_ship['x'], current_ship['x'] + 1, current_ship['y'], current_ship['y'] + current_ship['length'] + 1)

                current_ship['pixmap'] = ship
                current_ship['event'] = event

    # Ensure that the gameboard squares are saved globally
    if battleship_gameboard_squares.has_key(conn) == 0:
        battleship_gameboard_squares[conn] = {}

    battleship_gameboard_squares[conn][side] = squares
    if side == 0:
        battleship_gameboard_table[conn] = table
    return frame

def battleship_ship_dropped(widget, dc, x, y, sel_data, info, t, conn):
    global battleship_ships
    
    ship = int(sel_data.data)
    
    # Need to translate x,y into sane co-ordinates
    (xco, yco) = widget.get_pointer()

    x = (int)(xco / 20);
    y = (int)(yco / 20);

    # Which ship and which connection
    current_ship = battleship_ships[conn][ship]

    print "Orientation: " + current_ship['orientation']
    print "Length: %d" % current_ship['length']

    if current_ship['orientation'] == 'vertical':
        if current_ship['length'] + yco > 9:
            # Don't let the damn thing drop... how to cancel drag n drop?
            print "Telling it drag is unsuccessful."
            widget.drag_finish(dc, FALSE, FALSE, t)

    if current_ship['orientation'] == 'horizontal':
        if current_ship['length'] + xco > 9:
            widget.drag_finish(dc, FALSE, FALSE, t)

    current_ship['x'] = x
    current_ship['y'] = y

    battleship_update_gameboard(conn, 0)

def battleship_drag_data_get(widget, context, sel_data, info, time, data):
    global battleship_ships

    # @@ All this faffing around didn't make the center of the image the
    # @@ important bit, it's still the top left corner :(

    conn = data[0]
    ship = data[1]

    currentship = battleship_ships[conn][ship]

    x = 10
    if ship == 0:
        y = 20
    else:
        if ship == 1 or ship == 2:
            y = 30
        else:
            if ship == 3:
                y = 40
            else:
                y = 50
                
    sel_data.set(sel_data.target, 8, "%d" % ship)

    colormap = battleship_windows[conn].get_colormap()
    widget.drag_set_icon_pixmap(context, colormap, currentship['image'], currentship['mask'], x, y)

    return

def battleship_drag_data_delete():
    return

def battleship_update_gameboard(conn, side):
    global battleship_gameboard_squares
    global battleship_data
    global battleship_gameboard_table

    table = battleship_gameboard_table[conn]
    data = battleship_data[conn][side]

    squares = battleship_gameboard_squares[conn][side]

    for i in [0,1,2,3,4,5,6,7,8,9]:
        for j in [0,1,2,3,4,5,6,7,8,9]:
            image = battleship_images[data[i][j]]
            mask = battleship_masks[data[i][j]]
            # Update the image in the square
            squares[i][j].set(image, mask)

    if side == 0:
        for i in [0,1,2,3,4]:
            current_ship = battleship_ships[conn][i]
            ship = current_ship['pixmap']
            event = current_ship['event']
            
            table.remove(event)
            if current_ship['orientation'] == 'horizontal':
                table.attach(event, current_ship['x'], current_ship['x'] + current_ship['length'] + 1, current_ship['y'], current_ship['y'] + 1)
            else:
                table.attach(event, current_ship['x'], current_ship['x'] + 1, current_ship['y'], current_ship['y'] + current_ship['length'] + 1)

##
# Accept function
##

def battleship_accept(player, mode):
    global turfgame_playing
    global battleship_myturn
    
    conn = None
    for c in turfgame_playing["BATTLESHIP"]:
        if turfgame_playing["BATTLESHIP"][c] == player:
            conn = c

    if conn == None:
        return

    battleship_create_board(conn)
    battleship_myturn[conn] = -1
    
def battleship_decline(player):
    return

def battleship_terminate(player):
    # @@ Nuke the board and display a message saying that the other person resigned
    global battleship_boards

    battleship_boards[papaya_connection].destroy()
    del battleship_boards[papaya_connection]

    papaya.message("Battleships", player + " has conceded the game to you.");

def battleship_reset(player):
    return

def battleship_init():
    global battleship_images
    global battleship_masks

    global battleship_data
    global battleship_gameboard_squares
    global battleship_boards
    global battleship_windows
    global battleship_ships
    global battleship_gameboard_table
    
    global battleship_myturn
    global battleship_ready
    
    battleship_images = {}
    battleship_masks = {}

    battleship_boards = {}
    battleship_gameboard_squares = {}
    battleship_gameboard_table = {}
    battleship_data = {}
    battleship_myturn = {}
    battleship_ready = {}
    battleship_ships = {}
    battleship_windows = {}
    
    # Do this for each image used in battleships

    for i in ['0','1','2','3','4','5','6','7']:
        image = create_image_from_xpm(battleship_image_data[i])
        image.render()
        pixmap, mask = image.get_pixmap()

        battleship_images[i] = pixmap
        battleship_masks[i] = mask

    # @@ Perform other variable initialisation here.



    # Register with the turfgame plugin
    turfgame_register("BATTLESHIP", battleship_accept, battleship_decline, battleship_terminate, battleship_reset)
    papaya.turf_add("battleship_client_protocol")

# Define the XPM images for the battleships.

battleship_image_data = {}

battleship_image_data['7'] = [
    "20 20 2 1",
    " 	c None",
    ".	c #FF0000",
    "                    ",
    "                    ",
    "                    ",
    "           ....     ",
    "    ....  .....     ",
    "    ...........     ",
    "    ..........      ",
    "     .......        ",
    "     ......         ",
    "     .......        ",
    "    .........       ",
    "    .... ....       ",
    "    ...  .....      ",
    "    ...   ....      ",
    "          ...       ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    "]

battleship_image_data['6'] = [
    "20 20 2 1",
    "       c None",
    ".      c #13E209",
    "                    ",
    "                    ",
    "                ... ",
    "              ..... ",
    "            ....... ",
    "           .......  ",
    "          ......    ",
    "         ......     ",
    "         ....       ",
    "        ....        ",
    "  ..... ....        ",
    " ..........         ",
    "  .........         ",
    "    .......         ",
    "     .....          ",
    "     .....          ",
    "      ...           ",
    "                    ",
    "                    ",
    "                    "]

battleship_image_data['5'] = [
    "20 100 2 1",
    "       c None",
    ".      c #000000",
    "                    ",
    "          .         ",
    "         ...        ",
    "        .....       ",
    "       ..   ..      ",
    "      ..    ..      ",
    "     ..      ..     ",
    "     ..      ..     ",
    "     .       ..     ",
    "     .        .     ",
    "    ..        ..    ",
    "    ..        ..    ",
    "   ..         ..    ",
    "   ..          ..   ",
    "   ..          ..   ",
    "   .           ..   ",
    "  ..           ..   ",
    "  ..  ..   ..   ..  ",
    "  ..  ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .    .   .    ..  ",
    "  .    .   .    ..  ",
    "  .    .   .    ..  ",
    "  .   ..   .    ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..    .   ..  ",
    "  .    .    .   ..  ",
    "  .    .    .   ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .      ..     ..  ",
    "  .    ......   ..  ",
    "  .   ...   ..  ..  ",
    "  .  ..      .. ..  ",
    "  .  ..  ...  ....  ",
    "  .  .  ....  ....  ",
    "  . .. ..  .. ....  ",
    "  . .. ..  .. ....  ",
    "  . .  .   .. ....  ",
    "  . .  .   .. ....  ",
    "  ...  .   .. ....  ",
    "  ...  .   .  ....  ",
    "  ...  .....  . ..  ",
    " .. .   ...  .. ..  ",
    " .. ..      ..  ..  ",
    " .. ..      ..  ..  ",
    " ..  ...   ..   ..  ",
    " ..   ......    ..  ",
    " ..     ..      ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..        ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..   .    ..  ",
    " ..    .        ..  ",
    " ..             ..  ",
    " ..             ..  ",
    "  .             ..  ",
    "  ..            ..  ",
    "  ..            ..  ",
    "   .            ..  ",
    "   ..          ..   ",
    "    .          ..   ",
    "    ..         ..   ",
    "    ..        ..    ",
    "     .        ..    ",
    "     ..      ..     ",
    "     ..      ..     ",
    "      ..    ..      ",
    "       ..  ..       ",
    "        ....        ",
    "         ..         ",
    "                    ",
    "                    ",
    "                    ",
    "                    "]

battleship_image_data['4'] = [
    "20 80 2 1",
    "       c None",
    ".      c #000000",
    "                    ",
    "         ..         ",
    "        .....       ",
    "       ..   ..      ",
    "      ..    ..      ",
    "     ..      ..     ",
    "     .       ..     ",
    "     .        .     ",
    "    ..        ..    ",
    "    .         ..    ",
    "   ..          .    ",
    "   ..          ..   ",
    "  ..           ..   ",
    "  ..   .   ..   .   ",
    "  ..  ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .    .   ..   ..  ",
    "  .    .   .    ..  ",
    "  .    .   .    ..  ",
    "  .    .   .    ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..    .   ..  ",
    "  .    .    .   ..  ",
    "  .    .        ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .    .... .   ..  ",
    "  .   ...   ..  ..  ",
    "  .  ..      .. ..  ",
    "  .  .   ...  ....  ",
    "  . .. ... .  ....  ",
    "  . .. ..  .. ....  ",
    "  . .  .   .. ....  ",
    "  . .  .   .. ....  ",
    "  ...  .   .. ....  ",
    "  ...  .....  . ..  ",
    " .. .   ...  .. ..  ",
    " .. ..      ..  ..  ",
    " ..  ..    ..   ..  ",
    " ..   ......    ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..        ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..    .   .    ..  ",
    " ..             ..  ",
    " ..             ..  ",
    "  .             ..  ",
    "  ..            ..  ",
    "   .            ..  ",
    "   ..          ..   ",
    "    .          ..   ",
    "    ..         .    ",
    "     .        ..    ",
    "     ..      ..     ",
    "      ..    ...     ",
    "       ..  ...      ",
    "        .....       ",
    "         ..         ",
    "                    ",
    "                    ",
    "                    "]

battleship_image_data['3'] = [
    "20 60 2 1",
    "       c None",
    ".      c #000000",
    "                    ",
    "         ...        ",
    "       ... ..       ",
    "      ..     .      ",
    "     ..      ..     ",
    "     .        .     ",
    "    ..        ..    ",
    "   ..         ..    ",
    "   ..          ..   ",
    "  ..           ..   ",
    "  ..  ..   ..   ..  ",
    "  ..  ..   ..   ..  ",
    "  .    .   ..   ..  ",
    "  .    .   .    ..  ",
    "  .    .   .    ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..    .   ..  ",
    "  .    .    .   ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .      ..     ..  ",
    "  .   ...   ..  ..  ",
    "  .  ..      .. ..  ",
    "  .  .  ....  ....  ",
    "  . .. ..  .. ....  ",
    "  . .  .   .. ....  ",
    "  . .  .   .. ....  ",
    "  ...  .....  . ..  ",
    " .. .   ..   .. ..  ",
    " .. ..      ..  ..  ",
    " ..   ......    ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..        ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   .    ..  ",
    " ..   ..   .    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..    .   .    ..  ",
    " ..             ..  ",
    " ..             ..  ",
    "  ..            ..  ",
    "  ..            ..  ",
    "   ..          ..   ",
    "    ..         ..   ",
    "    ..        ..    ",
    "     ..      ..     ",
    "      ..    ..      ",
    "        .....       ",
    "         ..         ",
    "                    ",
    "                    "]

battleship_image_data['2'] = [
    "20 40 2 1",
    "       c None",
    ".      c #000000",
    "                    ",
    "        .. ..       ",
    "      ..     .      ",
    "     .        .     ",
    "    ..        ..    ",
    "   ..          ..   ",
    "  ..           ..   ",
    "  ..  ..   ..   ..  ",
    "  .    .   ..   ..  ",
    "  .    .   .    ..  ",
    "  .   ..   ..   ..  ",
    "  .   ..   ..   ..  ",
    "  .    .    .   ..  ",
    "  .             ..  ",
    "  .             ..  ",
    "  .    ...  ..  ..  ",
    "  .  ..   .  .. ..  ",
    "  . .. ..  .. ....  ",
    "  . .  .   .. ....  ",
    "  ...  .   .  . ..  ",
    " .. .       ... ..  ",
    " ..  ...  ...   ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..             ..  ",
    " ..        ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   ..   ..  ",
    " ..   ..   .    ..  ",
    " ..   ..  ..    ..  ",
    " ..   ..  ..    ..  ",
    " ..             ..  ",
    "  .             ..  ",
    "  ..            ..  ",
    "   ..          ..   ",
    "    ..        ..    ",
    "     ..      ..     ",
    "       ..  ..       ",
    "                    ",
    "                    "]

battleship_image_data['1'] = [
    "20 20 1 1",
    "       c None",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    ",
    "                    "]

battleship_image_data['0'] = battleship_image_data['1']

battleship_init()
