/*****************************************************************************
*
* Copyright (c) 2000 - 2007, The Regents of the University of California
* Produced at the Lawrence Livermore National Laboratory
* All rights reserved.
*
* This file is part of VisIt. For details, see http://www.llnl.gov/visit/. The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or materials provided with the distribution.
*  - Neither the name of the UC/LLNL nor  the names of its contributors may be
*    used to  endorse or  promote products derived from  this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED.  IN  NO  EVENT  SHALL  THE  REGENTS  OF  THE  UNIVERSITY OF
* CALIFORNIA, THE U.S.  DEPARTMENT  OF  ENERGY OR CONTRIBUTORS BE  LIABLE  FOR
* ANY  DIRECT,  INDIRECT,  INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef VOLUMEATTRIBUTES_H
#define VOLUMEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>
#include <ColorControlPointList.h>
#include <GaussianControlPointList.h>

// ****************************************************************************
// Class: VolumeAttributes
//
// Purpose:
//    This class contains the plot attributes for the volume plot.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Mar 13 14:48:05 PST 2007
//
// Modifications:
//   
// ****************************************************************************

class VolumeAttributes : public AttributeSubject
{
public:
    enum Renderer
    {
        Splatting,
        Texture3D,
        RayCasting,
        RayCastingIntegration
    };
    enum GradientType
    {
        CenteredDifferences,
        SobelOperator
    };
    enum Scaling
    {
        Linear,
        Log10,
        Skew
    };
    enum SamplingType
    {
        KernelBased,
        Rasterization
    };

    VolumeAttributes();
    VolumeAttributes(const VolumeAttributes &obj);
    virtual ~VolumeAttributes();

    virtual VolumeAttributes& operator = (const VolumeAttributes &obj);
    virtual bool operator == (const VolumeAttributes &obj) const;
    virtual bool operator != (const VolumeAttributes &obj) const;

    virtual const vtkstd::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const vtkstd::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColorControlPoints();
    void SelectOpacityControlPoints();
    void SelectOpacityVariable();
    void SelectFreeformOpacity();

    // Property setting methods
    void SetLegendFlag(bool legendFlag_);
    void SetLightingFlag(bool lightingFlag_);
    void SetColorControlPoints(const ColorControlPointList &colorControlPoints_);
    void SetOpacityAttenuation(float opacityAttenuation_);
    void SetFreeformFlag(bool freeformFlag_);
    void SetOpacityControlPoints(const GaussianControlPointList &opacityControlPoints_);
    void SetResampleTarget(int resampleTarget_);
    void SetOpacityVariable(const vtkstd::string &opacityVariable_);
    void SetFreeformOpacity(const unsigned char *freeformOpacity_);
    void SetUseColorVarMin(bool useColorVarMin_);
    void SetColorVarMin(float colorVarMin_);
    void SetUseColorVarMax(bool useColorVarMax_);
    void SetColorVarMax(float colorVarMax_);
    void SetUseOpacityVarMin(bool useOpacityVarMin_);
    void SetOpacityVarMin(float opacityVarMin_);
    void SetUseOpacityVarMax(bool useOpacityVarMax_);
    void SetOpacityVarMax(float opacityVarMax_);
    void SetSmoothData(bool smoothData_);
    void SetSamplesPerRay(int samplesPerRay_);
    void SetRendererType(Renderer rendererType_);
    void SetGradientType(GradientType gradientType_);
    void SetNum3DSlices(int num3DSlices_);
    void SetScaling(Scaling scaling_);
    void SetSkewFactor(double skewFactor_);
    void SetSampling(SamplingType sampling_);

    // Property getting methods
    bool                           GetLegendFlag() const;
    bool                           GetLightingFlag() const;
    const ColorControlPointList    &GetColorControlPoints() const;
          ColorControlPointList    &GetColorControlPoints();
    float                          GetOpacityAttenuation() const;
    bool                           GetFreeformFlag() const;
    const GaussianControlPointList &GetOpacityControlPoints() const;
          GaussianControlPointList &GetOpacityControlPoints();
    int                            GetResampleTarget() const;
    const vtkstd::string              &GetOpacityVariable() const;
          vtkstd::string              &GetOpacityVariable();
    const unsigned char            *GetFreeformOpacity() const;
          unsigned char            *GetFreeformOpacity();
    bool                           GetUseColorVarMin() const;
    float                          GetColorVarMin() const;
    bool                           GetUseColorVarMax() const;
    float                          GetColorVarMax() const;
    bool                           GetUseOpacityVarMin() const;
    float                          GetOpacityVarMin() const;
    bool                           GetUseOpacityVarMax() const;
    float                          GetOpacityVarMax() const;
    bool                           GetSmoothData() const;
    int                            GetSamplesPerRay() const;
    Renderer                       GetRendererType() const;
    GradientType                   GetGradientType() const;
    int                            GetNum3DSlices() const;
    Scaling                        GetScaling() const;
    double                         GetSkewFactor() const;
    SamplingType                   GetSampling() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static vtkstd::string Renderer_ToString(Renderer);
    static bool Renderer_FromString(const vtkstd::string &, Renderer &);
protected:
    static vtkstd::string Renderer_ToString(int);
public:
    static vtkstd::string GradientType_ToString(GradientType);
    static bool GradientType_FromString(const vtkstd::string &, GradientType &);
protected:
    static vtkstd::string GradientType_ToString(int);
public:
    static vtkstd::string Scaling_ToString(Scaling);
    static bool Scaling_FromString(const vtkstd::string &, Scaling &);
protected:
    static vtkstd::string Scaling_ToString(int);
public:
    static vtkstd::string SamplingType_ToString(SamplingType);
    static bool SamplingType_FromString(const vtkstd::string &, SamplingType &);
protected:
    static vtkstd::string SamplingType_ToString(int);
public:

    // Keyframing methods
    virtual vtkstd::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual vtkstd::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const VolumeAttributes &obj) const;
    bool GradientWontChange(const VolumeAttributes &obj) const;
    void GetTransferFunction(unsigned char *rgba) const;
    void SetDefaultColorControlPoints();
    void GetGaussianOpacities(unsigned char *alphas) const;
    void GetOpacities(unsigned char *alphas);
    void SetSmoothingFlag(bool val);
    bool GetSmoothingFlag() const;
    void SetEqualSpacingFlag(bool val);
    bool GetEqualSpacingFlag() const;
private:
    bool                     legendFlag;
    bool                     lightingFlag;
    ColorControlPointList    colorControlPoints;
    float                    opacityAttenuation;
    bool                     freeformFlag;
    GaussianControlPointList opacityControlPoints;
    int                      resampleTarget;
    vtkstd::string              opacityVariable;
    unsigned char            freeformOpacity[256];
    bool                     useColorVarMin;
    float                    colorVarMin;
    bool                     useColorVarMax;
    float                    colorVarMax;
    bool                     useOpacityVarMin;
    float                    opacityVarMin;
    bool                     useOpacityVarMax;
    float                    opacityVarMax;
    bool                     smoothData;
    int                      samplesPerRay;
    int                      rendererType;
    int                      gradientType;
    int                      num3DSlices;
    int                      scaling;
    double                   skewFactor;
    int                      sampling;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
};

#endif
