/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtSymmetricTensorMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Init utility for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSymmetricTensorMetaData::Init()
{
    dim = 0;

    avtSymmetricTensorMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Copy utility for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSymmetricTensorMetaData::Copy(const avtSymmetricTensorMetaData &obj)
{
    dim = obj.dim;

    avtSymmetricTensorMetaData::SelectAll();
}

// Type map format string
const char *avtSymmetricTensorMetaData::TypeMapFormatString = AVTSYMMETRICTENSORMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtSymmetricTensorMetaData::TmfsStruct = {AVTSYMMETRICTENSORMETADATA_TMFS};


// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Default constructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData() : 
    avtVarMetaData(avtSymmetricTensorMetaData::TmfsStruct)
{
    avtSymmetricTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtSymmetricTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Copy constructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj) : 
    avtVarMetaData(obj,avtSymmetricTensorMetaData::TmfsStruct)
{
    avtSymmetricTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::avtSymmetricTensorMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(const avtSymmetricTensorMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtSymmetricTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::~avtSymmetricTensorMetaData
//
// Purpose: 
//   Destructor for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData::~avtSymmetricTensorMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSymmetricTensorMetaData& 
avtSymmetricTensorMetaData::operator = (const avtSymmetricTensorMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtSymmetricTensorMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSymmetricTensorMetaData::operator == (const avtSymmetricTensorMetaData &obj) const
{
    // Create the return value
    return ((dim == obj.dim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSymmetricTensorMetaData::operator != (const avtSymmetricTensorMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtSymmetricTensorMetaData::TypeName() const
{
    return "avtSymmetricTensorMetaData";
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSymmetricTensorMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtSymmetricTensorMetaData *tmp = (const avtSymmetricTensorMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSymmetricTensorMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtSymmetricTensorMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtSymmetricTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSymmetricTensorMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtSymmetricTensorMetaData(*this);
    else
        retval = new avtSymmetricTensorMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtSymmetricTensorMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSymmetricTensorMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_dim, (void *)&dim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtSymmetricTensorMetaData constructor
//
//  Arguments:
//      n           The name of the tensor variable.
//      mn          The name of the mesh the tensor var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//
//  Programmer: Hank Childs
//  Creation:   September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:52:39 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************

avtSymmetricTensorMetaData::avtSymmetricTensorMetaData(std::string n, std::string mn, 
                                     avtCentering c, int vd)
    : avtVarMetaData(avtSymmetricTensorMetaData::TmfsStruct, n, mn, c)
{
    avtSymmetricTensorMetaData::Init();
    dim = vd;
}

// ****************************************************************************
//  Method: avtSymmetricTensorMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:54:42 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtSymmetricTensorMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Variable Dimension = " << dim << endl;
}

