/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LinearTransformAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Init utility for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LinearTransformAttributes::Init()
{
    m00 = 1;
    m01 = 0;
    m02 = 0;
    m03 = 0;
    m10 = 0;
    m11 = 1;
    m12 = 0;
    m13 = 0;
    m20 = 0;
    m21 = 0;
    m22 = 1;
    m23 = 0;
    m30 = 0;
    m31 = 0;
    m32 = 0;
    m33 = 1;
    invertLinearTransform = false;
    transformVectors = true;

    LinearTransformAttributes::SelectAll();
}

// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Copy utility for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LinearTransformAttributes::Copy(const LinearTransformAttributes &obj)
{
    m00 = obj.m00;
    m01 = obj.m01;
    m02 = obj.m02;
    m03 = obj.m03;
    m10 = obj.m10;
    m11 = obj.m11;
    m12 = obj.m12;
    m13 = obj.m13;
    m20 = obj.m20;
    m21 = obj.m21;
    m22 = obj.m22;
    m23 = obj.m23;
    m30 = obj.m30;
    m31 = obj.m31;
    m32 = obj.m32;
    m33 = obj.m33;
    invertLinearTransform = obj.invertLinearTransform;
    transformVectors = obj.transformVectors;

    LinearTransformAttributes::SelectAll();
}

// Type map format string
const char *LinearTransformAttributes::TypeMapFormatString = LINEARTRANSFORMATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t LinearTransformAttributes::TmfsStruct = {LINEARTRANSFORMATTRIBUTES_TMFS};


// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Default constructor for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes::LinearTransformAttributes() : 
    AttributeSubject(LinearTransformAttributes::TypeMapFormatString)
{
    LinearTransformAttributes::Init();
}

// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Constructor for the derived classes of LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes::LinearTransformAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LinearTransformAttributes::Init();
}

// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Copy constructor for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes::LinearTransformAttributes(const LinearTransformAttributes &obj) : 
    AttributeSubject(LinearTransformAttributes::TypeMapFormatString)
{
    LinearTransformAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LinearTransformAttributes::LinearTransformAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes::LinearTransformAttributes(const LinearTransformAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LinearTransformAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LinearTransformAttributes::~LinearTransformAttributes
//
// Purpose: 
//   Destructor for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes::~LinearTransformAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LinearTransformAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LinearTransformAttributes& 
LinearTransformAttributes::operator = (const LinearTransformAttributes &obj)
{
    if (this == &obj) return *this;

    LinearTransformAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LinearTransformAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LinearTransformAttributes::operator == (const LinearTransformAttributes &obj) const
{
    // Create the return value
    return ((m00 == obj.m00) &&
            (m01 == obj.m01) &&
            (m02 == obj.m02) &&
            (m03 == obj.m03) &&
            (m10 == obj.m10) &&
            (m11 == obj.m11) &&
            (m12 == obj.m12) &&
            (m13 == obj.m13) &&
            (m20 == obj.m20) &&
            (m21 == obj.m21) &&
            (m22 == obj.m22) &&
            (m23 == obj.m23) &&
            (m30 == obj.m30) &&
            (m31 == obj.m31) &&
            (m32 == obj.m32) &&
            (m33 == obj.m33) &&
            (invertLinearTransform == obj.invertLinearTransform) &&
            (transformVectors == obj.transformVectors));
}

// ****************************************************************************
// Method: LinearTransformAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LinearTransformAttributes::operator != (const LinearTransformAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LinearTransformAttributes::TypeName
//
// Purpose: 
//   Type name method for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LinearTransformAttributes::TypeName() const
{
    return "LinearTransformAttributes";
}

// ****************************************************************************
// Method: LinearTransformAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LinearTransformAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LinearTransformAttributes *tmp = (const LinearTransformAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LinearTransformAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LinearTransformAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LinearTransformAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LinearTransformAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LinearTransformAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LinearTransformAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LinearTransformAttributes(*this);
    else
        retval = new LinearTransformAttributes;

    return retval;
}

// ****************************************************************************
// Method: LinearTransformAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LinearTransformAttributes::SelectAll()
{
    Select(ID_m00,                   (void *)&m00);
    Select(ID_m01,                   (void *)&m01);
    Select(ID_m02,                   (void *)&m02);
    Select(ID_m03,                   (void *)&m03);
    Select(ID_m10,                   (void *)&m10);
    Select(ID_m11,                   (void *)&m11);
    Select(ID_m12,                   (void *)&m12);
    Select(ID_m13,                   (void *)&m13);
    Select(ID_m20,                   (void *)&m20);
    Select(ID_m21,                   (void *)&m21);
    Select(ID_m22,                   (void *)&m22);
    Select(ID_m23,                   (void *)&m23);
    Select(ID_m30,                   (void *)&m30);
    Select(ID_m31,                   (void *)&m31);
    Select(ID_m32,                   (void *)&m32);
    Select(ID_m33,                   (void *)&m33);
    Select(ID_invertLinearTransform, (void *)&invertLinearTransform);
    Select(ID_transformVectors,      (void *)&transformVectors);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LinearTransformAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LinearTransformAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LinearTransformAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LinearTransformAttributes.
    DataNode *node = new DataNode("LinearTransformAttributes");

    if(completeSave || !FieldsEqual(ID_m00, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m00", m00));
    }

    if(completeSave || !FieldsEqual(ID_m01, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m01", m01));
    }

    if(completeSave || !FieldsEqual(ID_m02, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m02", m02));
    }

    if(completeSave || !FieldsEqual(ID_m03, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m03", m03));
    }

    if(completeSave || !FieldsEqual(ID_m10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m10", m10));
    }

    if(completeSave || !FieldsEqual(ID_m11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m11", m11));
    }

    if(completeSave || !FieldsEqual(ID_m12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m12", m12));
    }

    if(completeSave || !FieldsEqual(ID_m13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m13", m13));
    }

    if(completeSave || !FieldsEqual(ID_m20, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m20", m20));
    }

    if(completeSave || !FieldsEqual(ID_m21, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m21", m21));
    }

    if(completeSave || !FieldsEqual(ID_m22, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m22", m22));
    }

    if(completeSave || !FieldsEqual(ID_m23, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m23", m23));
    }

    if(completeSave || !FieldsEqual(ID_m30, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m30", m30));
    }

    if(completeSave || !FieldsEqual(ID_m31, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m31", m31));
    }

    if(completeSave || !FieldsEqual(ID_m32, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m32", m32));
    }

    if(completeSave || !FieldsEqual(ID_m33, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("m33", m33));
    }

    if(completeSave || !FieldsEqual(ID_invertLinearTransform, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("invertLinearTransform", invertLinearTransform));
    }

    if(completeSave || !FieldsEqual(ID_transformVectors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("transformVectors", transformVectors));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LinearTransformAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LinearTransformAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LinearTransformAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("m00")) != 0)
        SetM00(node->AsDouble());
    if((node = searchNode->GetNode("m01")) != 0)
        SetM01(node->AsDouble());
    if((node = searchNode->GetNode("m02")) != 0)
        SetM02(node->AsDouble());
    if((node = searchNode->GetNode("m03")) != 0)
        SetM03(node->AsDouble());
    if((node = searchNode->GetNode("m10")) != 0)
        SetM10(node->AsDouble());
    if((node = searchNode->GetNode("m11")) != 0)
        SetM11(node->AsDouble());
    if((node = searchNode->GetNode("m12")) != 0)
        SetM12(node->AsDouble());
    if((node = searchNode->GetNode("m13")) != 0)
        SetM13(node->AsDouble());
    if((node = searchNode->GetNode("m20")) != 0)
        SetM20(node->AsDouble());
    if((node = searchNode->GetNode("m21")) != 0)
        SetM21(node->AsDouble());
    if((node = searchNode->GetNode("m22")) != 0)
        SetM22(node->AsDouble());
    if((node = searchNode->GetNode("m23")) != 0)
        SetM23(node->AsDouble());
    if((node = searchNode->GetNode("m30")) != 0)
        SetM30(node->AsDouble());
    if((node = searchNode->GetNode("m31")) != 0)
        SetM31(node->AsDouble());
    if((node = searchNode->GetNode("m32")) != 0)
        SetM32(node->AsDouble());
    if((node = searchNode->GetNode("m33")) != 0)
        SetM33(node->AsDouble());
    if((node = searchNode->GetNode("invertLinearTransform")) != 0)
        SetInvertLinearTransform(node->AsBool());
    if((node = searchNode->GetNode("transformVectors")) != 0)
        SetTransformVectors(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LinearTransformAttributes::SetM00(double m00_)
{
    m00 = m00_;
    Select(ID_m00, (void *)&m00);
}

void
LinearTransformAttributes::SetM01(double m01_)
{
    m01 = m01_;
    Select(ID_m01, (void *)&m01);
}

void
LinearTransformAttributes::SetM02(double m02_)
{
    m02 = m02_;
    Select(ID_m02, (void *)&m02);
}

void
LinearTransformAttributes::SetM03(double m03_)
{
    m03 = m03_;
    Select(ID_m03, (void *)&m03);
}

void
LinearTransformAttributes::SetM10(double m10_)
{
    m10 = m10_;
    Select(ID_m10, (void *)&m10);
}

void
LinearTransformAttributes::SetM11(double m11_)
{
    m11 = m11_;
    Select(ID_m11, (void *)&m11);
}

void
LinearTransformAttributes::SetM12(double m12_)
{
    m12 = m12_;
    Select(ID_m12, (void *)&m12);
}

void
LinearTransformAttributes::SetM13(double m13_)
{
    m13 = m13_;
    Select(ID_m13, (void *)&m13);
}

void
LinearTransformAttributes::SetM20(double m20_)
{
    m20 = m20_;
    Select(ID_m20, (void *)&m20);
}

void
LinearTransformAttributes::SetM21(double m21_)
{
    m21 = m21_;
    Select(ID_m21, (void *)&m21);
}

void
LinearTransformAttributes::SetM22(double m22_)
{
    m22 = m22_;
    Select(ID_m22, (void *)&m22);
}

void
LinearTransformAttributes::SetM23(double m23_)
{
    m23 = m23_;
    Select(ID_m23, (void *)&m23);
}

void
LinearTransformAttributes::SetM30(double m30_)
{
    m30 = m30_;
    Select(ID_m30, (void *)&m30);
}

void
LinearTransformAttributes::SetM31(double m31_)
{
    m31 = m31_;
    Select(ID_m31, (void *)&m31);
}

void
LinearTransformAttributes::SetM32(double m32_)
{
    m32 = m32_;
    Select(ID_m32, (void *)&m32);
}

void
LinearTransformAttributes::SetM33(double m33_)
{
    m33 = m33_;
    Select(ID_m33, (void *)&m33);
}

void
LinearTransformAttributes::SetInvertLinearTransform(bool invertLinearTransform_)
{
    invertLinearTransform = invertLinearTransform_;
    Select(ID_invertLinearTransform, (void *)&invertLinearTransform);
}

void
LinearTransformAttributes::SetTransformVectors(bool transformVectors_)
{
    transformVectors = transformVectors_;
    Select(ID_transformVectors, (void *)&transformVectors);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
LinearTransformAttributes::GetM00() const
{
    return m00;
}

double
LinearTransformAttributes::GetM01() const
{
    return m01;
}

double
LinearTransformAttributes::GetM02() const
{
    return m02;
}

double
LinearTransformAttributes::GetM03() const
{
    return m03;
}

double
LinearTransformAttributes::GetM10() const
{
    return m10;
}

double
LinearTransformAttributes::GetM11() const
{
    return m11;
}

double
LinearTransformAttributes::GetM12() const
{
    return m12;
}

double
LinearTransformAttributes::GetM13() const
{
    return m13;
}

double
LinearTransformAttributes::GetM20() const
{
    return m20;
}

double
LinearTransformAttributes::GetM21() const
{
    return m21;
}

double
LinearTransformAttributes::GetM22() const
{
    return m22;
}

double
LinearTransformAttributes::GetM23() const
{
    return m23;
}

double
LinearTransformAttributes::GetM30() const
{
    return m30;
}

double
LinearTransformAttributes::GetM31() const
{
    return m31;
}

double
LinearTransformAttributes::GetM32() const
{
    return m32;
}

double
LinearTransformAttributes::GetM33() const
{
    return m33;
}

bool
LinearTransformAttributes::GetInvertLinearTransform() const
{
    return invertLinearTransform;
}

bool
LinearTransformAttributes::GetTransformVectors() const
{
    return transformVectors;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LinearTransformAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LinearTransformAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_m00:                   return "m00";
    case ID_m01:                   return "m01";
    case ID_m02:                   return "m02";
    case ID_m03:                   return "m03";
    case ID_m10:                   return "m10";
    case ID_m11:                   return "m11";
    case ID_m12:                   return "m12";
    case ID_m13:                   return "m13";
    case ID_m20:                   return "m20";
    case ID_m21:                   return "m21";
    case ID_m22:                   return "m22";
    case ID_m23:                   return "m23";
    case ID_m30:                   return "m30";
    case ID_m31:                   return "m31";
    case ID_m32:                   return "m32";
    case ID_m33:                   return "m33";
    case ID_invertLinearTransform: return "invertLinearTransform";
    case ID_transformVectors:      return "transformVectors";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LinearTransformAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LinearTransformAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_m00:                   return FieldType_double;
    case ID_m01:                   return FieldType_double;
    case ID_m02:                   return FieldType_double;
    case ID_m03:                   return FieldType_double;
    case ID_m10:                   return FieldType_double;
    case ID_m11:                   return FieldType_double;
    case ID_m12:                   return FieldType_double;
    case ID_m13:                   return FieldType_double;
    case ID_m20:                   return FieldType_double;
    case ID_m21:                   return FieldType_double;
    case ID_m22:                   return FieldType_double;
    case ID_m23:                   return FieldType_double;
    case ID_m30:                   return FieldType_double;
    case ID_m31:                   return FieldType_double;
    case ID_m32:                   return FieldType_double;
    case ID_m33:                   return FieldType_double;
    case ID_invertLinearTransform: return FieldType_bool;
    case ID_transformVectors:      return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LinearTransformAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LinearTransformAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_m00:                   return "double";
    case ID_m01:                   return "double";
    case ID_m02:                   return "double";
    case ID_m03:                   return "double";
    case ID_m10:                   return "double";
    case ID_m11:                   return "double";
    case ID_m12:                   return "double";
    case ID_m13:                   return "double";
    case ID_m20:                   return "double";
    case ID_m21:                   return "double";
    case ID_m22:                   return "double";
    case ID_m23:                   return "double";
    case ID_m30:                   return "double";
    case ID_m31:                   return "double";
    case ID_m32:                   return "double";
    case ID_m33:                   return "double";
    case ID_invertLinearTransform: return "bool";
    case ID_transformVectors:      return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LinearTransformAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LinearTransformAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LinearTransformAttributes &obj = *((const LinearTransformAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_m00:
        {  // new scope
        retval = (m00 == obj.m00);
        }
        break;
    case ID_m01:
        {  // new scope
        retval = (m01 == obj.m01);
        }
        break;
    case ID_m02:
        {  // new scope
        retval = (m02 == obj.m02);
        }
        break;
    case ID_m03:
        {  // new scope
        retval = (m03 == obj.m03);
        }
        break;
    case ID_m10:
        {  // new scope
        retval = (m10 == obj.m10);
        }
        break;
    case ID_m11:
        {  // new scope
        retval = (m11 == obj.m11);
        }
        break;
    case ID_m12:
        {  // new scope
        retval = (m12 == obj.m12);
        }
        break;
    case ID_m13:
        {  // new scope
        retval = (m13 == obj.m13);
        }
        break;
    case ID_m20:
        {  // new scope
        retval = (m20 == obj.m20);
        }
        break;
    case ID_m21:
        {  // new scope
        retval = (m21 == obj.m21);
        }
        break;
    case ID_m22:
        {  // new scope
        retval = (m22 == obj.m22);
        }
        break;
    case ID_m23:
        {  // new scope
        retval = (m23 == obj.m23);
        }
        break;
    case ID_m30:
        {  // new scope
        retval = (m30 == obj.m30);
        }
        break;
    case ID_m31:
        {  // new scope
        retval = (m31 == obj.m31);
        }
        break;
    case ID_m32:
        {  // new scope
        retval = (m32 == obj.m32);
        }
        break;
    case ID_m33:
        {  // new scope
        retval = (m33 == obj.m33);
        }
        break;
    case ID_invertLinearTransform:
        {  // new scope
        retval = (invertLinearTransform == obj.invertLinearTransform);
        }
        break;
    case ID_transformVectors:
        {  // new scope
        retval = (transformVectors == obj.transformVectors);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

