/*=========================================================================

   Program: ParaView
   Module:  pqApplyBehavior.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef pqApplyBehavior_h
#define pqApplyBehavior_h

#include "pqApplicationComponentsModule.h"
#include <QObject>
#include <QScopedPointer>

class pqPipelineFilter;
class pqPipelineSource;
class pqPropertiesPanel;
class pqProxy;
class pqView;

/**
* @ingroup Behaviors
* pqApplyBehavior collects the logic that needs to happen after the user hits
* "Apply" on the pqPropertiesPanel. Since "Apply" is an important concept in
* ParaView application, it gets its own behavior so applications can customize
* it, if needed.
*
* For pqApplyBehavior to work, one needs to manually register
* pqPropertiesPanel instance(s). pqParaViewBehaviors does that automatically
* for pqPropertiesPanel instances available during the startup.
*/
class PQAPPLICATIONCOMPONENTS_EXPORT pqApplyBehavior : public QObject
{
  Q_OBJECT
  typedef QObject Superclass;

public:
  pqApplyBehavior(QObject* parent = 0);
  virtual ~pqApplyBehavior();

  /**
  * Register/unregister pqPropertiesPanel instances to monitor.
  */
  void registerPanel(pqPropertiesPanel* panel);
  void unregisterPanel(pqPropertiesPanel* panel);
protected slots:
  virtual void applied(pqPropertiesPanel*, pqProxy*);
  virtual void applied(pqPropertiesPanel*);

private slots:
  void onApplied(pqProxy*);
  void onApplied();

protected:
  virtual void showData(pqPipelineSource* source, pqView* view);
  void hideInputIfRequired(pqPipelineFilter* filter, pqView* view);

private:
  Q_DISABLE_COPY(pqApplyBehavior)
  class pqInternals;
  const QScopedPointer<pqInternals> Internals;
};

#endif
