/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include "gui.h"

#ifdef GTK_FACE
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "icons.h"
#include "gui_api.h"
#include "gkeys.h"
#include "gaccel.h"

void gui_beep()
{
	gdk_beep();
}

void gui_start_download(ismain)
int ismain;
{
#ifdef HAVE_MT
	if (!ismain)
	{
		GDK_THREADS_ENTER();
	}
#endif
	gtk_label_set(GTK_LABEL(gui_cfg.status_msg), "");
	gtk_widget_set_sensitive(gui_cfg.bt_rest,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mea_rest,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mtb_rest,FALSE);
	gtk_widget_set_sensitive(gui_cfg.bt_start,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mea_start,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mtb_start,FALSE);
	gtk_widget_set_sensitive(gui_cfg.bt_stop,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mea_stop,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mtb_stop,TRUE);
	gtk_widget_set_sensitive(gui_cfg.bt_break,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mea_break,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mtb_break,TRUE);

#ifdef WITH_TREE
	gtk_label_set(GTK_LABEL(gui_cfg.tree_help), "");
#endif

#ifdef HAVE_MT
	if (!ismain)
	{
		gdk_flush();
		GDK_THREADS_LEAVE();
	}
#endif
}

void gui_finish_download(ismain)
int ismain;
{
	cfg.processing = FALSE;

#ifdef HAVE_MT
	if (!ismain)
	{
		GDK_THREADS_ENTER();
	}
#endif
	gdk_beep ();

	gtk_widget_set_sensitive(gui_cfg.bt_rest,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mea_rest,TRUE);
	gtk_widget_set_sensitive(gui_cfg.mtb_rest,TRUE);
	if (cfg.urlstack)
	{
		gtk_widget_set_sensitive(gui_cfg.bt_start,TRUE);
		gtk_widget_set_sensitive(gui_cfg.mea_start,TRUE);
		gtk_widget_set_sensitive(gui_cfg.mtb_start,TRUE);
	}
	gtk_widget_set_sensitive(gui_cfg.bt_stop,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mea_stop,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mtb_stop,FALSE);
	gtk_widget_set_sensitive(gui_cfg.bt_break,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mea_break,FALSE);
	gtk_widget_set_sensitive(gui_cfg.mtb_break,FALSE);

#ifdef HAVE_MT
	if (!ismain)
	{
		gdk_flush();
		GDK_THREADS_LEAVE();
	}
#endif
	cfg.rbreak = FALSE;
	cfg.stop = FALSE;
}

void gui_finish_document(docp)
doc *docp;
{
#ifdef WITH_TREE
#ifdef _GTK_FEATURES_1_2
	if (cfg.xi_face && GTK_TOGGLE_BUTTON(gui_cfg.watch_download)->active)
	{
		GDK_THREADS_ENTER();
		LOCK_GTKTREE
		gtk_ctree_select(GTK_CTREE(gui_cfg.tree_widget),
				docp->doc_url->tree_nfo[0]);
		gtk_ctree_node_moveto(GTK_CTREE(gui_cfg.tree_widget),
				docp->doc_url->tree_nfo[0],
				0, 0.0, 0.0);
		UNLOCK_GTKTREE
		GDK_THREADS_LEAVE();
	}
#endif
#endif
}

void gui_start(argc,argv)
int *argc;
char **argv;
{
#ifdef _GTK_FEATURES_1_2
	char *p;
	char gtkrc[PATH_MAX];

#ifdef __CYGWIN__
	sprintf (gtkrc, "%s/%s-gtkrc", cfg.install_path, PACKAGE);
	gtk_rc_add_default_file (gtkrc);
#else
	/* Parse the file ~/.pavuk-gtkrc. This makes Pavuk themeable :) */
	if ((p = getenv ("HOME")))
	{
		sprintf (gtkrc, "%s/.%s-gtkrc", p, PACKAGE);
		gtk_rc_add_default_file (gtkrc);
	}
#endif
#endif

	gtk_init (argc, &argv);
	gkey_load();

	gui_cfg._go_bg = FALSE;
        gui_cfg.toplevel = NULL;
        gui_cfg.about_shell = NULL;
        gui_cfg.scn_load_shell = NULL;
        gui_cfg.scn_save_shell = NULL;
        gui_cfg.cfg_limits = NULL;
        gui_cfg.config_shell = NULL;
        gui_cfg.cfg_sch = NULL;
#ifdef WITH_TREE
        gui_cfg.tree_shell = NULL;
#endif

}

void gui_set_doccounter()
{
	char pom[256];

	if (cfg.xi_face)
	{
		GDK_THREADS_ENTER();
		sprintf(pom, gettext("Processed: %5d"), cfg.process_cnt);
		gtk_label_set(GTK_LABEL(gui_cfg.status_done), pom);
		sprintf(pom, gettext("Queued: %5d"), cfg.total_cnt);
		gtk_label_set(GTK_LABEL(gui_cfg.status_queue), pom);
		sprintf(pom, gettext("Failed: %4d"), cfg.fail_cnt);
		gtk_label_set(GTK_LABEL(gui_cfg.status_fail), pom);
		sprintf(pom, gettext("Rejected: %5d"), cfg.reject_cnt);
		gtk_label_set(GTK_LABEL(gui_cfg.status_rej), pom);
		gdk_flush();
		GDK_THREADS_LEAVE();

		_Xt_Serve
	}
}

void gui_set_progress(sz, rate, etime, rtime)
char *sz;
char *rate;
char *etime;
char *rtime;
{
#ifdef HAVE_MT
	int thrnr;

	thrnr = (int)pthread_getspecific(cfg.thrnr_key);

	GDK_THREADS_ENTER();
	gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 3, sz);
	gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 4, rate);
	gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 5, etime);
	gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 6, rtime);
	gdk_flush();
	GDK_THREADS_LEAVE();
#else
	char pom[40];

	sprintf(pom, "S: %s", sz);
	gtk_label_set(GTK_LABEL(gui_cfg.status_size), pom);
	sprintf(pom, "R: %s", rate);
	gtk_label_set(GTK_LABEL(gui_cfg.status_rate), pom);
	sprintf(pom, "ET: %s", etime);
	gtk_label_set(GTK_LABEL(gui_cfg.status_et), pom);
	sprintf(pom, "RT: %s", rtime);
	gtk_label_set(GTK_LABEL(gui_cfg.status_rt), pom);
	_Xt_Serve
#endif
}

void gui_clear_status()
{
	if (cfg.xi_face)
	{
#ifdef HAVE_MT
		int thrnr;

		thrnr = (int)pthread_getspecific(cfg.thrnr_key);

		GDK_THREADS_ENTER();
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 1, "");
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 2, "");
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 3, "");
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 4, "");
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 5, "");
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 6, "");
		gdk_flush();
		GDK_THREADS_LEAVE();
#else
		gtk_entry_set_text(GTK_ENTRY(gui_cfg.minitb_label), "");
		gtk_label_set(GTK_LABEL(gui_cfg.status_size), "");
		gtk_label_set(GTK_LABEL(gui_cfg.status_rate), "");
		gtk_label_set(GTK_LABEL(gui_cfg.status_et), "");
		gtk_label_set(GTK_LABEL(gui_cfg.status_rt), "");
#endif
	}
}

void gui_set_status(text)
char *text;
{

	if (cfg.xi_face)
	{
#ifdef HAVE_MT
		int thrnr;

		thrnr = (int)pthread_getspecific(cfg.thrnr_key);
		GDK_THREADS_ENTER();
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 2, text);
		gdk_flush();
		GDK_THREADS_LEAVE();
#else
		gtk_label_set(GTK_LABEL(gui_cfg.status_msg), text);
		_Xt_Serve
#endif
	}
	else
	{
		DEBUG_USER(" - %s\n", text);
	}
}


void gui_set_msg(text, tout)
char *text;
int tout;
{
	if (cfg.xi_face)
	{
		GDK_THREADS_ENTER();
		gtk_label_set(GTK_LABEL(gui_cfg.status_msg), text);
		gdk_flush();
		_Xt_Serve
		GDK_THREADS_LEAVE();
	}
	else
	{
		DEBUG_USER(" - %s\n", text);
	}
}

void gui_set_url(str)
char *str;
{
	if (cfg.xi_face)
	{
#ifdef HAVE_MT
		int thrnr;

		thrnr = (int)pthread_getspecific(cfg.thrnr_key);
		GDK_THREADS_ENTER();
		gtk_clist_set_text(GTK_CLIST(gui_cfg.status_list), thrnr, 1, str);
		gdk_flush();
		GDK_THREADS_LEAVE();
#else
		gtk_entry_set_text(GTK_ENTRY(gui_cfg.minitb_label), str);
#endif
	}
}

#ifdef WITH_TREE

#ifdef _GTK_FEATURES_1_2
void *gui_tree_make_entry(urlp)
url *urlp;
{
	GtkCTreeNode *retv;
	GtkCTreeNode *parent;
	GdkBitmap *shape;
	GdkPixmap *pixmap;
	gchar *text[1];
	dllist *par;
	url *parurl;

	par = dllist_last(urlp->parent_url);

	if (par)
		parurl = (url *) par->data;
	else
		parurl = NULL;

	LOCK_GTKTREE
	GDK_THREADS_ENTER();
	if (parurl && parurl->tree_nfo && parurl->tree_nfo[0])
		parent = (GtkCTreeNode *) parurl->tree_nfo[0];
	else
		parent = (GtkCTreeNode *) gui_cfg.root;

	g_return_val_if_fail(parent != NULL, NULL);

	if (urlp->status & URL_PROCESSED)
	{
		gchar *text;
		guint8 sp;
		GdkPixmap *p;
		GdkBitmap *m;
		gboolean il,ex;
	
		gtk_ctree_get_node_info(GTK_CTREE(gui_cfg.tree_widget) ,
			urlp->tree_nfo[0], &text, &sp, &p, &m,
			&pixmap, &shape, &il ,&ex);
	}
	else
	{
	 	pixmap = gui_cfg.icon.notprocessed->pixmap;
		shape = gui_cfg.icon.notprocessed->shape;
	}
	
	text[0] = url_to_urlstr(urlp, FALSE);

	retv = gtk_ctree_insert_node(GTK_CTREE(gui_cfg.tree_widget), parent ,
			NULL, text, 8 ,
			pixmap, shape, pixmap, shape, FALSE, TRUE);

	_free(text[0]);

	gtk_ctree_node_set_row_data(GTK_CTREE(gui_cfg.tree_widget), retv, (gpointer)urlp);

	_Xt_Serve
	GDK_THREADS_LEAVE();
	UNLOCK_GTKTREE

	return retv;		
}
#else
void *gui_tree_make_entry(urlp)
url *urlp;
{
	GtkWidget *retv;
	GtkWidget* subtree = NULL;
	GtkWidget* pmap;
	GtkWidget* label;
	GtkWidget* row_box;
	char *p;
	dllist *par;
	url *parurl;

	par = dllist_last(urlp->parent_url);

	if (par)
		parurl = (url *) par->data;
	else
		parurl = NULL;


	LOCK_GTKTREE
	if (parurl && parurl->tree_nfo && parurl->tree_nfo[0])
		subtree = GTK_TREE_ITEM_SUBTREE(parurl->tree_nfo[0]);
	else
		subtree = GTK_TREE_ITEM_SUBTREE(gui_cfg.root);

	if(!subtree)
	{
		subtree = gtk_tree_new();
		gtk_signal_connect (GTK_OBJECT (subtree), "event",
			(GtkSignalFunc) gui_tree_list_events,
			subtree);
		gtk_signal_connect(GTK_OBJECT(subtree), "selection_changed",
			(GtkSignalFunc) gui_SelectTreeNode,
			(gpointer)NULL);
		gtk_tree_item_set_subtree(
			GTK_TREE_ITEM((parurl ? parurl->tree_nfo[0] : gui_cfg.root)), subtree);
		gtk_widget_show(subtree);
	}

	retv = gtk_tree_item_new();
	gtk_object_set_user_data(GTK_OBJECT(retv), (gpointer)urlp);
	gtk_tree_append(GTK_TREE(subtree), retv);
	gtk_widget_show(retv);

	row_box = gtk_hbox_new(FALSE, 2);
	gtk_widget_show(row_box);
	gtk_container_add(GTK_CONTAINER(retv), row_box);

	if (urlp->status & URL_PROCESSED)
	{
		GtkWidget *pbox;
		GtkPixmap *ppmap = NULL;
		GList *chlist;

		pbox = GTK_BIN(urlp->tree_nfo[0])->child;

		for (chlist = GTK_BOX(pbox)->children ; chlist ; chlist = chlist->next)
		{
			if (GTK_IS_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget))
			{
				ppmap = GTK_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget);
				break;
			}

		}
		if (ppmap)
			pmap = gtk_pixmap_new(ppmap->pixmap, ppmap->mask);
		else
			pmap = gtk_pixmap_new(gui_cfg.icon.notprocessed->pixmap,
				gui_cfg.icon.notprocessed->shape);
	}
	else
		pmap = gtk_pixmap_new(gui_cfg.icon.notprocessed->pixmap,
			gui_cfg.icon.notprocessed->shape);

	gtk_widget_show(pmap);
	gtk_box_pack_start(GTK_BOX(row_box), pmap, FALSE, FALSE, 0);

	p = url_to_urlstr(urlp, FALSE);
	label = gtk_label_new(p);
	free(p);
	gtk_widget_show(label);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(row_box), label, FALSE, FALSE, 0);

	_Xt_Serve

	UNLOCK_GTKTREE

	return retv;
}
#endif
#endif

void gui_create_tree_root_node()
{
#ifdef WITH_TREE
	if (cfg.xi_face && !gui_cfg.root)
	{
#ifdef _GTK_FEATURES_1_2
		gchar *text[1];

		text[0] = gettext("Start");

		LOCK_GTKTREE
		GDK_THREADS_ENTER();
		gui_cfg.root = (GtkCTreeNode *)gtk_ctree_insert_node(
				GTK_CTREE(gui_cfg.tree_widget) ,
				NULL, NULL, text, 8 ,
				gui_cfg.icon.notprocessed->pixmap ,
				gui_cfg.icon.notprocessed->shape ,
				gui_cfg.icon.notprocessed->pixmap ,
				gui_cfg.icon.notprocessed->shape ,
				FALSE, TRUE);
		GDK_THREADS_LEAVE();
		UNLOCK_GTKTREE
#else
		LOCK_GTKTREE
		GDK_THREADS_ENTER();
		gui_cfg.root = gtk_tree_item_new_with_label(gettext("Start"));
		gtk_tree_append(GTK_TREE(gui_cfg.tree_widget), gui_cfg.root);
		gtk_widget_show(gui_cfg.root);
		gtk_object_set_user_data(GTK_OBJECT(gui_cfg.root), NULL);
		GDK_THREADS_LEAVE();
		UNLOCK_GTKTREE
#endif
	}
#endif /* WITH_TREE */
}

void gui_clear_tree()
{
#ifdef WITH_TREE
	if (cfg.xi_face && gui_cfg.root)
	{
#ifdef _GTK_FEATURES_1_2
		LOCK_GTKTREE
		if (!MT_IS_MAIN_THREAD())
		{
			GDK_THREADS_ENTER();
		}
		gtk_clist_freeze(GTK_CLIST(gui_cfg.tree_widget));
		gtk_clist_clear(GTK_CLIST(gui_cfg.tree_widget));
		gtk_clist_thaw(GTK_CLIST(gui_cfg.tree_widget));
#else
		GList rw;

		LOCK_GTKTREE
		if (!MT_IS_MAIN_THREAD())
		{
			GDK_THREADS_ENTER();
		}
		rw.prev = NULL;
		rw.next = NULL;
		rw.data = gui_cfg.root;

		gtk_tree_remove_items(GTK_TREE(gui_cfg.tree_widget), &rw);

#endif
		gui_cfg.root = NULL;
		if (!MT_IS_MAIN_THREAD())
		{
			GDK_THREADS_LEAVE();
		}
		UNLOCK_GTKTREE
	}
#endif /* WITH_TREE */
}

void gui_tree_add_start()
{
#if defined(_GTK_FEATURES_1_2) && defined(WITH_TREE) && !defined(HAVE_MT)
	if (cfg.xi_face)
	{
		GDK_THREADS_ENTER();
		gtk_clist_freeze(GTK_CLIST(gui_cfg.tree_widget));
		GDK_THREADS_LEAVE();
	}
#endif

}

void gui_tree_add_end()
{
#if defined(_GTK_FEATURES_1_2) && defined(WITH_TREE) && !defined(HAVE_MT)
	if (cfg.xi_face)
	{
		GDK_THREADS_ENTER();
		gtk_clist_thaw(GTK_CLIST(gui_cfg.tree_widget));
		GDK_THREADS_LEAVE();
	}
#endif
}

void gui_tree_set_icon_for_doc(docp)
doc *docp;
{
	icons_set_for_doc(docp);
}

#ifndef HAVE_MT
void gui_loop_serve()
{
	if (cfg.xi_face)
	{
		gui_cfg.endloop = FALSE;
		while (!gui_cfg.endloop &&
			gdk_events_pending() &&
			!gtk_main_iteration ());
	}
}

void gui_loop_do()
{
	if (cfg.xi_face)
	{
		gui_cfg.endloop = FALSE;
		while(!gui_cfg.endloop && !cfg.rbreak)
		{
			gtk_main_iteration ();
		}
	}
}

void gui_loop_escape()
{
	if (cfg.xi_face)
		gui_cfg.endloop = TRUE;
}
#endif /* HAVE_MT */

#ifdef HAVE_MT

void gui_mt_thread_start(thrnr)
{
	if (cfg.xi_face)
	{
		char *ep[7];
		char pom[10];

		sprintf(pom, "%d", thrnr);
		ep[0] = pom;
		ep[1] = "";
		ep[2] = gettext("Starting ...");
		ep[3] = "";
		ep[4] = "";
		ep[5] = "";
		ep[6] = "";
		GDK_THREADS_ENTER();
		gtk_clist_append(GTK_CLIST(gui_cfg.status_list), ep);
		GDK_THREADS_LEAVE();
	}
}

void gui_mt_thread_end(thrnr)
{
	if (cfg.xi_face)
	{
		GDK_THREADS_ENTER();
		gtk_clist_clear(GTK_CLIST(gui_cfg.status_list));
		GDK_THREADS_LEAVE();
	}
}

#endif

static gint TOut(data)
gpointer data;
{
	*(int *)data = 0;
	_Xt_EscLoop
	return FALSE;
}

void gui_msleep(msec)
long msec;
{
	gint inid;

	inid = gtk_timeout_add(msec, (GtkFunction) TOut, &inid);
	_Xt_ServeLoop
	if (inid)
		gtk_timeout_remove(inid);
}

static void rwCB(data, source, condition)
gpointer data;
gint source;
GdkInputCondition condition;
{
	gdk_input_remove(*(int *)data );
	*(int *)data = 0;
	_Xt_EscLoop
}

int gui_wait_io(sock, for_read)
int sock;
int for_read;
{
	int rv = 0;
	gint iid = 0;
	gint inid = 0;

	if (cfg.ctimeout > 0.0)
		inid = gtk_timeout_add((int)(cfg.ctimeout * 60000.0),
			(GtkFunction)TOut, &inid);

	if (cfg.ctimeout > (double)(ULONG_MAX / 60000))
		xprintf(0, gettext("Too high timeout value for GUI interface implementation of timeout\n"));

	iid = gdk_input_add(sock, for_read ? GDK_INPUT_READ : GDK_INPUT_WRITE,
		(GdkInputFunction) rwCB, (gpointer) &iid);

	_Xt_ServeLoop

	if (inid)
	{
		gtk_timeout_remove(inid);
		inid = 0;
	}
	else if (cfg.ctimeout > 0.0)
	{
		errno = ETIMEDOUT;
		rv = -1;
	}

	if (iid)
	{
		gdk_input_remove(iid);
		iid = 0;
	}

	return rv;
}

int gui_xvaprintf(strs, args)
char *strs;
va_list *args;
{
	char *p;
	bool_t last = 1;
	int ilen;
	int rv;

#ifdef _GTK_FEATURES_1_2
	char *buf = g_strdup_vprintf(strs, *args);
	rv = strlen(buf);
#else
	char buf[4096];

	buf[0] = '\0';
	rv = vsprintf(buf, strs, *args);
#endif

	LOCK_GTKLOG
	GDK_THREADS_ENTER();
	gtk_clist_freeze(GTK_CLIST(gui_cfg.logw));
	p = buf;
	while(*p)
	{
		ilen = strcspn(p, "\r\n");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;

		gtk_clist_append(GTK_CLIST(gui_cfg.logw), &p);

		p += ilen+last;
		p += strspn(p, "\r\n");
	}

	if (cfg.xlogsize)
	{
		while (cfg.xlogsize < GTK_CLIST(gui_cfg.logw)->rows)
			gtk_clist_remove(GTK_CLIST(gui_cfg.logw), 0);
	}

	gtk_clist_thaw(GTK_CLIST(gui_cfg.logw));
	if (cfg.log_autoscroll)
	{
		gui_cfg.logvadj->value = gui_cfg.logvadj->upper >  
			gui_cfg.logvadj->page_size ? gui_cfg.logvadj->upper -  
			gui_cfg.logvadj->page_size : 0;
		gtk_signal_emit_by_name(GTK_OBJECT(gui_cfg.logvadj), "value_changed");
	}
	GDK_THREADS_LEAVE();
	UNLOCK_GTKLOG

#ifdef _GTK_FEATURES_1_2
	g_free(buf);
#endif

	return rv;
}

#endif /* GTK_FACE */

