/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>

#include "config.h"
#include "dns.h"
#include "gui_api.h"
#include "absio.h"

int net_host_to_in_addr(hostname, haddr)
char *hostname;
struct in_addr *haddr;
{
	int len;

	if ((haddr->s_addr = inet_addr(hostname)) == -1)
	{
		if (dns_gethostbyname(hostname , &len  , (char *)haddr))
		{
			return -1;
		}
	}
	return 0;
}

/*****************************************************************/
/* otvori spojenie na dany port servera  s (IP , DNS) adresou	 */
/*****************************************************************/
int net_connect(hostname , port_no)
char *hostname;
int port_no;
{
	struct sockaddr_in addr;
	int sock;
	int rv,l;

	_h_errno_ = 0;

	memset(&addr , '\0' ,  sizeof(addr));
	if ((addr.sin_addr.s_addr = inet_addr(hostname)) == -1)
	{
		if (dns_gethostbyname(hostname , &rv  , (char *)&(addr.sin_addr)))
		{
			return -1;
		}
	}

	_Xt_Serve

	addr.sin_family = AF_INET;
	addr.sin_port = htons(port_no);

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		return -1;
	}

	if (fcntl(sock , F_SETFL , O_NONBLOCK))
	{
		xperror("fcntl() - F_SETFL");
		close(sock);
		return -1;
	}

	if (cfg.local_ip)
	{
		struct sockaddr_in localaddr;

		memset(&localaddr , '\0' ,  sizeof(localaddr));

		localaddr.sin_addr.s_addr = cfg.local_ip_addr.s_addr;
		localaddr.sin_family = AF_INET;
		localaddr.sin_port = htons(0);

		if (bind(sock, (struct sockaddr *)&localaddr, sizeof(localaddr)) == -1)
		{
			close(sock);
			return -1;
		}
	}

	rv = connect(sock, (struct sockaddr*)&addr, sizeof(addr));
	if (rv && 
		(errno != EINPROGRESS) &&
		(errno != EISCONN) &&
		(errno != EAGAIN) &&
		(errno != EWOULDBLOCK))
	{
		close(sock);
		return -1;
	}


#ifndef HAVE_MT
	if (cfg.xi_face)
	{
		if (rv && (errno == EINPROGRESS))
		{
			rv = gui_wait_io(sock, FALSE);

			if (!rv)
			{
				DEBUG_NET("Async connect - connected\n");
			}

			if (cfg.rbreak || cfg.stop || rv)
			{
				close(sock);
				return -1;
			}
			
		}
	}
	else
#endif /* !HAVE_MT */
	{
		if (rv && 
			(errno == EINPROGRESS ||
			 errno == EAGAIN ||
			 errno == EWOULDBLOCK))
		{
			while ((rv = tl_selectw(sock, (int)(cfg.ctimeout * 60.0))) == -1 
				&& errno == EINTR);
			if (rv <= 0)
			{
				if (rv == 0) errno = ETIMEDOUT;
				return -1;
			}
		}
	}

#if defined __QNX__ || defined __BEOS__
	if (connect(sock, (struct sockaddr*)&addr, sizeof(addr)) &&
		(errno != EISCONN))
	{
		close(sock);
		return -1;
	}
#else
	l = sizeof(rv);
	if (getsockopt(sock, SOL_SOCKET, SO_ERROR, (void *)&rv , &l) || rv)
	{
		close(sock);
		errno = rv;
		return -1;
	}
#endif

	DEBUG_NET("Successfully connected to %s,%d\n", hostname , port_no);

	return(sock);
}

int net_bindport(port)
int port;
{
	int sock;
	int n;
	struct sockaddr_in addr;
	char pom[512];

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		perror("socket");
		return -1;
	}

	addr.sin_addr.s_addr = cfg.local_ip_addr.s_addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);

	n = 1;
	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&n, sizeof(n)))
		xperror("net_bind: setsockopt - SO_REUSEADDR");

	if (bind(sock, (struct sockaddr*) &addr, sizeof(addr)) == -1)
	{
		sprintf(pom , "bind to port(%d)" , port);
		xperror(pom);
		close(sock);
		return -1;
	}

	n = sizeof(addr);
	if (getsockname(sock , (struct sockaddr*) &addr, &n))
	{
		xperror("getsockname");
		close(sock);
		return -1;
	}

	DEBUG_NET("BINDING to port : %d\n" , ntohs(addr.sin_port));

	if (listen(sock,1) == -1)
	{
		xperror("listen");
		close(sock);
		return -1;
	}

	return sock;
}

int net_accept(sock)
int sock;
{
	struct sockaddr_in caller;
	int p,rsock = -1;
	int rv;

	p = sizeof(caller);

	if (fcntl(sock , F_SETFL , O_NONBLOCK))
	{
		xperror("fcntl() - F_SETFL");
		close(sock);
		return -1;
	}

	rsock = accept(sock, (struct sockaddr*)&caller, &p);
	if ((rsock < 0) && (errno != EWOULDBLOCK) && (errno != EAGAIN))
	{
		close(sock);
		return -1;
	}

#ifndef HAVE_MT
	if (cfg.xi_face)
	{
		if ((rsock < 0) && 
			(errno == EWOULDBLOCK ||
			 errno == EAGAIN))
		{
			rv = gui_wait_io(sock, TRUE);
			if (rv || cfg.rbreak || cfg.stop)
			{
				close(sock);
				return -1;
			}
		}
	}
	else
#endif /* !HAVE_MT */
	{
		if ((rsock < 0) && (errno == EWOULDBLOCK || errno == EAGAIN))
		{
			while ((rv = tl_selectr(sock , (int)(cfg.ctimeout * 60.0))) == -1 
				&& errno == EINTR);
			if (rv <= 0)
			{
				if (rv == 0) errno = ETIMEDOUT;
				close(sock);
				return -1;
			}
		}
	}

	if ((rsock < 0) && ((rsock = accept(sock, (struct sockaddr*)&caller, &p)) == -1))
	{
		close(sock);
		return -1;
	}

	DEBUG_NET("ACCEPTING connection from: %s\n", inet_ntoa(caller.sin_addr));

	return rsock;
}

