/*
 * Performance Monitor
 * This file originated from several header files from the WINE project
 * which provides an Open Source implementation of the Windows API. See
 * http://www.winehq.org/ for further details.
 *
 * Copyright 2008 Aconex.  All rights reserved.
 * Portions Copyright 2007 Hans Leidekker.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */
#ifndef LIBPDH_H
#define LIBPDH_H

/* winperf.h portion */

#define PERF_SIZE_DWORD				0x00000000
#define PERF_SIZE_LARGE				0x00000100
#define PERF_SIZE_ZERO				0x00000200
#define PERF_SIZE_VARIABLE_LEN			0x00000300

#define PERF_TYPE_NUMBER			0x00000000
#define PERF_TYPE_COUNTER			0x00000400
#define PERF_TYPE_TEXT				0x00000800
#define PERF_TYPE_ZERO				0x00000C00

#define PERF_NUMBER_HEX				0x00000000
#define PERF_NUMBER_DECIMAL			0x00010000
#define PERF_NUMBER_DEC_1000			0x00020000

#define PERF_COUNTER_VALUE			0x00000000
#define PERF_COUNTER_RATE			0x00010000
#define PERF_COUNTER_FRACTION			0x00020000
#define PERF_COUNTER_BASE			0x00030000
#define PERF_COUNTER_ELAPSED			0x00040000
#define PERF_COUNTER_QUEUELEN			0x00050000
#define PERF_COUNTER_HISTOGRAM			0x00060000
#define PERF_COUNTER_PRECISION			0x00070000

#define PERF_TEXT_UNICODE			0x00000000
#define PERF_TEXT_ASCII				0x00010000

#define PERF_TIMER_TICK				0x00000000
#define PERF_TIMER_100NS			0x00100000
#define PERF_OBJECT_TIMER			0x00200000

#define PERF_DELTA_COUNTER			0x00400000
#define PERF_DELTA_BASE				0x00800000
#define PERF_INVERSE_COUNTER			0x01000000
#define PERF_MULTI_COUNTER			0x02000000

#define PERF_DISPLAY_NO_SUFFIX			0x00000000
#define PERF_DISPLAY_PER_SEC			0x10000000
#define PERF_DISPLAY_PERCENT			0x20000000
#define PERF_DISPLAY_SECONDS			0x30000000
#define PERF_DISPLAY_NOSHOW			0x40000000

#define PERF_100NSEC_MULTI_TIMER		0x22510500
#define PERF_100NSEC_MULTI_TIMER_INV		0x23510500
#define PERF_100NSEC_TIMER			0x20510500
#define PERF_100NSEC_TIMER_INV			0x21510500

#define PERF_AVERAGE_BASE			0x40030402
#define PERF_AVERAGE_BULK			0x40020500
#define PERF_AVERAGE_TIMER			0x30020400

#define PERF_COUNTER_100NS_QUEUELEN_TYPE	0x00550500
#define PERF_COUNTER_BULK_COUNT			0x10410500
#define PERF_COUNTER_COUNTER			0x10410400
#define PERF_COUNTER_DELTA			0x00400400
#define PERF_COUNTER_LARGE_DELTA		0x00400500
#define PERF_COUNTER_LARGE_QUEUELEN_TYPE	0x00450500
#define PERF_COUNTER_LARGE_RAWCOUNT		0x00010100
#define PERF_COUNTER_LARGE_RAWCOUNT_HEX		0x00000100
#define PERF_COUNTER_MULTI_BASE			0x42030500
#define PERF_COUNTER_MULTI_TIMER		0x22410500
#define PERF_COUNTER_MULTI_TIMER_INV		0x23410500
#define PERF_COUNTER_NODATA			0x40000200
#define PERF_COUNTER_QUEUELEN_TYPE		0x00450400
#define PERF_COUNTER_RAWCOUNT			0x00010000
#define PERF_COUNTER_RAWCOUNT_HEX		0x00000000
#define PERF_COUNTER_TEXT			0x00000b00
#define PERF_COUNTER_TIMER			0x20410500
#define PERF_COUNTER_TIMER_INV			0x21410500

#define PERF_ELAPSED_TIME			0x30240500
#define PERF_OBJ_TIME_TIMER			0x20610500
#define PERF_PRECISION_100NS_TIMER		0x20570500
#define PERF_PRECISION_OBJECT_TIMER		0x20670500
#define PERF_PRECISION_SYSTEM_TIMER		0x20470500

#define PERF_LARGE_RAW_BASE			0x40030500
#define PERF_RAW_BASE				0x40030403
#define PERF_RAW_FRACTION			0x20020400

#define PERF_SAMPLE_BASE			0x40030401
#define PERF_SAMPLE_COUNTER			0x00410400
#define PERF_SAMPLE_FRACTION			0x20c20400

/* pdhmsg.h portion */

#define PDH_CSTATUS_VALID_DATA			0x00000000L
#define PDH_CSTATUS_NEW_DATA			0x00000001L
#define PDH_CSTATUS_NO_MACHINE			0x800007D0L
#define PDH_CSTATUS_NO_INSTANCE			0x800007D1L
#define PDH_MORE_DATA				0x800007D2L
#define PDH_CSTATUS_ITEM_NOT_VALIDATED		0x800007D3L
#define PDH_RETRY				0x800007D4L
#define PDH_NO_DATA				0x800007D5L
#define PDH_CALC_NEGATIVE_DENOMINATOR		0x800007D6L
#define PDH_CALC_NEGATIVE_TIMEBASE		0x800007D7L
#define PDH_CALC_NEGATIVE_VALUE			0x800007D8L
#define PDH_DIALOG_CANCELLED			0x800007D9L
#define PDH_END_OF_LOG_FILE			0x800007DAL
#define PDH_ASYNC_QUERY_TIMEOUT			0x800007DBL
#define PDH_CANNOT_SET_DEFAULT_REALTIME_DATASOURCE	0x800007DCL
#define PDH_CSTATUS_NO_OBJECT			0xC0000BB8L
#define PDH_CSTATUS_NO_COUNTER			0xC0000BB9L
#define PDH_CSTATUS_INVALID_DATA		0xC0000BBAL
#define PDH_MEMORY_ALLOCATION_FAILURE		0xC0000BBBL
#define PDH_INVALID_HANDLE			0xC0000BBCL
#define PDH_INVALID_ARGUMENT			0xC0000BBDL
#define PDH_FUNCTION_NOT_FOUND			0xC0000BBEL
#define PDH_CSTATUS_NO_COUNTERNAME		0xC0000BBFL
#define PDH_CSTATUS_BAD_COUNTERNAME		0xC0000BC0L
#define PDH_INVALID_BUFFER			0xC0000BC1L
#define PDH_INSUFFICIENT_BUFFER			0xC0000BC2L
#define PDH_CANNOT_CONNECT_MACHINE		0xC0000BC3L
#define PDH_INVALID_PATH			0xC0000BC4L
#define PDH_INVALID_INSTANCE			0xC0000BC5L
#define PDH_INVALID_DATA			0xC0000BC6L
#define PDH_NO_DIALOG_DATA			0xC0000BC7L
#define PDH_CANNOT_READ_NAME_STRINGS		0xC0000BC8L
#define PDH_LOG_FILE_CREATE_ERROR		0xC0000BC9L
#define PDH_LOG_FILE_OPEN_ERROR			0xC0000BCAL
#define PDH_LOG_TYPE_NOT_FOUND			0xC0000BCBL
#define PDH_NO_MORE_DATA			0xC0000BCCL
#define PDH_ENTRY_NOT_IN_LOG_FILE		0xC0000BCDL
#define PDH_DATA_SOURCE_IS_LOG_FILE		0xC0000BCEL
#define PDH_DATA_SOURCE_IS_REAL_TIME		0xC0000BCFL
#define PDH_UNABLE_READ_LOG_HEADER		0xC0000BD0L
#define PDH_FILE_NOT_FOUND			0xC0000BD1L
#define PDH_FILE_ALREADY_EXISTS			0xC0000BD2L
#define PDH_NOT_IMPLEMENTED			0xC0000BD3L
#define PDH_STRING_NOT_FOUND			0xC0000BD4L
#define PDH_UNABLE_MAP_NAME_FILES		0x80000BD5L
#define PDH_UNKNOWN_LOG_FORMAT			0xC0000BD6L
#define PDH_UNKNOWN_LOGSVC_COMMAND		0xC0000BD7L
#define PDH_LOGSVC_QUERY_NOT_FOUND		0xC0000BD8L
#define PDH_LOGSVC_NOT_OPENED			0xC0000BD9L
#define PDH_WBEM_ERROR				0xC0000BDAL
#define PDH_ACCESS_DENIED			0xC0000BDBL
#define PDH_LOG_FILE_TOO_SMALL			0xC0000BDCL
#define PDH_INVALID_DATASOURCE			0xC0000BDDL
#define PDH_INVALID_SQLDB			0xC0000BDEL
#define PDH_NO_COUNTERS				0xC0000BDFL
#define PDH_SQL_ALLOC_FAILED			0xC0000BE0L
#define PDH_SQL_ALLOCCON_FAILED			0xC0000BE1L
#define PDH_SQL_EXEC_DIRECT_FAILED		0xC0000BE2L
#define PDH_SQL_FETCH_FAILED			0xC0000BE3L
#define PDH_SQL_ROWCOUNT_FAILED			0xC0000BE4L
#define PDH_SQL_MORE_RESULTS_FAILED		0xC0000BE5L
#define PDH_SQL_CONNECT_FAILED			0xC0000BE6L
#define PDH_SQL_BIND_FAILED			0xC0000BE7L
#define PDH_CANNOT_CONNECT_WMI_SERVER		0xC0000BE8L
#define PDH_PLA_COLLECTION_ALREADY_RUNNING	0xC0000BE9L
#define PDH_PLA_ERROR_SCHEDULE_OVERLAP		0xC0000BEAL
#define PDH_PLA_COLLECTION_NOT_FOUND		0xC0000BEBL
#define PDH_PLA_ERROR_SCHEDULE_ELAPSED		0xC0000BECL
#define PDH_PLA_ERROR_NOSTART			0xC0000BEDL
#define PDH_PLA_ERROR_ALREADY_EXISTS		0xC0000BEEL
#define PDH_PLA_ERROR_TYPE_MISMATCH		0xC0000BEFL
#define PDH_PLA_ERROR_FILEPATH			0xC0000BF0L
#define PDH_PLA_SERVICE_ERROR			0xC0000BF1L
#define PDH_PLA_VALIDATION_ERROR		0xC0000BF2L
#define PDH_PLA_VALIDATION_WARNING		0x80000BF3L
#define PDH_PLA_ERROR_NAME_TOO_LONG		0xC0000BF4L
#define PDH_INVALID_SQL_LOG_FORMAT		0xC0000BF5L
#define PDH_COUNTER_ALREADY_IN_QUERY		0xC0000BF6L
#define PDH_BINARY_LOG_CORRUPT			0xC0000BF7L
#define PDH_LOG_SAMPLE_TOO_SMALL		0xC0000BF8L
#define PDH_OS_LATER_VERSION			0xC0000BF9L
#define PDH_OS_EARLIER_VERSION			0xC0000BFAL
#define PDH_INCORRECT_APPEND_TIME		0xC0000BFBL
#define PDH_UNMATCHED_APPEND_COUNTER		0xC0000BFCL
#define PDH_SQL_ALTER_DETAIL_FAILED		0xC0000BFDL
#define PDH_QUERY_PERF_DATA_TIMEOUT		0xC0000BFEL

/* pdh.h portion */

typedef LONG   PDH_STATUS;
typedef HANDLE PDH_HQUERY;
typedef HANDLE PDH_HCOUNTER;
typedef HANDLE PDH_HLOG;

typedef struct {
    DWORD    CStatus;
    FILETIME TimeStamp;
    LONGLONG FirstValue;
    LONGLONG SecondValue;
    DWORD    MultiCount;
} PDH_RAW_COUNTER;

typedef struct {
    LPSTR szMachineName;
    LPSTR szObjectName;
    LPSTR szInstanceName;
    LPSTR szParentInstance;
    DWORD dwInstanceIndex;
    LPSTR szCounterName;
} PDH_COUNTER_PATH_ELEMENTS_A;

typedef struct {
    LPSTR szMachineName;
    GUID  ObjectGUID;
    DWORD dwItemId;
    LPSTR szInstanceName;
} PDH_DATA_ITEM_PATH_ELEMENTS_A;

typedef struct {
    DWORD     dwLength;
    DWORD     dwType;
    DWORD     CVersion;
    DWORD     CStatus;
    LONG      lScale;
    LONG      lDefaultScale;
    DWORD_PTR dwUserData;
    DWORD_PTR dwQueryUserData;
    LPSTR     szFullPath;
    union {
        PDH_DATA_ITEM_PATH_ELEMENTS_A DataItemPath;
        PDH_COUNTER_PATH_ELEMENTS_A   CounterPath;
        struct {
            LPSTR szMachineName;
            LPSTR szObjectName;
            LPSTR szInstanceName;
            LPSTR szParentInstance;
            DWORD dwInstanceIndex;
            LPSTR szCounterName;
        };
    };
    LPSTR szExplainText;
    DWORD DataBuffer[1];
} PDH_COUNTER_INFO_A;

PDH_STATUS WINAPI
PdhAddCounterA(PDH_HQUERY, LPCSTR, DWORD_PTR, PDH_HCOUNTER *);

PDH_STATUS WINAPI
PdhRemoveCounter(PDH_HCOUNTER);

PDH_STATUS WINAPI
PdhCollectQueryData(PDH_HQUERY);

PDH_STATUS WINAPI
PdhExpandCounterPathA(LPCSTR, LPSTR, LPDWORD);

PDH_STATUS WINAPI
PdhGetCounterInfoA(PDH_HCOUNTER, BOOLEAN, LPDWORD, PDH_COUNTER_INFO_A *);

PDH_STATUS WINAPI
PdhGetRawCounterValue(PDH_HCOUNTER, LPDWORD, PDH_RAW_COUNTER *);

PDH_STATUS WINAPI
PdhOpenQueryA(LPCSTR, DWORD_PTR, PDH_HQUERY *);

#endif /* LIBPDH_H */
