# (c) 2002-2003 Mathieu Roy <yeupou@gnu.org>
# dpkg.pl this file is part of package_db_view
#
#   all dpkg commands
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  take a look at http://savannah.nongnu.org/projects/pdbv
#  send comments at <pdbv-dev@nongnu.org>
#
#  $Id: dpkg.pl,v 1.10 2003/05/26 18:53:59 yeupou Exp $

print "The purpose of this file is not being executed alone";
exit;

# init values for dpkg
our $package_info_baseurl = "http://packages.debian.org/";
our @rawlist;
our @nicelist;

#our @grouplist;
our %package_section;

# init packages raw info list
sub PdbvPackageInit {
    open(STATUS, "$dpkg_dir/status") or die $sbst_unable_to_open."$dpkg_dir/status.\n\nStopped";
    $/ = '';
    while (<STATUS>) {
	push(@rawlist, $_);
    }
    close(STATUS);
        
    for (@rawlist) {
	my ($pack) = /^Package: (.*)$/m;
	my ($vers) = /^Version: (.*)$/m;
	push(@nicelist, $pack."_".$vers) if $vers ne '';
	
	if ($listing eq 'group' || $listing eq 'all') {
	    my ($group) = /^Section: (.*)$/m;
	    $package_section{$pack} = $group;
	    #push(@grouplist, $group);
	}
    }
 
    @nicelist = sort(@nicelist);

	
}

# return the dpkg version
sub PdbvPackagemanagerVersion {
    my $ret = `dpkg --version | head -n 1`;
    chomp($ret);
    $ret =~ s/\.$//;
    return $ret;
}

# return the packages list
sub PdbvPackages { 
    return @nicelist;
}

sub PdbvPackagesSorted {
    return @nicelist;
}

# return package name without the version
sub PdbvBasename {
    my $ret = $_[0];
    $ret =~ s/\_.*$//g;
    return $ret;
}

# return standard package info
sub PdbvInfo {
    my $pack = PdbvBasename($_[0]);
    # invalidate + to be treated as a caracter in regex
    $pack =~ s/\+/\\\+/g;

    for (@rawlist) {
	if (/^Package: $pack$/m) {    
	    return $_;
	    last;
	}
    }
}

# return all files in a package
sub PdbvList {
    my $pack = PdbvBasename($_[0]);
    my $ret = '';
    if (-e "$dpkg_dir/info/$pack.list") {
	open(LIST, "$dpkg_dir/info/$pack.list") or die $sbst_unable_to_open."$dpkg_dir/info/$pack.list.\n\nStopped";
	while (<LIST>) {
	    $ret .= $_;
	}
	close(LIST);
    }
    return $ret;
}

# return group to which one the package belongs
# it can be usefull for list by criterion
sub PdbvGroup {
    return $package_section{$_[0]};
}

# return version of one package
sub PdbvVersion {
    # Currently useless. Can be added like PdbvGroup with ease.
}

# return installation date (YYYY Month) of the package
# it can be usefull for list by criterion
sub PdbvDate {    
    my $sb = stat("$dpkg_dir/info/".PdbvBasename($_[0]).".list");
    my ($sec,$min,$hour,$mday,$month,$year,$sday,$aday,$est_dst) = localtime $sb->mtime;
    return ($year+1900)."_".sprintf("%02d", ($month+1) % 100);
}
