# (c) 2002-2003 Mathieu Roy <yeupou@gnu.org>
# rpm.pl this file is part of package_db_view
#
#   all rpm commands
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  take a look at http://savannah.nongnu.org/projects/pdbv
#  send comments at <pdbv-dev@nongnu.org>
#
#  $Id: rpm.pl,v 1.4 2003/04/04 18:45:13 yeupou Exp $

print "The purpose of this file is not being executed alone";
exit;

# IIRC, perl modules to access RPM database exists.
# It should be a lot faster.
# Send a mail at <pdbv-dev@nongnu.org> for proposal on this topic.

# Note that I cannot currently test pdbv with rpm, so the following is
# pretty untested.

our $package_info_baseurl = "http://www.rpmfind.net/linux/rpm2html/search.php?query=";

sub PdbvInit {
    return 1;
}

# return the rpm version
sub PdbvPackagemanagerVersion {
    my $ret = `rpm --version | head -n 1`;
    chomp($ret);
    $ret =~ s/\.$//;
    return $ret;
}

# return the packages list
sub PdbvPackages { 
    my @ret = `rpm -qa`;
    chomp(@ret);
    return @ret;
}

sub PdbvPackagesSorted {
    return sort(PdbvPackages());
}

# return package name without the version
sub PdbvBasename {
    my $ret = `rpm -q $_[0] --qf '%{NAME}'`;
    return $ret;
}

# return standard package info

sub PdbvInfo {
    my $pack = $_[0];
    my $item = $_[1] if $_[1];

    # More complete than rpm -qi
    my $ret = `rpm -q $pack --qf '%{summary}\n\n'"$sbst_package"' %{name}\n'"$sbst_version" %{version}\n'"$sbst_release"' %{release}\n'"$sbst_arch"' %{arch}\n'"$sbst_installdate"' %{installtime:date}\n\n'"$sbst_buildhost"' %{buildhost}\n'"$sbst_builddate"' %{buildtime:date}\n'"$sbst_packager"' %{packager}\n'"$sbst_size"' %{size}\n'"$sbst_group"' %{group}\n\n'"$sbst_description"'\n%{description}\n'"$sbst_url"' %{url}\n'`;
    return $ret;
}

# return all files in a package
sub PdbvList {
    # --status give a --list with more informations.
    # will change probably someday
    my $ret = `rpm -q --list $_[0]`;
    return $ret;
}


# As it does not exists in dpkg, we do not use it.
#function package_db_view_group_packages {
#    rpm -q --group $WORKING_GROUP
#}


# return group to which one the package belongs
# it can be usefull for list by criterion
sub PdbvGroup {
    my $ret = `rpm -q $_[0] --qf '%{GROUP}'`;
    return $ret;
}

# return what the rpm provides
sub PdbvProvides {
    my $ret = `rpm -q --provides $_[0]`;
    return $ret;
}

# return what the rpm requires
sub PdbvRequires {
    my $ret = `rpm -q --requires $_[0]`;
    return $ret;
}

# return group to which one the rpm belongs
# it can be usefull for list by criterion
sub PdbvGroup {
    my $ret = `rpm -q $_[0] --qf '%{GROUP}'`;
    $ret =~ s/\//-/;
    $ret =~ s/\ /_/;
    return $ret;
}

# return installation date (YYYY Month) of the rpm
# it can be usefull for list by criterion
sub PdbvDate {    
    my $year =`rpm -q $working_package --qf '%{INSTALLTIME:date}' | awk '{print $4}'`;
    my $date = `rpm -q $working_package --qf '%{INSTALLTIME:date}' | awk '{print $3}'`;
    return $year."_".$month;
}


# end
