/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/compress.hh
 *******************************************/

#ifndef PDF_CHAIN__TOOLS_COMPRESS
#define PDF_CHAIN__TOOLS_COMPRESS

#include "definings.hh"
#include "dialogs.hh"
#include "filechoosers.hh"

/*** Class ***/
class class_window_tools_compress : public Gtk::Window{
	
	public:
		class_window_tools_compress();
		virtual ~class_window_tools_compress(){}; // Destruktor (inline)
		
		// Routines
		void set_dialogs(class_dialogs*);
		void clear();
		
	protected:
		
		// Windows
		class_dialogs *pt_dialogs;
		
		// Widgets
		Gtk::VBox
			vbox_window;
		
		Gtk::HBox
			hbox_sourcefile,
		hbox_selection,
		hbox_selectionframe,
		hbox_save;
		
		Gtk::Frame
			frame_sourcefile,
		frame_selection;
		
		Gtk::Entry
			entry_sourcefile;
		
		Gtk::Button
			button_sourcefile,
		button_save;
		
		Gtk::RadioButton
			radiobutton_compress,
		radiobutton_uncompress;
		
		Gtk::Alignment
			alignment_selection,
		alignment_save;
		
		// Radiobutton Groups
		Gtk::RadioButton::Group
			radiobutton_group;
		
		// Signal Handlers
		virtual void on_button_sourcefile();
		virtual void on_button_save();
};

#endif
