/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Dialogs
 src/dialogs.cc
 *******************************************/

#include "dialogs.hh"

/*** Info Message Dialog ***/
void class_dialogs::info_message(Gtk::Window* pt_parent, Glib::ustring title, Glib::ustring message){
	
	int response;
	pt_message_dialog = new Gtk::MessageDialog(*pt_parent, "<big><b>" + Text::str_INFO + ": " + title + "</b></big>", true,
											   Gtk::MESSAGE_INFO, Gtk::BUTTONS_CLOSE, true);
	
	pt_message_dialog->set_default_response (Gtk::RESPONSE_CLOSE);
	pt_message_dialog->set_title(Text::str_INFO);
	pt_message_dialog->set_secondary_text(message, false);
	response = pt_message_dialog->run();
	delete pt_message_dialog;
	
	return;
}



/*** Question Message Dialog ***/
int class_dialogs::question_message(Gtk::Window* pt_parent, Glib::ustring title, Glib::ustring message){
	
	int response;
	pt_message_dialog = new Gtk::MessageDialog(*pt_parent, "<big><b>" + Text::str_QUESTION + ": "  + title + "</b></big>", true,
											   Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_YES_NO, true);
	
	pt_message_dialog->set_default_response (Gtk::RESPONSE_NO);
	pt_message_dialog->set_title(Text::str_QUESTION);
	pt_message_dialog->set_secondary_text(message, false);
	response = pt_message_dialog->run();
	delete pt_message_dialog;
	
	return response;
}



/*** Error Message Dialog ***/
void class_dialogs::error_message(Gtk::Window* pt_parent, Glib::ustring title, Glib::ustring message){
	
	int response;
	pt_message_dialog = new Gtk::MessageDialog(*pt_parent, "<big><b>" + Text::str_ERROR + ": " + title + "</b></big>", true,
											   Gtk::MESSAGE_ERROR, Gtk::BUTTONS_CLOSE, true);
	
	pt_message_dialog->set_default_response (Gtk::RESPONSE_CLOSE);
	pt_message_dialog->set_title(Text::str_ERROR);
	pt_message_dialog->set_secondary_text(message, false);
	response = pt_message_dialog->run();
	delete pt_message_dialog;
	
	return;
}



/*** Error Message - cerr (default Error function) ***/
void class_dialogs::error_cerr(Glib::ustring error_function, Glib::ustring error_message, Glib::ustring error_comment){
	
	if(!error_function.empty())
		std::cerr << std::endl << Text::err_msg_ERROR_AT_FUNCTION << Text::str_QUOTE_BEGIN << error_function.c_str() << Text::str_QUOTE_END;
	
	if(!error_message.empty())
		std::cerr << ": " << error_message.c_str();
	
	if(!error_comment.empty())
		std::cerr << " - " << Text::str_QUOTE_BEGIN << error_comment.c_str() << Text::str_QUOTE_END;
	
	return;
}



/*** On Window Main -> Menu Help -> About ***/
void class_dialogs::on_window_main_menu_help_about(){
	
	// Authors
	std::vector<Glib::ustring> authors;
	authors.push_back(Text::str_AUTHOR1);
	
	// About Window
	pt_about_dialog = new Gtk::AboutDialog();
	pt_about_dialog->set_default_response (Gtk::RESPONSE_CLOSE);
	
	pt_about_dialog->set_program_name(Text::str_PDF_CHAIN);
	pt_about_dialog->set_version(Text::str_VERSION);
	pt_about_dialog->set_comments(Text::str_COMMENTS);
	pt_about_dialog->set_authors(authors);
	pt_about_dialog->set_copyright(Text::str_COPYRIGHT);
	pt_about_dialog->set_license(Text::str_LICENSE);
	pt_about_dialog->set_website(Text::str_WEBSITE);
	pt_about_dialog->set_website_label(Text::str_WEBSITE_LABEL);
	
	// Icon
	Glib::RefPtr<Gio::File> file = Gio::File::create_for_path(PATH_ICON);
	if(file->query_exists() == true){
		pt_about_dialog->set_logo(Gdk::Pixbuf::create_from_file(PATH_ICON));
	}
	else{
		
		// Error Message
		error_cerr("class_dialogs::on_window_main_menu_help_about()", Text::err_FILE_DOES_NOT_EXIST, PATH_ICON);
	}
	
	pt_about_dialog->run();
	delete pt_about_dialog;
	
	return;
}

