/*                                                                              
 * PDFedit - free program for PDF document manipulation.                        
 * Copyright (C) 2006, 2007  PDFedit team:      Michal Hocko, 
 *                                              Miroslav Jahoda,       
 *                                              Jozef Misutka, 
 *                                              Martin Petricek                                             
 *
 * Project is hosted on http://sourceforge.net/projects/pdfedit                                                                      
 */ 
// vim:tabstop=4:shiftwidth=4:noexpandtab:textwidth=80

/*
 * $RCSfile: testcobjecthelpers.cc,v $
 *
 * $Log: testcobjecthelpers.cc,v $
 * Revision 1.3  2007/02/04 20:17:03  mstsxfx
 * Common Licence comment for all cc and h files available in doc/licence_header
 * file and its content to all cc and h files in src/{gui,kernel,utils}
 * directories.
 * Xpdf code, QSA and QOutputDevice code are not touched
 *
 * Revision 1.2  2006/05/29 00:11:52  misuj1am
 *
 * -- tests fixed / improved
 *
 * Revision 1.1  2006/04/21 20:42:17  hockm0bm
 * start of cobjecthelpers tests
 *
 *
 */

#include "testmain.h"
#include "../cobjecthelpers.h"

namespace {

/** Checks functionality od IdCollector class.
 */
void idCollectorTC()
{
	typedef std::vector<boost::shared_ptr<IProperty> > Storage;
	typedef std::vector<size_t> Container;
	typedef std::pair<size_t, const boost::shared_ptr<IProperty> > Entry;
	
	Storage array;
	array.push_back(boost::shared_ptr<IProperty>(new CInt(1)));
	array.push_back(boost::shared_ptr<IProperty>(new CInt(2)));
	array.push_back(boost::shared_ptr<IProperty>(new CInt(1)));

	Container container;
	boost::shared_ptr<CInt> child(new CInt(1));
	//typedef IdCollector<Container, size_t> IdCollectorType;
	//IdCollectorType collector(container, child);
	utils::IdCollector<Container, size_t> collector(container, child);

	size_t pos=0;
	for(Storage::iterator i=array.begin(); i!=array.end(); i++, pos++)
	{
		collector(Entry(pos, *i));
	}

	printf("container size=%u", container.size());
	printf("Elements are:");
	for(Container::iterator i=container.begin(); i!=container.end(); i++)
		printf(" %u", *i);
	printf("\n");
}


} // end of annonym namespace

class TestCObjectHelpers: public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE(TestCObjectHelpers);
		CPPUNIT_TEST(Test);
	CPPUNIT_TEST_SUITE_END();
public:
	/*
	void setUp()
	{
	}

	void tearDown()
	{
	}

	*/

	void Test()
	{
		//idCollectorTC();
	}
};

CPPUNIT_TEST_SUITE_REGISTRATION(TestCObjectHelpers);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestCObjectHelpers, "TEST_COBJECTHELPERS");
