/* 
 * This file is part of the PDF Split And Merge source code
 * Created on 26/giu/2014
 * Copyright 2013-2014 by Andrea Vacondio (andrea.vacondio@gmail.com).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.pdfsam.support.params;

import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.pdf.PdfVersion;

/**
 * Abstract builder for {@link AbstractPdfOutputParameters}.
 * 
 * @author Andrea Vacondio
 * @param <P>
 *            type of the parameters the builder builds
 */
public abstract class AbstractPdfOutputParametersBuilder<P extends AbstractPdfOutputParameters>
        extends AbstractParametersBuilder<P> {
    private boolean compress;
    private boolean discardBookmarks = false;
    private PdfVersion version;

    public void compress(boolean compress) {
        this.compress = compress;
    }

    protected boolean isCompress() {
        return compress;
    }

    public void version(PdfVersion version) {
        this.version = version;
    }

    protected PdfVersion getVersion() {
        return version;
    }

    public void discardBookmarks(boolean discardBookmarks) {
        this.discardBookmarks = discardBookmarks;
    }

    protected boolean isDiscardBookmarks() {
        return discardBookmarks;
    }
}
