(** Wrapper around Perl [LWP::UserAgent] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_LWP_UserAgent.ml,v 1.3 2003/10/16 13:41:07 rich Exp $
  *)

open Perl

open Pl_HTTP_Request
open Pl_HTTP_Response

let _ = eval "use LWP::UserAgent"

class lwp_useragent sv =

object (self)

  method simple_request (request : http_request) =
    let sv = call_method sv "simple_request" [request#sv] in
    new http_response sv
  method request (request : http_request) =
    let sv = call_method sv "request" [request#sv] in
    new http_response sv
  method agent =
    string_of_sv (call_method sv "agent" [])
  method set_agent v =
    call_method_void sv "agent" [sv_of_string v]
  method from =
    string_of_sv (call_method sv "from" [])
  method set_from v =
    call_method_void sv "from" [sv_of_string v]
  method timeout =
    int_of_sv (call_method sv "timeout" [])
  method set_timeout v =
    call_method_void sv "timeout" [sv_of_int v]
  method parse_head =
    bool_of_sv (call_method sv "parse_head" [])
  method set_parse_head v =
    call_method_void sv "parse_head" [sv_of_bool v]
  method max_size =
    int_of_sv (call_method sv "max_size" [])
  method set_max_size v =
    call_method_void sv "max_size" [sv_of_int v]
  method env_proxy =
    call_method_void sv "env_proxy" []

end

(* Note that "new" is a reserved word, so I've appended an _ character. *)
let new_ ?agent ?from ?timeout ?use_eval ?parse_head ?max_size
    ?env_proxy ?keep_alive () =
  let args = ref [] in
  let may f = function None -> () | Some v -> f v in
  may (fun v ->
	 args := sv_of_string "agent" :: sv_of_string v :: !args) agent;
  may (fun v ->
	 args := sv_of_string "from" :: sv_of_string v :: !args) from;
  may (fun v ->
	 args := sv_of_string "timeout" :: sv_of_int v :: !args) timeout;
  may (fun v ->
	 args := sv_of_string "use_eval" :: sv_of_bool v :: !args) use_eval;
  may (fun v ->
	 args := sv_of_string "parse_head" :: sv_of_bool v :: !args)parse_head;
  may (fun v ->
	 args := sv_of_string "max_size" :: sv_of_int v :: !args) max_size;
  may (fun v ->
	 args := sv_of_string "env_proxy" :: sv_of_bool v :: !args) env_proxy;
  may (fun v ->
	 args := sv_of_string "keep_alive" :: sv_of_int v :: !args) keep_alive;
  let sv = call_class_method "LWP::UserAgent" "new" !args in
  new lwp_useragent sv
