#include "petsc.h"
#include "petscfix.h"
/* matrix.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscmat.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matconjugate_ PMATCONJUGATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matconjugate_ pmatconjugate
#else
#define matconjugate_ pmatconjugate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matconjugate_ MATCONJUGATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matconjugate_ matconjugate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetup_ PMATSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetup_ pmatsetup
#else
#define matsetup_ pmatsetup_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetup_ MATSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetup_ matsetup
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matvalid_ PMATVALID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matvalid_ pmatvalid
#else
#define matvalid_ pmatvalid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matvalid_ MATVALID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matvalid_ matvalid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvalues_ PMATSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalues_ pmatsetvalues
#else
#define matsetvalues_ pmatsetvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvalues_ MATSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalues_ matsetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetstencil_ PMATSETSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetstencil_ pmatsetstencil
#else
#define matsetstencil_ pmatsetstencil_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetstencil_ MATSETSTENCIL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetstencil_ matsetstencil
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesblocked_ PMATSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblocked_ pmatsetvaluesblocked
#else
#define matsetvaluesblocked_ pmatsetvaluesblocked_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesblocked_ MATSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblocked_ matsetvaluesblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetvalues_ PMATGETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvalues_ pmatgetvalues
#else
#define matgetvalues_ pmatgetvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetvalues_ MATGETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvalues_ matgetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmapping_ PMATSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmapping_ pmatsetlocaltoglobalmapping
#else
#define matsetlocaltoglobalmapping_ pmatsetlocaltoglobalmapping_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmapping_ MATSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmapping_ matsetlocaltoglobalmapping
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmappingblock_ PMATSETLOCALTOGLOBALMAPPINGBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmappingblock_ pmatsetlocaltoglobalmappingblock
#else
#define matsetlocaltoglobalmappingblock_ pmatsetlocaltoglobalmappingblock_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmappingblock_ MATSETLOCALTOGLOBALMAPPINGBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmappingblock_ matsetlocaltoglobalmappingblock
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvalueslocal_ PMATSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalueslocal_ pmatsetvalueslocal
#else
#define matsetvalueslocal_ pmatsetvalueslocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvalueslocal_ MATSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalueslocal_ matsetvalueslocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesblockedlocal_ PMATSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblockedlocal_ pmatsetvaluesblockedlocal
#else
#define matsetvaluesblockedlocal_ pmatsetvaluesblockedlocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesblockedlocal_ MATSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblockedlocal_ matsetvaluesblockedlocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmult_ PMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmult_ pmatmult
#else
#define matmult_ pmatmult_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmult_ MATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmult_ matmult
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttranspose_ PMATMULTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttranspose_ pmatmulttranspose
#else
#define matmulttranspose_ pmatmulttranspose_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttranspose_ MATMULTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttranspose_ matmulttranspose
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultadd_ PMATMULTADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultadd_ pmatmultadd
#else
#define matmultadd_ pmatmultadd_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultadd_ MATMULTADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultadd_ matmultadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeadd_ PMATMULTTRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeadd_ pmatmulttransposeadd
#else
#define matmulttransposeadd_ pmatmulttransposeadd_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeadd_ MATMULTTRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeadd_ matmulttransposeadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultconstrained_ PMATMULTCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultconstrained_ pmatmultconstrained
#else
#define matmultconstrained_ pmatmultconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultconstrained_ MATMULTCONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultconstrained_ matmultconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeconstrained_ PMATMULTTRANSPOSECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeconstrained_ pmatmulttransposeconstrained
#else
#define matmulttransposeconstrained_ pmatmulttransposeconstrained_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeconstrained_ MATMULTTRANSPOSECONSTRAINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeconstrained_ matmulttransposeconstrained
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactor_ PMATLUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactor_ pmatlufactor
#else
#define matlufactor_ pmatlufactor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactor_ MATLUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactor_ matlufactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matilufactor_ PMATILUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactor_ pmatilufactor
#else
#define matilufactor_ pmatilufactor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matilufactor_ MATILUFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactor_ matilufactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactorsymbolic_ PMATLUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactorsymbolic_ pmatlufactorsymbolic
#else
#define matlufactorsymbolic_ pmatlufactorsymbolic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactorsymbolic_ MATLUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactorsymbolic_ matlufactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactornumeric_ PMATLUFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactornumeric_ pmatlufactornumeric
#else
#define matlufactornumeric_ pmatlufactornumeric_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matlufactornumeric_ MATLUFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactornumeric_ matlufactornumeric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactor_ PMATCHOLESKYFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactor_ pmatcholeskyfactor
#else
#define matcholeskyfactor_ pmatcholeskyfactor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactor_ MATCHOLESKYFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactor_ matcholeskyfactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactorsymbolic_ PMATCHOLESKYFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactorsymbolic_ pmatcholeskyfactorsymbolic
#else
#define matcholeskyfactorsymbolic_ pmatcholeskyfactorsymbolic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactorsymbolic_ MATCHOLESKYFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactorsymbolic_ matcholeskyfactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactornumeric_ PMATCHOLESKYFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactornumeric_ pmatcholeskyfactornumeric
#else
#define matcholeskyfactornumeric_ pmatcholeskyfactornumeric_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcholeskyfactornumeric_ MATCHOLESKYFACTORNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactornumeric_ matcholeskyfactornumeric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolve_ PMATSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolve_ pmatsolve
#else
#define matsolve_ pmatsolve_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolve_ MATSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolve_ matsolve
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolveadd_ PMATSOLVEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolveadd_ pmatsolveadd
#else
#define matsolveadd_ pmatsolveadd_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolveadd_ MATSOLVEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolveadd_ matsolveadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolvetranspose_ PMATSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetranspose_ pmatsolvetranspose
#else
#define matsolvetranspose_ pmatsolvetranspose_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolvetranspose_ MATSOLVETRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetranspose_ matsolvetranspose
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolvetransposeadd_ PMATSOLVETRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetransposeadd_ pmatsolvetransposeadd
#else
#define matsolvetransposeadd_ pmatsolvetransposeadd_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolvetransposeadd_ MATSOLVETRANSPOSEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetransposeadd_ matsolvetransposeadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matrelax_ PMATRELAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrelax_ pmatrelax
#else
#define matrelax_ pmatrelax_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matrelax_ MATRELAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrelax_ matrelax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matpbrelax_ PMATPBRELAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matpbrelax_ pmatpbrelax
#else
#define matpbrelax_ pmatpbrelax_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matpbrelax_ MATPBRELAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matpbrelax_ matpbrelax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetdiagonal_ PMATGETDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetdiagonal_ pmatgetdiagonal
#else
#define matgetdiagonal_ pmatgetdiagonal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetdiagonal_ MATGETDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetdiagonal_ matgetdiagonal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetrowmax_ PMATGETROWMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetrowmax_ pmatgetrowmax
#else
#define matgetrowmax_ pmatgetrowmax_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetrowmax_ MATGETROWMAX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetrowmax_ matgetrowmax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matequal_ PMATEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matequal_ pmatequal
#else
#define matequal_ pmatequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matequal_ MATEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matequal_ matequal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalscale_ PMATDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscale_ pmatdiagonalscale
#else
#define matdiagonalscale_ pmatdiagonalscale_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalscale_ MATDIAGONALSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscale_ matdiagonalscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matscale_ PMATSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matscale_ pmatscale
#else
#define matscale_ pmatscale_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matscale_ MATSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matscale_ matscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matnorm_ PMATNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matnorm_ pmatnorm
#else
#define matnorm_ pmatnorm_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matnorm_ MATNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matnorm_ matnorm
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassemblybegin_ PMATASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblybegin_ pmatassemblybegin
#else
#define matassemblybegin_ pmatassemblybegin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassemblybegin_ MATASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblybegin_ matassemblybegin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassembled_ PMATASSEMBLED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassembled_ pmatassembled
#else
#define matassembled_ pmatassembled_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassembled_ MATASSEMBLED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassembled_ matassembled
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassemblyend_ PMATASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblyend_ pmatassemblyend
#else
#define matassemblyend_ pmatassemblyend_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matassemblyend_ MATASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblyend_ matassemblyend
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcompress_ PMATCOMPRESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcompress_ pmatcompress
#else
#define matcompress_ pmatcompress_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matcompress_ MATCOMPRESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcompress_ matcompress
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetoption_ PMATSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetoption_ pmatsetoption
#else
#define matsetoption_ pmatsetoption_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetoption_ MATSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetoption_ matsetoption
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matzeroentries_ PMATZEROENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzeroentries_ pmatzeroentries
#else
#define matzeroentries_ pmatzeroentries_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matzeroentries_ MATZEROENTRIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzeroentries_ matzeroentries
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetsize_ PMATGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsize_ pmatgetsize
#else
#define matgetsize_ pmatgetsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetsize_ MATGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsize_ matgetsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetlocalsize_ PMATGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetlocalsize_ pmatgetlocalsize
#else
#define matgetlocalsize_ pmatgetlocalsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetlocalsize_ MATGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetlocalsize_ matgetlocalsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetownershiprange_ PMATGETOWNERSHIPRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetownershiprange_ pmatgetownershiprange
#else
#define matgetownershiprange_ pmatgetownershiprange_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetownershiprange_ MATGETOWNERSHIPRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetownershiprange_ matgetownershiprange
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matilufactorsymbolic_ PMATILUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactorsymbolic_ pmatilufactorsymbolic
#else
#define matilufactorsymbolic_ pmatilufactorsymbolic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matilufactorsymbolic_ MATILUFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactorsymbolic_ matilufactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define maticcfactorsymbolic_ PMATICCFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define maticcfactorsymbolic_ pmaticcfactorsymbolic
#else
#define maticcfactorsymbolic_ pmaticcfactorsymbolic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define maticcfactorsymbolic_ MATICCFACTORSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define maticcfactorsymbolic_ maticcfactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matincreaseoverlap_ PMATINCREASEOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincreaseoverlap_ pmatincreaseoverlap
#else
#define matincreaseoverlap_ pmatincreaseoverlap_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matincreaseoverlap_ MATINCREASEOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincreaseoverlap_ matincreaseoverlap
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matprinthelp_ PMATPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matprinthelp_ pmatprinthelp
#else
#define matprinthelp_ pmatprinthelp_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matprinthelp_ MATPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matprinthelp_ matprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetblocksize_ PMATGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetblocksize_ pmatgetblocksize
#else
#define matgetblocksize_ pmatgetblocksize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetblocksize_ MATGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetblocksize_ matgetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetblocksize_ PMATSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetblocksize_ pmatsetblocksize
#else
#define matsetblocksize_ pmatsetblocksize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetblocksize_ MATSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetblocksize_ matsetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetunfactored_ PMATSETUNFACTORED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetunfactored_ pmatsetunfactored
#else
#define matsetunfactored_ pmatsetunfactored_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetunfactored_ MATSETUNFACTORED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetunfactored_ matsetunfactored
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetsubmatrix_ PMATGETSUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsubmatrix_ pmatgetsubmatrix
#else
#define matgetsubmatrix_ pmatgetsubmatrix_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetsubmatrix_ MATGETSUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsubmatrix_ matgetsubmatrix
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matstashsetinitialsize_ PMATSTASHSETINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matstashsetinitialsize_ pmatstashsetinitialsize
#else
#define matstashsetinitialsize_ pmatstashsetinitialsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matstashsetinitialsize_ MATSTASHSETINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matstashsetinitialsize_ matstashsetinitialsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matinterpolateadd_ PMATINTERPOLATEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matinterpolateadd_ pmatinterpolateadd
#else
#define matinterpolateadd_ pmatinterpolateadd_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matinterpolateadd_ MATINTERPOLATEADD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matinterpolateadd_ matinterpolateadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matinterpolate_ PMATINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matinterpolate_ pmatinterpolate
#else
#define matinterpolate_ pmatinterpolate_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matinterpolate_ MATINTERPOLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matinterpolate_ matinterpolate
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matrestrict_ PMATRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrestrict_ pmatrestrict
#else
#define matrestrict_ pmatrestrict_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matrestrict_ MATRESTRICT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrestrict_ matrestrict
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define maticcfactor_ PMATICCFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define maticcfactor_ pmaticcfactor
#else
#define maticcfactor_ pmaticcfactor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define maticcfactor_ MATICCFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define maticcfactor_ maticcfactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesadic_ PMATSETVALUESADIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesadic_ pmatsetvaluesadic
#else
#define matsetvaluesadic_ pmatsetvaluesadic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesadic_ MATSETVALUESADIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesadic_ matsetvaluesadic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetcoloring_ PMATSETCOLORING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetcoloring_ pmatsetcoloring
#else
#define matsetcoloring_ pmatsetcoloring_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetcoloring_ MATSETCOLORING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetcoloring_ matsetcoloring
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesadifor_ PMATSETVALUESADIFOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesadifor_ pmatsetvaluesadifor
#else
#define matsetvaluesadifor_ pmatsetvaluesadifor_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsetvaluesadifor_ MATSETVALUESADIFOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesadifor_ matsetvaluesadifor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalscalelocal_ PMATDIAGONALSCALELOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscalelocal_ pmatdiagonalscalelocal
#else
#define matdiagonalscalelocal_ pmatdiagonalscalelocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matdiagonalscalelocal_ MATDIAGONALSCALELOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscalelocal_ matdiagonalscalelocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetinertia_ PMATGETINERTIA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetinertia_ pmatgetinertia
#else
#define matgetinertia_ pmatgetinertia_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetinertia_ MATGETINERTIA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetinertia_ matgetinertia
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolves_ PMATSOLVES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolves_ pmatsolves
#else
#define matsolves_ pmatsolves_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matsolves_ MATSOLVES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolves_ matsolves
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matissymmetric_ PMATISSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matissymmetric_ pmatissymmetric
#else
#define matissymmetric_ pmatissymmetric_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matissymmetric_ MATISSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matissymmetric_ matissymmetric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matissymmetricknown_ PMATISSYMMETRICKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matissymmetricknown_ pmatissymmetricknown
#else
#define matissymmetricknown_ pmatissymmetricknown_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matissymmetricknown_ MATISSYMMETRICKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matissymmetricknown_ matissymmetricknown
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matishermitianknown_ PMATISHERMITIANKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matishermitianknown_ pmatishermitianknown
#else
#define matishermitianknown_ pmatishermitianknown_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matishermitianknown_ MATISHERMITIANKNOWN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matishermitianknown_ matishermitianknown
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matisstructurallysymmetric_ PMATISSTRUCTURALLYSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matisstructurallysymmetric_ pmatisstructurallysymmetric
#else
#define matisstructurallysymmetric_ pmatisstructurallysymmetric_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matisstructurallysymmetric_ MATISSTRUCTURALLYSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matisstructurallysymmetric_ matisstructurallysymmetric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matishermitian_ PMATISHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matishermitian_ pmatishermitian
#else
#define matishermitian_ pmatishermitian_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matishermitian_ MATISHERMITIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matishermitian_ matishermitian
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matstashgetinfo_ PMATSTASHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matstashgetinfo_ pmatstashgetinfo
#else
#define matstashgetinfo_ pmatstashgetinfo_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matstashgetinfo_ MATSTASHGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matstashgetinfo_ matstashgetinfo
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetvecs_ PMATGETVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvecs_ pmatgetvecs
#else
#define matgetvecs_ pmatgetvecs_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matgetvecs_ MATGETVECS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvecs_ matgetvecs
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmult_ PMATMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmult_ pmatmatmult
#else
#define matmatmult_ pmatmatmult_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmult_ MATMATMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmult_ matmatmult
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmultsymbolic_ PMATMATMULTSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmultsymbolic_ pmatmatmultsymbolic
#else
#define matmatmultsymbolic_ pmatmatmultsymbolic_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmultsymbolic_ MATMATMULTSYMBOLIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmultsymbolic_ matmatmultsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmultnumeric_ PMATMATMULTNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmultnumeric_ pmatmatmultnumeric
#else
#define matmatmultnumeric_ pmatmatmultnumeric_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmultnumeric_ MATMATMULTNUMERIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmultnumeric_ matmatmultnumeric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmulttranspose_ PMATMATMULTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmulttranspose_ pmatmatmulttranspose
#else
#define matmatmulttranspose_ pmatmatmulttranspose_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmatmulttranspose_ MATMATMULTTRANSPOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmatmulttranspose_ matmatmulttranspose
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   matconjugate_(Mat mat, int *__ierr ){
*__ierr = MatConjugate(
	(Mat)PetscToPointer((mat) ));
}
void PETSC_STDCALL   matsetup_(Mat A, int *__ierr ){
*__ierr = MatSetUp(
	(Mat)PetscToPointer((A) ));
}
void PETSC_STDCALL   matvalid_(Mat m,PetscTruth *flg, int *__ierr ){
*__ierr = MatValid(
	(Mat)PetscToPointer((m) ),flg);
}
void PETSC_STDCALL   matsetvalues_(Mat mat,PetscInt *m, PetscInt idxm[],PetscInt *n, PetscInt idxn[], PetscScalar v[],InsertMode *addv, int *__ierr ){
*__ierr = MatSetValues(
	(Mat)PetscToPointer((mat) ),*m,idxm,*n,idxn,v,*addv);
}
void PETSC_STDCALL   matsetstencil_(Mat mat,PetscInt *dim, PetscInt dims[], PetscInt starts[],PetscInt *dof, int *__ierr ){
*__ierr = MatSetStencil(
	(Mat)PetscToPointer((mat) ),*dim,dims,starts,*dof);
}
void PETSC_STDCALL   matsetvaluesblocked_(Mat mat,PetscInt *m, PetscInt idxm[],PetscInt *n, PetscInt idxn[], PetscScalar v[],InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesBlocked(
	(Mat)PetscToPointer((mat) ),*m,idxm,*n,idxn,v,*addv);
}
void PETSC_STDCALL   matgetvalues_(Mat mat,PetscInt *m, PetscInt idxm[],PetscInt *n, PetscInt idxn[],PetscScalar v[], int *__ierr ){
*__ierr = MatGetValues(
	(Mat)PetscToPointer((mat) ),*m,idxm,*n,idxn,v);
}
void PETSC_STDCALL   matsetlocaltoglobalmapping_(Mat x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = MatSetLocalToGlobalMapping(
	(Mat)PetscToPointer((x) ),
	(ISLocalToGlobalMapping)PetscToPointer((mapping) ));
}
void PETSC_STDCALL   matsetlocaltoglobalmappingblock_(Mat x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = MatSetLocalToGlobalMappingBlock(
	(Mat)PetscToPointer((x) ),
	(ISLocalToGlobalMapping)PetscToPointer((mapping) ));
}
void PETSC_STDCALL   matsetvalueslocal_(Mat mat,PetscInt *nrow, PetscInt irow[],PetscInt *ncol, PetscInt icol[], PetscScalar y[],InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesLocal(
	(Mat)PetscToPointer((mat) ),*nrow,irow,*ncol,icol,y,*addv);
}
void PETSC_STDCALL   matsetvaluesblockedlocal_(Mat mat,PetscInt *nrow, PetscInt irow[],PetscInt *ncol, PetscInt icol[], PetscScalar y[],InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesBlockedLocal(
	(Mat)PetscToPointer((mat) ),*nrow,irow,*ncol,icol,y,*addv);
}
void PETSC_STDCALL   matmult_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMult(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   matmulttranspose_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMultTranspose(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   matmultadd_(Mat mat,Vec v1,Vec v2,Vec v3, int *__ierr ){
*__ierr = MatMultAdd(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((v1) ),
	(Vec)PetscToPointer((v2) ),
	(Vec)PetscToPointer((v3) ));
}
void PETSC_STDCALL   matmulttransposeadd_(Mat mat,Vec v1,Vec v2,Vec v3, int *__ierr ){
*__ierr = MatMultTransposeAdd(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((v1) ),
	(Vec)PetscToPointer((v2) ),
	(Vec)PetscToPointer((v3) ));
}
void PETSC_STDCALL   matmultconstrained_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMultConstrained(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   matmulttransposeconstrained_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMultTransposeConstrained(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   matlufactor_(Mat mat,IS row,IS col,MatFactorInfo *info, int *__ierr ){
*__ierr = MatLUFactor(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((row) ),
	(IS)PetscToPointer((col) ),info);
}
void PETSC_STDCALL   matilufactor_(Mat mat,IS row,IS col,MatFactorInfo *info, int *__ierr ){
*__ierr = MatILUFactor(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((row) ),
	(IS)PetscToPointer((col) ),info);
}
void PETSC_STDCALL   matlufactorsymbolic_(Mat mat,IS row,IS col,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatLUFactorSymbolic(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((row) ),
	(IS)PetscToPointer((col) ),info,fact);
}
void PETSC_STDCALL   matlufactornumeric_(Mat mat,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatLUFactorNumeric(
	(Mat)PetscToPointer((mat) ),info,fact);
}
void PETSC_STDCALL   matcholeskyfactor_(Mat mat,IS perm,MatFactorInfo *info, int *__ierr ){
*__ierr = MatCholeskyFactor(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((perm) ),info);
}
void PETSC_STDCALL   matcholeskyfactorsymbolic_(Mat mat,IS perm,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatCholeskyFactorSymbolic(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((perm) ),info,fact);
}
void PETSC_STDCALL   matcholeskyfactornumeric_(Mat mat,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatCholeskyFactorNumeric(
	(Mat)PetscToPointer((mat) ),info,fact);
}
void PETSC_STDCALL   matsolve_(Mat mat,Vec b,Vec x, int *__ierr ){
*__ierr = MatSolve(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matsolveadd_(Mat mat,Vec b,Vec y,Vec x, int *__ierr ){
*__ierr = MatSolveAdd(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((y) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matsolvetranspose_(Mat mat,Vec b,Vec x, int *__ierr ){
*__ierr = MatSolveTranspose(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matsolvetransposeadd_(Mat mat,Vec b,Vec y,Vec x, int *__ierr ){
*__ierr = MatSolveTransposeAdd(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),
	(Vec)PetscToPointer((y) ),
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matrelax_(Mat mat,Vec b,PetscReal *omega,MatSORType *flag,PetscReal *shift,PetscInt *its,PetscInt *lits,Vec x, int *__ierr ){
*__ierr = MatRelax(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),*omega,*flag,*shift,*its,*lits,
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matpbrelax_(Mat mat,Vec b,PetscReal *omega,MatSORType *flag,PetscReal *shift,PetscInt *its,PetscInt *lits,Vec x, int *__ierr ){
*__ierr = MatPBRelax(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((b) ),*omega,*flag,*shift,*its,*lits,
	(Vec)PetscToPointer((x) ));
}
void PETSC_STDCALL   matgetdiagonal_(Mat mat,Vec v, int *__ierr ){
*__ierr = MatGetDiagonal(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((v) ));
}
void PETSC_STDCALL   matgetrowmax_(Mat mat,Vec v, int *__ierr ){
*__ierr = MatGetRowMax(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((v) ));
}
void PETSC_STDCALL   matequal_(Mat A,Mat B,PetscTruth *flg, int *__ierr ){
*__ierr = MatEqual(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),flg);
}
void PETSC_STDCALL   matdiagonalscale_(Mat mat,Vec l,Vec r, int *__ierr ){
*__ierr = MatDiagonalScale(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((l) ),
	(Vec)PetscToPointer((r) ));
}
void PETSC_STDCALL   matscale_(Mat mat,PetscScalar *a, int *__ierr ){
*__ierr = MatScale(
	(Mat)PetscToPointer((mat) ),*a);
}
void PETSC_STDCALL   matnorm_(Mat mat,NormType *type,PetscReal *nrm, int *__ierr ){
*__ierr = MatNorm(
	(Mat)PetscToPointer((mat) ),*type,nrm);
}
void PETSC_STDCALL   matassemblybegin_(Mat mat,MatAssemblyType *type, int *__ierr ){
*__ierr = MatAssemblyBegin(
	(Mat)PetscToPointer((mat) ),*type);
}
void PETSC_STDCALL   matassembled_(Mat mat,PetscTruth *assembled, int *__ierr ){
*__ierr = MatAssembled(
	(Mat)PetscToPointer((mat) ),assembled);
}
void PETSC_STDCALL   matassemblyend_(Mat mat,MatAssemblyType *type, int *__ierr ){
*__ierr = MatAssemblyEnd(
	(Mat)PetscToPointer((mat) ),*type);
}
void PETSC_STDCALL   matcompress_(Mat mat, int *__ierr ){
*__ierr = MatCompress(
	(Mat)PetscToPointer((mat) ));
}
void PETSC_STDCALL   matsetoption_(Mat mat,MatOption *op, int *__ierr ){
*__ierr = MatSetOption(
	(Mat)PetscToPointer((mat) ),*op);
}
void PETSC_STDCALL   matzeroentries_(Mat mat, int *__ierr ){
*__ierr = MatZeroEntries(
	(Mat)PetscToPointer((mat) ));
}
void PETSC_STDCALL   matgetsize_(Mat mat,PetscInt *m,PetscInt* n, int *__ierr ){
*__ierr = MatGetSize(
	(Mat)PetscToPointer((mat) ),m,n);
}
void PETSC_STDCALL   matgetlocalsize_(Mat mat,PetscInt *m,PetscInt* n, int *__ierr ){
*__ierr = MatGetLocalSize(
	(Mat)PetscToPointer((mat) ),m,n);
}
void PETSC_STDCALL   matgetownershiprange_(Mat mat,PetscInt *m,PetscInt* n, int *__ierr ){
*__ierr = MatGetOwnershipRange(
	(Mat)PetscToPointer((mat) ),m,n);
}
void PETSC_STDCALL   matilufactorsymbolic_(Mat mat,IS row,IS col,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatILUFactorSymbolic(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((row) ),
	(IS)PetscToPointer((col) ),info,fact);
}
void PETSC_STDCALL   maticcfactorsymbolic_(Mat mat,IS perm,MatFactorInfo *info,Mat *fact, int *__ierr ){
*__ierr = MatICCFactorSymbolic(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((perm) ),info,fact);
}
void PETSC_STDCALL   matincreaseoverlap_(Mat mat,PetscInt *n,IS is[],PetscInt *ov, int *__ierr ){
*__ierr = MatIncreaseOverlap(
	(Mat)PetscToPointer((mat) ),*n,is,*ov);
}
void PETSC_STDCALL   matprinthelp_(Mat mat, int *__ierr ){
*__ierr = MatPrintHelp(
	(Mat)PetscToPointer((mat) ));
}
void PETSC_STDCALL   matgetblocksize_(Mat mat,PetscInt *bs, int *__ierr ){
*__ierr = MatGetBlockSize(
	(Mat)PetscToPointer((mat) ),bs);
}
void PETSC_STDCALL   matsetblocksize_(Mat mat,PetscInt *bs, int *__ierr ){
*__ierr = MatSetBlockSize(
	(Mat)PetscToPointer((mat) ),*bs);
}
void PETSC_STDCALL   matsetunfactored_(Mat mat, int *__ierr ){
*__ierr = MatSetUnfactored(
	(Mat)PetscToPointer((mat) ));
}
void PETSC_STDCALL   matgetsubmatrix_(Mat mat,IS isrow,IS iscol,PetscInt *csize,MatReuse *cll,Mat *newmat, int *__ierr ){
*__ierr = MatGetSubMatrix(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((isrow) ),
	(IS)PetscToPointer((iscol) ),*csize,*cll,newmat);
}
void PETSC_STDCALL   matstashsetinitialsize_(Mat mat,PetscInt *size,PetscInt *bsize, int *__ierr ){
*__ierr = MatStashSetInitialSize(
	(Mat)PetscToPointer((mat) ),*size,*bsize);
}
void PETSC_STDCALL   matinterpolateadd_(Mat A,Vec x,Vec y,Vec w, int *__ierr ){
*__ierr = MatInterpolateAdd(
	(Mat)PetscToPointer((A) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ),
	(Vec)PetscToPointer((w) ));
}
void PETSC_STDCALL   matinterpolate_(Mat A,Vec x,Vec y, int *__ierr ){
*__ierr = MatInterpolate(
	(Mat)PetscToPointer((A) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   matrestrict_(Mat A,Vec x,Vec y, int *__ierr ){
*__ierr = MatRestrict(
	(Mat)PetscToPointer((A) ),
	(Vec)PetscToPointer((x) ),
	(Vec)PetscToPointer((y) ));
}
void PETSC_STDCALL   maticcfactor_(Mat mat,IS row,MatFactorInfo* info, int *__ierr ){
*__ierr = MatICCFactor(
	(Mat)PetscToPointer((mat) ),
	(IS)PetscToPointer((row) ),info);
}
void PETSC_STDCALL   matsetvaluesadic_(Mat mat,void*v, int *__ierr ){
*__ierr = MatSetValuesAdic(
	(Mat)PetscToPointer((mat) ),v);
}
void PETSC_STDCALL   matsetcoloring_(Mat mat,ISColoring coloring, int *__ierr ){
*__ierr = MatSetColoring(
	(Mat)PetscToPointer((mat) ),
	(ISColoring)PetscToPointer((coloring) ));
}
void PETSC_STDCALL   matsetvaluesadifor_(Mat mat,PetscInt *nl,void*v, int *__ierr ){
*__ierr = MatSetValuesAdifor(
	(Mat)PetscToPointer((mat) ),*nl,v);
}
void PETSC_STDCALL   matdiagonalscalelocal_(Mat mat,Vec diag, int *__ierr ){
*__ierr = MatDiagonalScaleLocal(
	(Mat)PetscToPointer((mat) ),
	(Vec)PetscToPointer((diag) ));
}
void PETSC_STDCALL   matgetinertia_(Mat mat,PetscInt *nneg,PetscInt *nzero,PetscInt *npos, int *__ierr ){
*__ierr = MatGetInertia(
	(Mat)PetscToPointer((mat) ),nneg,nzero,npos);
}
void PETSC_STDCALL   matsolves_(Mat mat,Vecs b,Vecs x, int *__ierr ){
*__ierr = MatSolves(
	(Mat)PetscToPointer((mat) ),
	(Vecs)PetscToPointer((b) ),
	(Vecs)PetscToPointer((x) ));
}
void PETSC_STDCALL   matissymmetric_(Mat A,PetscReal *tol,PetscTruth *flg, int *__ierr ){
*__ierr = MatIsSymmetric(
	(Mat)PetscToPointer((A) ),*tol,flg);
}
void PETSC_STDCALL   matissymmetricknown_(Mat A,PetscTruth *set,PetscTruth *flg, int *__ierr ){
*__ierr = MatIsSymmetricKnown(
	(Mat)PetscToPointer((A) ),set,flg);
}
void PETSC_STDCALL   matishermitianknown_(Mat A,PetscTruth *set,PetscTruth *flg, int *__ierr ){
*__ierr = MatIsHermitianKnown(
	(Mat)PetscToPointer((A) ),set,flg);
}
void PETSC_STDCALL   matisstructurallysymmetric_(Mat A,PetscTruth *flg, int *__ierr ){
*__ierr = MatIsStructurallySymmetric(
	(Mat)PetscToPointer((A) ),flg);
}
void PETSC_STDCALL   matishermitian_(Mat A,PetscTruth *flg, int *__ierr ){
*__ierr = MatIsHermitian(
	(Mat)PetscToPointer((A) ),flg);
}
void PETSC_STDCALL   matstashgetinfo_(Mat mat,PetscInt *nstash,PetscInt *reallocs,PetscInt *bnstash,PetscInt *brealloc, int *__ierr ){
*__ierr = MatStashGetInfo(
	(Mat)PetscToPointer((mat) ),nstash,reallocs,bnstash,brealloc);
}
void PETSC_STDCALL   matgetvecs_(Mat mat,Vec *right,Vec *left, int *__ierr ){
*__ierr = MatGetVecs(
	(Mat)PetscToPointer((mat) ),right,left);
}
void PETSC_STDCALL   matmatmult_(Mat A,Mat B,MatReuse *scall,PetscReal *fill,Mat *C, int *__ierr ){
*__ierr = MatMatMult(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*scall,*fill,C);
}
void PETSC_STDCALL   matmatmultsymbolic_(Mat A,Mat B,PetscReal *fill,Mat *C, int *__ierr ){
*__ierr = MatMatMultSymbolic(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*fill,C);
}
void PETSC_STDCALL   matmatmultnumeric_(Mat A,Mat B,Mat C, int *__ierr ){
*__ierr = MatMatMultNumeric(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),
	(Mat)PetscToPointer((C) ));
}
void PETSC_STDCALL   matmatmulttranspose_(Mat A,Mat B,MatReuse *scall,PetscReal *fill,Mat *C, int *__ierr ){
*__ierr = MatMatMultTranspose(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*scall,*fill,C);
}
#if defined(__cplusplus)
}
#endif
