/* Copyright (C) 2000-2004 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "pfaeditui.h"

static GClut magnify0_clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static uint8 magnify0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfa, 0x2, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xff, 0x6, 0xff, 
    0xff, 0xff, 0x7f, 
    0xff, 0xff, 0xbf, 
    0xff, 0xff, 0xdf, 
    0xff, 0xff, 0xef, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage magnify0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) magnify0_data,
    &magnify0_clut,
    1
};

static uint8 pointer0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7f, 0xff, 
    0xff, 0x3f, 0xff, 
    0xff, 0x1f, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x7, 0xff, 
    0xff, 0x3, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x4f, 0xff, 
    0xff, 0x67, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage pointer0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) pointer0_data,
    &magnify0_clut,
    1
};

static uint8 ruler0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xc0, 0x0, 0x7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage ruler0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) ruler0_data,
    &magnify0_clut,
    1
};

static uint8 knife0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xf1, 0xff, 0xdf, 
    0xfe, 0x3f, 0xdf, 
    0xff, 0xc7, 0xc1, 
    0xff, 0xf8, 0xdf, 
    0xff, 0xff, 0x1f, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage knife0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) knife0_data,
    &magnify0_clut,
    1
};

static uint8 corner0_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static GClut corner0_clut = { 3, 0, 2,
    0x0, 0xff0000, 0xc0c0c0 };

static struct _GImage corner0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) corner0_data,
    &corner0_clut,
    2
};

static uint8 curve0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage curve0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) curve0_data,
    &corner0_clut,
    2
};

static uint8 tangent0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static uint8 corner1_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static GClut corner1_clut = { 3, 0, 2,
    0x0, 0xff0000, 0xc0c0c0 };

static struct _GImage corner1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) corner1_data,
    &corner0_clut,
    2
};

static uint8 curve1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage curve1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) curve1_data,
    &corner0_clut,
    2
};

static uint8 tangent1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage tangent1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) tangent1_data,
    &corner0_clut,
    2
};

static struct _GImage tangent0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) tangent0_data,
    &corner0_clut,
    2
};


static uint8 rotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut rotate0_clut = { 6, 0, 0,
    0xc0c0c0, 0xff0000, 0x0, 0xff00, 0xff, 0x4040ff };

static struct _GImage rotate0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) rotate0_data,
    &rotate0_clut,
    0
};


static uint8 skew0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage skew0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) skew0_data,
    &rotate0_clut,
    0
};


static uint8 flip0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage flip0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) flip0_data,
    &rotate0_clut,
    0
};


static uint8 scale0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage scale0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) scale0_data,
    &rotate0_clut,
    0
};


static uint8 pen0_data[] = {
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x4, 0x4, 0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage pen0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) pen0_data,
    &rotate0_clut,
    0
};

static uint8 beveljoin0_data[] = {
    0xff, 0xff, 
    0xfe, 0x0, 
    0xfd, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage beveljoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) beveljoin0_data,
    &magnify0_clut,
    1
};


static uint8 buttcap0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage buttcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) buttcap0_data,
    &magnify0_clut,
    1
};


static uint8 miterjoin0_data[] = {
    0xff, 0xff, 
    0x80, 0x0, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage miterjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) miterjoin0_data,
    &magnify0_clut,
    1
};


static uint8 roundcap0_data[] = {
    0xff, 0xff, 
    0xf8, 0x3f, 
    0xe7, 0xcf, 
    0xdf, 0xf7, 
    0xdf, 0xf7, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundcap0_data,
    &magnify0_clut,
    1
};


static uint8 roundjoin0_data[] = {
    0xff, 0xff, 
    0xf8, 0x0, 
    0xe7, 0xff, 
    0xdf, 0xff, 
    0xdf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundjoin0_data,
    &magnify0_clut,
    1
};


static uint8 squarecap0_data[] = {
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage squarecap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) squarecap0_data,
    &magnify0_clut,
    1
};

static uint8 rect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0x80, 0x0, 0x1, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rect0_data,
    &magnify0_clut,
    1
};

static uint8 rrect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xf0, 0x0, 0xf, 
    0xcf, 0xff, 0xf3, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xcf, 0xff, 0xf3, 
    0xf0, 0x0, 0xf, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rrect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rrect0_data,
    &magnify0_clut,
    1
};


static uint8 elipse0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x81, 0xff, 
    0xf8, 0x7e, 0x1f, 
    0xe7, 0xff, 0xe7, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xe7, 0xff, 0xe7, 
    0xf8, 0x7e, 0x1f, 
    0xff, 0x81, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage elipse0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) elipse0_data,
    &magnify0_clut,
    1
};


static uint8 poly0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0x99, 0xff, 
    0xfe, 0x7e, 0x7f, 
    0xf9, 0xff, 0x9f, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xf9, 0xff, 0x9f, 
    0xfe, 0x7e, 0x7f, 
    0xff, 0x99, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage poly0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) poly0_data,
    &magnify0_clut,
    1
};


static uint8 star0_data[] = {
    0xfd, 0xff, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0x99, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfb, 0xff, 0xdf, 
    0xe7, 0xff, 0xe7, 
    0x9f, 0xff, 0xf9, 
    0x7f, 0xff, 0xfe, 
    0x9f, 0xff, 0xf9, 
    0xe7, 0xff, 0xe7, 
    0xfb, 0xff, 0xdf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0x99, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0xff, 0xab, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage star0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) star0_data,
    &magnify0_clut,
    1
};

static uint8 shift0_data[] = {
    0xff, 0xef, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xef, 0xd7, 0xef, 
    0xdf, 0xd7, 0xf7, 
    0x80, 0x0, 0x3, 
    0x7f, 0xd7, 0xfd, 
    0x80, 0x0, 0x3, 
    0xdf, 0xd7, 0xf7, 
    0xef, 0xd7, 0xef, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xef, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage shift0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) shift0_data,
    &magnify0_clut,
    1
};


static uint8 pencil0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut pencil0_clut = { 4, 0, 0,
    0xffffff, 0x0, 0xd0d000, 0xeed0d0 };

static struct _GImage pencil0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) pencil0_data,
    &pencil0_clut,
    0
};


static uint8 freehand0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage freehand0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &corner0_clut,
    2
};

static GClut greyfree0_clut = { 3, 0, 2,
    0x404040, 0xc00000, 0x808080 };

static struct _GImage greyfree0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &greyfree0_clut,
    2
};


static uint8 line0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage line0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) line0_data,
    &pencil0_clut,
    0
};


static uint8 hand0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage hand0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) hand0_data,
    &pencil0_clut,
    0
};

static uint8 press2ptr0_data[] = {
    0xff, 0xf2, 
    0xef, 0x9c, 
    0xec, 0xf8, 
    0xef, 0xf0, 
    0xff, 0xe0, 
    0x11, 0xc0, 
    0xff, 0xf0, 
    0xef, 0xf2, 
    0xef, 0xe6, 
    0xef, 0xe7, 
};

static struct _GImage press2ptr0_base = {
    it_mono,
    2069,16,10,2,
    (uint8 *) press2ptr0_data,
    &magnify0_clut,
    1
};

GImage GIcon_press2ptr = { 0, &press2ptr0_base };
GImage GIcon_hand = { 0, &hand0_base };
GImage GIcon_line = { 0, &line0_base };
GImage GIcon_pencil = { 0, &pencil0_base };
GImage GIcon_shift = { 0, &shift0_base };
GImage GIcon_star = { 0, &star0_base };
GImage GIcon_poly = { 0, &poly0_base };
GImage GIcon_elipse = { 0, &elipse0_base };
GImage GIcon_rrect = { 0, &rrect0_base };
GImage GIcon_rect = { 0, &rect0_base };
GImage GIcon_squarecap = { 0, &squarecap0_base };
GImage GIcon_roundjoin = { 0, &roundjoin0_base };
GImage GIcon_roundcap = { 0, &roundcap0_base };
GImage GIcon_miterjoin = { 0, &miterjoin0_base };
GImage GIcon_buttcap = { 0, &buttcap0_base };
GImage GIcon_beveljoin = { 0, &beveljoin0_base };
GImage GIcon_freehand = { 0, &freehand0_base };
GImage GIcon_greyfree = { 0, &greyfree0_base };
GImage GIcon_pen = { 0, &pen0_base };
GImage GIcon_knife = { 0, &knife0_base };
GImage GIcon_scale = { 0, &scale0_base };
GImage GIcon_flip = { 0, &flip0_base };
GImage GIcon_skew = { 0, &skew0_base };
GImage GIcon_rotate = { 0, &rotate0_base };
GImage GIcon_tangent = { 0, &tangent0_base };
GImage GIcon_curve = { 0, &curve0_base };
GImage GIcon_corner = { 0, &corner0_base };
GImage GIcon_ruler = { 0, &ruler0_base };
GImage GIcon_pointer = { 0, &pointer0_base };
GImage GIcon_magnify = { 0, &magnify0_base };

GImage GIcon_midtangent = { 0, &tangent1_base };
GImage GIcon_midcurve = { 0, &curve1_base };
GImage GIcon_midcorner = { 0, &corner1_base };

/* Small (16x12) images */

static uint8 smallstar0_data[] = {
    0xf7, 0xef, 
    0xf1, 0x8f, 
    0xf6, 0x6f, 
    0xf7, 0xef, 
    0xef, 0xf7, 
    0x9f, 0xf9, 
    0x7f, 0xfe, 
    0x9f, 0xf9, 
    0xef, 0xf7, 
    0xf7, 0xef, 
    0xf6, 0x6f, 
    0xf1, 0x8f, 
};

static struct _GImage smallstar0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallstar0_data,
    &magnify0_clut,
    1
};

static uint8 smallruler0_data[] = {
    0xff, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0x81, 0xfe, 
    0xdd, 0xfe, 
    0xed, 0xfe, 
    0xfd, 0xfe, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfc, 0x0, 
    0xff, 0xff, 
};

static struct _GImage smallruler0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallruler0_data,
    &magnify0_clut,
    1
};

static uint8 smallrect0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xc0, 0x3, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xc0, 0x3, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallrect0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallrect0_data,
    &magnify0_clut,
    1
};

static uint8 smallelipse0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xfc, 0x3f, 
    0xf3, 0xcf, 
    0xef, 0xf7, 
    0xdf, 0xfb, 
    0xef, 0xf7, 
    0xf3, 0xcf, 
    0xfc, 0x3f, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallelipse0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallelipse0_data,
    &magnify0_clut,
    1
};

static uint8 smallpoly0_data[] = {
    0xff, 0xff, 
    0xfd, 0xff, 
    0xf2, 0x7f, 
    0xef, 0xbf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xef, 0xbf, 
    0xf2, 0x7f, 
    0xfd, 0xff, 
};

static struct _GImage smallpoly0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpoly0_data,
    &magnify0_clut,
    1
};

static uint8 smallpointer0_data[] = {
    0xdf, 0xff, 
    0xcf, 0xff, 
    0xc7, 0xff, 
    0xc3, 0xff, 
    0xc1, 0xff, 
    0xc0, 0xff, 
    0xc3, 0xff, 
    0xd9, 0xff, 
    0xf9, 0xff, 
    0xfc, 0xff, 
    0xfc, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpointer0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpointer0_data,
    &magnify0_clut,
    1
};

static uint8 smallpen0_data[] = {
    0xff, 0xff, 
    0xff, 0x1f, 
    0xfc, 0xef, 
    0xe3, 0xf0, 
    0x1f, 0xb7, 
    0x0, 0x57, 
    0x1f, 0xb7, 
    0xe3, 0xf0, 
    0xfc, 0xef, 
    0xff, 0x1f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpen0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpen0_data,
    &magnify0_clut,
    1
};

static uint8 smallpencil0_data[] = {
    0xc7, 0xff, 
    0xcb, 0xff, 
    0xdd, 0xff, 
    0xee, 0xff, 
    0xf7, 0x7f, 
    0xfb, 0xbf, 
    0xfd, 0xdf, 
    0xfe, 0xef, 
    0xff, 0x67, 
    0xff, 0x9b, 
    0xff, 0xd7, 
    0xff, 0xef, 
};

static struct _GImage smallpencil0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpencil0_data,
    &magnify0_clut,
    1
};

static uint8 smallknife0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x0, 0x1, 
    0xc7, 0xef, 
    0xf8, 0xe1, 
    0xff, 0xf, 
    0xff, 0xef, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallknife0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallknife0_data,
    &magnify0_clut,
    1
};

static uint8 smallmag0_data[] = {
    0xff, 0xff, 
    0xf1, 0xff, 
    0xee, 0xff, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xee, 0xff, 
    0xf1, 0x7f, 
    0xff, 0xbf, 
    0xff, 0xdf, 
    0xff, 0xef, 
    0xff, 0xff, 
};

static struct _GImage smallmag0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallmag0_data,
    &magnify0_clut,
    1
};

static uint8 smallhand0_data[] = {
    0xfe, 0x7f, 
    0xfd, 0xbf, 
    0xed, 0x8f, 
    0xd5, 0xb7, 
    0xd5, 0xb5, 
    0xd9, 0xb2, 
    0xe9, 0xb2, 
    0xed, 0xb6, 
    0x97, 0xfe, 
    0x67, 0xfd, 
    0xb7, 0xfd, 
    0xdf, 0xfd, 
};

static struct _GImage smallhand0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallhand0_data,
    &magnify0_clut,
    1
};

static uint8 smallcurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut smallcurve0_clut = { 3, 0, 1,
    0x0, 0xb0b0b0, 0xff0000 };

static struct _GImage smallcurve0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcurve0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallcorner0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallcorner0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcorner0_data,
    &smallcurve0_clut,
    1
};

static uint8 smalltangent0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smalltangent0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smalltangent0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallflip0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallflip0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallflip0_data,
    &rotate0_clut,
    1
};

static uint8 smallrotate0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x3, 0x1, 0x2, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallrotate0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallrotate0_data,
    &rotate0_clut,
    1
};

static uint8 smallscale0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallscale0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallscale0_data,
    &rotate0_clut,
    1
};

static uint8 smallskew0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallskew0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallskew0_data,
    &rotate0_clut,
    1
};

static uint8 logo_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x0, 0x2, 0x0, 0x0, 0x1, 0x1, 0x0, 0x1, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut logo_clut = { 4, 0, 0,
    0xb0b0b0, 0x0000ff, 0xff0000, 0x808080 };

static struct _GImage logo_base = {
    it_index,
    15420,11,13,11,
    (uint8 *) logo_data,
    &logo_clut,
    0
};

static uint8 logoback_data[] = {
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x3, 0x3, 0x3, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 
    0x3, 0x3, 0x3, 0x0, 0x3, 0x0, 0x0, 0x3, 0x3, 0x0, 0x3, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage logoback_base = {
    it_index,
    15420,11,13,11,
    (uint8 *) logoback_data,
    &logo_clut,
    0
};

static uint8 logogrid_data[] = {
    0xbf, 0xff, 
    0x3f, 0xff, 
    0xbf, 0xff, 
    0x9f, 0xff, 
    0xaf, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbd, 0xff, 
    0xbe, 0xff, 
    0x0, 0x1f, 
    0xbf, 0xbf, 
    0xbf, 0xdf, 
    0xbf, 0xff, 
};

static GClut def_clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static struct _GImage logogrid_base = {
    it_mono,
    15420,11,13,2,
    (uint8 *) logogrid_data,
    &def_clut,
    1
};

static uint8 image_data[] = {
    0x00, 0x00,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x00, 0x00,
};

static struct _GImage def_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &def_clut,
    1
};
static GClut red_clut = { 2, 0, -1,
    0x0, 0xff0000 };
static struct _GImage red_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &red_clut,
    -1
};
static GClut blue_clut = { 2, 0, -1,
    0x0, 0x0000ff };
static struct _GImage blue_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &blue_clut,
    -1
};
static GClut green_clut = { 2, 0, -1,
    0x0, 0x00ff00 };
static struct _GImage green_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &green_clut,
    -1
};
static GClut magenta_clut = { 2, 0, -1,
    0x0, 0xff00ff };
static struct _GImage magenta_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &magenta_clut,
    -1
};
static GClut cyan_clut = { 2, 0, -1,
    0x0, 0x00ffff };
static struct _GImage cyan_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &cyan_clut,
    -1
};
static GClut yellow_clut = { 2, 0, -1,
    0x0, 0xffff00 };
static struct _GImage yellow_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &yellow_clut,
    -1
};
static GClut white_clut = { 2, 0, -1,
    0x0, 0xffffff };
static struct _GImage white_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &white_clut,
    -1
};

GImage def_image = { 0, &def_base };
GImage red_image = { 0, &red_base };
GImage blue_image = { 0, &blue_base };
GImage green_image = { 0, &green_base };
GImage magenta_image = { 0, &magenta_base };
GImage yellow_image = { 0, &yellow_base };
GImage cyan_image = { 0, &cyan_base };
GImage white_image = { 0, &white_base };

static uint8 continue_data[] = {
    0xfe, 0xff, 
    0xff, 0x7f, 
    0xf0, 0x3f, 
    0xef, 0x7f, 
    0xfe, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage continue_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) continue_data,
    &magnify0_clut,
    1
};

static uint8 stepout_data[] = {
    0xfe, 0x1f, 
    0xfd, 0xef, 
    0xfd, 0xc7, 
    0xfd, 0xef, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepout_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepout_data,
    &magnify0_clut,
    1
};

static uint8 stepover_data[] = {
    0xf0, 0x1f, 
    0xef, 0xef, 
    0xef, 0xc7, 
    0xef, 0xef, 
    0xff, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepover_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepover_data,
    &magnify0_clut,
    1
};

static uint8 stepinto_data[] = {
    0xff, 0xff, 
    0xf3, 0xff, 
    0xed, 0xff, 
    0xed, 0xff, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xf8, 0xff, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepinto_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepinto_data,
    &magnify0_clut,
    1
};

static uint8 watchpnt_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    0, 0, 3, 3, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1
};

static GClut watchpnt_clut = { 4, 0, 1,
    0x000000, 0xb0b0b0, 0xff0000, 0x0000ff };

static struct _GImage watchpnt_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) watchpnt_data,
    &watchpnt_clut,
    1
};

static uint8 menudelta_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xe0, 0x3, 
    0xef, 0xfb, 
    0xf7, 0xf7, 
    0xf7, 0xf7, 
    0xfb, 0xef, 
    0xfb, 0xef, 
    0xfd, 0xdf, 
    0xfd, 0xdf, 
    0xfe, 0xbf, 
    0xfe, 0xbf, 
    0xff, 0x7f, 
    0xff, 0x7f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage menudelta_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) menudelta_data,
    &magnify0_clut,
    1
};

static uint8 exit_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x8a, 0xa3, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0xbd, 0xb7, 
    0x9d, 0xb7, 
    0xbd, 0xb7, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0x8a, 0xb7, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage exit_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) exit_data,
    &magnify0_clut,
    1
};

static uint8 stopped_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1
};

static GClut stopped_clut = { 3, 0, 1,
    0xff0000, 0xb0b0b0, 0xffffff };

static struct _GImage stopped_base = {
    it_index,
    15420,36,12,36,
    (uint8 *) stopped_data,
    &stopped_clut,
    1
};

static uint8 stop_data[] = {
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1
};

static struct _GImage stop_base = {
    it_index,
    15420,19,17,19,
    (uint8 *) stop_data,
    &stopped_clut,
    1
};

static uint8 exclude_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xff, 0x81, 
    0xbe, 0xde, 0xfd, 0xff, 0xbd, 
    0xbe, 0xde, 0x83, 0xff, 0xbd, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3d, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage exclude_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) exclude_data,
    &magnify0_clut,
    1
};

static uint8 intersection_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xfc, 0x3f, 
    0xbe, 0xde, 0xfd, 0xfd, 0xbf, 
    0xbe, 0xde, 0x83, 0xfd, 0xbf, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3f, 
    0xfe, 0xfe, 0xef, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0x0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage intersection_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) intersection_data,
    &magnify0_clut,
    1
};

static uint8 rmoverlap_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0x0, 0x3f, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xef, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xf7, 0x7f, 0xbf, 
    0xbe, 0x0, 0x83, 0x7f, 0x81, 
    0xbe, 0xde, 0xfd, 0x7f, 0xfd, 
    0xbe, 0xde, 0x83, 0x7f, 0xfd, 
    0x80, 0x1e, 0xf7, 0x1, 0xfd, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage rmoverlap_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) rmoverlap_data,
    &magnify0_clut,
    1
};

static uint8 findinter_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage findinter_base = {
    it_index,
    15420,40,16,40,
    (uint8 *) findinter_data,
    &smallcurve0_clut,
    1
};

static uint8 outline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x87, 0xf, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0x87, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage outline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) outline_data,
    &magnify0_clut,
    1
};

static uint8 inline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xa0, 0x2f, 
    0xbd, 0xef, 
    0x85, 0xf, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0x85, 0xf, 
    0xbd, 0xef, 
    0xa0, 0x2f, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage inline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) inline_data,
    &magnify0_clut,
    1
};

static uint8 shadow_data[] = {
    0xff, 0xff, 
    0xc0, 0x1f, 
    0xdf, 0xcf, 
    0xc2, 0xf, 
    0xfa, 0xf, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xc2, 0x1f, 
    0xdf, 0xcf, 
    0xc0, 0xf, 
    0xe0, 0xf, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage shadow_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) shadow_data,
    &magnify0_clut,
    1
};

static unsigned char wireframe_data[] = {
    0xff, 0xff, 
    0x80, 0x3f, 
    0xbf, 0x9f, 
    0x84, 0x2f, 
    0xf4, 0xd7, 
    0xf5, 0x67, 
    0xf5, 0x87, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0x84, 0x3f, 
    0xbf, 0x9f, 
    0x80, 0x2f, 
    0xdf, 0xd7, 
    0xef, 0xe7, 
    0xf0, 0x7, 
};

static struct _GImage wireframe_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) wireframe_data,
    &magnify0_clut,
    1
};

static uint8 menumark_data[] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static GClut menumark_clut = { 6, 0, 1,
    0x0, 0xb0b0b0, 0xf7f7f7, 0xdddddd, 0x808080, 0x666666 };

static struct _GImage menumark_base = {
    it_index,
    15420,16,10,16,
    (uint8 *) menumark_data,
    &menumark_clut,
    0xffffffff
};


GImage GIcon_smallskew = { 0, &smallskew0_base };
GImage GIcon_smallscale = { 0, &smallscale0_base };
GImage GIcon_smallrotate = { 0, &smallrotate0_base };
GImage GIcon_smallflip = { 0, &smallflip0_base };
GImage GIcon_smalltangent = { 0, &smalltangent0_base };
GImage GIcon_smallcorner = { 0, &smallcorner0_base };
GImage GIcon_smallcurve = { 0, &smallcurve0_base };
GImage GIcon_smallmag = { 0, &smallmag0_base };
GImage GIcon_smallknife = { 0, &smallknife0_base };
GImage GIcon_smallhand = { 0, &smallhand0_base };
GImage GIcon_smallpen = { 0, &smallpen0_base };
GImage GIcon_smallpencil = { 0, &smallpencil0_base };
GImage GIcon_smallpointer = { 0, &smallpointer0_base };
GImage GIcon_smallruler = { 0, &smallruler0_base };
GImage GIcon_smallelipse = { 0, &smallelipse0_base };
GImage GIcon_smallrect = { 0, &smallrect0_base };
GImage GIcon_smallpoly = { 0, &smallpoly0_base };
GImage GIcon_smallstar = { 0, &smallstar0_base };
GImage GIcon_PfaEditLogo = { 0, &logo_base };
GImage GIcon_PfaEditBack = { 0, &logoback_base };
GImage GIcon_PfaEditGuide = { 0, &logogrid_base };

GImage GIcon_continue = { 0, &continue_base };
GImage GIcon_stepout = { 0, &stepout_base };
GImage GIcon_stepover = { 0, &stepover_base };
GImage GIcon_stepinto = { 0, &stepinto_base };
GImage GIcon_watchpnt = { 0, &watchpnt_base };
GImage GIcon_menudelta = { 0, &menudelta_base };
GImage GIcon_exit = { 0, &exit_base };

GImage GIcon_Stopped = { 0, &stopped_base };
GImage GIcon_Stop = { 0, &stop_base };

GImage GIcon_exclude = { 0, &exclude_base };
GImage GIcon_intersection = { 0, &intersection_base };
GImage GIcon_rmoverlap = { 0, &rmoverlap_base };
GImage GIcon_findinter = { 0, &findinter_base };

GImage GIcon_outline = { 0, &outline_base };
GImage GIcon_inline = { 0, &inline_base };
GImage GIcon_shadow = { 0, &shadow_base };
GImage GIcon_wireframe = { 0, &wireframe_base };

GImage GIcon_menumark = { 0, &menumark_base };
