auto:
	aclocal && autoconf && automake
	(cd pfe && aclocal && autoconf && automake)
	(cd pfe && autoheader) || true
	(cd bin && aclocal && autoconf && automake)
	(cd testmodule && aclocal && autoconf && automake)

rpm : dist-bzip
	rpm -ta $(PACKAGE)-$(VERSION).tar.bz2

sweep:
	- grep -l "Make-H" pfe/*.h | xargs rm
	- rm doc/changes.htm doc/pfe.1 doc/pfe.htm
	- rm pfe/incl-gen.h
	- for i in pfe/*-dll.c \
	; do test ".$$i" = ".pfe/module-dll.c" && continue  \
	; echo rm $$i ; rm $$i ; done

# NOTE: Tek cms directories contain "~" which breaks libtool
sun: auto
	- rm Makefile
	bash -c 'bash configure --prefix=$$HOME/$$OSTYPE'
	- cd Release/sparc*/pfe ; sed -e "s,IFS='~',IFS='?'," \
          -e "/^[a-z_]*_cmds=/s,~,?,g" libtool >libtool.new \
	; test -s libtool.new && mv libtool.new libtool
	make-sun # $(MAKE) -f Makefile
	make check && make install

tek: auto
	- rm Makefile
	bash -c 'bash configure --prefix=$$HOME/$$OSTYPE'
	$(MAKE) -f Makefile
	echo "#       make check && make install"

rebuild: auto
	- rm Makefile
	bash -c 'for variant in regs fig forth call calls fast . \
	; do bash configure --prefix=$$HOME/$$OSTYPE \
	  --with-variant=$$variant \
	; done'
	$(MAKE) -f Makefile
	$(MAKE) -f Makefile check
	echo "#       make install-all"

make-rw:
	chmod -R +w .
