function varargout = pfs_read_xyz( fileName )
  % Read hdr image file (formats accepted by pfsin) and return X, Y,
  % and Z color channels.
  %
  % [X Y Z] = hdr_read_rgb( fileName )
  
  % Check if file exists
  fid = fopen( fileName, 'rb' );
  if( fid == -1 ) 
    error( 'pfs_read_xyz: File "%s" does not exist', fileName );
  end
  fclose( fid );

  fid = pfspopen( sprintf( '%spfsin ''%s''%s', pfs_shell(), fileName, pfs_shell( 1 ) ), 'r' );
  pin = pfsopen( fid );
  pin = pfsget( pin );
  pfsclose( pin );
  pfspclose( fid );
  
  if( nargout == 3 )
      varargout{1} = pin.channels.X;
      varargout{2} = pin.channels.Y;
      varargout{3} = pin.channels.Z;      
  elseif( nargout == 1 )
      varargout{1} = cat( 3, pin.channels.X, pin.channels.Y, pin.channels.Z );
  else
      error( 'Wrong number of output parameters' );
  end
    
end
  